/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.upgradeevalu.enums.ItCompatFeautureEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItElementType;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.parser.CompatibilityXlsParser;
import com.huawei.ism.tool.upgradeevalu.service.ICompatibilityExcelInfo;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class CompatibilityExcelInfo
implements ICompatibilityExcelInfo {
    private static final Logger LOGGER = Logger.getLogger(CompatibilityExcelInfo.class);
    private static CompatibilityExcelInfo instance = new CompatibilityExcelInfo();
    private ZipEntry excelEntry;
    private ZipEntry versionEntry;
    private InputStream in;
    private Map<String, List<ItemInfo>> xlsDevInfoMap;

    public static CompatibilityExcelInfo getInstance() {
        return instance;
    }

    @Override
    public Map<String, Object> getAllExcelContent(String zipFileDir) throws ToolException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ZipFile zf = null;
        InputStream versionIs = null;
        try {
            zf = new ZipFile(FilePathUtils.checkFile((String)zipFileDir));
            Enumeration<? extends ZipEntry> zipEntrys = zf.entries();
            while (zipEntrys.hasMoreElements()) {
                ZipEntry zipEntry = zipEntrys.nextElement();
                if (zipEntry.getName().endsWith(".xls")) {
                    this.excelEntry = zipEntry;
                    continue;
                }
                if (!zipEntry.getName().endsWith(".sign")) continue;
                this.versionEntry = zipEntry;
            }
            if (null != this.excelEntry) {
                this.in = zf.getInputStream(this.excelEntry);
            }
            CompatibilityXlsParser cXlsPar = new CompatibilityXlsParser();
            cXlsPar.setPackagePath(zipFileDir);
            this.xlsDevInfoMap = cXlsPar.parseXlsAllHostInfo(this.in, zipFileDir);
            resultMap.put("deviceMap", this.xlsDevInfoMap);
        }
        catch (IOException e) {
            throw new ToolException("compatibility.compat.exception.excelsheet", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, versionIs);
            StreamUtils.closeStream(null, (InputStream)this.in);
            StreamUtils.closeResource(null, (Closeable)zf);
        }
        return resultMap;
    }

    @Override
    public void executePretreatmentResult(Map<String, List<ItemInfo>> allExcelContenMap) {
        Map<String, List<ItemInfo>> map = allExcelContenMap;
        ArrayList<String> allHbaList = new ArrayList<String>();
        this.handleHostReportXls(map, allHbaList);
        this.handleDataBaseReport(map);
    }

    private void transCompatibilityMap(ItemInfo itemInfo) {
        Map<ItElementType, List<String>> eleMap = itemInfo.getEleMap();
        ArrayList<String> eleList = new ArrayList<String>();
        ArrayList allEleList = new ArrayList();
        if (eleMap.containsKey((Object)ItElementType.OS)) {
            eleList.add(eleMap.get((Object)ItElementType.OS).get(0));
        }
        if (eleMap.containsKey((Object)ItElementType.MULTIPATH)) {
            eleList.add(eleMap.get((Object)ItElementType.MULTIPATH).get(0));
        }
        if (eleMap.containsKey((Object)ItElementType.HBA)) {
            for (String hbaStr : eleMap.get((Object)ItElementType.HBA)) {
                ArrayList<String> otrEleList = new ArrayList<String>();
                otrEleList.addAll(eleList);
                otrEleList.add(hbaStr);
                allEleList.add(otrEleList);
            }
        } else {
            allEleList.add(eleList);
        }
        itemInfo.getElementStrMap().put(ItCompatFeautureEnum.BASE_CONNECTIVITY, allEleList);
    }

    private void handleHostReportXls(Map<String, List<ItemInfo>> map, List<String> allHbaList) {
        if (map.containsKey("HostReport")) {
            for (ItemInfo hi : map.get("HostReport")) {
                if (!CommonUtils.isNoOSInfo(hi)) {
                    Map<ItElementType, List<String>> currMap = hi.getEleMap();
                    hi.setEleMap(currMap);
                }
                this.transCompatibilityMap(hi);
            }
        }
    }

    private void handleDataBaseReport(Map<String, List<ItemInfo>> map) {
        if (map.containsKey("DatabaseReport")) {
            HashMap<ItElementType, List<String>> currMap = new HashMap<ItElementType, List<String>>();
            for (ItemInfo hi : map.get("DatabaseReport")) {
                ArrayList<String> currList = new ArrayList<String>();
                if (hi.getOsName() != null) {
                    currList.add(hi.getOsName());
                    currMap.put(ItElementType.OS, currList);
                }
                hi.setEleMap(currMap);
                this.transCompatibilityMap(hi);
            }
        }
    }
}

