/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DB2CompService
extends AbstractCompService {
    private static final List<String> DB2_WHITE_VERSION_LIST = Arrays.asList("V9.1", "V9.5", "V9.7", "V10.5");

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        ItemInfo itemInfo = params.getItemInfo();
        String dataBaseVersion = itemInfo.getDatabaseVersion();
        EvalFeatureResult result = new EvalFeatureResult();
        String[] db2Version = dataBaseVersion.trim().split("[\\.]");
        if (db2Version.length >= 2) {
            dataBaseVersion = db2Version[0] + "." + db2Version[1];
            for (String version : DB2_WHITE_VERSION_LIST) {
                if (!dataBaseVersion.equalsIgnoreCase(version)) continue;
                result.setItemResult(ItemResultEnum.PASS);
                return (T)result;
            }
        }
        result.setItemResult(ItemResultEnum.PASS);
        return (T)result;
    }
}

