/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.grab.GrabThread;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.service.HostHbaTimeOutService;
import com.huawei.ism.tool.upgradeevalu.service.VirtualCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class DataBaseCompService
extends AbstractCompService {
    private static final int INVALID_PARAM = -1;
    private static final String COLLECT_FAILED = "NA";
    private static final int TO_LOW_EDGE = 120;
    private static final String HIGH = "HIGH";
    private static final String NORMAL = "NORMAL";
    private static final String BLACK_START = "11.2.0.3";
    private static final String BLACK_END = "12.1.0.1";
    private static final String PRODUCT_MODEL = "Device Type|Product Model";
    private static final String PRODUCT_VERSION = "Product Version";
    private static final String VERSION = "Version";
    private static final String MODEL = "Model";
    private static final String SN = "SN";
    private static final String LUN_INFO = "LUNInfo";
    private static final String LUN_NUMBER = "LUNNumber";
    private static final String SYSTEM_INFO = "SystemInfo";
    private static final String RESULT = "result";
    private static final int LUNNUM = 1000;
    private static final int HIGHEST_WIGHT = 100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataBaseCompService.class);
    private static String dataStorageSN = "";
    public static final String IS_AIX = "isAixHost";
    public static final String IS_VMWARE = "isVmwareHost";
    public static final String IS_WINDOWS = "isWindowsHost";
    private boolean needHbaCase;
    private boolean needIscsiCase;
    private DevNode curStorageDev;
    private String deviceType;
    private String productVersion;
    private Integer storageLUN;

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        this.curStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        T result = null;
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        result = this.executeEval(params);
        return result;
    }

    private <T extends EvalFeatureResult> T executeEval(AbstractCompService.EvalCommParams params) {
        ArrayList<DevNode> curOracle2HostDevList;
        Map<GrabDevNode2, GrabThread> currThreadMap;
        EvalTaskResult evalTaskResult;
        List<EvalItemResult> evalItemList;
        ArrayList<EvalItemResult> curOracle2HostList;
        dataStorageSN = params.getStorageSn();
        this.getLunNum();
        EvalFeatureResult result = new EvalFeatureResult();
        StringBuilder oracleDesc = new StringBuilder();
        EvalFeatureResult checkOracleVersionResult = new EvalFeatureResult();
        boolean checkOracleVersion = this.checkOracleVersion(params, checkOracleVersionResult, oracleDesc);
        if (checkOracleVersion) {
            result.setItemResult(ItemResultEnum.PASS);
            LOGGER.info(String.format(Locale.ENGLISH, "Oracle check and pass:%s", params.getItemInfo().getIp()));
            return (T)result;
        }
        if (this.checkCurStorageDev(params, result, oracleDesc)) {
            return (T)result;
        }
        Map<DevNode, DevNode> hostMappedDb = HostEvalContext.getHostMappedDb();
        if (this.getCurOracle2HostList(params, result, oracleDesc, hostMappedDb, curOracle2HostList = new ArrayList<EvalItemResult>(), evalItemList = (evalTaskResult = HostEvalContext.getHostRvalResult().get(dataStorageSN)).getEvalItemList(), currThreadMap = GrabEngine.getInstance().getCurrThreadMap(), curOracle2HostDevList = new ArrayList<DevNode>())) {
            return (T)result;
        }
        if (curOracle2HostList.isEmpty()) {
            LOGGER.error("Get the wrong number of hosts associated with the database.");
            this.buildNotpassInfo(result, oracleDesc);
            return (T)result;
        }
        ArrayList<EvalFeatureResult> resultList = new ArrayList<EvalFeatureResult>();
        HostHbaTimeOutService hostHbaTimeOutService = new HostHbaTimeOutService();
        for (EvalItemResult evalItemResult : curOracle2HostList) {
            ItemInfo itemInfo = evalItemResult.getItemInfo();
            StringBuilder multiPathDesc = new StringBuilder();
            HashMap<String, Boolean> hostTypeMap = this.getHostTypeMap();
            HostHbaTimeOutService.checkOsType(itemInfo.getDevInfo(), itemInfo.getOsName(), hostTypeMap);
            if (this.checkVersionByProductVersion(itemInfo, multiPathDesc, hostTypeMap)) continue;
            EvalFeatureResult fcHbaTimeOut = new EvalFeatureResult();
            EvalFeatureResult iscsiTimeOut = new EvalFeatureResult();
            Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
            String iscsiTimeOutSting = evalMap.get(ItUpgradeKeyEnum.ISCSI_TIMEOUT_CHECK.toString());
            iscsiTimeOut = this.getEvalFeatureResult(result, hostHbaTimeOutService, itemInfo, multiPathDesc, hostTypeMap, fcHbaTimeOut, iscsiTimeOut, evalMap, iscsiTimeOutSting);
            EvalFeatureResult hostResult = new EvalFeatureResult();
            this.buildHostEvalResults(resultList, fcHbaTimeOut, iscsiTimeOut, hostResult, result);
        }
        return (T)this.buildAllHostEvaLResult(result, resultList, oracleDesc, (DevNode)curOracle2HostDevList.get(0));
    }

    private EvalFeatureResult getEvalFeatureResult(EvalFeatureResult result, HostHbaTimeOutService hostHbaTimeOutService, ItemInfo itemInfo, StringBuilder multiPathDesc, HashMap<String, Boolean> hostTypeMap, EvalFeatureResult fcHbaTimeOut, EvalFeatureResult iscsiTimeOut, Map<String, String> evalMap, String iscsiTimeOutSting) {
        if (this.deviceType.contains("dorado")) {
            if (this.productVersion.compareTo("v300r001c00") >= 0 || Products.isDigitalVer((String)this.productVersion)) {
                hostHbaTimeOutService.checkHostFCTimeOut(fcHbaTimeOut, itemInfo, hostTypeMap.get(IS_AIX), hostTypeMap.get(IS_VMWARE), hostTypeMap.get(IS_WINDOWS), multiPathDesc);
                iscsiTimeOut = this.checkIscsiTimeout(iscsiTimeOut, evalMap, iscsiTimeOutSting, hostTypeMap.get(IS_VMWARE), itemInfo);
            }
        } else if (this.productVersion.compareTo("v300r003c00") >= 0) {
            hostHbaTimeOutService.checkHostFCTimeOut(fcHbaTimeOut, itemInfo, hostTypeMap.get(IS_AIX), hostTypeMap.get(IS_VMWARE), hostTypeMap.get(IS_WINDOWS), multiPathDesc);
            iscsiTimeOut = this.checkIscsiTimeout(iscsiTimeOut, evalMap, iscsiTimeOutSting, hostTypeMap.get(IS_VMWARE), itemInfo);
        } else if (this.checkproductVersion()) {
            iscsiTimeOut = this.checkStorageLUN(result, hostHbaTimeOutService, itemInfo, multiPathDesc, hostTypeMap, fcHbaTimeOut, iscsiTimeOut, evalMap, iscsiTimeOutSting);
        } else {
            LOGGER.info(String.format(Locale.ENGLISH, "non conformity judgment logic, deviceType: %s, productVersion:%s, storageLUN:%s", this.deviceType, this.productVersion, this.storageLUN));
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
        }
        return iscsiTimeOut;
    }

    private EvalFeatureResult checkStorageLUN(EvalFeatureResult result, HostHbaTimeOutService hostHbaTimeOutService, ItemInfo itemInfo, StringBuilder multiPathDesc, HashMap<String, Boolean> hostTypeMap, EvalFeatureResult fcHbaTimeOut, EvalFeatureResult iscsiTimeOut, Map<String, String> evalMap, String iscsiTimeOutSting) {
        if (this.storageLUN != null && this.storageLUN <= 1000) {
            hostHbaTimeOutService.checkHostFCTimeOut(fcHbaTimeOut, itemInfo, hostTypeMap.get(IS_AIX), hostTypeMap.get(IS_VMWARE), hostTypeMap.get(IS_WINDOWS), multiPathDesc);
            iscsiTimeOut = this.checkIscsiTimeout(iscsiTimeOut, evalMap, iscsiTimeOutSting, hostTypeMap.get(IS_VMWARE), itemInfo);
        } else {
            LOGGER.error("Getting error in storing Lun information.");
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
        }
        return iscsiTimeOut;
    }

    private boolean checkproductVersion() {
        return (this.deviceType.contains("hvs") || this.deviceType.contains("18")) && this.productVersion.contains("v1") || this.productVersion.compareTo("v300r003c00") < 0 && this.productVersion.contains("v3") || this.deviceType.contains("t") && this.productVersion.contains("v2");
    }

    private HashMap<String, Boolean> getHostTypeMap() {
        HashMap<String, Boolean> hostTypeMap = new HashMap<String, Boolean>();
        hostTypeMap.put(IS_AIX, false);
        hostTypeMap.put(IS_VMWARE, false);
        hostTypeMap.put(IS_WINDOWS, false);
        return hostTypeMap;
    }

    private boolean checkVersionByProductVersion(ItemInfo itemInfo, StringBuilder multiPathDesc, HashMap<String, Boolean> hostTypeMap) {
        if (this.deviceType.contains("dorado")) {
            if ((this.productVersion.compareTo("v300r001c00") >= 0 || Products.isDigitalVer((String)this.productVersion)) && this.checkMultiPathVersion(itemInfo, hostTypeMap.get(IS_AIX), multiPathDesc)) {
                return true;
            }
        } else {
            String string = hostTypeMap.get(IS_AIX) != false ? "v300r003c20spc200" : "v300r003c00";
            if (this.productVersion.compareTo(string) >= 0 ? this.checkMultiPathVersion(itemInfo, hostTypeMap.get(IS_AIX), multiPathDesc) : (this.productVersion.compareTo("v300r001c10spc200") >= 0 || this.deviceType.contains("t") && this.productVersion.contains("v2") && this.productVersion.compareTo("v200r002c20spc200") >= 0) && this.storageLUN != null && this.storageLUN <= 1000 && hostTypeMap.get(IS_AIX) == false && this.checkMultiPathVersion(itemInfo, hostTypeMap.get(IS_AIX), multiPathDesc)) {
                return true;
            }
        }
        return false;
    }

    private <T extends EvalFeatureResult> boolean getCurOracle2HostList(AbstractCompService.EvalCommParams params, EvalFeatureResult result, StringBuilder oracleDesc, Map<DevNode, DevNode> hostMappedDb, List<EvalItemResult> curOracle2HostList, List<EvalItemResult> evalItemList, Map<GrabDevNode2, GrabThread> currThreadMap, List<DevNode> curOracle2HostDevList) {
        for (Map.Entry<DevNode, DevNode> entry : hostMappedDb.entrySet()) {
            DevNode oracleDev = entry.getValue();
            if (!params.getItemInfo().getIp().equals(oracleDev.getIp())) continue;
            DevNode hostDev = entry.getKey();
            curOracle2HostDevList.add(hostDev);
            if (org.apache.commons.lang3.StringUtils.isBlank(hostDev.getDeviceSerialNumber())) {
                LOGGER.error("Failed to get host Sn associated with database,sn :" + hostDev.getIp());
                this.buildNotpassInfo(result, oracleDesc);
                return true;
            }
            this.getItemAfterGrab(curOracle2HostList, evalItemList, currThreadMap, hostDev);
        }
        return false;
    }

    private <T extends EvalFeatureResult> boolean checkCurStorageDev(AbstractCompService.EvalCommParams params, EvalFeatureResult result, StringBuilder oracleDesc) {
        if (this.curStorageDev == null) {
            LOGGER.error("Oracle associated storage information access failed, ip:" + params.getItemInfo().getIp());
            this.buildNotpassInfo(result, oracleDesc);
            return true;
        }
        this.deviceType = this.curStorageDev.getDeviceType().toString().toLowerCase(Locale.ENGLISH);
        this.productVersion = this.curStorageDev.getProductVersion().toLowerCase(Locale.ENGLISH);
        return false;
    }

    private void buildNotpassInfo(EvalFeatureResult result, StringBuilder oracleDesc) {
        result.setItemResult(ItemResultEnum.NOTPASS);
        oracleDesc.append("\n");
        result.getCaseKeyList().clear();
        result.getCaseKeyList().add("oracleTimeOut");
        oracleDesc.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.changetips"));
        result.setFailDesc(oracleDesc.toString());
    }

    private void getItemAfterGrab(List<EvalItemResult> curOracle2HostList, List<EvalItemResult> evalItemList, Map<GrabDevNode2, GrabThread> currThreadMap, DevNode hostDev) {
        for (EvalItemResult evalItemResult : evalItemList) {
            if (org.apache.commons.lang3.StringUtils.isBlank(evalItemResult.getEvalDevNode().getDeviceSerialNumber()) || !evalItemResult.getEvalDevNode().getDeviceSerialNumber().equals(hostDev.getDeviceSerialNumber())) continue;
            GrabThread hostThead = this.getHostThead(currThreadMap, hostDev);
            try {
                if (hostThead != null) {
                    hostThead.join();
                } else {
                    LOGGER.info(String.format(Locale.ENGLISH, "No host thread is collected or the collection is finished,host sn:", hostDev.getDeviceSerialNumber()));
                }
                while (ItemResultEnum.EVALUATING.equals((Object)evalItemResult.getItemResultEnum()) || ItemResultEnum.WAIT_TOGO.equals((Object)evalItemResult.getItemResultEnum())) {
                    ConnUtils.sleep((int)1000);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("preThread error", e);
            }
            curOracle2HostList.add(evalItemResult);
        }
    }

    private GrabThread getHostThead(Map<GrabDevNode2, GrabThread> currThreadMap, DevNode hostDev) {
        for (Map.Entry<GrabDevNode2, GrabThread> curThead : currThreadMap.entrySet()) {
            if (!curThead.getKey().getDeviceSerialNumber().equals(hostDev.getDeviceSerialNumber())) continue;
            return curThead.getValue();
        }
        LOGGER.error("Failed to get host thread.");
        return null;
    }

    private EvalFeatureResult checkIscsiTimeout(EvalFeatureResult iscsiTimeOut, Map<String, String> evalMap, String iscsiTimeOutSting, boolean isVmwareHost, ItemInfo itemInfo) {
        if (!org.apache.commons.lang3.StringUtils.isBlank(evalMap.get(ItUpgradeKeyEnum.ISCSI_TIMEOUT_CHECK.toString()))) {
            if (isVmwareHost) {
                VirtualCompService virtualCompService = new VirtualCompService();
                iscsiTimeOut = virtualCompService.vmwareIscsiTimeOut(ItUpgradeKeyEnum.ISCSI_TIMEOUT_CHECK.toString(), itemInfo, this.curStorageDev);
            } else {
                iscsiTimeOut = super.parseCheckResultByItemKey(ItUpgradeKeyEnum.ISCSI_TIMEOUT_CHECK.toString(), evalMap);
            }
        } else {
            iscsiTimeOut.setItemResult(ItemResultEnum.CANNOTEVAL);
        }
        return iscsiTimeOut;
    }

    private EvalFeatureResult buildAllHostEvaLResult(EvalFeatureResult result, List<EvalFeatureResult> ResultList, StringBuilder oracleDesc, DevNode devNode) {
        for (EvalFeatureResult evalFeatureResult : ResultList) {
            ItemResultEnum itemResult = evalFeatureResult.getItemResult();
            if (ItemResultEnum.CANNOTEVAL.equals((Object)itemResult)) {
                this.buildNotpassInfo(result, oracleDesc);
                LOGGER.info("Judgment is not passed, modify PST timeout.");
                return result;
            }
            if (!ItemResultEnum.NOTPASS.equals((Object)itemResult)) continue;
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(result.getFailDesc() + "\n" + evalFeatureResult.getFailDesc());
        }
        if (ItemResultEnum.NOTPASS.equals((Object)result.getItemResult())) {
            result.setFailDesc(result.getFailDesc() + "\n" + this.getRecommendedAction(result, devNode));
        }
        if (ItemResultEnum.CANNOTEVAL.equals((Object)result.getItemResult())) {
            this.buildNotpassInfo(result, oracleDesc);
        }
        return result;
    }

    private String getRecommendedAction(EvalFeatureResult result, DevNode devNode) {
        String devName = devNode.getDeviceName().toLowerCase(Locale.ENGLISH);
        List<String> caseKeyList = result.getCaseKeyList();
        if (this.needHbaCase && this.needIscsiCase) {
            caseKeyList.add("hostHbaTimeOut." + devName);
            caseKeyList.add("IscsiTimeoutCheck." + devName);
            caseKeyList.add("oracleTimeOut");
            return ResourceUtil.getString((String)"eval.host.task.compatfail.oracle.pst.hba.and.pst");
        }
        if (this.needHbaCase && !this.needIscsiCase) {
            caseKeyList.add("hostHbaTimeOut." + devName);
            caseKeyList.add("oracleTimeOut");
            return ResourceUtil.getString((String)"eval.host.task.compatfail.oracle.hba.and.pst");
        }
        caseKeyList.add("IscsiTimeoutCheck." + devName);
        caseKeyList.add("oracleTimeOut");
        return ResourceUtil.getString((String)"eval.host.task.compatfail.oracle.pst.iscsi.and.pst");
    }

    private void buildHostEvalResults(List<EvalFeatureResult> ResultList, EvalFeatureResult fcHbaTimeOut, EvalFeatureResult iscsiTimeOut, EvalFeatureResult hostResult, EvalFeatureResult result) {
        if (ItemResultEnum.CANNOTEVAL.equals((Object)fcHbaTimeOut.getItemResult()) || ItemResultEnum.CANNOTEVAL.equals((Object)iscsiTimeOut.getItemResult())) {
            hostResult.setItemResult(ItemResultEnum.CANNOTEVAL);
        } else if (!ItemResultEnum.CANNOTEVAL.equals((Object)hostResult.getItemResult())) {
            if (ItemResultEnum.NOTPASS.equals((Object)fcHbaTimeOut.getItemResult())) {
                this.needHbaCase = true;
                hostResult.setItemResult(ItemResultEnum.NOTPASS);
            }
            if (ItemResultEnum.NOTPASS.equals((Object)iscsiTimeOut.getItemResult())) {
                this.needIscsiCase = true;
                hostResult.setItemResult(ItemResultEnum.NOTPASS);
            }
        }
        hostResult.setFailDesc(fcHbaTimeOut.getFailDesc() + "\n" + iscsiTimeOut.getFailDesc());
        ResultList.add(hostResult);
    }

    private boolean checkOracleVersion(AbstractCompService.EvalCommParams params, EvalFeatureResult result, StringBuilder oracleDesc) {
        ItemInfo itemInfo = params.getItemInfo();
        String dataBaseVersion = itemInfo.getDatabaseVersion();
        String asmDiskGroupType = itemInfo.getAsmDiskGroupType();
        String asmHbeatiowait = itemInfo.getAsmHbeatiowait();
        ArrayList<String> evalSNResult = new ArrayList<String>();
        int versionNum = this.transToVersionNUm(dataBaseVersion = dataBaseVersion.trim());
        if (versionNum == -1 || CommonUtils.isCommandExecError(asmDiskGroupType) || CommonUtils.isCommandExecError(asmHbeatiowait) || CommonUtils.isCommandExecError(dataBaseVersion)) {
            oracleDesc.append(ResourceUtil.getStringWithParams((String)"eval.device.task.paramcheck.fail.tips.common", (Object[])new Object[0]));
            return false;
        }
        asmDiskGroupType = asmDiskGroupType.toUpperCase(Locale.getDefault());
        int versionBlackStartNum = this.transToVersionNUm(BLACK_START);
        int versionBlackEndNum = this.transToVersionNUm(BLACK_END);
        if (versionBlackStartNum <= versionNum && versionNum <= versionBlackEndNum) {
            if (COLLECT_FAILED.equals(asmDiskGroupType)) {
                oracleDesc.append(ResourceUtil.getStringWithParams((String)"eval.host.task.database.asmHbeatiowait.error", (Object[])new Object[]{asmHbeatiowait}));
                return false;
            }
            if ((result = this.evalItemResult(asmDiskGroupType, asmHbeatiowait, result, evalSNResult, oracleDesc)).getItemResult().equals((Object)ItemResultEnum.NOTPASS) || result.getItemResult().equals((Object)ItemResultEnum.CANNOTEVAL)) {
                return false;
            }
        }
        result.setItemResult(ItemResultEnum.PASS);
        return true;
    }

    private boolean checkMultiPathVersion(ItemInfo itemInfo, Boolean isAix, StringBuilder multiPathDesc) {
        Map<String, String> multiSoftVersion = HostHbaTimeOutService.parseJson2Map(itemInfo.getMultiSoftEdition());
        return this.checkMultiPathWithVersion(isAix, multiSoftVersion, multiPathDesc);
    }

    private boolean checkMultiPathWithVersion(Boolean isAix, Map<String, String> multiSoftVersion, StringBuilder multiPathDesc) {
        String huaweiMultiVersion = multiSoftVersion.get("HuaweiMultipathVersion");
        String versionStr = huaweiMultiVersion.replaceAll("\\.", "");
        int version = StringUtils.str2Int((String)versionStr);
        String selfMultiState = multiSoftVersion.get("SelfMultiPath");
        if (-1 != version && "enabled".equals(selfMultiState)) {
            multiPathDesc.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.can.not.eval.huawie.self.enabled"));
            return false;
        }
        if (-1 != version) {
            multiPathDesc.append(ResourceUtil.getStringWithParams((String)"eval.host.task.compatfail.hbatimeout.huawei.multipath.version", (Object[])new Object[]{huaweiMultiVersion}));
            return HostHbaTimeOutService.checkMultiPathVer(isAix, version);
        }
        if ("enabled".equals(selfMultiState)) {
            multiPathDesc.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.self.multipath"));
            return false;
        }
        multiPathDesc.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.can.not.eval.no.multipath.version"));
        return false;
    }

    private EvalFeatureResult evalItemResult(String asmDiskGroupType, String asmHbeatiowait, EvalFeatureResult result, List<String> evalSNResult, StringBuilder oracleDesc) {
        if (asmDiskGroupType.contains(NORMAL) || asmDiskGroupType.contains(HIGH)) {
            try {
                int asmHbeatiowaitInt = Integer.parseInt(asmHbeatiowait);
                if (asmHbeatiowaitInt < 120) {
                    result.setItemResult(ItemResultEnum.NOTPASS);
                    oracleDesc.append(ResourceUtil.getStringWithParams((String)"eval.host.task.database.asmHbeatiowait.tolow", (Object[])new Object[]{asmHbeatiowaitInt, 120}));
                    return result;
                }
            }
            catch (NumberFormatException e) {
                result.setItemResult(ItemResultEnum.CANNOTEVAL);
                oracleDesc.append(ResourceUtil.getStringWithParams((String)"eval.host.task.database.asmHbeatiowait.error", (Object[])new Object[]{asmHbeatiowait}));
                return result;
            }
        }
        return result;
    }

    private void evalSNAndResult(List<String> evalSNResult) {
        List<Map<String, Object>> rusultMap = this.judgeSysAndLun();
        for (Map<String, Object> evalResult : rusultMap) {
            if (Boolean.parseBoolean(evalResult.get(RESULT).toString())) continue;
            evalSNResult.add(evalResult.get(SN).toString());
        }
    }

    private int transToVersionNUm(String dataBaseVersion) {
        String[] nums = dataBaseVersion.split("\\.");
        if (nums.length < 4) {
            return -1;
        }
        int wightOfPos = 100000;
        int result = 0;
        try {
            for (int i = 0; i < 4; ++i) {
                String numOfPos = nums[i];
                int numOfPosInt = Integer.parseInt(numOfPos);
                if (numOfPosInt == 0) {
                    wightOfPos /= 10;
                    continue;
                }
                result += numOfPosInt * wightOfPos;
                wightOfPos /= 10;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return result;
    }

    private void getLunNum() {
        String needHandleSn = dataStorageSN;
        List<Map<String, Object>> deviceInfos = this.prepareDeviceInfos(needHandleSn);
        for (Map<String, Object> deviceInfo : deviceInfos) {
            this.storageLUN = Integer.parseInt(deviceInfo.get(LUN_NUMBER).toString());
            LOGGER.info(String.format(Locale.ENGLISH, "sn : %s storageLUN : %s", dataStorageSN, this.storageLUN));
        }
    }

    private List<Map<String, Object>> judgeSysAndLun() {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String needHandleSn = dataStorageSN;
            List<Map<String, Object>> deviceInfos = this.prepareDeviceInfos(needHandleSn);
            LOGGER.info(String.format(Locale.ENGLISH, "deviceInfos:%s", deviceInfos));
            if (deviceInfos.isEmpty()) {
                result.put(SN, COLLECT_FAILED);
                result.put(RESULT, false);
                resultList.add(result);
                return resultList;
            }
            for (Map<String, Object> deviceInfo : deviceInfos) {
                String productLUN = deviceInfo.get(LUN_NUMBER).toString();
                String productModel = deviceInfo.get(MODEL).toString();
                String strProductVersion = deviceInfo.get(VERSION).toString();
                boolean checkCliModel = productModel.contains("--");
                boolean checkCliVersion = strProductVersion.contains("--");
                if (StringUtils.isNULLStr((String)productLUN) || StringUtils.isNULLStr((String)productModel) || StringUtils.isNULLStr((String)strProductVersion) || Integer.parseInt(productLUN) == -1 || checkCliModel || checkCliVersion) {
                    result.put(SN, deviceInfo.get(SN));
                    result.put(RESULT, false);
                    resultList.add(result);
                }
                if (Integer.parseInt(productLUN) <= 1000) continue;
                result.put(SN, deviceInfo.get(SN));
                result.put(RESULT, false);
                resultList.add(result);
            }
            return resultList;
        }
        catch (Exception e) {
            LOGGER.error("exec match error", e);
            SceneDataExchange.getInstance().saveKV("storageInfoStatus", "unknown");
            return resultList;
        }
    }

    public List<Map<String, Object>> prepareDeviceInfos(String needHandleSns) {
        ArrayList<Map<String, Object>> deviceInfos = new ArrayList<Map<String, Object>>();
        LOGGER.info(String.format(Locale.ENGLISH, "the data storage sn is :%s", dataStorageSN));
        HashMap<String, Object> deviceInfo = new HashMap<String, Object>();
        if (StringUtils.isNULLStr((String)needHandleSns)) {
            LOGGER.info(String.format(Locale.ENGLISH, "device sn is null:%s", needHandleSns));
            return deviceInfos;
        }
        String key = needHandleSns + "_systemInfo";
        String cli = SceneDataExchange.getInstance().loadKV(key);
        this.checkCli(cli);
        Map<String, String> modelAndVersionInfo = this.analysisSysModelVersion(cli);
        deviceInfo.put(SN, needHandleSns);
        deviceInfo.put(SYSTEM_INFO, cli);
        deviceInfo.put(MODEL, modelAndVersionInfo.get(MODEL));
        deviceInfo.put(VERSION, modelAndVersionInfo.get(VERSION));
        key = needHandleSns + "_LUNInfo";
        cli = SceneDataExchange.getInstance().loadKV(key);
        this.checkCli(cli);
        deviceInfo.put(LUN_INFO, cli);
        deviceInfo.put(LUN_NUMBER, this.calLunNumber(cli));
        deviceInfos.add(deviceInfo);
        LOGGER.info(String.format(Locale.ENGLISH, "deviceInfos:%s", ((Object)deviceInfos).toString()));
        return deviceInfos;
    }

    public void checkCli(String cli) {
        if (cli == null) {
            throw new NullPointerException("storageInfo is not obtained");
        }
    }

    private int calLunNumber(String cli) {
        int lunNum = 0;
        for (String line : cli.split("\\n")) {
            String[] stringSplit;
            Pattern pattern = Pattern.compile("[0-9]+");
            if (!pattern.matcher((stringSplit = line.trim().split("\\s+"))[0]).matches()) continue;
            ++lunNum;
        }
        if (lunNum == 0 && !cli.contains("successful")) {
            return -1;
        }
        return lunNum;
    }

    private Map<String, String> analysisSysModelVersion(String cli) {
        HashMap<String, String> modelVerInfo = new HashMap<String, String>();
        for (String line : cli.split("\\n")) {
            Pattern productModelPattern = Pattern.compile(PRODUCT_MODEL, 2);
            Pattern productVersionPattern = Pattern.compile(PRODUCT_VERSION, 2);
            String[] stringSplit = line.trim().split("\\||:");
            if (productModelPattern.matcher(stringSplit[0].trim()).matches()) {
                modelVerInfo.put(MODEL, stringSplit.length > 1 ? stringSplit[1] : "");
            }
            if (!productVersionPattern.matcher(stringSplit[0].trim()).matches()) continue;
            modelVerInfo.put(VERSION, stringSplit.length > 1 ? stringSplit[1] : "");
        }
        return modelVerInfo;
    }
}

