/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabWorktaker;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.upgradeevalu.adapter.EvalRuleManager;
import com.huawei.ism.tool.upgradeevalu.adapter.EvaluationFlow;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IAnalyzeMethod;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.iterface.IEvalService;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.util.Grab2EvalUtils;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class EvalServiceImpl
implements IEvalService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabWorktaker.class);
    private EvalRuleManager ruleManager;
    private IAnalyzeMethod analyzeMethod;
    private JythonExecuter jythonExecuter = new JythonExecuter();

    public EvalServiceImpl() {
        this.ruleManager = new EvalRuleManager();
        this.analyzeMethod = this.getIAnalyzeMethod();
    }

    public IAnalyzeMethod getIAnalyzeMethod() {
        return this.ruleManager;
    }

    @Override
    public EvalItemResult evalDevice(GrabResultEntity entity, EvalTaskResult taskResult) throws ToolException {
        EvalItemResult itemResult = HostEvalUtils.findEvalItemResult(entity, taskResult);
        try {
            if (!NodeAddEnum.GRAB_PKG.equals((Object)entity.getEvalNode().getNodeAddType())) {
                itemResult = Grab2EvalUtils.parseGrabResult(entity, itemResult);
            }
            this.evalItemResult(itemResult, taskResult);
        }
        catch (ToolException e) {
            itemResult.setItemResultEnum(ItemResultEnum.EVALUATION_STOP);
            itemResult.setFailedReason(ResourceUtil.getString((String)e.getErrorId()));
            LOGGER.error("parse grab result error", e);
        }
        catch (Exception e) {
            itemResult.setItemResultEnum(ItemResultEnum.EVALUATION_STOP);
            itemResult.setFailedReason(ResourceUtil.getString((String)"eval.host.evalfail.evaltool.tip"));
            LOGGER.error("parse grab result error", e);
        }
        return itemResult;
    }

    public EvalItemResult evalGrabResult(GrabResultEntity entity, EvalTaskResult taskResult) {
        EvalItemResult itemResult = HostEvalUtils.findEvalItemResult(entity, taskResult);
        try {
            itemResult = Grab2EvalUtils.parseGrabResult(entity, itemResult);
            this.evalItemResult(itemResult, taskResult);
        }
        catch (ToolException e) {
            itemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
            itemResult.setFailedReason(e.getLocalizedMessage());
            LOGGER.error("parse grab result error", e);
        }
        catch (Exception e) {
            itemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
            itemResult.setFailedReason(ResourceUtil.getString((String)"eval.host.evalfail.evaltool.tip"));
            LOGGER.error("parse grab result error", e);
        }
        return itemResult;
    }

    private void evalItemResult(EvalItemResult evalItemResult, EvalTaskResult taskResult) throws ToolException {
        try {
            evalItemResult.setItemResultEnum(ItemResultEnum.EVALUATING);
            Date createDate = new Date();
            evalItemResult.setCreateTime(createDate);
            this.execOneItem(evalItemResult);
            this.handleItemStatus(evalItemResult);
        }
        catch (ToolException e) {
            evalItemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
            evalItemResult.setMessageType(EvalItemResult.EvalMessageType.EXCEPTION_MESSAGE);
            evalItemResult.setFailedReason(e.getErrorLocaleDescription());
            throw new ToolException(e.getErrorId(), (Throwable)e);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "finish AllDevItem: %s", taskResult.getTaskInfo().getStorageInfo()));
    }

    private void execOneItem(EvalItemResult evalItemResult) throws ToolException {
        Map<ItDeviceType, EvaluationFlow> currEvaluationFlowMap = this.ruleManager.getEvaluationTypeFlow();
        List<RuleItem> ruleList = this.ruleManager.findCurrentItemFlow(currEvaluationFlowMap, evalItemResult.getItemInfo());
        if (null == ruleList) {
            evalItemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
            evalItemResult.setFailedReason(ResourceUtil.getString((String)"compatibility.compat.exception.no.rule.list"));
            return;
        }
        this.execAllRuleItem(ruleList, evalItemResult);
    }

    private void execAllRuleItem(List<RuleItem> ruleList, EvalItemResult evalItemResult) throws ToolException {
        for (RuleItem ruleItem : ruleList) {
            this.analyzeMethod.handleRules(ruleItem, evalItemResult, this.jythonExecuter);
            LOGGER.info(String.format(Locale.ENGLISH, "finish oneRuleItem: %s", ruleItem.getItemTitle()));
            this.dealwith4Report(evalItemResult);
        }
    }

    private void dealwith4Report(EvalItemResult evalItemResult) {
        List<EvalFeatureResult> allFeatureResult = evalItemResult.getFeatureResultList();
        EvalFeatureResult featureResult = allFeatureResult.get(allFeatureResult.size() - 1);
        featureResult.setOsName(evalItemResult.getItemInfo().getOsName());
        featureResult.setDevType(evalItemResult.getItemInfo().getDevInfo());
        String failDesc = featureResult.getFailDesc();
        String suggestFlag = CompatibilityResourceUtils.getUIString("feature.eval.detail.dialog.suggest.flag");
        String activeFlag = CompatibilityResourceUtils.getUIString("feature.eval.detail.dialog.actions.flag");
        if (failDesc.contains(suggestFlag) || failDesc.contains(activeFlag)) {
            int suggestIndex = -1 == failDesc.indexOf(suggestFlag) ? failDesc.indexOf(activeFlag) : failDesc.indexOf(suggestFlag);
            int suggestLength = -1 == failDesc.indexOf(suggestFlag) ? activeFlag.length() : suggestFlag.length();
            String suggest = failDesc.substring(suggestIndex + suggestLength + 1);
            failDesc = failDesc.substring(0, suggestIndex);
            if (!StringUtils.isNULLStr((String)suggest)) {
                featureResult.setSuggest(suggest);
            }
        }
        featureResult.setFailDesc(failDesc);
    }

    private void handleItemStatus(EvalItemResult evalItemResult) throws ToolException {
        List<EvalFeatureResult> featureList = evalItemResult.getFeatureResultList();
        int countNotPass = 0;
        int countCanNotEval = 0;
        int countOptimRecomd = 0;
        int countPass = 0;
        for (int i = 0; i < featureList.size(); ++i) {
            if (ItemResultEnum.NOTPASS.equals((Object)featureList.get(i).getItemResult())) {
                ++countNotPass;
                continue;
            }
            if (ItemResultEnum.CANNOTEVAL.equals((Object)featureList.get(i).getItemResult()) || ItemResultEnum.EVALUATION_STOP.equals((Object)featureList.get(i).getItemResult())) {
                ++countCanNotEval;
                continue;
            }
            if (ItemResultEnum.OPTIM_RECOMD.equals((Object)featureList.get(i).getItemResult())) {
                ++countOptimRecomd;
                continue;
            }
            if (!ItemResultEnum.PASS.equals((Object)featureList.get(i).getItemResult())) continue;
            ++countPass;
        }
        Date finishDate = new Date();
        evalItemResult.setFinishTime(finishDate);
        LOGGER.info(String.format(Locale.ENGLISH, "Finish OneDevItem: %s--%s--%s", new Object[]{evalItemResult.getItemInfo().getDeviceName(), evalItemResult.getItemInfo().getOsName(), evalItemResult.getItemResultEnum()}));
        if (countPass == featureList.size() && countPass != 0) {
            evalItemResult.setItemResultEnum(ItemResultEnum.PASS);
            return;
        }
        if (countNotPass > 0) {
            evalItemResult.setItemResultEnum(ItemResultEnum.NOTPASS);
        } else if (countCanNotEval > 0) {
            evalItemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
        } else if (countOptimRecomd > 0) {
            evalItemResult.setItemResultEnum(ItemResultEnum.OPTIM_RECOMD);
        } else {
            evalItemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
        }
    }
}

