/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.ListCellEntity;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.refresh.listenner.IProgressCallback;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public class ExecStorinfoProgressUpdater
implements IProgressCallback {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExecStorinfoProgressUpdater.class);
    private DevNode devNode;
    private EvalTaskResult evalTaskResult;
    private HostEvaluMainDialog dialog = HostEvaluMainDialog.getInstance();
    private ListCellEntity<ItemResultEnum> pregEntity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecStorinfoProgressUpdater(DevNode devNode, EvalTaskResult evalTaskResult) {
        this.devNode = devNode;
        this.evalTaskResult = evalTaskResult;
        List<ListCellEntity<ItemResultEnum>> listEntityts = evalTaskResult.getEvalDetailListHead();
        if (listEntityts.isEmpty()) {
            this.pregEntity = new ListCellEntity();
            this.pregEntity.setOperDate(new Date());
            this.pregEntity.setResultEnum((Object)ItemResultEnum.EVALUATING);
            this.pregEntity.setObject(devNode.getDeviceName());
            this.pregEntity.setEvalItemName("StorageInfoQry");
            this.pregEntity.setProgress(0.0f);
            this.pregEntity.setOperation(ResourceUtil.getString((String)"evalu.ui.mainDialog.evaluBefore.check"));
            HostEvaluMainDialog hostEvaluMainDialog = this.dialog;
            synchronized (hostEvaluMainDialog) {
                listEntityts.add(this.pregEntity);
                this.dialog.updateStorageDetail(evalTaskResult);
            }
        }
        if (!evalTaskResult.getEvalItemList().isEmpty()) {
            evalTaskResult.getEvalDetailListHead().remove(new ListCellEntity("eval.ui.start.load.storage.info.end", false));
            evalTaskResult.getEvalDetailListHead().remove(new ListCellEntity("eval.ui.start.load.storage.info.start", false));
        }
    }

    public void refresh(float progress) {
        LOGGER.info("update progress :{} sn:{}", (Object)Float.valueOf(progress), (Object)this.devNode.getDeviceSerialNumber());
        this.pregEntity.setProgress(progress);
        this.dialog.updateStorageDetail(this.evalTaskResult);
    }

    public void finsh(Object resultObject) {
        StorageInfo si = (StorageInfo)resultObject;
        if (si.getErrorCode() == 0) {
            this.pregEntity.setResultEnum((Object)ItemResultEnum.PASS);
        } else {
            this.pregEntity.setResultEnum((Object)ItemResultEnum.NOTPASS);
            this.pregEntity.setMessageTip(ResourceUtil.getString((String)"eval.retain.devinfo.error"));
        }
        this.pregEntity.setProgress(100.0f);
        this.dialog.updateStorageDetail(this.evalTaskResult);
    }
}

