/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.upgradeevalu.enums.ItElementType;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.parser.XmlItemParser;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class FilterBlackList {
    private static final String SOLUTION = "Solution_" + LanguageManager.getInstance().getCurrentLanguage().getLanguage();
    private static XmlItemParser xmlinstance = XmlItemParser.getInstance();
    private static final String HBA_FORMAT_STRING = "<b>HBA (Model : {0}, Driver Version : {1})</b> ";
    private static final String HBA_LINK_NA = "LINK-NA";

    public boolean compatibilityCheckBlackList(ItemInfo singleItemInfo, EvalFeatureResult baseConnectBlack, boolean isDirectConNet) {
        String hbaName = singleItemInfo.getHbaName().trim();
        if (hbaName.equals(HBA_LINK_NA)) {
            return true;
        }
        String systemName = this.getSystemName(singleItemInfo);
        if (this.checkSystemName(singleItemInfo, baseConnectBlack, systemName)) {
            return false;
        }
        String hbaDriver = singleItemInfo.getHbaDriverNum().trim();
        if (systemName.toLowerCase(Locale.ENGLISH).contains("vmware")) {
            if (!this.checkHBAinfo(singleItemInfo, baseConnectBlack)) {
                return false;
            }
        } else {
            return true;
        }
        String[] allHbaModel = hbaName.trim().split(";");
        String[] allHbaDV = hbaDriver.trim().split(";");
        String[] allHbaFW = singleItemInfo.getHbaFirmwareNum().trim().split(";");
        StringBuffer errMegBuffer = new StringBuffer();
        for (int i = 0; i < allHbaModel.length; ++i) {
            String meg;
            String format;
            Map<String, String> checkHbaInBlackList = xmlinstance.checkHbaInBlackList(allHbaModel[i], allHbaDV[i], allHbaFW[i], systemName);
            if (checkHbaInBlackList == null) continue;
            if (Integer.parseInt(checkHbaInBlackList.get("ID")) != 2) {
                format = MessageFormat.format(HBA_FORMAT_STRING, allHbaModel[i], allHbaDV[i]);
                meg = format + checkHbaInBlackList.get(SOLUTION);
                errMegBuffer.append(meg);
                continue;
            }
            if (!isDirectConNet) continue;
            format = MessageFormat.format(HBA_FORMAT_STRING, allHbaModel[i], allHbaDV[i]);
            meg = format + checkHbaInBlackList.get(SOLUTION);
            errMegBuffer.append(meg);
        }
        if (errMegBuffer.length() > 0) {
            baseConnectBlack.setItemResult(ItemResultEnum.NOTPASS);
            baseConnectBlack.setFailDesc(errMegBuffer.toString());
            CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "hba driver is incorrect");
            return false;
        }
        return true;
    }

    private boolean checkSystemName(ItemInfo singleItemInfo, EvalFeatureResult baseConnectBlack, String systemName) {
        if (StringUtils.isNULLStr((String)systemName) || systemName.equalsIgnoreCase("NA")) {
            baseConnectBlack.setItemResult(ItemResultEnum.CANNOTEVAL);
            baseConnectBlack.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.OsInfo.error"));
            CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "no os in element db");
            return true;
        }
        return false;
    }

    private String getSystemName(ItemInfo singleItemInfo) {
        String systemName = null;
        systemName = singleItemInfo.getEleMap().containsKey((Object)ItElementType.OS) ? singleItemInfo.getEleMap().get((Object)ItElementType.OS).get(0) : singleItemInfo.getOsName();
        return systemName;
    }

    private boolean checkHBAinfo(ItemInfo singleItemInfo, EvalFeatureResult baseConnectBlack) {
        String[] checkStr;
        String hbaDriver = singleItemInfo.getHbaDriverNum().trim();
        String hbaFirmw = singleItemInfo.getHbaFirmwareNum().trim();
        String hbaName = singleItemInfo.getHbaName().trim();
        if (org.apache.commons.lang3.StringUtils.isEmpty(hbaDriver)) {
            baseConnectBlack.setItemResult(ItemResultEnum.NOTPASS);
            baseConnectBlack.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaDriver.error"));
            CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "no hba driver");
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(hbaFirmw)) {
            baseConnectBlack.setItemResult(ItemResultEnum.NOTPASS);
            baseConnectBlack.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaFirmw.error"));
            CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "no hba fw");
            return false;
        }
        for (String str : checkStr = new String[]{"No HBA", "esxcfg", "NA", "??"}) {
            if (hbaDriver.contains(str) || this.checkHbaNameIsNull(hbaDriver)) {
                baseConnectBlack.setItemResult(ItemResultEnum.NOTPASS);
                baseConnectBlack.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaDriver.error"));
                CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "hba driver is incorrect");
                return false;
            }
            if (hbaFirmw.contains(str) || this.checkHbaNameIsNull(hbaFirmw)) {
                baseConnectBlack.setItemResult(ItemResultEnum.NOTPASS);
                baseConnectBlack.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaFirmw.error"));
                CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "hba fw is incorrect");
                return false;
            }
            if (!hbaName.contains(str) && !hbaName.equalsIgnoreCase("No HBA card type info.") && !this.checkHbaNameIsNull(hbaName)) continue;
            baseConnectBlack.setItemResult(ItemResultEnum.NOTPASS);
            baseConnectBlack.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaType.error"));
            CommonUtils.logEvalResultDetails(singleItemInfo.getDetails() + "no hba Model");
            return false;
        }
        return true;
    }

    public boolean checkHbaNameIsNull(String name) {
        return org.apache.commons.lang3.StringUtils.isEmpty(name) || name.equalsIgnoreCase(";") || name.equalsIgnoreCase("unknown");
    }
}

