/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.obase.entity.ListCellEntity;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.upgradeevalu.entity.DeviceDetails;
import com.huawei.ism.tool.upgradeevalu.entity.TaskDeviceTnfo;
import com.huawei.ism.tool.upgradeevalu.entity.TaskInfoByUserOPDate;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.enums.TaskStatusEnum;
import com.huawei.ism.tool.upgradeevalu.iterface.IEvalObserver;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityReportBuilder;
import com.huawei.ism.tool.upgradeevalu.service.DefaultGrabEvalObserver;
import com.huawei.ism.tool.upgradeevalu.service.EvalServiceImpl;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.tool.upgradeevalu.utils.ExcelCreater;
import com.huawei.json.JSONArray;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import utils.FilesUtil;

public class GrabEndHandler
extends DefaultGrabEvalObserver {
    private static final Logger LOGGER = Logger.getLogger(GrabEndHandler.class);
    private List<GrabDevNode2> toEvalGrabDevs = new ArrayList<GrabDevNode2>();
    private Map<GrabDevNode2, EvalItemResult> evalResultMap = new ConcurrentHashMap<GrabDevNode2, EvalItemResult>();
    private Map<String, Integer> evalPregMap = new ConcurrentHashMap<String, Integer>();
    private EvalTaskResult taskResult;
    private IEvalObserver progressUpdator;
    private ExecutorService executorService = null;
    private static final String SENCEIMPORT = "SENCEIMPORT";

    public List<GrabDevNode2> getToEvalGrabDevs() {
        return this.toEvalGrabDevs;
    }

    public void setProgressUpdator(IEvalObserver progressUpdator) {
        this.progressUpdator = progressUpdator;
    }

    public void setToEvalGrabDevs(List<GrabDevNode2> toEvalGrabDevs) {
        this.toEvalGrabDevs = toEvalGrabDevs;
    }

    public void setEvalResultMap(Map<GrabDevNode2, EvalItemResult> evalResultMap) {
        this.evalResultMap = evalResultMap;
    }

    public GrabEndHandler(List<GrabDevNode2> toEvalGrabDevs, EvalTaskResult taskResult) {
        this.toEvalGrabDevs = toEvalGrabDevs;
        for (GrabDevNode2 grabDevNode2 : toEvalGrabDevs) {
            this.evalPregMap.put(grabDevNode2.getDeviceSerialNumber(), 0);
        }
        this.taskResult = taskResult;
        int threadNum = Math.min(toEvalGrabDevs.size(), 5);
        this.executorService = Executors.newFixedThreadPool(threadNum);
        taskResult.setStartEvaTime(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDevGrabEnd(GrabResultEntity entity) {
        if (entity != null) {
            EvalItemResult result = HostEvalUtils.findEvalItemResult(entity, this.taskResult);
            try {
                if (HostEvalUtils.isTaskEnd(result.getItemResultEnum())) {
                    return;
                }
                if (entity.isGrabStop()) {
                    this.handleGrabStopState(entity, result);
                    return;
                }
                if (entity.isGrabFailed()) {
                    this.handleGrabFailedState(entity, result);
                    return;
                }
                EvalServiceImpl service = new EvalServiceImpl();
                result.setProcessBar(90);
                entity.setCurProgress(90);
                this.refreshPregress(entity);
                if (StringUtils.isEmpty(entity.getErrorMessage())) {
                    if (!StringUtils.isEmpty(entity.getErrorMessageKey())) {
                        result.setItemResultEnum(ItemResultEnum.EVALUATION_STOP);
                        result.setFailedReason(ResourceUtil.getString((String)entity.getErrorMessageKey()));
                    } else {
                        result = service.evalDevice(entity, this.taskResult);
                    }
                } else {
                    result.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
                    result.setFailedReason(ResourceUtil.getString((String)"eval.host.evalfail.grab.tip"));
                }
            }
            catch (ToolException e) {
                LOGGER.error("ToolException evalerror");
            }
            catch (Exception e) {
                LOGGER.error("Exception evalerror", e);
            }
            finally {
                result.setProcessBar(100);
                entity.setCurProgress(100);
                this.checkDeviceSerialNumber(entity, result);
                this.refreshPregress(entity);
                this.progressUpdator.updateProgress(this.taskResult);
                this.evalResultMap.put(entity.getEvalNode(), result);
                this.startGenReportOnEvalEnd();
            }
        }
    }

    private void checkDeviceSerialNumber(GrabResultEntity entity, EvalItemResult result) {
        if (result.getEvalDevNode().getDeviceSerialNumber().equals(entity.getEvalNode().getDeviceSerialNumber()) && !StringUtils.isBlank(result.getFailedReason())) {
            entity.setErrorMessage(result.getFailedReason());
            entity.setErrorMessageKey("");
        }
    }

    public void startGenReportOnEvalEnd() {
        if (this.isAllEvalEnd()) {
            HostEvalUtils.handleTaskStatus(this.taskResult);
            HostEvalContext.getHostRvalResult().put(this.taskResult.getHostEvalTask().getIdentifier(), this.taskResult);
            GrabResultEntity entity = new GrabResultEntity();
            this.triggerGrabTaskEnd(entity);
        }
    }

    public boolean isAllEvalEnd() {
        for (Map.Entry<String, Integer> entry : this.evalPregMap.entrySet()) {
            if (entry.getValue() == 100) continue;
            return false;
        }
        return true;
    }

    public void handleGrabFailedState(GrabResultEntity entity, EvalItemResult result) {
        result.setItemResultEnum(ItemResultEnum.EVALUATION_STOP);
        if (!StringUtils.isBlank(entity.getErrorMessageKey()) && !"--".equals(ResourceUtil.getString((String)entity.getErrorMessageKey()))) {
            result.setFailedReason(ResourceUtil.getString((String)entity.getErrorMessageKey()));
        } else if (!StringUtils.isBlank(entity.getErrorMessage()) && !"--".equals(entity.getErrorMessage())) {
            result.setFailedReason(entity.getErrorMessage());
        } else {
            result.setFailedReason(ResourceUtil.getString((String)"eval.host.evalfail.grab.tip"));
        }
    }

    public void handleGrabStopState(GrabResultEntity entity, EvalItemResult result) {
        result.setItemResultEnum(ItemResultEnum.EVALUATION_STOP);
        result.setFailedReason(ResourceUtil.getString((String)"eval.host.grab.task.stoped.tip"));
    }

    private String evalResultReportUrl(EvalTaskResult evalTaskResult) {
        Object reportPath = HibernateContainer.getInstance().get((Object)"offLineReportDir");
        File reportDirFile = HostEvalContext.getInstance().getReportDir();
        String reportDirPath = "";
        if (null != reportDirFile) {
            reportDirPath = FilesUtil.getCanonicalPath((File)reportDirFile);
        }
        String reportFile = reportPath != null ? reportPath.toString() : reportDirPath;
        reportFile = reportFile + File.separator + "temp";
        StringBuffer fileName = new StringBuffer();
        fileName.append(evalTaskResult.getHostEvalTask().getIdentifier());
        fileName.append("_EvalResult");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        fileName.append(simpleDateFormat.format(new Date()));
        fileName.append(".xls");
        evalTaskResult.setEvalResultUrl(reportFile + File.separator + fileName.toString());
        evalTaskResult.setOriginalExcelUrl(fileName.toString());
        return reportFile + File.separator + fileName.toString();
    }

    @Override
    public void refreshPregress(GrabResultEntity entity) {
        try {
            if (entity.isRefreshing()) {
                this.executorService.execute(new RefreshGrabProgress(entity));
                return;
            }
            EvalItemResult detailItem = HostEvalUtils.findEvalItemResult(entity, this.taskResult);
            if (0 < entity.getCurProgress() && entity.getCurProgress() < 100) {
                detailItem.setItemResultEnum(ItemResultEnum.EVALUATING);
            }
            detailItem.setProcessBar(entity.getCurProgress());
            this.progressUpdator.updateEvalDetail(detailItem);
            this.updateTaskTotalProgress(entity);
        }
        catch (Exception e) {
            LOGGER.error("update progress error", e);
        }
    }

    public void updateTaskTotalProgress(GrabResultEntity entity) {
        this.evalPregMap.put(entity.getEvalNode().getDeviceSerialNumber(), entity.getCurProgress());
        int totalPreg = 0;
        for (GrabDevNode2 node : this.toEvalGrabDevs) {
            Integer preg = this.evalPregMap.get(node.getDeviceSerialNumber());
            if (preg == null) continue;
            totalPreg += preg.intValue();
        }
        int realPregress = totalPreg / this.evalPregMap.size();
        this.taskResult.setProgressCurrent(realPregress);
        if (realPregress >= 0 && realPregress < 100) {
            this.taskResult.setTaskStatus(TaskStatusEnum.EVALUATING);
        }
        this.progressUpdator.updateProgress(this.taskResult);
    }

    public void triggerGrabTaskEnd(GrabResultEntity entity) {
        this.taskResult.getTaskInfo().setTaskUrl(entity.getGrabConbineResultFile());
        if (HostEvalUtils.isTaskEnd(this.taskResult.getTaskStatus())) {
            this.taskResult.setProgressCurrent(100.0f);
            this.taskResult.setEvaluTime(new Date());
            this.progressUpdator.updateProgress(this.taskResult);
        }
        HostEvalContext.getHostEvaledMap().put(this.taskResult.getHostEvalTask().getStorageSn(), true);
        this.taskResult.setFinishTime(new Date());
        this.generateTaskXlsReport();
        if (this.taskResult.getHostEvalTask().getNotAddedInitNumbers() > 0) {
            ListCellEntity e = new ListCellEntity(ResourceUtil.getString((String)"eval.initiator.added.missing.end.eval.warning.tip"), true);
            e.setShowSingleTip(true);
            if (!this.taskResult.getEvalDetailListEnd().contains(e)) {
                this.taskResult.getEvalDetailListEnd().add((ListCellEntity<ItemResultEnum>)e);
                HostEvaluMainDialog.getInstance().updateStorageDetail(this.taskResult);
            }
        }
        this.generateFinalReport();
    }

    public void generateTaskXlsReport() {
        try {
            ExcelCreater.getInstance().buildCampabilityReport(this.taskResult, this.evalResultReportUrl(this.taskResult));
        }
        catch (Exception e) {
            LOGGER.error("generate report error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFinalReport() {
        final Map<String, EvalTaskResult> map = HostEvalContext.getCurHostRvalResult();
        IEvalObserver iEvalObserver = this.progressUpdator;
        synchronized (iEvalObserver) {
            for (EvalTaskResult task : map.values()) {
                if (HostEvalUtils.isTaskEnd(task.getTaskStatus())) continue;
                return;
            }
        }
        this.progressUpdator.notifyReportGenStart(5);
        Thread task = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GrabContext.countDownLatch.await();
                    LOGGER.info("this thread begin to generate final report");
                    Map<String, EvalTaskResult> hostRvalResult = HostEvalContext.getHostRvalResult();
                    List<TaskInfoByUserOPDate> taskUserDateList = HostEvalContext.getInstance().getTaskUserDateList();
                    TaskInfoByUserOPDate taskUserDate = taskUserDateList.get(taskUserDateList.size() - 1);
                    Map<String, TaskDeviceTnfo> storageMap = taskUserDate.getStorageMap();
                    for (String sn : storageMap.keySet()) {
                        EvalTaskResult evalTaskResult = hostRvalResult.get(sn);
                        List hostInfolist = GrabEndHandler.this.buildDeviceDate(evalTaskResult);
                        String hostInfos = JSON.toJSONString(hostInfolist);
                        JSONArray hostInfosToJson = new JSONArray(hostInfos);
                        storageMap.get(sn).setHostInfo(hostInfosToJson);
                    }
                    CompatibilityReportBuilder crb = new CompatibilityReportBuilder();
                    crb.buildReport(map, HostEvalContext.getInstance().getReportDir(), GrabEndHandler.this.progressUpdator);
                }
                catch (InterruptedException e) {
                    LOGGER.error("this thread has wait error", e);
                }
                finally {
                    GrabEndHandler.this.progressUpdator.notifyAllTaskEnd();
                }
            }
        });
        task.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                LOGGER.error(thread.getName() + ":" + throwable.getMessage());
            }
        });
        task.setName("GenerateReportThread");
        task.start();
    }

    private List<DeviceDetails> buildDeviceDate(EvalTaskResult evalTaskResult) {
        List<EvalItemResult> evalItemList = evalTaskResult.getEvalItemList();
        ArrayList<DeviceDetails> deviceDetails = new ArrayList<DeviceDetails>();
        GrabContext context = GrabContext.getInstance();
        Map<String, String> devOffAndOnLine = context.getDevOffAndOnLineMap();
        for (EvalItemResult evalItemResult : evalItemList) {
            ItemInfo itemInfo = evalItemResult.getItemInfo();
            DeviceDetails deviceDetail = new DeviceDetails();
            deviceDetail.setDeviceType(itemInfo.getDevInfo());
            deviceDetail.setDeviceVersion(itemInfo.getOsName());
            deviceDetail.setHbaVersion(itemInfo.getHbaTimeOut());
            deviceDetail.setMultipathVersion(itemInfo.getMultiSoftEdition());
            deviceDetail.setNetWork(itemInfo.getFcNetInfo());
            deviceDetail.setSupperUser(itemInfo.getSuperUser());
            if (!StringUtils.isEmpty(itemInfo.getIp())) {
                String importType = devOffAndOnLine.get(itemInfo.getIp()) == null ? SENCEIMPORT : devOffAndOnLine.get(itemInfo.getIp());
                deviceDetail.setDevImportType(importType);
            }
            deviceDetail.setEvaluationResults(evalItemResult.getItemResultEnum());
            List<EvalFeatureResult> featureResultList = evalItemResult.getFeatureResultList();
            for (EvalFeatureResult evalFeatureResult : featureResultList) {
                ItemResultEnum itemResult = evalFeatureResult.getItemResult();
                switch (itemResult) {
                    case CANNOTEVAL: {
                        deviceDetail.getCanNoteValItem().add(evalFeatureResult.getFeatureId());
                        break;
                    }
                    case NOTPASS: {
                        deviceDetail.getNotPassItem().add(evalFeatureResult.getFeatureId());
                        break;
                    }
                }
            }
            deviceDetails.add(deviceDetail);
        }
        return deviceDetails;
    }

    private class RefreshGrabProgress
    implements Runnable {
        private GrabResultEntity resultEntity = null;
        private EvalItemResult detailItem = null;

        public RefreshGrabProgress(GrabResultEntity entity) {
            this.resultEntity = entity;
            this.detailItem = HostEvalUtils.findEvalItemResult(this.resultEntity, GrabEndHandler.this.taskResult);
        }

        @Override
        public void run() {
            while (this.detailItem.getProcessBar() < Math.min(this.resultEntity.getCurProgress(), 90)) {
                if (0 < this.resultEntity.getCurProgress() && this.resultEntity.getCurProgress() < 100) {
                    this.detailItem.setItemResultEnum(ItemResultEnum.EVALUATING);
                }
                this.detailItem.setProcessBar(this.detailItem.getProcessBar() + 1);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("sleep error.");
                }
            }
        }
    }
}

