/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import com.huawei.ism.util.CommonUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import utils.Products;

public class HostHbaTimeOutService
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HostHbaTimeOutService.class);
    private static final String JSON_TIMEOUT = "Timeout";
    public static final int HUAWEI_MULTIPATH_VERSION_SEP = 801000;
    public static final int HUAWEI_AIX_MULTIPATH_VERSION_SEP = 803028;
    public static final int HBA_TIMEOUT_SEP = 6;
    public static final int VMWARE_HBA_TIMEOUT_SEP = 11;
    public static final int WRONG_VALUE_TO_INT = -1;
    public static final String JSON_HUAWEI_MULTIPATH = "HuaweiMultipathVersion";
    public static final String JSON_SELF_MULTIPATH = "SelfMultiPath";
    public static final String JSON_SELFMP_ENABLED = "enabled";
    private static final String AIX_PASS_FLAG = "changed";
    private static final String AIX_PASS_FLAG2 = "not involved";
    private static final String AIX_NOT_PASS_FLAG = "unchanged";
    private static final String QLOGIC_NO_PLUGINS = "Unknown";
    private static final String HBA_TIMEOUT_ERROR = "Error";
    private static final String HBA_TIMEOUT_DEFAULT = "default";
    private static final String[] AVAILABLE_TIMEOUT_AIX = new String[]{"unchanged", "changed", "not involved"};
    private static final String[] AVAILABLE_TIMEOUT_OTHERS = new String[]{"Error", "default"};
    private static final String OS_AIX = "AIX";
    private static final String OS_VMWARE = "VMware";
    private static final String OS_WINDOWS = "Windows";
    private static final String RUL_ITEM = "itemInfo";
    private static final String BLANK_SPACE = " ";
    public static final String LINE_FEED = "\n";
    private boolean notPass;
    private boolean storagePass;
    private boolean cannotEval;
    private boolean toBeConfirmed;
    private String toBeConfirmedInfo;
    private boolean hasErrorMeg;
    private boolean isHasOperateSys = true;
    private StringBuilder multiPathInfo = new StringBuilder();
    private String deviceType;
    private String productVersion;
    private String osType;
    private String osName;
    private boolean isAix;
    private boolean isVMware;
    private boolean isWindows;
    private String notPassedDesc;
    private String cannotEvalDesc;

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        this.notPassedDesc = ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.passed");
        this.cannotEvalDesc = ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.can.not.eval");
        ArrayList<String> faildInfo = new ArrayList<String>();
        EvalFeatureResult result = new EvalFeatureResult();
        Object itemInfoObj = evalContext.get(RUL_ITEM);
        ItemInfo itemInfo = (ItemInfo)CommonUtil.convertObject((Object)itemInfoObj, ItemInfo.class);
        this.osType = itemInfo.getDevInfo();
        this.osName = itemInfo.getOsName();
        Map<String, String> multiSoftVersion = HostHbaTimeOutService.parseJson2Map(itemInfo.getMultiSoftEdition());
        DevNode curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        if (null != curHostStorageDev) {
            this.deviceType = curHostStorageDev.getDeviceType().toString();
            this.productVersion = curHostStorageDev.getProductVersion();
            itemInfo.getInfoGrabMetaMsg().put("StorageModel", "{deviceType: " + this.deviceType + ", productVersion: " + this.productVersion + "}");
        }
        this.checkHostFCTimeOut(result, itemInfo, this.isAix, this.isVMware, this.isWindows, this.multiPathInfo);
        this.checkWithMultiPathVersion(multiSoftVersion);
        this.fill2EvalResult(faildInfo, result);
        if (this.storagePass) {
            result.setItemResult(ItemResultEnum.PASS);
        }
        return (T)result;
    }

    public void checkHostFCTimeOut(EvalFeatureResult result, ItemInfo itemInfo, Boolean isAixHost, Boolean isVmwareHost, Boolean isWindowsHost, StringBuilder multiPathDesc) {
        List<Map<String, String>> allTimeout = new ArrayList<Map<String, String>>();
        ArrayList<String> faildInfo = new ArrayList<String>();
        try {
            allTimeout = this.parseJson2List(itemInfo.getHbaTimeOut(), isAixHost);
        }
        catch (ToolException e) {
            this.buildTimeOutDate(allTimeout);
            if (e.getErrorId().equals(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.changetips"))) {
                if (isWindowsHost.booleanValue()) {
                    this.handleWindowsNoPlug(itemInfo.getHbaTimeOut());
                } else {
                    result.setItemResult(ItemResultEnum.CANNOTEVAL);
                    result.setFailDesc(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.reason") + ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.tips") + LINE_FEED + LINE_FEED + ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.changetips"));
                }
            } else {
                this.createNoTimeOutResult(result, isAixHost, isVmwareHost);
            }
            return;
        }
        catch (Exception e) {
            this.createNoTimeOutResult(result, isAixHost, isVmwareHost);
            this.buildTimeOutDate(allTimeout);
        }
        for (Map<String, String> singleTimeout : allTimeout) {
            String timeoutStr = singleTimeout.get(JSON_TIMEOUT);
            int timeout = -1;
            if (this.isWindowsEmulexTmo(timeoutStr)) {
                if (-1 != HostHbaTimeOutService.getWindowsTmo(timeoutStr)) {
                    timeout = HostHbaTimeOutService.getWindowsTmo(timeoutStr);
                }
            } else {
                timeout = StringUtils.str2Int((String)timeoutStr);
            }
            this.checkTimeOut(result, isAixHost, isVmwareHost, faildInfo, singleTimeout, timeoutStr, timeout);
        }
        this.fill2Result(faildInfo, result, itemInfo, multiPathDesc);
    }

    private void checkTimeOut(EvalFeatureResult result, Boolean isAixHost, Boolean isVmwareHost, List<String> faildInfo, Map<String, String> singleTimeout, String timeoutStr, int timeout) {
        if (isAixHost.booleanValue()) {
            this.checkAixTimeout(singleTimeout, result, faildInfo, isAixHost, isVmwareHost);
            return;
        }
        if (timeout < (isVmwareHost != false ? 11 : 6) && -1 != timeout) {
            return;
        }
        result.setItemResult(ItemResultEnum.NOTPASS);
        this.structureFaildInfo(faildInfo, singleTimeout, timeoutStr, isAixHost, isVmwareHost);
    }

    private void buildTimeOutDate(List<Map<String, String>> allTimeout) {
        allTimeout.add(new HashMap());
    }

    private void createNoTimeOutResult(EvalFeatureResult result, Boolean isAixHost, Boolean isVmwareHost) {
        result.setItemResult(ItemResultEnum.CANNOTEVAL);
        LOGGER.error("No valid HBA timeout parameter is obtained.");
        result.setFailDesc(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.no.hba.timeout.info") + LINE_FEED + ResourceUtil.getStringWithParams((String)"eval.host.task.compatfail.hbatimeout.no.hba.timeout.info.recommended.actions", (Object[])new Object[]{isAixHost != false ? "fast_fail" : (isVmwareHost != false ? "\u226410" : "\u22645")}));
    }

    private void handleWindowsNoPlug(String tmoJson) {
        EvalFeatureResult result = new EvalFeatureResult();
        JSONArray ja = new JSONArray(tmoJson);
        boolean isQlogicUnknown = false;
        boolean isEmulexUnknown = false;
        for (int i = 0; i < ja.length(); ++i) {
            HashMap<String, String> hbaTmoMap = new HashMap<String, String>();
            JSONObject jo = ja.getJSONObject(i);
            HostHbaTimeOutService.fillJson2Map(hbaTmoMap, jo);
            String hbaModel = (String)hbaTmoMap.get("HBAModel");
            String hbaTmo = (String)hbaTmoMap.get(JSON_TIMEOUT);
            if (!QLOGIC_NO_PLUGINS.equalsIgnoreCase(hbaTmo)) continue;
            if ("Qlogic".equalsIgnoreCase(hbaModel)) {
                isQlogicUnknown = true;
            }
            if (!"Emulex".equalsIgnoreCase(hbaModel)) continue;
            isEmulexUnknown = true;
        }
        result.setItemResult(ItemResultEnum.CANNOTEVAL);
        result.setFailDesc(HostHbaTimeOutService.createFaileDescByKey(isQlogicUnknown, isEmulexUnknown));
    }

    private static String createFaileDescByKey(boolean isQlogicUnknown, boolean isEmulexUnknown) {
        String descKey = isQlogicUnknown && isEmulexUnknown ? ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.emulex.qlogic.tips") : (isQlogicUnknown ? ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.tips") : ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.emulex.tips"));
        return ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.reason") + descKey + LINE_FEED + LINE_FEED + ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.changetips");
    }

    private static int getWindowsTmo(String timeOut) {
        int linkTimeOut = -1;
        int nodeTimeOut = -1;
        int winTmoOut = -1;
        String[] tmos = timeOut.split("\\,");
        try {
            for (String tmo : tmos) {
                if (tmo.contains("linkTimeOut")) {
                    linkTimeOut = StringUtils.str2Int((String)tmo.split(":")[1]);
                    continue;
                }
                if (!tmo.contains("nodeTimeOut")) continue;
                nodeTimeOut = StringUtils.str2Int((String)tmo.split(":")[1]);
            }
        }
        catch (Exception e) {
            return winTmoOut;
        }
        if (-1 == linkTimeOut || -1 == nodeTimeOut) {
            return winTmoOut;
        }
        winTmoOut = linkTimeOut > nodeTimeOut ? linkTimeOut : nodeTimeOut;
        return winTmoOut;
    }

    public static void checkOsType(String hostType, String osName, HashMap<String, Boolean> hostTypeMap) {
        if (OS_AIX.equalsIgnoreCase(hostType) || osName.contains(OS_AIX)) {
            hostTypeMap.put("isAixHost", true);
        }
        if (OS_VMWARE.equalsIgnoreCase(hostType) || osName.contains(OS_VMWARE)) {
            hostTypeMap.put("isVmwareHost", true);
        }
        if (OS_WINDOWS.equalsIgnoreCase(hostType) || osName.contains(OS_WINDOWS)) {
            hostTypeMap.put("isWindowsHost", true);
        }
    }

    private void checkAixTimeout(Map<String, String> singleTimeout, EvalFeatureResult result, List<String> faildInfo, Boolean isHostAix, Boolean isHostVmware) {
        String timeoutStr = singleTimeout.get(JSON_TIMEOUT);
        if (AIX_NOT_PASS_FLAG.equals(timeoutStr)) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            this.structureFaildInfo(faildInfo, singleTimeout, timeoutStr, isHostAix, isHostVmware);
        }
    }

    private void fill2Result(List<String> faildInfo, EvalFeatureResult result, ItemInfo itemInfo, StringBuilder multiPathDesc) {
        if (ItemResultEnum.NOTPASS.equals((Object)result.getItemResult())) {
            StringBuilder faildMessage2 = new StringBuilder();
            faildMessage2.append(ResourceUtil.getStringWithParams((String)"eval.host.task.compatfail.hbatimeout.os", (Object[])new Object[]{itemInfo.getOsName(), itemInfo.getIp()})).append(LINE_FEED);
            if (!StringUtils.isNULLStr((String)multiPathDesc.toString())) {
                faildMessage2.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.multipath.software"));
                faildMessage2.append((CharSequence)multiPathDesc).append(LINE_FEED);
            }
            faildMessage2.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.hba.timeout.title")).append(LINE_FEED);
            faildMessage2.append(HostHbaTimeOutService.transferList2Str(faildInfo));
            String notPassedDescs = ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.passed");
            StringBuffer notPassedDescBf = new StringBuffer(notPassedDescs);
            notPassedDescBf.append(LINE_FEED).append(faildMessage2.toString()).append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.recommended.actions"));
            result.setFailDesc(notPassedDescBf.toString());
        }
    }

    private void fill2EvalResult(List<String> faildInfo, EvalFeatureResult result) {
        StringBuilder faildMessage2 = new StringBuilder();
        if (!this.isHasOperateSys) {
            faildMessage2.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.no.os.info"));
        } else {
            faildMessage2.append(ResourceUtil.getStringWithParams((String)"eval.host.task.compatfail.hbatimeout.os", (Object[])new Object[]{this.osName})).append(LINE_FEED);
            if (!StringUtils.isNULLStr((String)this.multiPathInfo.toString())) {
                faildMessage2.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.multipath.software"));
                faildMessage2.append((CharSequence)this.multiPathInfo).append(LINE_FEED);
            }
            faildMessage2.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.hba.timeout.title")).append(LINE_FEED);
            faildMessage2.append(HostHbaTimeOutService.transferList2Str(faildInfo));
        }
        if (this.cannotEval) {
            this.cannotEvalDesc = this.cannotEvalDesc + LINE_FEED + faildMessage2.toString();
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            result.setFailDesc(this.cannotEvalDesc);
        } else if (this.notPass) {
            if (!this.hasErrorMeg) {
                result.setItemResult(ItemResultEnum.NOTPASS);
                this.notPassedDesc = this.notPassedDesc + LINE_FEED + faildMessage2.toString();
                this.notPassedDesc = this.notPassedDesc + ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.recommended.actions");
                result.setFailDesc(this.notPassedDesc);
            }
        } else if (this.toBeConfirmed) {
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            result.setFailDesc(this.toBeConfirmedInfo + LINE_FEED + faildMessage2.toString());
        }
    }

    private void checkWithStorageVersion(boolean isAixOs) {
        if (StringUtils.isNULLStr((String)this.deviceType) || StringUtils.isNULLStr((String)this.productVersion)) {
            this.toBeConfirmedInfo = isAixOs ? ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.aix.no.StorageType.info") : ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.other.no.StorageType.info");
            this.toBeConfirmed = true;
            return;
        }
        this.checkDeviceTypeAndVersion(isAixOs);
    }

    private void structureFaildInfo(List<String> faildInfo, Map<String, String> singleTimeout, String timeoutStr, Boolean isHostAix, Boolean isHostVmware) {
        if (singleTimeout.containsKey(JSON_TIMEOUT)) {
            singleTimeout.remove(JSON_TIMEOUT);
            faildInfo.add(ResourceUtil.getStringWithParams((String)"eval.host.task.compatfail.hbatimeout.not.pass.error.tips", (Object[])new Object[]{HostHbaTimeOutService.transferMap2Str(singleTimeout), timeoutStr, isHostAix != false ? "fast_fail" : (isHostVmware != false ? "10" : "5")}));
        }
    }

    private void checkDeviceTypeAndVersion(boolean isAixOs) {
        this.deviceType = this.deviceType.toLowerCase(Locale.ENGLISH);
        this.productVersion = this.productVersion.toLowerCase(Locale.ENGLISH);
        this.storagePass = true;
        if (isAixOs) {
            this.checkAix2StorageVersion();
        } else {
            this.checkOthersystem2StorageVersion();
        }
    }

    private void checkOthersystem2StorageVersion() {
        if (this.deviceType.contains("t") && this.productVersion.compareTo("v200r002c20spc200") >= 0) {
            return;
        }
        if ((this.deviceType.contains("hvs") || this.deviceType.contains("18")) && this.productVersion.contains("v1") && this.productVersion.compareTo("v100r001c20spc200") >= 0) {
            return;
        }
        if (this.productVersion.compareTo("v300r001c10spc200") >= 0) {
            return;
        }
        this.notPass = true;
        this.storagePass = false;
    }

    private void checkAix2StorageVersion() {
        if (this.deviceType.contains("dorado") && this.productVersion.compareTo("v300r001c00") >= 0 || Products.isDigitalVer((String)this.productVersion)) {
            return;
        }
        if (this.productVersion.compareTo("v300r003c20spc200") >= 0) {
            return;
        }
        this.notPass = true;
        this.storagePass = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkWithMultiPathVersion(Map<String, String> multiSoftVersion) {
        String huaweiMultiVersion = multiSoftVersion.get(JSON_HUAWEI_MULTIPATH);
        String versionStr = huaweiMultiVersion.replaceAll("\\.", "");
        int version = StringUtils.str2Int((String)versionStr);
        String selfMultiState = multiSoftVersion.get(JSON_SELF_MULTIPATH);
        if (-1 != version && JSON_SELFMP_ENABLED.equals(selfMultiState)) {
            this.notPass = true;
            this.multiPathInfo.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.can.not.eval.huawie.self.enabled"));
            return;
        }
        if (-1 != version) {
            this.multiPathInfo.append(ResourceUtil.getStringWithParams((String)"eval.host.task.compatfail.hbatimeout.huawei.multipath.version", (Object[])new Object[]{huaweiMultiVersion}));
            if (HostHbaTimeOutService.checkMultiPathVer(this.isAix, version)) {
                this.checkWithStorageVersion(this.isAix);
                return;
            }
            this.notPass = true;
            return;
        }
        if (JSON_SELFMP_ENABLED.equals(selfMultiState)) {
            this.notPass = true;
            this.multiPathInfo.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.self.multipath"));
            return;
        }
        this.multiPathInfo.append(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.can.not.eval.no.multipath.version"));
        this.notPass = true;
    }

    public static boolean checkMultiPathVer(Boolean isAixHost, int version) {
        return isAixHost == false && 801000 <= version || isAixHost != false && 803028 <= version;
    }

    private static String transferList2Str(List<String> faildMessageList) {
        StringBuilder faildMessage = new StringBuilder();
        for (String singleMessage : faildMessageList) {
            faildMessage.append(singleMessage);
            faildMessage.append(LINE_FEED);
        }
        return faildMessage.toString();
    }

    private static String transferMap2Str(Map<String, String> singleTimeout) {
        String timeoutInfo = ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.brackets.left");
        String colon = ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.colon");
        String comma = ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.comma");
        StringBuilder str = new StringBuilder();
        Set<Map.Entry<String, String>> entries = singleTimeout.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String value = entry.getValue();
            if (StringUtils.isNULLStr((String)value) || "NA".equals(value)) continue;
            str.append(entry.getKey());
            str.append(colon + BLANK_SPACE);
            str.append(value);
            str.append(comma + BLANK_SPACE);
        }
        if (0 == str.length()) {
            return "";
        }
        timeoutInfo = timeoutInfo + str.substring(0, str.length() - comma.length() - 1) + ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.brackets.right");
        return timeoutInfo;
    }

    private List<Map<String, String>> parseJson2List(String jsonStr, Boolean isAixHost) throws ToolException {
        if (org.apache.commons.lang3.StringUtils.isBlank(jsonStr) || jsonStr.length() <= 2) {
            throw new ToolException(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.no.hba.timeout.info"));
        }
        ArrayList<Map<String, String>> allInfo = new ArrayList<Map<String, String>>();
        JSONArray ja = new JSONArray(jsonStr);
        for (int i = 0; i < ja.length(); ++i) {
            HashMap<String, String> singleInfo = new HashMap<String, String>();
            JSONObject jo = ja.getJSONObject(i);
            HostHbaTimeOutService.fillJson2Map(singleInfo, jo);
            allInfo.add(singleInfo);
            String timeoutStr = (String)singleInfo.get(JSON_TIMEOUT);
            if (null != timeoutStr) {
                if (QLOGIC_NO_PLUGINS.equalsIgnoreCase(timeoutStr)) {
                    throw new ToolException(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.not.plugins.error.changetips"));
                }
                int timeout = this.isWindowsEmulexTmo(timeoutStr) ? HostHbaTimeOutService.getWindowsTmo(timeoutStr) : StringUtils.str2Int((String)timeoutStr);
                if (-1 != timeout && timeout >= 0) {
                    if (!timeoutStr.contains(".")) {
                        continue;
                    }
                } else if (isAixHost.booleanValue()) {
                    if (HostHbaTimeOutService.checkWithDeviceType(AVAILABLE_TIMEOUT_AIX, timeoutStr)) {
                        continue;
                    }
                } else if (HostHbaTimeOutService.checkWithDeviceType(AVAILABLE_TIMEOUT_OTHERS, timeoutStr)) {
                    throw new ToolException(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.no.hba.timeout.info"));
                }
            }
            throw new ToolException(ResourceUtil.getString((String)"eval.host.task.compatfail.hbatimeout.no.hba.timeout.info"));
        }
        LOGGER.info(String.format(Locale.ENGLISH, "the hba timeout information is :%s", allInfo));
        return allInfo;
    }

    private boolean isWindowsEmulexTmo(String timeOut) {
        return !StringUtils.isNULLStr((String)timeOut) && timeOut.contains("linkTimeOut") && timeOut.contains(",");
    }

    private static boolean checkWithDeviceType(String[] availableTimeouts, String timeoutStr) {
        for (String availableTimeout : availableTimeouts) {
            if (!availableTimeout.equals(timeoutStr)) continue;
            return true;
        }
        return false;
    }

    private static void fillJson2Map(Map<String, String> singleInfo, JSONObject jsonObject) {
        for (Object key : jsonObject.keySet()) {
            Object value = jsonObject.get(key.toString());
            if (value instanceof JSONObject) {
                HostHbaTimeOutService.fillJson2Map(singleInfo, (JSONObject)value);
                continue;
            }
            singleInfo.put(key.toString(), value.toString());
        }
    }

    public static Map<String, String> parseJson2Map(String jsonStr) {
        HashMap<String, String> singleInfo = new HashMap<String, String>();
        LOGGER.info(String.format(Locale.ENGLISH, "the json information is :%s", jsonStr));
        try {
            JSONObject jo = new JSONObject(jsonStr);
            singleInfo.put(JSON_HUAWEI_MULTIPATH, jo.get(JSON_HUAWEI_MULTIPATH).toString());
            singleInfo.put(JSON_SELF_MULTIPATH, jo.get(JSON_SELF_MULTIPATH).toString());
        }
        catch (JSONException e) {
            singleInfo.put(JSON_HUAWEI_MULTIPATH, "");
            singleInfo.put(JSON_SELF_MULTIPATH, "");
            LOGGER.error("parse the multipath softVersion faild, it's not a correct information from the excel.");
        }
        LOGGER.info(String.format(Locale.ENGLISH, "the multipath version information is :%s", singleInfo));
        return singleInfo;
    }
}

