/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class HostStorageOSTypeConsistencyCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HostStorageOSTypeConsistencyCheck.class);
    private static final String CLI_RETS = "cliRets";
    private static final String TRUE_VALUE = "True";
    private static final String FALSE_VALUE = "False";
    private static final String INITIATOR = "host_os_wwninfo";
    private static final Map<String, String> OS_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("Linux", "Linux");
            this.put("Windows", "Windows");
            this.put("Solaris", "Solaris");
            this.put("HPUX", "HP-UX");
            this.put("AIX", "AIX");
            this.put("VMwareESX", "VMware");
            this.put("WindowsServer2012", "Windows");
            this.put("OracleVMServerforx86", "Linux");
            this.put("OracleVMServerforSPARC", "Solaris");
            this.put("OpenVMS", "Linux");
        }
    };
    private DevNode curHostStorageDev = null;

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        this.curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        EvalFeatureResult result = new EvalFeatureResult();
        this.curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        String devSn = this.curHostStorageDev.getDeviceSerialNumber();
        String key = devSn + "_storageHostOsWwnsInfo";
        String jsonRetInStorage = SceneDataExchange.getInstance().loadKV(key);
        LOGGER.info("HostStorageOSTypeConsistencyCheck-----" + jsonRetInStorage);
        try {
            this.checkOSTypeConsistency(result, jsonRetInStorage);
        }
        catch (JSONException e) {
            String failDesc = ResourceUtil.getString((String)"ctrl.path.gt8.upgrade.carsh.unable.eval");
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
            LOGGER.error("Check linux nvme service json error: " + e.getMessage());
        }
        if (result instanceof EvalFeatureResult) {
            return (T)result;
        }
        LOGGER.error("has unknown error.");
        return (T)new EvalFeatureResult();
    }

    private void checkOSTypeConsistency(EvalFeatureResult result, String jsonRetInStorage) {
        if (StringUtils.isBlank(jsonRetInStorage)) {
            String failDesc = ResourceUtil.getString((String)"ctrl.path.gt8.upgrade.carsh.unable.eval");
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
            return;
        }
        JSONObject jsonObjInStorage = JSON.parseObject(jsonRetInStorage);
        String resultStorage = jsonObjInStorage.getString("result");
        String storageCliRets = jsonObjInStorage.getString(CLI_RETS);
        if (resultStorage.equals(TRUE_VALUE)) {
            result.setOriginalInfo(storageCliRets);
        }
        if (resultStorage.equals(FALSE_VALUE)) {
            LOGGER.info("checkOSTypeConsistency-----failed.failed command.");
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"host.os.consistency.storage.execute.fail", (Object[])new Object[]{jsonObjInStorage.getString("failCommand")}));
            return;
        }
        JSONObject storageInitiatorArr = jsonObjInStorage.getJSONObject(INITIATOR);
        JSONObject initiatorMap = JSONObject.parseObject(storageInitiatorArr.toJSONString());
        LOGGER.info("checkOSTypeConsistency-----" + JSON.toJSONString(initiatorMap));
        Map<String, String> hostInitiatorMap = this.gethostWwnsOstypeMap();
        LOGGER.info("checkOSTypeConsistency-----" + JSON.toJSONString(hostInitiatorMap));
        Set<Integer> hostids = this.getOsNotConsistencyhost(initiatorMap, hostInitiatorMap);
        if (!hostids.isEmpty()) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"host.os.consistency.host.storage.not.consistency", (Object[])new Object[]{this.getHostIdString(hostids)}));
            return;
        }
        result.setItemResult(ItemResultEnum.PASS);
    }

    private Set<Integer> getOsNotConsistencyhost(Map<String, String> initiatorMap, Map<String, String> hostInitiatorMap) {
        LOGGER.info("getOsNotConsistencyhost-----" + JSON.toJSONString(initiatorMap));
        HashSet<Integer> hostids = new HashSet<Integer>();
        for (Map.Entry<String, String> wwnOs : initiatorMap.entrySet()) {
            String wwn = wwnOs.getKey().toUpperCase(Locale.ENGLISH);
            String[] hostidostype = wwnOs.getValue().split("\\*");
            int hostid = Integer.parseInt(hostidostype[0]);
            String ostype = hostidostype[1];
            LOGGER.info("getOsNotConsistencyhost-----" + ostype);
            if (!hostInitiatorMap.containsKey(wwn)) continue;
            LOGGER.info("getOsNotConsistencyhost-----hostostype" + JSON.toJSONString(hostInitiatorMap.get(wwn)));
            String arrOstype = this.arrangeOstype(ostype);
            LOGGER.info("getOsNotConsistencyhost-----" + arrOstype);
            if ("OracleVM".equals(arrOstype)) break;
            LOGGER.info("getOsNotConsistencyhost-----refOstype(arrOstype)" + this.refOstype(arrOstype));
            if (hostInitiatorMap.get(wwn).equals(this.refOstype(arrOstype))) continue;
            hostids.add(hostid);
        }
        LOGGER.info("getOsNotConsistencyhost-----" + JSON.toJSONString(hostids));
        return hostids;
    }

    private String refOstype(String ostype) {
        if (OS_TYPE_MAP.get(ostype) == null) {
            return ostype;
        }
        return OS_TYPE_MAP.get(ostype);
    }

    private String arrangeOstype(String ostype) {
        return ostype.replace(" ", "").replace("_", "").replace("-", "");
    }

    private Map<String, String> gethostWwnsOstypeMap() {
        List hostNodes = DefaultNodeProviderImpl.getInstance().getHostNodeList();
        List<DevNode> offHostDevs = HostEvalContext.getInstance().getOffHostDevs();
        hostNodes.addAll(offHostDevs);
        HashMap<String, String> hostInitiatorMap = new HashMap<String, String>();
        for (DevNode hostNode : hostNodes) {
            String hostOsType = hostNode.getDeviceName();
            if ("FusionSphere".equals(hostOsType)) {
                hostOsType = "Linux";
            }
            LOGGER.info("gethostWwnsOstypeMap-----" + hostOsType);
            String devKey = hostNode.getDevKey();
            Launcher launcher = GrabContext.getInstance().getLauncherMap().get(devKey);
            this.getwwnsOsMap(launcher.getFcWwns(), hostInitiatorMap, hostOsType);
            this.getwwnsOsMap(launcher.getiSCSIWwns(), hostInitiatorMap, hostOsType);
            this.getwwnsOsMap(launcher.getIBWwns(), hostInitiatorMap, hostOsType);
        }
        LOGGER.info("gethostWwnsOstypeMap-----" + JSON.toJSONString(hostInitiatorMap));
        return hostInitiatorMap;
    }

    private void getwwnsOsMap(List<String> wwns, Map<String, String> hostInitiatorMap, String osType) {
        if (wwns == null || wwns.isEmpty()) {
            return;
        }
        wwns.stream().forEach(wwn -> hostInitiatorMap.put(wwn.toUpperCase(Locale.ENGLISH), osType));
    }

    private String getHostIdString(Set<Integer> hostids) {
        LOGGER.info("getHostIdString-----Start");
        ArrayList<Integer> hostidList = new ArrayList<Integer>(hostids);
        StringBuffer hostidbf = new StringBuffer();
        hostidList.stream().sorted();
        for (int i = 0; i < hostidList.size(); ++i) {
            hostidbf.append(hostidList.get(i));
            if (i == hostidList.size() - 1) break;
            hostidbf.append(",");
        }
        return hostidbf.toString();
    }
}

