/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class LinuxCSIVersionCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LinuxCSIVersionCheck.class);
    private static final String CHECK_RESULT = "check_result";
    private static final String SSH_OUTPUT = "ssh_output";
    private static final String ERR_MSG = "err_msg";
    private static final String TARGET_VERSION = "target_version";
    private static final String CSI_VERSION_GRAB = "csi_version_grab";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        EvalFeatureResult result = new EvalFeatureResult();
        ItemInfo itemInfo = params.getItemInfo();
        try {
            this.checkCSIVersion(result, itemInfo);
        }
        catch (RuntimeException e) {
            String failDesc = ResourceUtil.getString((String)"ctrl.path.gt8.upgrade.carsh.unable.eval");
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
            LOGGER.error("Check CSI Version error: " + e.getMessage());
        }
        return (T)result;
    }

    private <T extends EvalFeatureResult> void checkCSIVersion(EvalFeatureResult result, ItemInfo itemInfo) {
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        String csiVersionGrabJson = evalMap.get(CSI_VERSION_GRAB);
        if (StringUtils.isBlank(csiVersionGrabJson)) {
            LOGGER.error("Get CSI version error.");
            result.setFailDesc(ResourceUtil.getString((String)"ctrl.path.gt8.upgrade.carsh.unable.eval"));
            result.setItemResult(ItemResultEnum.NOTPASS);
            return;
        }
        JSONObject jsonCSIVersionadm = JSON.parseObject(csiVersionGrabJson);
        String accessStatus = jsonCSIVersionadm.getString(CHECK_RESULT);
        String sshOutput = jsonCSIVersionadm.getString(SSH_OUTPUT);
        String errKey = jsonCSIVersionadm.getString(ERR_MSG);
        String targetVersion = jsonCSIVersionadm.getString(TARGET_VERSION);
        result.setOriginalInfo(sshOutput);
        if ("False".equals(accessStatus)) {
            if ("linux.csi.version.too.early".equals(errKey)) {
                result.setFailDesc(ResourceUtil.getStringWithParams((String)errKey, (Object[])new Object[]{targetVersion}));
            } else if ("linux.run.command.failed".equals(errKey)) {
                result.setFailDesc(ResourceUtil.getStringWithParams((String)errKey, (Object[])new Object[]{sshOutput}));
            } else if ("linux.get.csi.version.failed".equals(errKey)) {
                result.setFailDesc(ResourceUtil.getString((String)errKey));
            }
            result.setItemResult(ItemResultEnum.NOTPASS);
        }
    }
}

