/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class LinuxNVMeServiceCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LinuxNVMeServiceCheck.class);
    private static final String ACCESS_STATUS = "access_status";
    private static final String CLI_RETS = "cliRets";
    private static final String ERR_MEG = "err_meg";
    private static final String HOST_NVME_INFO = "hostNvmeInfo";
    private static final String TRUE_VALUE = "True";
    private static final String FALSE_VALUE = "False";
    private static final String INITIATOR = "nvme_initiator";
    private static final String UN_KNOWN_MEG = "ctrl.path.gt8.upgrade.carsh.unable.eval";
    private static final String ERROR_MEG = "Linux_nof_auto_reconnect.notpass";
    private static final String PASS = "PASS";
    private static final String NOTPASS = "NOTPASS";
    private static final String CANNOTEVAL = "CANNOTEVAL";
    private DevNode curHostStorageDev = null;

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        EvalFeatureResult result = new EvalFeatureResult();
        ItemInfo itemInfo = params.getItemInfo();
        this.curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        String devSn = this.curHostStorageDev.getDeviceSerialNumber();
        String key = devSn + "_storageNqnInfo";
        String jsonRetInStorage = SceneDataExchange.getInstance().loadKV(key);
        try {
            this.checkNvmeService(result, itemInfo, jsonRetInStorage);
        }
        catch (JSONException e) {
            String failDesc = ResourceUtil.getString((String)UN_KNOWN_MEG);
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
            LOGGER.error("Check linux nvme service json error: " + e.getMessage());
        }
        if (result instanceof EvalFeatureResult) {
            return (T)result;
        }
        LOGGER.error("has unknown error.");
        return (T)new EvalFeatureResult();
    }

    private void checkNvmeService(EvalFeatureResult result, ItemInfo itemInfo, String jsonRetInStorage) {
        if (StringUtils.isBlank(jsonRetInStorage)) {
            String failDesc = ResourceUtil.getString((String)UN_KNOWN_MEG);
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
            return;
        }
        JSONObject jsonObjInStorage = JSON.parseObject(jsonRetInStorage);
        String resultStorage = jsonObjInStorage.getString("result");
        String storageCliRets = jsonObjInStorage.getString(CLI_RETS);
        if (resultStorage.equals(TRUE_VALUE)) {
            result.setOriginalInfo(storageCliRets);
            return;
        }
        if (resultStorage.equals(FALSE_VALUE)) {
            result.setOriginalInfo(storageCliRets);
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"eval.host.evaluation.item.lunMapChangeCheck.storage.error", (Object[])new Object[]{jsonObjInStorage.getString("failCommand")}));
            return;
        }
        this.checkStorageAndHostNvme(result, itemInfo, jsonObjInStorage);
    }

    private void checkStorageAndHostNvme(EvalFeatureResult result, ItemInfo itemInfo, JSONObject jsonObjectInStorage) {
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        String hostNvmeInfo = evalMap.get(HOST_NVME_INFO);
        if (StringUtils.isBlank(hostNvmeInfo)) {
            LOGGER.error("get hostNvmeInfo error.");
            result.setFailDesc(ResourceUtil.getString((String)UN_KNOWN_MEG));
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setOriginalInfo(jsonObjectInStorage.getString(CLI_RETS));
            return;
        }
        JSONObject jsonObjectInHost = JSON.parseObject(hostNvmeInfo);
        String mpathadmCli = jsonObjectInHost.getString(CLI_RETS);
        String accessStatus = jsonObjectInHost.getString(ACCESS_STATUS);
        result.setOriginalInfo(jsonObjectInStorage.getString(CLI_RETS) + System.lineSeparator() + mpathadmCli);
        if (PASS.equals(accessStatus)) {
            LOGGER.info("the hostNqn is null, pass.");
            return;
        }
        String hostNqnStr = jsonObjectInHost.getString(INITIATOR);
        JSONArray storageInitiatorArr = jsonObjectInStorage.getJSONArray(INITIATOR);
        List<String> initiatorListStorage = JSONObject.parseArray(storageInitiatorArr.toJSONString(), String.class);
        if (Arrays.stream(hostNqnStr.split(",")).anyMatch(hostNqn -> initiatorListStorage.contains(hostNqn))) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            LOGGER.info("the hostNqn:%s match is successful", (Object)hostNqnStr);
            result.setFailDesc(ResourceUtil.getString((String)(NOTPASS.equals(accessStatus) ? ERROR_MEG : UN_KNOWN_MEG)));
            return;
        }
        if (CANNOTEVAL.equals(accessStatus)) {
            result.setFailDesc(ResourceUtil.getString((String)UN_KNOWN_MEG));
            result.setItemResult(ItemResultEnum.NOTPASS);
        }
    }
}

