/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class LunCapacityConsistencyCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LunCapacityConsistencyCheck.class);
    private DevNode curHostStorageDev = null;
    private static final String CLIRETS = "cli_rets";
    private static final String EXECUTEERROR = "execute_error";
    private static final String FAILCMDS = "fail_cmds";
    private static final String LUNWWNCAPACITYS = "lun_wwn_capacitys";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        EvalFeatureResult result = new EvalFeatureResult();
        this.curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        String devSn = this.curHostStorageDev.getDeviceSerialNumber();
        String key = devSn + "_luns_in_precise_mode";
        String jsonRetInStorage = SceneDataExchange.getInstance().loadKV(key);
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        Map<String, String> evalMap = params.getItemInfo().getInfoGrabMetaMsg();
        String jsonRetInHost = evalMap.get("HostLunWWNCapacsityInfo");
        JSONObject jsonObjInStorage = JSON.parseObject(jsonRetInStorage);
        JSONObject jsonObjInHost = JSON.parseObject(jsonRetInHost);
        String emptyError = "";
        if (null == jsonObjInStorage) {
            emptyError = ResourceUtil.getString((String)"lun.capacity.consistency.check.cannot.get.storage.null");
        }
        if (null == jsonObjInHost) {
            emptyError = emptyError + System.lineSeparator() + ResourceUtil.getString((String)"lun.capacity.consistency.check.cannot.get.host.null");
        }
        if (!StringUtils.isNULLStr((String)emptyError)) {
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            result.setFailDesc(emptyError);
            return (T)result;
        }
        String cliRetsInStorage = jsonObjInStorage.getString(CLIRETS);
        String cliRetsInHost = jsonObjInHost.getString(CLIRETS);
        result.setOriginalInfo(cliRetsInStorage + '\n' + cliRetsInHost);
        try {
            String executeError = this.checkExecuteError(jsonObjInStorage, jsonObjInHost);
            if (!StringUtils.isNULLStr((String)executeError)) {
                result.setItemResult(ItemResultEnum.NOTPASS);
                result.setFailDesc(executeError);
                return (T)result;
            }
            this.checkLunCapacity(jsonObjInStorage, jsonObjInHost, result);
        }
        catch (Exception e) {
            LOGGER.error("LunCapacityConsistencyCheck occured exception:", e);
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.lunMapChangeCheck.execute.error"));
            return (T)result;
        }
        return (T)result;
    }

    private String checkExecuteError(JSONObject jsonObjInStorage, JSONObject jsonObjInHost) {
        StringBuilder error = new StringBuilder();
        String executeErrorInStorage = this.buildExecuteError(jsonObjInStorage.getJSONArray(EXECUTEERROR));
        String executeErrorInHost = this.buildExecuteError(jsonObjInHost.getJSONArray(EXECUTEERROR));
        String executeFailInStorage = this.buildFailCmds(jsonObjInStorage);
        String executeFailInHost = this.buildFailCmds(jsonObjInHost);
        String allStorageFails = this.buildAllTypeError(executeErrorInStorage, executeFailInStorage);
        String allHostFails = this.buildAllTypeError(executeErrorInHost, executeFailInHost);
        if (!StringUtils.isNULLStr((String)allStorageFails)) {
            error.append(ResourceUtil.getStringWithParams((String)"lun.capacity.consistency.check.storage.execute.fail", (Object[])new Object[]{allStorageFails}));
        }
        if (!StringUtils.isNULLStr((String)allHostFails)) {
            error.append(ResourceUtil.getStringWithParams((String)"lun.capacity.consistency.check.host.execute.fail", (Object[])new Object[]{allHostFails}));
        }
        return error.toString();
    }

    private String buildAllTypeError(String executeError, String cmdError) {
        if (StringUtils.isNULLStr((String)executeError) && StringUtils.isNULLStr((String)cmdError)) {
            return "";
        }
        if (!StringUtils.isNULLStr((String)executeError) && !StringUtils.isNULLStr((String)cmdError)) {
            return executeError + System.lineSeparator() + cmdError;
        }
        return executeError + cmdError;
    }

    private String buildExecuteError(JSONArray executeErrors) {
        StringBuilder error = new StringBuilder();
        if (null == executeErrors) {
            return error.toString();
        }
        List<String> errorKeys = JSONObject.parseArray(executeErrors.toJSONString(), String.class);
        for (String key : errorKeys) {
            error.append(ResourceUtil.getString((String)key));
            error.append(System.lineSeparator());
        }
        return error.toString();
    }

    private String buildFailCmds(JSONObject jsonObj) {
        String error = jsonObj.getString(FAILCMDS);
        if (StringUtils.isNULLStr((String)error)) {
            return "";
        }
        error = ResourceUtil.getStringWithParams((String)"lun.capacity.consistency.check.cmd.execute.error", (Object[])new Object[]{error});
        return error;
    }

    private void checkLunCapacity(JSONObject jsonObjInStorage, JSONObject jsonObjInHost, EvalFeatureResult result) {
        StringBuilder checkError = new StringBuilder();
        JSONObject storageLunsJson = jsonObjInStorage.getJSONObject(LUNWWNCAPACITYS);
        JSONObject hostLunsJson = jsonObjInHost.getJSONObject(LUNWWNCAPACITYS);
        if (storageLunsJson == null || hostLunsJson == null) {
            result.setItemResult(ItemResultEnum.PASS);
            return;
        }
        Map storageLuns = JSONObject.parseObject(storageLunsJson.toJSONString(), HashMap.class);
        Map hostLuns = JSONObject.parseObject(hostLunsJson.toJSONString(), HashMap.class);
        for (Map.Entry entry : hostLuns.entrySet()) {
            String hostWwn = (String)entry.getKey();
            String hostCapacity = (String)entry.getValue();
            if (StringUtils.isNULLStr((String)((String)storageLuns.get(hostWwn))) || hostCapacity.equals(storageLuns.get(hostWwn))) continue;
            checkError.append(ResourceUtil.getStringWithParams((String)"lun.capacity.consistency.check.capacity.not.consistency", (Object[])new Object[]{hostWwn, storageLuns.get(hostWwn), hostCapacity}));
        }
        if (checkError.length() <= 0) {
            result.setItemResult(ItemResultEnum.PASS);
            return;
        }
        result.setFailDesc(checkError.toString());
        result.setItemResult(ItemResultEnum.NOTPASS);
    }
}

