/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class LunMapChangeCheck
extends AbstractCompService {
    private static final String RESULT = "result";
    private static final String CLIRETS = "cliRets";
    private static final String HOST = "host";
    private static final String INITIATOR = "initiator";
    private static final String LUN_WWN = "lunWWN";
    private static final String WWN = "WWN";
    private static final String HOST_LUN_ID = "HOST_LUN_ID";
    private static final String ERR_MSG = "errMsg";
    private static final String TRUE_VALUE = "True";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LunMapChangeCheck.class);
    private DevNode curHostStorageDev = null;
    private List<String> initiatorListInHost = new ArrayList<String>();
    private Map<String, List<String>> lunWWNListInHost = new HashMap<String, List<String>>();

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        EvalFeatureResult result = new EvalFeatureResult();
        this.curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        String devSn = this.curHostStorageDev.getDeviceSerialNumber();
        String key = devSn + "_hostLunInfo";
        String jsonRetInStorage = SceneDataExchange.getInstance().loadKV(key);
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        Map<String, String> evalMap = params.getItemInfo().getInfoGrabMetaMsg();
        String jsonRetInHost = evalMap.get("HostLunWWNInfo");
        try {
            result = this.checkLunChange(result, jsonRetInStorage, jsonRetInHost);
        }
        catch (NullPointerException e) {
            LOGGER.error("checkLunChange occured exception:", e);
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.lunMapChangeCheck.execute.error"));
            return (T)result;
        }
        return (T)result;
    }

    private EvalFeatureResult checkLunChange(EvalFeatureResult result, String jsonRetInStorage, String jsonRetInHost) {
        JSONObject jsonObjInHost;
        JSONObject jsonObjInStorage = JSON.parseObject(jsonRetInStorage);
        if (this.checkResultIsPass(result, jsonObjInStorage, jsonObjInHost = JSON.parseObject(jsonRetInHost))) {
            return result;
        }
        String cliRetsInStorage = jsonObjInStorage.getString(CLIRETS);
        String cliRetsInHost = jsonObjInHost.getString(CLIRETS);
        result.setOriginalInfo(cliRetsInStorage + cliRetsInHost);
        String resultInStorage = jsonObjInStorage.getString(RESULT);
        String resultInHost = jsonObjInHost.getString(RESULT);
        if (resultInStorage.equals("False")) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"eval.host.evaluation.item.lunMapChangeCheck.storage.error", (Object[])new Object[]{jsonObjInStorage.getString("failCommand")}));
            return result;
        }
        if (resultInHost.equals("False")) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            String errMsg = this.parseErrMsg(jsonObjInHost);
            result.setFailDesc(errMsg);
            return result;
        }
        this.getHostLunListInHost(jsonObjInHost);
        Map<String, Map<String, String>> initiatorLun = this.getInitiatorLunInStorage(jsonObjInStorage);
        ArrayList<String> hostLunIDModifiedList = new ArrayList<String>();
        List<String> noMapLunList = this.getLunNoMapListInStorage(initiatorLun, hostLunIDModifiedList);
        if (noMapLunList.size() > 0) {
            LOGGER.error("There are lunmap changed:{}", (Object)noMapLunList.toString());
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"eval.host.evaluation.item.lunMapChangeCheck.notpass", (Object[])new Object[]{String.join((CharSequence)",", noMapLunList)}));
            return result;
        }
        if (hostLunIDModifiedList.size() > 0) {
            LOGGER.error("There are host lun id changed :{}", (Object)((Object)hostLunIDModifiedList).toString());
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"eval.host.evaluation.item.hostLunIDChangeCheck.notpass", (Object[])new Object[]{String.join((CharSequence)",", hostLunIDModifiedList)}));
            return result;
        }
        return result;
    }

    private boolean checkResultIsPass(EvalFeatureResult result, JSONObject jsonObjInStorage, JSONObject jsonObjInHost) {
        if (jsonObjInStorage != null && jsonObjInStorage.getString(RESULT).equals(TRUE_VALUE)) {
            result.setOriginalInfo(jsonObjInStorage.getString(CLIRETS));
            return true;
        }
        if (jsonObjInHost != null && jsonObjInHost.getString(RESULT).equals(TRUE_VALUE)) {
            result.setOriginalInfo(jsonObjInHost.getString(CLIRETS));
            return true;
        }
        if (null == jsonObjInStorage || null == jsonObjInHost) {
            LOGGER.error("The json data is null.");
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.lunMapChangeCheck.execute.error"));
            return true;
        }
        return false;
    }

    private void getHostLunListInHost(JSONObject jsonObjInHost) {
        JSONArray hostArrInHost = jsonObjInHost.getJSONArray(HOST);
        for (JSONObject jsonObject : hostArrInHost) {
            JSONArray initiatorArr = jsonObject.getJSONArray(INITIATOR);
            List<String> initiatorListInHostTemp = JSONObject.parseArray(initiatorArr.toJSONString(), String.class);
            this.initiatorListInHost = this.toLowerCase4List(initiatorListInHostTemp);
            this.lunWWNListInHost = this.parseOneHostLunId(jsonObject);
        }
    }

    private Map<String, Map<String, String>> getInitiatorLunInStorage(JSONObject jsonObjInStorage) {
        HashMap<String, Map<String, String>> initiatorLunMap = new HashMap<String, Map<String, String>>();
        JSONArray hostArrInStorage = jsonObjInStorage.getJSONArray(HOST);
        for (JSONObject jsonObject : hostArrInStorage) {
            JSONArray initiatorArr = jsonObject.getJSONArray(INITIATOR);
            List<String> initiatorListTemp = JSONObject.parseArray(initiatorArr.toJSONString(), String.class);
            List<String> initiatorListInStorage = this.toLowerCase4List(initiatorListTemp);
            Map<String, String> lunWWNListInStorage = this.parseOneStorageLunId(jsonObject);
            for (String initiatorStr : initiatorListInStorage) {
                if (initiatorLunMap.containsKey(initiatorStr)) {
                    Map map = (Map)initiatorLunMap.get(initiatorStr);
                    map.putAll(lunWWNListInStorage);
                    continue;
                }
                initiatorLunMap.put(initiatorStr, lunWWNListInStorage);
            }
        }
        return initiatorLunMap;
    }

    private List<String> getLunNoMapListInStorage(Map<String, Map<String, String>> initiatorLunMap, List<String> hostLunIDModifiedList) {
        ArrayList<String> noMapLunList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : initiatorLunMap.entrySet()) {
            String initiatorInStorage = entry.getKey();
            if (!this.initiatorListInHost.contains(initiatorInStorage)) continue;
            Map<String, String> lunWWNListInStorage = entry.getValue();
            List<String> noMapLunListOneHost = this.parseLunNoMap(lunWWNListInStorage, this.lunWWNListInHost, hostLunIDModifiedList);
            noMapLunList.addAll(noMapLunListOneHost);
        }
        this.removeDuplicate(noMapLunList);
        this.removeDuplicate(hostLunIDModifiedList);
        return noMapLunList;
    }

    private List<String> parseLunNoMap(Map<String, String> lunWWNListInStorage, Map<String, List<String>> lunWWNMapInHost, List<String> hostLunIDModifiedList) {
        ArrayList<String> noMapLunList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : lunWWNListInStorage.entrySet()) {
            if (!lunWWNMapInHost.containsKey(entry.getKey())) {
                noMapLunList.add(entry.getKey());
                continue;
            }
            List<String> hostLunIdList = lunWWNMapInHost.get(entry.getKey());
            if (entry.getValue().isEmpty() || hostLunIdList.isEmpty() || hostLunIdList.contains(entry.getValue())) continue;
            hostLunIDModifiedList.add(entry.getKey());
        }
        return noMapLunList;
    }

    private List<String> parseOneHostLunInfo(JSONObject jsonObj) {
        ArrayList<String> lunWWNList = new ArrayList<String>();
        JSONArray lunWWNArr = jsonObj.getJSONArray(LUN_WWN);
        Iterator<Object> iterator = lunWWNArr.iterator();
        while (iterator.hasNext()) {
            JSONObject jsonObject = null;
            Object obj = iterator.next();
            if (!(obj instanceof JSONObject)) continue;
            jsonObject = (JSONObject)obj;
            String lunWWN = jsonObject.getString(WWN);
            lunWWNList.add(lunWWN);
        }
        return this.toLowerCase4List(lunWWNList);
    }

    private Map<String, List<String>> parseOneHostLunId(JSONObject jsonObj) {
        JSONArray lunWWNArr = jsonObj.getJSONArray(LUN_WWN);
        Iterator<Object> iterator = lunWWNArr.iterator();
        HashMap<String, List<String>> hostLunIDMap = new HashMap<String, List<String>>();
        while (iterator.hasNext()) {
            JSONObject jsonObject = null;
            Object obj = iterator.next();
            if (!(obj instanceof JSONObject)) continue;
            jsonObject = (JSONObject)obj;
            String lunWWN = jsonObject.getString(WWN);
            JSONArray hostLunIdArray = jsonObject.getJSONArray(HOST_LUN_ID);
            List<Object> hostLunIdList = new ArrayList();
            if (null != hostLunIdArray) {
                hostLunIdList = JSONObject.parseArray(hostLunIdArray.toJSONString(), String.class);
            }
            lunWWN = lunWWN.toLowerCase(Locale.ENGLISH);
            hostLunIDMap.put(lunWWN, hostLunIdList);
        }
        return hostLunIDMap;
    }

    private Map<String, String> parseOneStorageLunId(JSONObject jsonObj) {
        JSONArray lunWWNArr = jsonObj.getJSONArray(LUN_WWN);
        Iterator<Object> iterator = lunWWNArr.iterator();
        HashMap<String, String> hostLunIDMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            JSONObject jsonObject = null;
            Object obj = iterator.next();
            if (!(obj instanceof JSONObject)) continue;
            jsonObject = (JSONObject)obj;
            String lunWWN = jsonObject.getString(WWN);
            String hostLunId = jsonObject.getString(HOST_LUN_ID);
            lunWWN = lunWWN.toLowerCase(Locale.ENGLISH);
            hostLunIDMap.put(lunWWN, hostLunId);
        }
        return hostLunIDMap;
    }

    private void removeDuplicate(List<String> list) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(list.size());
        set.addAll(list);
        list.clear();
        list.addAll(set);
    }

    private List<String> toLowerCase4List(List<String> originList) {
        ArrayList<String> destList = new ArrayList<String>();
        for (String str : originList) {
            destList.add(str.toLowerCase(Locale.ENGLISH));
        }
        return destList;
    }

    private String parseErrMsg(JSONObject jsonObj) {
        String errMsg = "";
        JSONObject errMsgJsonObj = jsonObj.getJSONObject(ERR_MSG);
        if (errMsgJsonObj == null) {
            errMsg = ResourceUtil.getStringWithParams((String)"eval.host.evaluation.item.lunMapChangeCheck.host.error", (Object[])new Object[]{jsonObj.getString("failCommand")});
        } else {
            String key = errMsgJsonObj.getString("key");
            String value = errMsgJsonObj.getString("value");
            errMsg = ResourceUtil.getStringWithParams((String)key, (Object[])new Object[]{value});
        }
        return errMsg;
    }
}

