/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public class NfsMatchKernelVersionCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(NfsMatchKernelVersionCheck.class);
    private static final String CHECK_ITEM_KEY = "NFSMatchKernelVersionCheck";
    private static final String CHECK_RESULT_FLAG_KEY = "checkResultFlag";
    private static final String CHECK_ORIGINAL_INFO_KEY = "checkOriginalInfo";
    private static final String LOGICAL_PORT_IP_INFO_KEY = "_query_logical_port_ip";
    private static final String GRAB_CONTINUE_CHECK_FLAG = "CONTINUE_CHECK";
    private static final String HOST_MOUNT_INFO_KEY = "hostMountInfo";
    private static final String LOGICAL_PORT_ORIGINAL_INFO_KEY = "cli_ret";
    private static final String LOGICAL_PORT_QUERY_RESULT_KEY = "query_flag";
    private static final String LOGICAL_PORT_IP_LIST_KEY = "ip_list";
    private List<String> originalInfo = new ArrayList<String>();
    private EvalFeatureResult result = new EvalFeatureResult();

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        LinkedHashMap checkResult = this.parseGrabCheckResult(evalContext);
        String grabResultFlag = (String)checkResult.get(CHECK_RESULT_FLAG_KEY);
        this.originalInfo.add((String)checkResult.get(CHECK_ORIGINAL_INFO_KEY));
        if (!GRAB_CONTINUE_CHECK_FLAG.equals(grabResultFlag)) {
            this.result.setItemResult(ItemResultEnum.valueOf((String)checkResult.get(CHECK_RESULT_FLAG_KEY)));
            this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
            this.result.setFailDesc(ResourceUtil.getString((String)"Nfs.match.kernrl.version.check.host.falied"));
            return (T)this.result;
        }
        Optional<List<String>> ipList = this.getLogicalPortIpAddress(evalContext);
        if (!ipList.isPresent()) {
            this.result.setItemResult(ItemResultEnum.CANNOTEVAL);
            this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
            this.result.setFailDesc(ResourceUtil.getString((String)"Nfs.match.kernrl.version.check.storage.falied"));
            LOGGER.error("query Logical Port IpAddress failed.");
            return (T)this.result;
        }
        String mountInfo = (String)checkResult.get(HOST_MOUNT_INFO_KEY);
        this.originalInfo.add(mountInfo);
        if (this.isHostRunningNFSService(mountInfo, ipList.get())) {
            this.result.setItemResult(ItemResultEnum.NOTPASS);
            this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
            this.result.setFailDesc(ResourceUtil.getString((String)"Nfs.match.kernrl.version.check.storage.notpass"));
            return (T)this.result;
        }
        this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
        return (T)this.result;
    }

    private Optional<List<String>> getLogicalPortIpAddress(Map<String, Object> evalContext) {
        Boolean queryFlag;
        String devSn = EvaluationEngine.getCurHostStorageDev(evalContext).getDeviceSerialNumber();
        String logicalPortInfostr = SceneDataExchange.getInstance().loadKV(devSn + LOGICAL_PORT_IP_INFO_KEY);
        Map logicalPortInfo = JSON.parseObject(logicalPortInfostr, LinkedHashMap.class);
        if (logicalPortInfo.get(LOGICAL_PORT_ORIGINAL_INFO_KEY) instanceof String) {
            this.originalInfo.add((String)logicalPortInfo.get(LOGICAL_PORT_ORIGINAL_INFO_KEY));
        }
        if (logicalPortInfo.get(LOGICAL_PORT_QUERY_RESULT_KEY) instanceof Boolean && (queryFlag = (Boolean)logicalPortInfo.get(LOGICAL_PORT_QUERY_RESULT_KEY)).booleanValue() && logicalPortInfo.get(LOGICAL_PORT_IP_LIST_KEY) instanceof List) {
            return Optional.of((List)logicalPortInfo.get(LOGICAL_PORT_IP_LIST_KEY));
        }
        return Optional.empty();
    }

    private boolean isHostRunningNFSService(String mountInfo, List<String> ipList) {
        for (String ip : ipList) {
            if (!mountInfo.contains(ip)) continue;
            return true;
        }
        return false;
    }

    private LinkedHashMap parseGrabCheckResult(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        Map<String, String> evalMap = params.getItemInfo().getInfoGrabMetaMsg();
        String jsonRetInHost = evalMap.get(CHECK_ITEM_KEY);
        return JSON.parseObject(jsonRetInHost, LinkedHashMap.class);
    }
}

