/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SolarisVersionAndMultipathCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SolarisVersionAndMultipathCheck.class);
    private static final String ACCESS_STATUS = "access_status";
    private static final String CLI_RETS = "cliRets";
    private static final String ERR_MEG = "err_meg";
    private static final String SOLARIS_MPATHADM = "SolarisMpathadm";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        EvalFeatureResult result = new EvalFeatureResult();
        ItemInfo itemInfo = params.getItemInfo();
        try {
            this.checkLunDateWithAlua(result, itemInfo);
        }
        catch (RuntimeException e) {
            String failDesc = ResourceUtil.getString((String)"ctrl.path.gt8.upgrade.carsh.unable.eval");
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
            LOGGER.error("Check Solaris version and multiPath error: " + e.getMessage());
        }
        return (T)result;
    }

    private <T extends EvalFeatureResult> void checkLunDateWithAlua(EvalFeatureResult result, ItemInfo itemInfo) {
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        String solarisMpathadm = evalMap.get(SOLARIS_MPATHADM);
        if (StringUtils.isBlank(solarisMpathadm)) {
            LOGGER.error("get SolarisMpathadm error.");
            result.setFailDesc(ResourceUtil.getString((String)"ctrl.path.gt8.upgrade.carsh.unable.eval"));
            result.setItemResult(ItemResultEnum.NOTPASS);
            return;
        }
        JSONObject jsonSolarisMpathadm = JSON.parseObject(solarisMpathadm);
        String accessStatus = jsonSolarisMpathadm.getString(ACCESS_STATUS);
        String mpathadmCli = jsonSolarisMpathadm.getString(CLI_RETS);
        String mpathadmMeg = jsonSolarisMpathadm.getString(ERR_MEG);
        result.setOriginalInfo(mpathadmCli);
        if ("not enabled".equals(accessStatus)) {
            result.setFailDesc(ResourceUtil.getString((String)mpathadmMeg));
            result.setItemResult(ItemResultEnum.NOTPASS);
        }
    }
}

