/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SqlServerCompService
extends AbstractCompService {
    private static final List<String> SQLSERVER_WHITE_VERSION_LIST = Arrays.asList("Microsoft SQL Server 2014", "Microsoft SQL Server 2012 (SP1)", "Microsoft SQL Server 2008 R2 (RTM)", "Microsoft SQL Server 2008 (RTM)", "Microsoft SQL Server 2000", "Microsoft SQL Server 2005");

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        ItemInfo itemInfo = params.getItemInfo();
        String dataBaseVersion = itemInfo.getDatabaseVersion();
        EvalFeatureResult result = new EvalFeatureResult();
        dataBaseVersion = dataBaseVersion.split("-")[0].trim();
        for (String version : SQLSERVER_WHITE_VERSION_LIST) {
            if (!dataBaseVersion.equals(version)) continue;
            result.setItemResult(ItemResultEnum.PASS);
            return (T)result;
        }
        result.setItemResult(ItemResultEnum.PASS);
        return (T)result;
    }
}

