/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class VMwareAAFixedModelCheck
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(VMwareAAFixedModelCheck.class);
    private static final String VMWARE_AA_FIXED_CHECK = "VMwareAAFixedModelCheck";
    private static final String VMWARE_AA_FIXED_DEVICE_NAME = "vmwareAaFixedDeviceName";
    private static final String CHECK_RESULT_FLAG = "checkResultFlag";
    private static final String CHECK_ORIGINAL_INFO = "checkOriginalInfo";
    private static final String GRAB_OPTIM_RECOMD_FLAG = "OPTIM_RECOMD";
    private static final String GRAB_PASS_FLAG = "PASS";
    private List<String> originalInfo = new ArrayList<String>();
    private List<String> deviceNames = new ArrayList<String>();
    private EvalFeatureResult result = new EvalFeatureResult();

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        LinkedHashMap checkResult = this.parseGrabCheckResult(evalContext);
        String grabResultFlag = (String)checkResult.get(CHECK_RESULT_FLAG);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("VMwareAAFixedModelCheck grabResultFlag:" + grabResultFlag);
        }
        this.originalInfo.add((String)checkResult.get(CHECK_ORIGINAL_INFO));
        if (GRAB_PASS_FLAG.equals(grabResultFlag)) {
            this.result.setItemResult(ItemResultEnum.PASS);
            this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
            return (T)this.result;
        }
        if (GRAB_OPTIM_RECOMD_FLAG.equals(grabResultFlag)) {
            this.deviceNames.add((String)checkResult.get(VMWARE_AA_FIXED_DEVICE_NAME));
            String devices = String.join((CharSequence)"\n", this.deviceNames);
            this.result.setItemResult(ItemResultEnum.NOTPASS);
            this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
            this.result.setFailDesc(ResourceUtil.getStringWithParams((String)"vmware.aa.fixied.model.check.is.aa.fixed", (Object[])new Object[]{devices}));
            return (T)this.result;
        }
        this.result.setItemResult(ItemResultEnum.NOTPASS);
        this.result.setOriginalInfo(String.join((CharSequence)"\n", this.originalInfo));
        this.result.setFailDesc(ResourceUtil.getString((String)"vmware.aa.fixied.model.check.execute.fail"));
        LOGGER.error("has unknown error.");
        return (T)this.result;
    }

    private LinkedHashMap parseGrabCheckResult(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        Map<String, String> evalMap = params.getItemInfo().getInfoGrabMetaMsg();
        String jsonRetInHost = evalMap.get(VMWARE_AA_FIXED_CHECK);
        return JSON.parseObject(jsonRetInHost, LinkedHashMap.class);
    }
}

