/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.util.CommonUtil;
import com.huawei.json.JSONObject;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class VirtualCompService
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(VirtualCompService.class);
    private static final String NA = "NA";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        Object itemInfoObj = evalContext.get("itemInfo");
        ItemInfo itemInfo = (ItemInfo)CommonUtil.convertObject((Object)itemInfoObj, ItemInfo.class);
        return (T)this.vmwareIscsiTimeOut(ItUpgradeKeyEnum.ISCSI_TIMEOUT_CHECK.toString(), itemInfo, null);
    }

    public EvalFeatureResult vmwareIscsiTimeOut(String checkItemKey, ItemInfo itemInfo, DevNode curStorageDev) {
        String infoGrabMetaMsg = itemInfo.getInfoGrabMetaMsg("StorageModel");
        String deviceType = null;
        String productVersion = null;
        if (curStorageDev == null) {
            if (StringUtils.isNotBlank(infoGrabMetaMsg)) {
                JSONObject jsonObject = new JSONObject(infoGrabMetaMsg);
                deviceType = this.getJsonString(jsonObject, "deviceType");
                productVersion = this.getJsonString(jsonObject, "productVersion");
            }
        } else {
            deviceType = curStorageDev.getDeviceType().toString();
            productVersion = curStorageDev.getProductVersion();
        }
        if (itemInfo.isStorageCoverHostTmo(deviceType, productVersion)) {
            return new EvalFeatureResult();
        }
        EvalFeatureResult result = new EvalFeatureResult();
        String iscsiTimeout = itemInfo.getIscsiTimeOut();
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        if (evalMap.containsKey(checkItemKey)) {
            String evalResult = evalMap.get(checkItemKey);
            JSONObject json = new JSONObject(evalResult);
            String originalInfo = this.getJsonString(json, "cliRet");
            result.setOriginalInfo(originalInfo);
        }
        this.checkIsVirtualServCompOk(result, iscsiTimeout);
        return result;
    }

    private void checkIsVirtualServCompOk(EvalFeatureResult result, String iscsiTimeout) {
        if (NA.equals(iscsiTimeout)) {
            LOGGER.info("No iscsi adapter..");
            result.setItemResult(ItemResultEnum.PASS);
            return;
        }
        String[] allTimeout = iscsiTimeout.split(";");
        int timeOut = 0;
        for (String oneTimeout : allTimeout) {
            int tmpTime = 0;
            tmpTime = this.getTimeout(oneTimeout, result);
            if (tmpTime == -1) {
                LOGGER.error("Current iscsiTimeout is wrong : " + oneTimeout);
                result.setItemResult(ItemResultEnum.NOTPASS);
                result.setFailDesc(ResourceUtil.getString((String)"eval.host.multipath.buglist.failed.without.command"));
                return;
            }
            if (tmpTime <= timeOut) continue;
            timeOut = tmpTime;
        }
        if (timeOut <= 12) {
            result.setItemResult(ItemResultEnum.PASS);
        } else {
            LOGGER.info(String.format(Locale.ENGLISH, "Current iscsiTimeout (%s) > 12...", timeOut));
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"iscsi.timeout.check.Vmware.not.passed", (Object[])new Object[]{String.valueOf(timeOut)}));
        }
    }

    private int getTimeout(String oneTimeout, EvalFeatureResult result) {
        int timeOut = 0;
        for (String time : oneTimeout.split(",")) {
            try {
                if (NA.equals(time.split(":")[1])) {
                    return -1;
                }
                timeOut += Integer.parseInt(time.split(":")[1]);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return timeOut;
    }
}

