/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class XlsWriter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XlsWriter.class);
    private static final Object XLS_WRITER_LOCK = new Object();
    private static XlsWriter instance = null;
    private static HSSFCellStyle titleStyle = null;
    private static HSSFCellStyle contentStyle = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XlsWriter getInstance() {
        Object object = XLS_WRITER_LOCK;
        synchronized (object) {
            if (null == instance) {
                instance = new XlsWriter();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXlsReport(File saveFile, Map<String, List<List<String>>> reportDatas) throws ToolException {
        Object object = XLS_WRITER_LOCK;
        synchronized (object) {
            if (saveFile.isDirectory()) {
                throw new ToolException("The savefile is a directory, not file.");
            }
            if (!saveFile.getParentFile().exists() && saveFile.getParentFile().mkdirs()) {
                throw new ToolException("create directory failed.");
            }
            LOGGER.info("begin to write data to excel.");
            OutputStream outputStream = null;
            HSSFWorkbook writeWorkBook = null;
            try {
                outputStream = this.getXlsFos(saveFile);
                writeWorkBook = new HSSFWorkbook();
                this.initFontAndStyle(writeWorkBook);
                if (reportDatas.containsKey("HostReport")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "HostReport", 0), reportDatas.get("HostReport"));
                }
                if (reportDatas.containsKey("DatabaseReport")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "DatabaseReport", 0), reportDatas.get("DatabaseReport"));
                }
                if (reportDatas.containsKey("SwitchReport")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "SwitchReport", 0), reportDatas.get("SwitchReport"));
                }
                if (reportDatas.containsKey("Check Manually")) {
                    this.saveColItem2Sheet(writeWorkBook, this.createSheet(writeWorkBook, "Check Manually", 0), reportDatas.get("Check Manually"));
                }
                this.writeXls(writeWorkBook, outputStream);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, writeWorkBook);
                StreamUtils.closeStream((OutputStream)outputStream, null);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)writeWorkBook);
            StreamUtils.closeStream((OutputStream)outputStream, null);
        }
    }

    private void saveColItem2Sheet(HSSFWorkbook writeWorkBook, Sheet sheet, List<List<String>> xlsReportData) throws ToolException {
        boolean createTitle = false;
        int rowIndex = 0;
        try {
            for (List<String> linkedList : xlsReportData) {
                int colIndex = 0;
                if (!createTitle) {
                    for (String item : linkedList) {
                        sheet.setColumnWidth(colIndex, 3840);
                        POIUtils.setCellValue((Sheet)sheet, (int)rowIndex, (int)colIndex, (String)item, (HSSFCellStyle)titleStyle);
                        ++colIndex;
                    }
                    createTitle = true;
                } else {
                    for (String item : linkedList) {
                        sheet.setColumnWidth(colIndex, 3840);
                        POIUtils.setCellValue((Sheet)sheet, (int)rowIndex, (int)colIndex, (String)item, (HSSFCellStyle)contentStyle);
                        ++colIndex;
                    }
                }
                ++rowIndex;
            }
        }
        catch (Exception e) {
            LOGGER.error("add cell to sheet error");
            throw new ToolException("write data to sheet error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateXlsRow(String path, List<String> dataList) {
        block7: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            HSSFWorkbook workbook = null;
            try {
                fis = new FileInputStream(path);
                workbook = new HSSFWorkbook(fis);
                this.initFontAndStyle(workbook);
                if (null != workbook) {
                    HSSFSheet sheet = workbook.getSheet("data");
                    if (null != sheet) {
                        this.sheetSetData(dataList, sheet, contentStyle);
                    }
                    fos = new FileOutputStream(path);
                    workbook.write(fos);
                    LOGGER.info("update finished.");
                }
                StreamUtils.closeResource(null, (Closeable)workbook);
            }
            catch (IOException e) {
                LOGGER.error("write data to excel error.");
                break block7;
            }
            finally {
                StreamUtils.closeResource(null, workbook);
                StreamUtils.closeStream(fos, (InputStream)fis);
            }
            StreamUtils.closeStream(fos, (InputStream)fis);
        }
    }

    private void sheetSetData(List<String> dataList, Sheet sheet, HSSFCellStyle style) {
        int colIndex = 0;
        for (String data : dataList) {
            sheet.setColumnWidth(colIndex, 3840);
            POIUtils.setCellValue((Sheet)sheet, (int)1, (int)colIndex, (String)data, (HSSFCellStyle)style);
            ++colIndex;
        }
    }

    private void writeXls(HSSFWorkbook writeWorkBook, OutputStream outputStream) {
        try {
            if (null != writeWorkBook) {
                writeWorkBook.write(outputStream);
            }
        }
        catch (IOException e) {
            LOGGER.error("Writable Workbook write error.");
        }
    }

    private Sheet createSheet(HSSFWorkbook writeWork, String sheetTitle, int index) {
        HSSFSheet writeableSheet = writeWork.createSheet(sheetTitle);
        return writeableSheet;
    }

    private OutputStream getXlsFos(File savefile) throws ToolException {
        String filePath = CommonUtils.getCanonicalFilePath(savefile);
        savefile = CommonUtils.getCanonicalFile(filePath);
        OutputStream out = null;
        try {
            out = this.checkFile(savefile);
        }
        catch (IOException e) {
            throw new ToolException("create outputstream failed.", (Throwable)e);
        }
        return out;
    }

    private OutputStream checkFile(File savefile) throws ToolException, IOException {
        File file = savefile.getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new ToolException("mk dir failed.");
        }
        if (savefile.exists() && !savefile.delete()) {
            throw new ToolException("savefile already exists.");
        }
        if (!savefile.createNewFile()) {
            throw new ToolException("cannot create new file.");
        }
        FileOutputStream out = new FileOutputStream(savefile);
        return out;
    }

    private void initFontAndStyle(HSSFWorkbook book) {
        titleStyle = POIUtils.createTitleStyle((HSSFWorkbook)book);
        contentStyle = POIUtils.createContentStyle((HSSFWorkbook)book);
        contentStyle.setWrapText(false);
    }
}

