/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service.multipath;

import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.entity.SelfMultiPathInfo;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class ISCSIEvalService {
    private static ISCSIEvalService INSTANCE = new ISCSIEvalService();
    private static String IPMATCHER = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static String CONTROLLERMATCHER = "[0-9|A-Z|a-z]+\\.[0-9|A-Z|a-z]+\\.[0-9|A-Z|a-z]+";
    private static String HYBRIDNETWORK = "HybridNetwork";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ISCSIEvalService.class);
    private static final String DISK_NAME = "diskName";
    private static final String IS_REDUNDANT = "isRedundant";
    private static final String NETWORK_TYPE = "networkType";

    private ISCSIEvalService() {
    }

    public static ISCSIEvalService getInstance() {
        return INSTANCE;
    }

    public List<Map<String, String>> evaluPath(List<SelfMultiPathInfo> path, DevNode storageDev, String cliRet) throws ToolException {
        HashMap<String, String> ipAndControMap = new HashMap<String, String>();
        ArrayList<Map<String, String>> redundantDiskList = new ArrayList<Map<String, String>>();
        if (null == path || null == storageDev) {
            LOGGER.info("Path or StorageDevNode is null.");
            return null;
        }
        if (StringUtils.isNULLStr((String)cliRet)) {
            cliRet = "";
        }
        String storageSN = storageDev.getDeviceSerialNumber();
        String key = storageSN + "_storageControllerInfo";
        String cli = SceneDataExchange.getInstance().loadKV(key);
        if (StringUtils.isNULLStr((String)cli)) {
            LOGGER.error("Storage-side target device echo is null.");
            ToolException toolException = new ToolException("evalu.query.storageTarget.device.failed");
            toolException.setDes(cliRet + System.lineSeparator() + cli);
            throw toolException;
        }
        this.parseEcho(cli, ipAndControMap);
        if (ipAndControMap.isEmpty()) {
            LOGGER.error("Storage-side target device is error echo");
            ToolException toolException = new ToolException("evalu.query.storageTarget.device.failed");
            toolException.setDes(cliRet + System.lineSeparator() + cli);
            throw toolException;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "The ipAndControMap is %s", ((Object)ipAndControMap).toString()));
        for (SelfMultiPathInfo disk : path) {
            this.parseRedundantDisk(disk, redundantDiskList, ipAndControMap);
        }
        return redundantDiskList;
    }

    public void parseRedundantDisk(SelfMultiPathInfo disk, List<Map<String, String>> redundantDiskList, Map<String, String> ipAndControMap) {
        if (this.checkNetWorkType(disk, redundantDiskList)) {
            return;
        }
        List<String> pathInfoList = disk.getPath();
        if (this.checkPathReduntant(disk, redundantDiskList, ipAndControMap, pathInfoList)) {
            LOGGER.info(String.format(Locale.ENGLISH, "The disk is redundant.", new Object[0]));
            return;
        }
        this.bulidRedundantDiskLits(disk, redundantDiskList, "False");
        LOGGER.info(String.format(Locale.ENGLISH, "The disk is Non-redundant :%s", disk.getDiskName()));
    }

    private boolean checkPathReduntant(SelfMultiPathInfo disk, List<Map<String, String>> redundantDiskList, Map<String, String> ipAndControMap, List<String> pathInfoList) {
        boolean isBelongStorage = false;
        if (pathInfoList.isEmpty()) {
            LOGGER.info("The pathInfo is empty.");
            isBelongStorage = true;
        }
        boolean isControllerA = false;
        boolean isControllerB = false;
        boolean isControllerL = false;
        boolean isControllerR = false;
        for (String pathInfo : pathInfoList) {
            if (StringUtils.isNULLStr((String)pathInfo)) {
                LOGGER.info("The pathInfo is empty.");
                isBelongStorage = true;
                continue;
            }
            String controller = this.getCtrlFromPath(ipAndControMap, pathInfo);
            if (StringUtils.isNULLStr((String)controller)) continue;
            isBelongStorage = true;
            if (controller.toLowerCase(Locale.ENGLISH).contains("a")) {
                isControllerA = true;
                LOGGER.info(String.format(Locale.ENGLISH, "The %s is A controller.", pathInfo));
            } else if (controller.toLowerCase(Locale.ENGLISH).contains("b")) {
                isControllerB = true;
                LOGGER.info(String.format(Locale.ENGLISH, "The %s is B controller.", pathInfo));
            } else if (controller.toLowerCase(Locale.ENGLISH).contains("l")) {
                isControllerL = true;
                LOGGER.info(String.format(Locale.ENGLISH, "The %s is L controller.", pathInfo));
            } else if (controller.toLowerCase(Locale.ENGLISH).contains("r")) {
                isControllerR = true;
                LOGGER.info(String.format(Locale.ENGLISH, "The %s is R controller.", pathInfo));
            }
            if (!this.getRedundantDiskList(disk, redundantDiskList, isControllerA, isControllerB, isControllerL, isControllerR)) continue;
            return true;
        }
        return this.checkBelongStorage(disk, redundantDiskList, isBelongStorage);
    }

    private String getCtrlFromPath(Map<String, String> ipAndControMap, String pathInfo) {
        return ipAndControMap.keySet().stream().filter(pathInfo::contains).map(ipAndControMap::get).findFirst().orElse("");
    }

    private boolean checkNetWorkType(SelfMultiPathInfo disk, List<Map<String, String>> redundantDiskList) {
        if (HYBRIDNETWORK.equals(disk.getNetworkType())) {
            this.bulidRedundantDiskLits(disk, redundantDiskList, "");
            LOGGER.info(String.format(Locale.ENGLISH, "The disk is HybridNetwork :%s", disk.getDiskName()));
            return true;
        }
        return false;
    }

    private boolean checkBelongStorage(SelfMultiPathInfo disk, List<Map<String, String>> redundantDiskList, boolean isBelongStorage) {
        if (!isBelongStorage) {
            this.bulidRedundantDiskLits(disk, redundantDiskList, "True");
            LOGGER.info(String.format(Locale.ENGLISH, "The disk is not belong to the storage, the result set pass, the disk name is:%s", disk.getDiskName()));
            return true;
        }
        return false;
    }

    private boolean getRedundantDiskList(SelfMultiPathInfo disk, List<Map<String, String>> redundantDiskList, boolean isControllerA, boolean isControllerB, boolean isControllerL, boolean isControllerR) {
        if (isControllerA && isControllerB) {
            this.bulidRedundantDiskLits(disk, redundantDiskList, "True");
            LOGGER.info(String.format(Locale.ENGLISH, "The disk is Redundant :%s", disk.getDiskName()));
            return true;
        }
        if (isControllerL && isControllerR) {
            this.bulidRedundantDiskLits(disk, redundantDiskList, "True");
            LOGGER.info(String.format(Locale.ENGLISH, "The disk is Redundant :%s", disk.getDiskName()));
            return true;
        }
        return false;
    }

    public void bulidRedundantDiskLits(SelfMultiPathInfo disk, List<Map<String, String>> redundantDiskList, String isRedundant) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put(DISK_NAME, disk.getDiskName());
        infoMap.put(NETWORK_TYPE, disk.getNetworkType());
        infoMap.put(IS_REDUNDANT, isRedundant);
        redundantDiskList.add(infoMap);
    }

    public Map<String, String> parseEcho(String cli, Map<String, String> ipAndControMap) {
        List resultList = CliResolverUtils.resloveCliRetToList((String)cli);
        for (Map recordMap : resultList) {
            String ipv6;
            String[] controStrs;
            String controller;
            if (!"link up".equalsIgnoreCase((String)recordMap.get("Running Status")) || StringUtils.isNULLStr((String)(controller = (String)recordMap.get("ID"))) || "--".equals(controller) || (controStrs = controller.split("\\.")).length < 3) continue;
            String ipv4 = (String)recordMap.get("IPv4 Address");
            if (!StringUtils.isNULLStr((String)ipv4) && !"--".equals(ipv4)) {
                ipAndControMap.put(ipv4, controStrs[1]);
            }
            if (StringUtils.isNULLStr((String)(ipv6 = (String)recordMap.get("IPv6 Address"))) || "--".equals(ipv6)) continue;
            ipAndControMap.put(ipv6.toLowerCase(), controStrs[1]);
            String ipv6Complement = this.trans2ComplementIpv6(ipv6);
            ipAndControMap.put(ipv6Complement.toLowerCase(), controStrs[1]);
        }
        return ipAndControMap;
    }

    private String trans2ComplementIpv6(String ipv6) {
        int ipv6ComplementSubsectionNum = 8;
        if (ipv6.split(":").length == 8) {
            return ipv6;
        }
        ArrayList<String> complementIpv6Subsections = new ArrayList<String>();
        String[] subsections = ipv6.split(":", -1);
        int spaceLength = "".equals(subsections[0]) || "".equals(subsections[subsections.length - 1]) ? 2 : 1;
        for (int i = 0; i < subsections.length; ++i) {
            if ("".equals(subsections[i])) {
                int complementLength = 8 - (subsections.length - spaceLength);
                for (int j = 0; j < complementLength; ++j) {
                    complementIpv6Subsections.add("0");
                }
                if (!"".equals(subsections[i + 1])) continue;
                ++i;
                continue;
            }
            complementIpv6Subsections.add(subsections[i]);
        }
        return String.join((CharSequence)":", complementIpv6Subsections);
    }
}

