/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service.multipath;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class MultiPathStatusEvallService
extends AbstractCompService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MultiPathStatusEvallService.class);
    private static final String MULTIPATH_QUERY_KEY = "cmd_disaplay_cmd_info_multipath_hdiskList";
    private static final String FILTER_NOTHW_KEY_PRIX = "cmd_disaplay_multipath_hdiskinfo_";
    private static final String HDISK_REDUNT_CHECK_RESULT = "reduntpathInfo:";
    private static final EvalFeatureResult CANNOTEVAL = new EvalFeatureResult(null, ItemResultEnum.CANNOTEVAL);
    private static final String HWMULTIPATH_NA = "NA";
    private static final String SELFMULTIPATH_ENABLED = "enabled";
    private static final String SELFMULTIPATH_DISABLED = "disabled";
    private static final String SELF_MULTI_PATH_INFO = "SelfMultiPath";
    private static final String HW_MULTIPATH_VERSION = "HuaweiMultipathVersion";
    private static final String TRUE = "True";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        EvalFeatureResult result = null;
        try {
            Map<String, String> evalMap = params.getItemInfo().getInfoGrabMetaMsg();
            result = evalMap.containsKey("multiPathEvalResult") ? this.parseCheckResultNew(evalMap, evalContext) : (evalMap.containsKey("multipath_check") || evalMap.containsKey("multiPathStatus") ? this.parseCheckResult(evalMap, evalContext) : this.executeAixEvalMultipath(params));
        }
        catch (ToolException e) {
            DevNode devNode = (DevNode)evalContext.get("evalStorDevNode");
            String failDesc = ResourceUtil.getStringWithParams((String)e.getErrorId(), (Object[])new Object[]{devNode.getIp()});
            result = new EvalFeatureResult();
            if (!StringUtils.isNULLStr((String)e.getDes())) {
                LOGGER.info("The storage port echo info is error.");
                result.setOriginalInfo(e.getDes());
            }
            result.setFailDesc(failDesc);
            result.setItemResult(ItemResultEnum.NOTPASS);
        }
        return (T)result;
    }

    private <T extends EvalFeatureResult> T executeAixEvalMultipath(AbstractCompService.EvalCommParams params) {
        ItemInfo itemInfo = params.getItemInfo();
        String multiPath = itemInfo.getMultiSoftEdition();
        JSONObject multiPathInfo = this.parseToJsonObj(multiPath);
        EvalFeatureResult result = new EvalFeatureResult();
        StringBuilder originalInfo = new StringBuilder();
        originalInfo.append(multiPath).append('\n');
        Set<Map.Entry<String, String>> allCli = itemInfo.getInfoGrabMetaMsg().entrySet();
        for (Map.Entry<String, String> cli : allCli) {
            if ("DIFNotIdentityCheck".equals(cli.getKey())) continue;
            originalInfo.append('\n').append(cli.getValue());
        }
        result.setOriginalInfo(originalInfo.toString());
        if (null == multiPathInfo) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.multipath.reduntpath.qry.multipath.failed"));
            return (T)result;
        }
        String hwMultiPathVer = this.getJsonVal(multiPathInfo, HW_MULTIPATH_VERSION, HWMULTIPATH_NA);
        String buildInMultiPath = this.getJsonVal(multiPathInfo, SELF_MULTI_PATH_INFO, SELFMULTIPATH_DISABLED);
        if (!HWMULTIPATH_NA.equals(hwMultiPathVer) || SELFMULTIPATH_ENABLED.equals(buildInMultiPath)) {
            return this.checkMultiPathRedundantPath(result, itemInfo);
        }
        result.setItemResult(ItemResultEnum.NOTPASS);
        result.setFailDesc(ResourceUtil.getString((String)"eval.host.multipath.reduntpath.self&buildin.allnotexist"));
        return (T)result;
    }

    private String getJsonVal(JSONObject multiPathInfo, String key, String defaultVal) {
        try {
            return multiPathInfo.getString(key);
        }
        catch (Exception e) {
            LOGGER.error("getJsonValue error:" + multiPathInfo);
            return defaultVal;
        }
    }

    private <T extends EvalFeatureResult> T checkMultiPathRedundantPath(EvalFeatureResult result, ItemInfo itemInfo) {
        LOGGER.info("mapInfo:{}", (Object)itemInfo.getInfoGrabMetaMsg());
        String pathInfo = itemInfo.getInfoGrabMetaMsg(MULTIPATH_QUERY_KEY);
        List<String> validPathList = this.getAvailablePaths(pathInfo, itemInfo);
        if (validPathList.isEmpty()) {
            String failReson = ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.donot.get.disk.information", (Object[])new Object[]{"lsdev -Cc disk | grep FC"});
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(failReson);
            return (T)result;
        }
        List<String> noRedntPathHdisk = this.findNotRedntPathDisk(validPathList, itemInfo);
        if (!noRedntPathHdisk.isEmpty()) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getStringWithParams((String)"eval.multipath.reduntpath.check.fail", (Object[])new Object[]{this.toStringParams(noRedntPathHdisk)}));
        }
        return (T)result;
    }

    private String toStringParams(List<String> inValidPathList) {
        if (inValidPathList.isEmpty()) {
            return "";
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (String hdisk : inValidPathList) {
            paramBuilder.append(hdisk).append('\u3001');
        }
        return paramBuilder.toString().substring(0, paramBuilder.length() - 1);
    }

    private List<String> findNotRedntPathDisk(List<String> validPathList, ItemInfo itemInfo) {
        ArrayList<String> noReduntCheckResult = new ArrayList<String>();
        for (String path : validPathList) {
            String pathKey = HDISK_REDUNT_CHECK_RESULT + path;
            String resultVal = itemInfo.getInfoGrabMetaMsg(pathKey).trim();
            if (TRUE.equalsIgnoreCase(resultVal)) continue;
            noReduntCheckResult.add(path);
        }
        return noReduntCheckResult;
    }

    private List<String> getAvailablePaths(String pathInfo, ItemInfo itemInfo) {
        ArrayList<String> validPathList = new ArrayList<String>();
        String[] lines = pathInfo.split("\r\n");
        for (int i = 1; i < lines.length; ++i) {
            String path = lines[i];
            String[] info = path.split(" ");
            String key = FILTER_NOTHW_KEY_PRIX + info[0];
            String filterValue = itemInfo.getInfoGrabMetaMsg(key);
            if (!filterValue.contains("Manufacturer.....")) continue;
            validPathList.add(info[0]);
        }
        return validPathList;
    }
}

