/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.silence;

import com.alibaba.fastjson.JSON;
import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import com.huawei.ism.tool.silence.ISilenceTask;
import com.huawei.ism.tool.silence.entity.DeviceResultInfo;
import com.huawei.ism.tool.silence.entity.SilenceTaskRequest;
import com.huawei.ism.tool.silence.entity.SilenceTaskResponse;
import com.huawei.ism.tool.silence.entity.TaskExtensionInfo;
import com.huawei.ism.tool.silence.util.ResponseHelper;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.Module;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.UpgEvaUserOpData;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluState;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.silence.adapter.UpgradeEvaluationSilenceService;
import com.huawei.ism.tool.upgradeevalu.silence.entity.RequestParams;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallable;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;

public class UpgradeEvaluationSilenceTask
implements ISilenceTask {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UpgradeEvaluationSilenceTask.class);
    private UpgradeEvaluationSilenceService adapter = UpgradeEvaluationSilenceService.getInstance();
    private SilenceTaskRequest request = null;
    private SilenceTaskResponse response = new SilenceTaskResponse();
    private UpgradeEvaluationResponseHelper responseHelper = new UpgradeEvaluationResponseHelper();
    private Map<String, EvaluDevNode> upgradeEvaluDevNodes = new HashMap<String, EvaluDevNode>();
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public void init() {
        this.adapter.init();
    }

    public void excute(SilenceTaskRequest req) {
        this.request = req;
        ArrayList<EvaluDevNode> evaluDevNodes = new ArrayList<EvaluDevNode>();
        List devNodes = this.request.getDevs();
        HashMap<String, DeviceResultInfo> results = new HashMap<String, DeviceResultInfo>();
        HashMap<String, DeviceResultInfo> deviceResultInfos = new HashMap<String, DeviceResultInfo>();
        ArrayList<List<String>> devsSelectItems = new ArrayList<List<String>>();
        this.response.setDevRsps(results);
        Map params = this.request.getParams();
        for (com.huawei.ism.tool.obase.entity.DevNode oldDevNode : devNodes) {
            DevNode devNode = EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)oldDevNode);
            DeviceLocator.addOrMdyDev((DevNode)devNode);
            EvaluDevNode evaluDev = new EvaluDevNode(devNode);
            evaluDevNodes.add(evaluDev);
            this.upgradeEvaluDevNodes.put(devNode.getDeviceSerialNumber(), evaluDev);
            if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
                evaluDev.setSvpIp(devNode.getIp());
                evaluDev.setIp((String)devNode.getIpList().get(0));
            }
            DeviceResultInfo deviceResultInfo = new DeviceResultInfo();
            deviceResultInfo.setSn(devNode.getDeviceSerialNumber());
            results.put(devNode.getDeviceSerialNumber(), deviceResultInfo);
            deviceResultInfos.put(evaluDev.getId(), deviceResultInfo);
            RequestParams requestParams = new RequestParams(devNode.getDeviceSerialNumber(), params);
            List<String> selectItem = requestParams.getSelectItem();
            devsSelectItems.add(selectItem);
            try {
                evaluDev.setUpgradeMode(requestParams.getUpgradeMode());
                evaluDev.setDestVersion(requestParams.getDestVersion());
            }
            catch (ToolException e) {
                LOGGER.error("Silence Upgrade Evaluation failed.");
                String errMsg = ResourceUtil.getString((String)e.getErrorId());
                this.responseHelper.updateDeviceResultWhenError(deviceResultInfo, errMsg);
            }
        }
        this.initEvaluInfo(evaluDevNodes);
        this.setAllDevsSelectItems(evaluDevNodes, devsSelectItems);
        UpgradeEvaluationObserver observer = new UpgradeEvaluationObserver(deviceResultInfos);
        this.adapter.upgradeEvaluation(evaluDevNodes, observer, this.evaluContext.getHtmlDir());
        this.executorService.submit(new RefreshProgress());
    }

    private void initEvaluInfo(List<EvaluDevNode> evaluDevNodes) {
        this.evaluContext.setReportDir(new File(this.request.getWorkPath()));
        this.loadEvaluDevNode(evaluDevNodes);
        this.addDevsToUserOpMap(evaluDevNodes);
    }

    private void loadEvaluDevNode(List<EvaluDevNode> evaluDevNodes) {
        EvaluDevManager.getInstance().setEvaluDevs(new ArrayList<EvaluDevNode>(evaluDevNodes));
        EvaluDevManager.getInstance().addTabDevs(new ArrayList<EvaluDevNode>(evaluDevNodes));
        AsyncExcutor.execute((ProgressDialog)null, (boolean)true, (long)50000L, (Callable[])new Callable[]{new LoadEvaluItemCallable(evaluDevNodes)});
    }

    private void addDevsToUserOpMap(List<EvaluDevNode> devs) {
        for (EvaluDevNode dev : devs) {
            UpgEvaUserOpData userOpData = new UpgEvaUserOpData();
            userOpData.setDevNode(dev);
            userOpData.setToVersion(dev.getDestVersion());
            userOpData.setUpgradeType(dev.getUpgradeModeUI());
            this.evaluContext.getUserOpData().put(dev, userOpData);
            LOGGER.info("Bind the userOpInfo with dev: {} success.", (Object)dev.getIp());
        }
    }

    private void setAllDevsSelectItems(List<EvaluDevNode> evaluDevNodes, List<List<String>> devsSelectItems) {
        for (int i = 0; i < evaluDevNodes.size(); ++i) {
            this.setSelectItems(evaluDevNodes.get(i), devsSelectItems.get(i));
        }
    }

    private void setSelectItems(EvaluDevNode evaluDevNode, List<String> selectItem) {
        if (selectItem.size() == 0) {
            return;
        }
        KeyOrderedHashMap<CrossVersionType, ProductCfg> products = evaluDevNode.getProducts();
        ProductCfg prod = (ProductCfg)products.get((Object)CrossVersionType.INNERVERSION);
        List<Module> modules = prod.getModules();
        if (modules.size() == 0) {
            LOGGER.error("There are no evaluation items to select from.");
            return;
        }
        List<EvaluItem> selectItemList = this.findAllSelectItems(modules, selectItem);
        Module selectItemModule = modules.get(0);
        selectItemModule.setItems(selectItemList);
        modules = new ArrayList<Module>();
        modules.add(selectItemModule);
        prod.setModules(modules);
        prod.setDynamicModules(new ArrayList<Module>());
    }

    private List<EvaluItem> findAllSelectItems(List<Module> modules, List<String> selectItem) {
        ArrayList<EvaluItem> selectItemList = new ArrayList<EvaluItem>();
        for (String selectItemId : selectItem) {
            EvaluItem item = this.getSelectItemById(modules, selectItemId);
            if (item == null) {
                LOGGER.error("The select item is not in the equipment evaluation item, the name is :" + selectItemId);
                continue;
            }
            selectItemList.add(item);
        }
        return selectItemList;
    }

    private EvaluItem getSelectItemById(List<Module> modules, String selectItemId) {
        for (Module module : modules) {
            for (EvaluItem item : module.getItems()) {
                if (!selectItemId.equals(item.getId())) continue;
                return item;
            }
        }
        return null;
    }

    public void acceptCmd(Collection<TaskExtensionInfo> taskExtensionInfos) {
    }

    public SilenceTaskResponse getResponse() {
        this.responseHelper.mergeResult(this.response);
        return this.response;
    }

    public boolean isSupportAcceptCmd() {
        return false;
    }

    public class UpgradeEvaluationResponseHelper
    extends ResponseHelper {
        private static final String NAME = "name";
        private static final String METHOD = "method";
        private static final String CRITERION = "criterion";
        private static final String SUGGESTION = "suggestion";
        private static final String SOURCE_INFO = "sourceInfo";
        private static final String START_TIME = "startTime";
        private static final String RESULT = "result";
        private static final String CHECK_STATE = "checkState";
        private static final String ERROR_INFO = "errorInfo";

        public void updateReturnDatas(Map<String, String> evaluItems, EvaluItem item) {
            String name = this.getEvaluaItemName(item);
            String oldItemStr = "";
            if (evaluItems.containsKey(name)) {
                oldItemStr = evaluItems.get(name);
            }
            evaluItems.put(name, this.addCheckItemContext(item, oldItemStr));
        }

        private String getEvaluaItemName(EvaluItem item) {
            if ("innerCheck".equals(item.getItemType()) || !this.containCheckItemResource(item)) {
                String sendReportWithPath;
                String name = item.getName();
                if (name.contains(sendReportWithPath = ResourceUtil.getString((String)"evalu.ui.itemDetail.items.customer.repair1"))) {
                    String repairStr = ResourceUtil.getString((String)"eval.silence.task.ui.sendReport.repair");
                    name = "<html><span style=\"color:red\",>" + repairStr + "</span></html>";
                }
                return name;
            }
            return this.getCheckItemResource(item, NAME);
        }

        private String addCheckItemContext(EvaluItem item, String oldItemStr) {
            ResultItem resultItem = item.getRetItem();
            LinkedHashMap<String, String> evaluItemInfo = JSON.parseObject(oldItemStr, LinkedHashMap.class);
            if (StringUtils.isNULLStr((String)oldItemStr)) {
                evaluItemInfo = new LinkedHashMap<String, String>();
                Date curDate = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startTime = dateFormat.format(curDate);
                evaluItemInfo.put(START_TIME, startTime);
            }
            if (this.containCheckItemResource(item)) {
                evaluItemInfo.put(METHOD, this.getCheckItemResource(item, METHOD));
                evaluItemInfo.put(CRITERION, this.getCheckItemResource(item, CRITERION));
                evaluItemInfo.put(SUGGESTION, this.getCheckItemResource(item, SUGGESTION));
            }
            evaluItemInfo.put(SOURCE_INFO, resultItem.getSourceInfo());
            evaluItemInfo.put(RESULT, resultItem.getRetFlag().toString());
            evaluItemInfo.put(CHECK_STATE, this.transStateToUiText(resultItem.getRetFlag()));
            evaluItemInfo.put(ERROR_INFO, resultItem.getErrorInfo());
            return JSON.toJSONString(evaluItemInfo);
        }

        private boolean containCheckItemResource(EvaluItem item) {
            return this.getCheckItemResource(item, NAME) != null;
        }

        private String transStateToUiText(ResultFlag resultFlag) {
            switch (resultFlag) {
                case WAITING: {
                    return ResourceUtil.getString((String)"evalu.evaluState.under.evaluation");
                }
                case PASS: {
                    return ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.pass");
                }
                case NOTPASS: {
                    return ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.pass");
                }
                case NOCHECK: {
                    return ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.evaluation");
                }
                case NOSUPPORT: {
                    return ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.support");
                }
                case WARN: {
                    return ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.warn");
                }
            }
            return ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.exception");
        }

        private String getCheckItemResource(EvaluItem item, String detailPart) {
            String idPrefix = item.getId() + ".";
            String resourceKey = idPrefix + detailPart;
            if ("innerCheck".equals(item.getItemType())) {
                String val = item.getString(resourceKey);
                val = "--".equals(val) ? resourceKey : val;
                val = val.replaceAll("\\\\n", "\n");
                return val;
            }
            EvaluDevNode evaluDevNode = EvaluDevManager.getInstance().getTabDevById(item.getDevID());
            if (evaluDevNode == null) {
                return null;
            }
            ResourceBundle bundle = evaluDevNode.getProduct(item.getCrossVersionType()).getResBundle();
            if (bundle.containsKey(resourceKey)) {
                return bundle.getString(resourceKey);
            }
            return null;
        }
    }

    public class UpgradeEvaluationObserver
    implements IUiObserver {
        private Map<String, DeviceResultInfo> resultInfos;
        private HashMap<String, LinkedHashMap> devReturnDatas = new HashMap();

        public UpgradeEvaluationObserver(Map<String, DeviceResultInfo> resultInfos) {
            this.resultInfos = resultInfos;
        }

        @Override
        public void updateChildItems(EvaluDevNode evaluDev, String itemId, Map<String, Object> jsonMsg) {
            List<EvaluItem> childItems = this.convertMsg2CheckItems(jsonMsg, evaluDev.getId());
            ProductCfg product = evaluDev.getProduct(CrossVersionType.INNERVERSION);
            product.setDynamicEvaluItems(itemId, childItems);
            for (EvaluItem item : childItems) {
                this.updateDetailList(item);
            }
        }

        private List<EvaluItem> convertMsg2CheckItems(Map<String, Object> jsonMsg, String devId) {
            ArrayList<EvaluItem> items = new ArrayList<EvaluItem>();
            List mpItems = PyJavaUtils.convertPyList2Jlist((Object)jsonMsg.get("checkitems"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Map item : mpItems) {
                EvaluItem checkItem;
                block5: {
                    checkItem = new EvaluItem();
                    checkItem.setItemType("innerCheck");
                    checkItem.setShowOrigin(false);
                    checkItem.setDevID(devId);
                    String suggession = item.get("suggession").toString();
                    ResultItem retItem = new ResultItem();
                    retItem.setErrorInfo(suggession);
                    retItem.setSourceInfo("");
                    int status = Integer.parseInt(item.get("status").toString());
                    retItem.setRetFlag(ResultFlag.valueOf(status));
                    checkItem.setRetItem(retItem);
                    String name = item.get("name").toString();
                    checkItem.setName(name);
                    if (item.containsKey("startTime")) {
                        String startTime = item.get("startTime").toString();
                        try {
                            Date date = simpleDateFormat.parse(startTime);
                            retItem.setFinishTime(date);
                        }
                        catch (ParseException e) {
                            retItem.setFinishTime(Calendar.getInstance().getTime());
                            if (!LOGGER.isInfoEnabled()) break block5;
                            LOGGER.info("parse exception, startTime=" + startTime);
                        }
                    }
                }
                if (item.containsKey("nameId")) {
                    String nameId = item.get("nameId").toString();
                    checkItem.setId(nameId);
                }
                StringBuilder buffer = new StringBuilder();
                String ctrl = item.get("ctrl").toString();
                buffer.append(checkItem.getId() + "_" + ctrl);
                checkItem.setIdentifier(buffer.toString());
                items.add(checkItem);
            }
            return items;
        }

        @Override
        public void updateDetailList(EvaluItem item) {
            DeviceResultInfo resultInfo = this.resultInfos.get(item.getDevID());
            LinkedHashMap evaluItems = new LinkedHashMap();
            if (this.devReturnDatas.containsKey(resultInfo.getSn())) {
                evaluItems = this.devReturnDatas.get(resultInfo.getSn());
            } else {
                this.devReturnDatas.put(resultInfo.getSn(), evaluItems);
            }
            UpgradeEvaluationSilenceTask.this.responseHelper.updateReturnDatas(evaluItems, item);
            Map extras = resultInfo.getExtras();
            UpgradeEvaluationSilenceTask.this.responseHelper;
            extras.put("returnData", JSON.toJSONString(evaluItems));
            EvaluDevNode evaluDevNode = (EvaluDevNode)((Object)UpgradeEvaluationSilenceTask.this.upgradeEvaluDevNodes.get(resultInfo.getSn()));
            if (evaluDevNode.getEvaluState().equals((Object)EvaluState.SUCCESS)) {
                ResultFlag devEvaluResult = evaluDevNode.getEvaluRet().getRetFlag();
                this.setEvaluUiResult(devEvaluResult, resultInfo);
            }
        }

        private void setEvaluUiResult(ResultFlag devEvaluResult, DeviceResultInfo resultInfo) {
            resultInfo.setStatus("finished");
            if (ResultFlag.PASS.equals((Object)devEvaluResult)) {
                resultInfo.setResult("success");
                resultInfo.setBizStatus(ResourceUtil.getString((String)"evalu.ui.itemDetail.return.success"));
            } else {
                resultInfo.setResult("failed");
                resultInfo.setBizStatus(ResourceUtil.getString((String)"evalu.ui.itemDetail.return.failure"));
            }
        }

        @Override
        public void finishAll() {
            this.dealUnfinishedDevice();
        }

        private void dealUnfinishedDevice() {
            Map devRsps = UpgradeEvaluationSilenceTask.this.response.getDevRsps();
            boolean hasUnfinishedDevice = false;
            for (String sn : devRsps.keySet()) {
                DeviceResultInfo resultInfo = (DeviceResultInfo)devRsps.get(sn);
                if (!this.isUnfinishedDevice(resultInfo)) continue;
                resultInfo.setStatus("finished");
                resultInfo.setResult("failed");
                this.setEvaluUiResult(ResultFlag.NOTPASS, resultInfo);
                hasUnfinishedDevice = true;
            }
            if (hasUnfinishedDevice) {
                UpgradeEvaluationSilenceTask.this.response.setTaskEnd(true);
            }
        }

        private boolean isUnfinishedDevice(DeviceResultInfo deviceResultInfo) {
            return !"finished".equals(deviceResultInfo.getStatus());
        }

        @Override
        public void updateDevTableRow(EvaluDevNode dev) {
        }

        @Override
        public void addDev2Table(List<EvaluDevNode> evaludevs) {
        }

        @Override
        public void refreshDetailList(boolean isRewriteDetail) {
        }

        @Override
        public void showTaskErr(String errMsg) {
        }

        @Override
        public void evaluProcessTip(String msg) {
        }

        @Override
        public void refreshLoadingPic() {
        }

        @Override
        public void updateItemProgress(EvaluDevNode dev, int progress, String itemId) {
        }

        @Override
        public void updateItemProgress(EvaluDevNode dev, int progress, String timeLeft, String itemId) {
        }
    }

    private class RefreshProgress
    implements Runnable {
        private static final int SLEEP_MS = 10000;
        private Map<String, DeviceResultInfo> devRsps;

        private RefreshProgress() {
            this.devRsps = UpgradeEvaluationSilenceTask.this.response.getDevRsps();
        }

        @Override
        public void run() {
            while (!UpgradeEvaluationSilenceTask.this.response.isTaskEnd()) {
                this.refreshAllDevice();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Refresh progress thread sleep error.");
                }
            }
        }

        private void refreshAllDevice() {
            for (Map.Entry<String, DeviceResultInfo> entry : this.devRsps.entrySet()) {
                DeviceResultInfo deviceResultInfo = entry.getValue();
                this.refreshOneDevice(deviceResultInfo);
            }
        }

        private void refreshOneDevice(DeviceResultInfo deviceResultInfo) {
            EvaluDevNode evaluDevNode = (EvaluDevNode)((Object)UpgradeEvaluationSilenceTask.this.upgradeEvaluDevNodes.get(deviceResultInfo.getSn()));
            deviceResultInfo.setProgress(Integer.valueOf(evaluDevNode.getEvaluProgress()));
        }
    }
}

