/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.silence.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RequestParams {
    private static final String TARGET_VERSION = "targetVersion";
    private static final String MODEL = "model";
    private static final String MODEL_ONLINE = "online";
    private static final String MODEL_OFFLINE = "offline";
    private static final String MODEL_FAST = "fast";
    private static final String ITEM = "item";
    private Map<String, String> params;

    public RequestParams(String sn, Map<String, String> params) {
        String paramstr = params.get(sn);
        JSONObject paramObj = (JSONObject)JSON.parse(paramstr);
        this.params = JSONObject.toJavaObject(paramObj, Map.class);
    }

    public UpgradeMode getUpgradeMode() throws ToolException {
        String upgradeMode;
        switch (upgradeMode = this.params.get(MODEL)) {
            case "online": {
                return UpgradeMode.ONLINE;
            }
            case "offline": {
                return UpgradeMode.OFFLINE;
            }
            case "fast": {
                return UpgradeMode.FAST;
            }
        }
        throw new ToolException("eval.silence.task.unsupport.upgrademMode");
    }

    public String getDestVersion() throws ToolException {
        if (this.params.containsKey(TARGET_VERSION)) {
            return this.params.get(TARGET_VERSION);
        }
        throw new ToolException("eval.silence.task.no.upgrade.DestVerion");
    }

    public List<String> getSelectItem() {
        String selectItemJsonStr = this.params.get(ITEM);
        if (selectItemJsonStr == null) {
            return new ArrayList<String>();
        }
        return this.tansSelectItemToList(selectItemJsonStr);
    }

    private List<String> tansSelectItemToList(String selectItemJsonStr) {
        String[] selectItemJsonStrs = selectItemJsonStr.split(",");
        return Arrays.asList(selectItemJsonStrs);
    }
}

