/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.task;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.entity.UpgradeHostInfo;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.impl.ICompservice;
import com.huawei.ism.tool.upgradeevalu.enums.ItCompatFeautureEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskParameters;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.FilterBlackList;
import com.huawei.ism.tool.upgradeevalu.task.TaskAnalyze;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationEngine {
    private static final Logger log = LoggerFactory.getLogger(EvaluationEngine.class);
    private static final String NONE = "None";
    private static final String FC_ONLY = "FC_Only";
    private static final String ISCSI_ONLY = "iSCSI_Only";
    private static final String FC_ISCSI = "FC_and_iSCSI";
    public static final String SERVICE_INTER = "serviceInter";
    public static final String RULE_ITEM = "ruleItem";
    public static final String ID = "ID";
    public static final String ISCSI = "ISCSI";
    public static final String IB = "IB";
    public static final String FC = "FC";
    public static final String ISCSI_TYPE = "222";
    public static final String INITIATOR_TYPE = "TYPE";
    public static final String RUNNINGSTATUS_ONLINE = "27";
    public static final String RUNNINGSTATUS = "RUNNINGSTATUS";
    public static final String FC_TYPE = "223";
    public static final String IB_TYPE = "16499";
    public static final String DATA_BASE = "dataBase";
    public static final String ITEM_INFO = "itemInfo";
    public static final String EVAL_ITEM_RESULT = "evalItemResult";
    public static final String EVAL_STORAGE_DEV = "evalStorDevNode";
    public static final String STORAGE_SN = "StorageSN";
    private static final int CORE_NUM = Integer.parseInt(ResourceUtil.getString((String)"cloudservice.compatibility.taskengine.threadpool.countsize"));
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(EvaluationEngine.class);
    private static final EvaluationEngine INSTANCE = new EvaluationEngine();
    private LinkedBlockingQueue<Runnable> linkeDevBlockingQueue = new LinkedBlockingQueue();
    private ThreadPoolExecutor threadPool = null;
    private ConcurrentHashMap<EvalTaskResult, TaskAnalyze> evalThreadMap = new ConcurrentHashMap();

    public EvaluationEngine() {
        this.threadPool = new ThreadPoolExecutor(CORE_NUM, 8, 1L, TimeUnit.MILLISECONDS, this.linkeDevBlockingQueue, new AnalyzeThreadFactory());
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public int getActiveThreadCount() {
        int threadCount = this.threadPool.getActiveCount();
        return threadCount;
    }

    public void addOneTaskThread(EvalTaskResult taskResult, EvalTaskParameters evalTaskParameters) {
        LOGGER.info("Add new task thread to thread pool ");
        LOGGER.info(String.format(Locale.ENGLISH, "Add new Thread: %s---%s", taskResult.getTaskInfo().getTaskId(), taskResult.getTaskInfo().getTaskName()));
        TaskAnalyze currThread = new TaskAnalyze(taskResult, evalTaskParameters);
        this.evalThreadMap.put(taskResult, currThread);
        this.threadPool.execute(currThread);
    }

    public static EvaluationEngine getInstance() {
        return INSTANCE;
    }

    public static EvalFeatureResult executeBlackList(ItemInfo singleItemInfo, EvalFeatureResult baseConnectBlack, boolean isDirectConNet) {
        FilterBlackList bilterBlackList = new FilterBlackList();
        bilterBlackList.compatibilityCheckBlackList(singleItemInfo, baseConnectBlack, isDirectConNet);
        return baseConnectBlack;
    }

    public static <T extends EvalFeatureResult> T executeEval(Map<String, Object> evalContext, EvalFeatureResult evalResult) throws ToolException {
        EvalFeatureResult evalFeatureResult = null;
        Object ruleItem = evalContext.get(RULE_ITEM);
        Object itemInfo = evalContext.get(ITEM_INFO);
        Object evalItemResult = evalContext.get(EVAL_ITEM_RESULT);
        RuleItem item = (RuleItem)CommonUtil.convertObject((Object)ruleItem, RuleItem.class);
        ItemInfo itemInf = (ItemInfo)CommonUtil.convertObject((Object)itemInfo, ItemInfo.class);
        EvalItemResult evalItemResultInfo = (EvalItemResult)CommonUtil.convertObject((Object)evalItemResult, EvalItemResult.class);
        StorageInfo storageInfo = EvaluationEngine.getStorageInfo(itemInf, evalItemResultInfo);
        String evalService = item.getEvalService();
        Object service = ReflectionUtils.newInstance((String)evalService);
        try {
            if (ItCompatFeautureEnum.BASE_CONNECTIVITY.toString().equals(item.getItemTitle())) {
                evalFeatureResult = EvaluationEngine.executeBlackList(itemInf, evalResult, EvaluationEngine.isCurHostDirectConNetwork(storageInfo, evalContext));
            }
            if (service != null && service instanceof ICompservice) {
                evalContext.put(STORAGE_SN, null != storageInfo ? storageInfo.getStorageSn() : null);
                ICompservice serviceReal = (ICompservice)CommonUtil.convertObject((Object)service, ICompservice.class);
                evalFeatureResult = serviceReal.evalate(evalContext);
                if (evalFeatureResult == null) {
                    log.info("the item is :{} evalFeatureResult is null host ip:{}", (Object)item.getItemTitle(), (Object)itemInf.getIp());
                    evalFeatureResult = new EvalFeatureResult();
                    evalFeatureResult.setItemResult(ItemResultEnum.CANNOTEVAL);
                    evalFeatureResult.setFailDesc(ResourceUtil.getString((String)"compatibility.compat.exception.db.query"));
                    return (T)evalFeatureResult;
                }
            }
            if (evalFeatureResult == null) {
                log.error("evalItemResult is null");
                throw new ToolException("evalItemResult is null");
            }
            log.info("the item is :{} this item original result is:{}", (Object)item.getItemTitle(), (Object)evalFeatureResult.getItemResult());
            if (EvaluationEngine.checkItemResult(evalContext, evalFeatureResult, item, storageInfo)) {
                return (T)evalFeatureResult;
            }
            if (EvaluationEngine.checkFCHbaTimeOutHyperV(evalContext, item, storageInfo)) {
                return (T)new EvalFeatureResult();
            }
            if (EvaluationEngine.iscsiTimeoutCheck(evalContext, item, storageInfo)) {
                return (T)new EvalFeatureResult();
            }
        }
        catch (Exception e) {
            log.error("eval error!", e);
            throw new ToolException("compatibility.compat.exception.db.query", (Throwable)e);
        }
        log.info("compat eval is finished.");
        return (T)evalFeatureResult;
    }

    private static <T extends EvalFeatureResult> boolean checkFCHbaTimeOutHyperV(Map<String, Object> evalContext, RuleItem item, StorageInfo storageInfo) {
        if (!EvaluationEngine.getInitiatorInfo(storageInfo, evalContext).get(FC).booleanValue()) {
            boolean isFCItem;
            boolean bl = isFCItem = item.getItemTitle().equalsIgnoreCase("baseConnectivity") || item.getItemTitle().equalsIgnoreCase("hostHbaTimeOut") || item.getItemTitle().equalsIgnoreCase("WindowsVirtualHyperVCluster");
            if (isFCItem) {
                LOGGER.info("the host is not FC network, set baseConnectivity and hostHbaTimeOut and WindowsVirtualHyperVCluster item result pass!");
                return true;
            }
        }
        return false;
    }

    private static <T extends EvalFeatureResult> boolean iscsiTimeoutCheck(Map<String, Object> evalContext, RuleItem item, StorageInfo storageInfo) {
        boolean isFCItem;
        if (!EvaluationEngine.getInitiatorInfo(storageInfo, evalContext).get(ISCSI).booleanValue() && (isFCItem = item.getItemTitle().equalsIgnoreCase("IscsiTimeoutCheck"))) {
            LOGGER.info("the host is not ISCSI network, set IscsiTimeoutCheck item result pass!");
            return true;
        }
        return false;
    }

    private static <T extends EvalFeatureResult> boolean checkItemResult(Map<String, Object> evalContext, EvalFeatureResult evalFeatureResult, RuleItem item, StorageInfo storageInfo) {
        if (null == storageInfo || ItUpgradeKeyEnum.ORACLE_TIME_OUT.toString().equals(item.getItemTitle())) {
            LOGGER.info("the storageInfo is null!");
            return true;
        }
        int storageLUNNum = EvaluationEngine.calculateLUNNumber(storageInfo, evalContext);
        if (ItemResultEnum.PASS.equals((Object)evalFeatureResult.getItemResult()) || storageLUNNum <= 0) {
            LOGGER.info("the eval result is pass or storageLun info get failed!");
            return true;
        }
        if (EvaluationEngine.getHostNumber(storageInfo) <= 0 || storageLUNNum == 0) {
            LOGGER.info("the host number or lun number is 0, set all item result pass!");
            evalFeatureResult.setItemResult(ItemResultEnum.PASS);
            return true;
        }
        if (!(EvaluationEngine.getInitiatorInfo(storageInfo, evalContext).get(FC).booleanValue() || EvaluationEngine.getInitiatorInfo(storageInfo, evalContext).get(ISCSI).booleanValue() || EvaluationEngine.getInitiatorInfo(storageInfo, evalContext).get(IB).booleanValue())) {
            LOGGER.info("the host network can not eval, set all item result pass!");
            return true;
        }
        return false;
    }

    private static StorageInfo getStorageInfo(ItemInfo itemInf, EvalItemResult evalItemResultInfo) {
        StorageInfo storageInfo = null;
        storageInfo = itemInf.getOsName().equalsIgnoreCase("Oracle") ? EvaluationEngine.getCurSQLtStorage(evalItemResultInfo) : EvaluationEngine.getCurHostStorage(evalItemResultInfo);
        return storageInfo;
    }

    private static boolean isCurHostDirectConNetwork(StorageInfo storageInfo, Map<String, Object> evalContext) {
        if (null == storageInfo) {
            LOGGER.info("the storage info is null.");
            return true;
        }
        List hostInfos = storageInfo.getHostList();
        List<String> hostWwnList = EvaluationEngine.getHostWWN(evalContext);
        if (hostWwnList.isEmpty() || hostInfos == null) {
            LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s get the host wwn list failed.", storageInfo.getStorageSn()));
            return true;
        }
        for (UpgradeHostInfo hostInfo : hostInfos) {
            List initList = hostInfo.getInitList();
            for (Map map : initList) {
                List pathList;
                boolean isDirectConNet;
                if (StringUtils.isNULLStr((String)((String)map.get(ID))) || !hostWwnList.contains(((String)map.get(ID)).trim()) || !(isDirectConNet = EvaluationEngine.calculatePathNumber(pathList = hostInfo.getPathsList()))) continue;
                LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s, the host name is :%s, it is direct connection network.", storageInfo.getStorageSn(), hostInfo.getHostName()));
                return true;
            }
        }
        LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s, it is not direct connection network.", storageInfo.getStorageSn()));
        return false;
    }

    private static boolean calculatePathNumber(List<Map<String, String>> pathList) {
        ArrayList<String> initiatorPortWwnList = new ArrayList<String>();
        for (Map<String, String> map : pathList) {
            String initiatorPortWwn = map.get("INITIATOR_PORT_WWN");
            if (StringUtils.isNULLStr((String)initiatorPortWwn)) continue;
            initiatorPortWwnList.add(initiatorPortWwn);
        }
        HashSet initiatorPortWwnSet = new HashSet(initiatorPortWwnList);
        if (initiatorPortWwnList.size() == initiatorPortWwnSet.size()) {
            LOGGER.info("the network is direct connection!");
            return true;
        }
        return false;
    }

    private static StorageInfo getCurSQLtStorage(EvalItemResult evalItemResult) {
        try {
            List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
            String sqlSerialNumber = evalItemResult.getHostEvalTask().getStorageSn();
            if (storageInfos == null) {
                LOGGER.error("the storageInfos is null");
                return null;
            }
            for (StorageInfo storageInfo : storageInfos) {
                if (!storageInfo.getStorageSn().equalsIgnoreCase(sqlSerialNumber)) continue;
                LOGGER.error("the host IP is :" + evalItemResult.getItemInfo().getIp() + ", the storage sn is :" + sqlSerialNumber);
                return storageInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error("the host IP is :" + evalItemResult.getItemInfo().getIp() + ", the storage info is null!", e);
        }
        return null;
    }

    public static StorageInfo getCurHostStorage(EvalItemResult evalItemResult) {
        try {
            List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
            if (storageInfos == null) {
                LOGGER.error("the storageInfos is null.");
                return null;
            }
            String storageSn = evalItemResult.getHostEvalTask().getStorageSn();
            LOGGER.info(String.format(Locale.ENGLISH, "the host IP is :%s, the storage info is: %s", evalItemResult.getItemInfo().getIp(), storageSn));
            for (StorageInfo storageInfo : storageInfos) {
                if (StringUtils.isNULLStr((String)storageSn) || !storageSn.equalsIgnoreCase(storageInfo.getStorageSn())) continue;
                LOGGER.info(String.format(Locale.ENGLISH, "the host IP is :%s", evalItemResult.getItemInfo().getIp()));
                return storageInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error("the host IP is :" + evalItemResult.getItemInfo().getIp() + ", the storage info is null!", e);
        }
        return null;
    }

    public static StorageInfo getCurHostStorage(String storageSn) {
        try {
            List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
            if (storageInfos == null) {
                LOGGER.error("the storageInfos is null.");
                return null;
            }
            for (StorageInfo storageInfo : storageInfos) {
                if (StringUtils.isNULLStr((String)storageSn) || !storageSn.equalsIgnoreCase(storageInfo.getStorageSn())) continue;
                return storageInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error("the storage info is null!", e);
        }
        return null;
    }

    public static DevNode getCurHostStorageDev(Map<String, Object> evalContext) {
        Object evalItemResult = evalContext.get(EVAL_ITEM_RESULT);
        EvalItemResult evalItemResultInfo = (EvalItemResult)CommonUtil.convertObject((Object)evalItemResult, EvalItemResult.class);
        StorageInfo storageInfo = EvaluationEngine.getCurHostStorage(evalItemResultInfo);
        List nodeList = DefaultNodeProviderImpl.getInstance().getNodeList();
        return EvaluationEngine.getStorageNode(storageInfo, nodeList);
    }

    public static DevNode getStorageNode(StorageInfo storageInfo, List<DevNode> nodeList) {
        if (storageInfo != null) {
            for (DevNode devNode : nodeList) {
                if (!devNode.getDeviceSerialNumber().equals(storageInfo.getStorageSn())) continue;
                return devNode;
            }
        } else {
            LOGGER.error("getCurHostStorage is filed,storageInfo =null");
        }
        return null;
    }

    private static int getHostNumber(StorageInfo storageInfo) {
        List hostInfos = storageInfo.getHostList();
        int hostNum = 0;
        for (UpgradeHostInfo hostInfo : hostInfos) {
            if (Integer.parseInt(hostInfo.getInitiatorNum()) <= 0) continue;
            ++hostNum;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s, the host number is: %s", storageInfo.getStorageSn(), hostNum));
        return hostNum;
    }

    private static List<String> getHostWWN(Map<String, Object> evalContext) {
        ArrayList<String> wwnList = new ArrayList<String>();
        Object itemInfoObj = evalContext.get(ITEM_INFO);
        ItemInfo itemInfo = (ItemInfo)CommonUtil.convertObject((Object)itemInfoObj, ItemInfo.class);
        return EvaluationEngine.getHostWWNByItemInfo(wwnList, itemInfo);
    }

    private static List<String> getHostWWNByItemInfo(List<String> wwnList, ItemInfo itemInfo) {
        try {
            Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
            String aluaInfo = evalMap.get("aluaLauncher");
            Launcher launcher = JSONObject.parseObject(aluaInfo, Launcher.class);
            if ("unknown".equals(launcher.getOtherDataMap().get("queryWwnSuccess")) || !((Boolean)launcher.getOtherDataMap().get("queryWwnSuccess")).booleanValue()) {
                LOGGER.info(String.format(Locale.ENGLISH, "the host Ip is: %s, the wwnList is empty.", itemInfo.getIp()));
                return new ArrayList<String>();
            }
            wwnList.addAll(launcher.getFcWwns());
            wwnList.addAll(launcher.getIBWwns());
            wwnList.addAll(launcher.getiSCSIWwns());
            wwnList.addAll(launcher.getNVMEWwns());
            LOGGER.info(String.format(Locale.ENGLISH, "the host Ip is: %s, the wwnList is :%s", itemInfo.getIp(), wwnList));
            return wwnList;
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "the host Ip is: %s, the exception is : ", itemInfo.getIp()), e);
            return new ArrayList<String>();
        }
    }

    private static int calculateLUNNumber(StorageInfo storageInfo, Map<String, Object> evalContext) {
        List<String> hostWwnList = EvaluationEngine.getHostWWN(evalContext);
        return EvaluationEngine.calculateLUNNumberByWWN(storageInfo, hostWwnList);
    }

    private static int calculateLUNNumberByWWN(StorageInfo storageInfo, List<String> hostWwnList) {
        List hostInfos = storageInfo.getHostList();
        int lunNum = 0;
        int allLunNum = 0;
        if (hostWwnList.isEmpty() || hostInfos == null) {
            LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s get the host wwn list failed.", storageInfo.getStorageSn()));
            return -1;
        }
        for (UpgradeHostInfo hostInfo : hostInfos) {
            List initList = hostInfo.getInitList();
            for (Map map : initList) {
                if (StringUtils.isNULLStr((String)((String)map.get(ID))) || !((String)map.get(RUNNINGSTATUS)).trim().equals(RUNNINGSTATUS_ONLINE) || !hostWwnList.contains(((String)map.get(ID)).toUpperCase(Locale.ENGLISH).trim())) continue;
                LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s, the host name is :%s, the lun size is :%s", storageInfo.getStorageSn(), hostInfo.getHostName(), hostInfo.getLunNum()));
                lunNum = hostInfo.getLunNum() == null ? 0 : Integer.parseInt(hostInfo.getLunNum());
                break;
            }
            allLunNum += lunNum;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "the storage sn is: %s, the lun size is : 0.", storageInfo.getStorageSn()));
        return allLunNum;
    }

    private static Map<String, Boolean> getInitiatorInfo(StorageInfo storageInfo, Map<String, Object> evalContext) {
        List hostInfos = storageInfo.getHostList();
        List<String> hostWwnList = EvaluationEngine.getHostWWN(evalContext);
        HashMap<String, Boolean> initiatorNumberMap = new HashMap<String, Boolean>();
        initiatorNumberMap.put(ISCSI, false);
        initiatorNumberMap.put(FC, false);
        initiatorNumberMap.put(IB, false);
        for (UpgradeHostInfo hostInfo : hostInfos) {
            List initList = hostInfo.getInitList();
            for (Map map : initList) {
                if (StringUtils.isNULLStr((String)((String)map.get(ID))) || !hostWwnList.contains(((String)map.get(ID)).trim())) continue;
                if (StringUtils.isNULLStr((String)((String)map.get(INITIATOR_TYPE))) || StringUtils.isNULLStr((String)((String)map.get(RUNNINGSTATUS)))) {
                    LOGGER.info(String.format(Locale.ENGLISH, "the host name is: %s, get initiator type or running status failed.", hostInfo.getHostName()));
                    return initiatorNumberMap;
                }
                if (ISCSI_TYPE.equals(((String)map.get(INITIATOR_TYPE)).trim()) && RUNNINGSTATUS_ONLINE.equals(((String)map.get(RUNNINGSTATUS)).trim())) {
                    initiatorNumberMap.put(ISCSI, true);
                    LOGGER.info(String.format(Locale.ENGLISH, "the host name is: %s, the initiator info is : ISCSI.", hostInfo.getHostName()));
                }
                if (FC_TYPE.equals(((String)map.get(INITIATOR_TYPE)).trim()) && RUNNINGSTATUS_ONLINE.equals(((String)map.get(RUNNINGSTATUS)).trim())) {
                    initiatorNumberMap.put(FC, true);
                    LOGGER.info(String.format(Locale.ENGLISH, "the host name is: %s, the initiator info is : FC.", hostInfo.getHostName()));
                }
                if (!IB_TYPE.equals(((String)map.get(INITIATOR_TYPE)).trim()) || !RUNNINGSTATUS_ONLINE.equals(((String)map.get(RUNNINGSTATUS)).trim())) continue;
                initiatorNumberMap.put(IB, true);
                LOGGER.info(String.format(Locale.ENGLISH, "the host name is: %s, the initiator info is : IB.", hostInfo.getHostName()));
            }
        }
        return initiatorNumberMap;
    }

    private static class AnalyzeThreadFactory
    implements ThreadFactory {
        private AnalyzeThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread th = new Thread(runnable);
            th.setDaemon(false);
            th.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error(thread.getName() + " : " + throwable.getMessage());
                }
            });
            return th;
        }
    }
}

