/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.task;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabParamEntity;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabWorktaker;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.enums.TaskStatusEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskParameters;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.model.TaskInfo;
import com.huawei.ism.tool.upgradeevalu.service.ExecStorinfoProgressUpdater;
import com.huawei.ism.tool.upgradeevalu.service.GrabEndHandler;
import com.huawei.ism.tool.upgradeevalu.service.StorInfoProgressUpdater;
import com.huawei.ism.tool.upgradeevalu.task.IHostComAnalyze;
import com.huawei.ism.tool.upgradeevalu.task.TaskAnalyze;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.util.Grab2EvalUtils;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.tool.upgradeevalu.util.ReportGenerateTaskHelper;
import com.huawei.ism.tool.upgradeevalu.util.StorageInfoQryTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class HostComAnalyze
implements IHostComAnalyze {
    private static final HostComAnalyze INSTANCE = new HostComAnalyze();
    private static final Logger LOGGER = Logger.getLogger(HostComAnalyze.class);

    private HostComAnalyze() {
    }

    public static IHostComAnalyze getInstance() {
        return INSTANCE;
    }

    @Override
    public EvalTaskResult analyzeCompatibility(EvalTaskParameters evalTaskParameters) {
        LOGGER.info("***[entry analyzeCompatibility]***");
        EvalTaskResult evalTaskResult = new EvalTaskResult();
        evalTaskResult.setHostEvalTask(evalTaskParameters.getHostEvalTask());
        TaskInfo taskInfo = new TaskInfo(evalTaskParameters.getCollectResultFile());
        evalTaskResult.setTaskInfo(taskInfo);
        TaskAnalyze taskAnalyze = new TaskAnalyze(evalTaskResult, evalTaskParameters);
        ReportGenerateTaskHelper.execute(taskAnalyze);
        return evalTaskResult;
    }

    @Override
    public EvalTaskResult onlineAnalyzeCompatibility(EvalTaskParameters evalTaskParameters) {
        LOGGER.info("***[entry onlineAnalyzeCompatibility]***");
        HostEvalNode evalNode = evalTaskParameters.getHostEvalTask();
        EvalTaskResult evalTaskResult = HostEvalContext.getHostRvalResult().get(evalNode.getIdentifier());
        try {
            List<DevNode> toEvalDevs = evalNode.getStorageMappingHosts();
            if (toEvalDevs == null || toEvalDevs.isEmpty() || evalNode.getStorageIp() == null) {
                LOGGER.info(String.format(Locale.ENGLISH, "to eval device of stoeage %s is none.", evalNode.getStorageIp()));
                return evalTaskResult;
            }
            for (EvalItemResult evalItemResult : evalTaskResult.getEvalItemList()) {
                evalItemResult.setHostEvalTask(evalNode);
                evalTaskParameters.getProgressUpdator().updateEvalDetail(evalItemResult);
            }
            List<GrabDevNode2> toEvalGrabDevs = this.retainToEvalDevice(toEvalDevs);
            TaskInfo taskInfo = new TaskInfo(evalTaskParameters.getCollectResultFile());
            evalTaskResult.setTaskInfo(taskInfo);
            evalTaskResult.setStartEvaTime(new Date());
            evalTaskResult.setHostEvalTask(evalTaskParameters.getHostEvalTask());
            GrabEndHandler handler = new GrabEndHandler(toEvalGrabDevs, evalTaskResult);
            handler.setProgressUpdator(evalTaskParameters.getProgressUpdator());
            DoEvalTask task = new DoEvalTask(handler, evalTaskResult, evalTaskParameters, toEvalGrabDevs);
            AsyncExcutor.submit((Callable)task);
        }
        catch (Exception e) {
            LOGGER.error("execute eval error", e);
            evalTaskResult.setTaskStatus(TaskStatusEnum.EXCEPTION_STOP);
        }
        return evalTaskResult;
    }

    public void submitOffLinePakEvalTask(final List<GrabDevNode2> toEvalGrabDevs, final GrabEndHandler handler, final EvalTaskResult evalTaskResult, final EvalTaskParameters evalTaskParameters) {
        Callable<Boolean> offEvalTask = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                List<GrabDevNode2> offLineDevs = HostComAnalyze.this.findOnlineEvalDev(toEvalGrabDevs, NodeAddEnum.GRAB_PKG);
                if (offLineDevs.isEmpty()) {
                    return false;
                }
                TreeSet<String> zipFiles = new TreeSet<String>();
                HostComAnalyze.this.evalStartPrepare(handler, offLineDevs, zipFiles);
                List<Map<String, Object>> evalData = Grab2EvalUtils.parseDevData4eval(zipFiles);
                HostComAnalyze.this.fillNodesEvalData(handler, evalTaskResult, evalTaskParameters, offLineDevs, evalData);
                for (GrabDevNode2 grabDevNode : offLineDevs) {
                    zipFiles.add(grabDevNode.getDevInfoPkgPath());
                    GrabResultEntity entity = new GrabResultEntity();
                    entity.setEvalNode(grabDevNode);
                    handler.notifyDevGrabEnd(entity);
                }
                return true;
            }
        };
        ThreadPoolManager.getInstance().submit((Callable)offEvalTask);
    }

    public void evalStartPrepare(GrabEndHandler handler, List<GrabDevNode2> offLineDevs, Set<String> zipFiles) {
        for (GrabDevNode2 grabDevNode : offLineDevs) {
            zipFiles.add(grabDevNode.getDevInfoPkgPath());
            GrabResultEntity entity = new GrabResultEntity();
            entity.setCurProgress(30);
            entity.setEvalNode(grabDevNode);
            handler.refreshPregress(entity);
        }
    }

    public void fillNodesEvalData(GrabEndHandler handler, EvalTaskResult evalTaskResult, EvalTaskParameters evalTaskParameters, List<GrabDevNode2> offLineDevs, List<Map<String, Object>> evalData) {
        for (GrabDevNode2 grabDevNode : offLineDevs) {
            ItemInfo it = Grab2EvalUtils.findDevItemInfo(evalData, grabDevNode);
            if (it == null) {
                LOGGER.error("cannot find devxls data:" + grabDevNode.getIp());
                continue;
            }
            EvalItemResult itemResult = HostEvalUtils.findEvalItemResult(grabDevNode, evalTaskResult);
            itemResult.setItemInfo(it);
            itemResult.setHostEvalTask(evalTaskParameters.getHostEvalTask());
            GrabResultEntity entity = new GrabResultEntity();
            entity.setCurProgress(60);
            entity.setEvalNode(grabDevNode);
            handler.refreshPregress(entity);
        }
    }

    public void submitOnlineEvalTask(EvalTaskParameters evalTaskParameters, EvalTaskResult evalTaskResult, List<GrabDevNode2> toEvalGrabDevs, GrabEndHandler handler) {
        List<GrabDevNode2> onlineEvalList = this.findOnlineEvalDev(toEvalGrabDevs, NodeAddEnum.ONLINE, NodeAddEnum.GRAB_FILE, NodeAddEnum.COLLECT_FILE);
        if (onlineEvalList.isEmpty()) {
            return;
        }
        GrabParamEntity grabParamEntity = new GrabParamEntity(onlineEvalList, handler, 1, null);
        evalTaskResult.setHandler(handler);
        this.mapDevStorage(evalTaskParameters, grabParamEntity);
        GrabWorktaker.getInstance().collectDevsInfos(grabParamEntity, null);
        evalTaskResult.setTaskFolderPath(grabParamEntity.getTaskDirPath());
    }

    public List<GrabDevNode2> findOnlineEvalDev(List<GrabDevNode2> toEvalGrabDevs, NodeAddEnum ... addType) {
        ArrayList<GrabDevNode2> onLineDevList = new ArrayList<GrabDevNode2>();
        for (GrabDevNode2 grabDev : toEvalGrabDevs) {
            for (NodeAddEnum type : addType) {
                if (!type.equals((Object)grabDev.getNodeAddType())) continue;
                onLineDevList.add(grabDev);
            }
        }
        return onLineDevList;
    }

    public List<GrabDevNode2> retainToEvalDevice(List<DevNode> toEvalDevs) {
        ArrayList<GrabDevNode2> toEvalGrabDevs = new ArrayList<GrabDevNode2>();
        ArrayList<DevNode> addedDev = new ArrayList<DevNode>();
        for (DevNode grabEvalDev : toEvalDevs) {
            if (addedDev.contains(grabEvalDev)) continue;
            toEvalGrabDevs.add(ToolUtils.toGrabNewNode(EntityUtils.toNewDev((DevNode)grabEvalDev)));
            addedDev.add(grabEvalDev);
        }
        return toEvalGrabDevs;
    }

    public void mapDevStorage(EvalTaskParameters evalTaskParameters, GrabParamEntity grabParamEntity) {
        String storageSn = evalTaskParameters.getHostEvalTask().getStorageSn();
        List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
        if (storageInfos == null) {
            return;
        }
        for (StorageInfo storageInfo : storageInfos) {
            if (storageSn == null || !storageSn.equalsIgnoreCase(storageInfo.getStorageSn())) continue;
            grabParamEntity.setMappedStorage(storageInfo);
            break;
        }
    }

    private final class DoEvalTask
    implements Callable<Boolean> {
        private final GrabEndHandler handler;
        private final EvalTaskResult evalTaskResult;
        private final EvalTaskParameters evalTaskParameters;
        private final List<GrabDevNode2> toEvalGrabDevs;

        private DoEvalTask(GrabEndHandler handler, EvalTaskResult evalTaskResult, EvalTaskParameters evalTaskParameters, List<GrabDevNode2> toEvalGrabDevs) {
            this.handler = handler;
            this.evalTaskResult = evalTaskResult;
            this.evalTaskParameters = evalTaskParameters;
            this.toEvalGrabDevs = toEvalGrabDevs;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                this.updateStorageInfo();
                HostComAnalyze.this.submitOnlineEvalTask(this.evalTaskParameters, this.evalTaskResult, this.toEvalGrabDevs, this.handler);
                HostComAnalyze.this.submitOffLinePakEvalTask(this.toEvalGrabDevs, this.handler, this.evalTaskResult, this.evalTaskParameters);
            }
            catch (Exception e) {
                LOGGER.error("exec eval error", e);
                return false;
            }
            return true;
        }

        private void updateStorageInfo() {
            Boolean evaled = HostEvalContext.getHostEvaledMap().get(this.evalTaskResult.getHostEvalTask().getStorageSn());
            DevNode devNode = DefaultNodeProviderImpl.getInstance().findDevNode(this.evalTaskResult.getHostEvalTask().getStorageSn());
            ExecStorinfoProgressUpdater callback = null;
            if (null == devNode) {
                LOGGER.error("DefaultNodeProviderImpl.getInstance() is filed,devNode = null");
                return;
            }
            callback = new ExecStorinfoProgressUpdater(devNode, this.evalTaskResult);
            if (evaled == null || !evaled.booleanValue()) {
                List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
                for (StorageInfo si : storageInfos) {
                    if (!si.getStorageSn().equals(devNode.getDeviceSerialNumber()) || si.getErrorCode() != 0) continue;
                    ConnUtils.sleep((int)2000);
                    callback.finsh(si);
                    return;
                }
            }
            this.evalTaskResult.setTaskStatus(TaskStatusEnum.EVALUATING);
            this.evalTaskParameters.getProgressUpdator().updateProgress(this.evalTaskResult);
            StorageInfoQryTask task = new StorageInfoQryTask(devNode, callback);
            try {
                StorageInfo si = (StorageInfo)AsyncExcutor.submit((Callable)task).get();
                List hostNodeList = DefaultNodeProviderImpl.getInstance().getHostNodeList();
                List<DevNode> offLineNodeList = HostEvalContext.getInstance().getOffHostDevs();
                hostNodeList.addAll(offLineNodeList);
                HashSet nodeList = new HashSet(hostNodeList);
                hostNodeList.clear();
                hostNodeList.addAll(nodeList);
                HostEvaluMainDialog.getInstance().checkStorageHostsAssociation(si, hostNodeList);
                List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
                storageInfos.remove(si);
                storageInfos.add(si);
                new StorInfoProgressUpdater(devNode).finsh(si);
                HostEvalContext.getStorageMap().put("storageInfo", storageInfos);
                LOGGER.info(String.format(Locale.ENGLISH, "exec result:%s", storageInfos));
            }
            catch (Exception e) {
                LOGGER.error("execute rrror", e);
            }
            this.stopIfMannualEnded();
        }

        public void stopIfMannualEnded() {
            if (HostEvalContext.isTaskForceStopped()) {
                for (EvalItemResult result : this.evalTaskResult.getEvalItemList()) {
                    result.setItemResultEnum(ItemResultEnum.EVALUATION_STOP);
                    result.setFailedReason(ResourceUtil.getString((String)"eval.host.grab.task.stoped.tip"));
                }
                HostEvaluMainDialog.getInstance().updateStorageDetail(this.evalTaskResult);
                this.evalTaskResult.setTaskStatus(TaskStatusEnum.EVALUATION_STOP);
                HostEvaluMainDialog.getInstance().updateProgress(this.evalTaskResult);
                HostEvaluMainDialog.getInstance().setEnabled(true);
                throw new NullPointerException("eval.host.grab.task.stoped.tip");
            }
        }
    }
}

