/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.task;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.upgradeevalu.adapter.EvalRuleManager;
import com.huawei.ism.tool.upgradeevalu.adapter.EvaluationFlow;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IAnalyzeMethod;
import com.huawei.ism.tool.upgradeevalu.entity.DeviceDetails;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalUserOpData;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.enums.TaskStatusEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskParameters;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.service.CompatibilityExcelInfo;
import com.huawei.ism.tool.upgradeevalu.service.ICompatibilityExcelInfo;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.tool.upgradeevalu.util.ReportGenerateTaskHelper;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import com.huawei.ism.tool.upgradeevalu.utils.ExcelCreater;
import com.huawei.json.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import utils.FilesUtil;

public class TaskAnalyze
implements Runnable {
    private static final String TASK_FORCE_STOPPED = "eval.host.task.force.stopped";
    private static final Logger LOGGER = Logger.getLogger(TaskAnalyze.class);
    private static final String UPLOAD_TMP_PATH = SystemEnvUtil.getDefaultUserDir() + File.separator + "upload" + File.separator + "toolResult" + File.separator + "Upgrade";
    private HostEvalContext evaluContext = HostEvalContext.getInstance();
    private String threadName = "";
    private Integer processNumber = 0;
    private EvalRuleManager ruleManager;
    private JythonExecuter jythonExecuter = new JythonExecuter();
    private String threadPool = "Start Task Analysis--";
    private EvalTaskResult taskResult;
    private IAnalyzeMethod analyzeMethod;
    private ICompatibilityExcelInfo compatExcelHandler;
    private EvalTaskParameters evalTaskParameters;
    private float singleDeviceProgress;

    public TaskAnalyze() {
    }

    public TaskAnalyze(EvalTaskResult taskResult, EvalTaskParameters evalTaskParameters) {
        this.setTaskResult(taskResult);
        this.ruleManager = new EvalRuleManager();
        this.setThreadName(this.createThreadName());
        this.analyzeMethod = this.getIAnalyzeMethod();
        this.evalTaskParameters = evalTaskParameters;
    }

    public IAnalyzeMethod getIAnalyzeMethod() {
        return this.ruleManager;
    }

    @Override
    public void run() {
        LOGGER.info(String.format(Locale.ENGLISH, "Current thread: %s", this.threadName));
        try {
            this.initTaskResult();
            this.createAnalyzeFlow();
        }
        catch (ToolException e) {
            this.handleToolException(e);
        }
        catch (Exception e) {
            this.setTooException(e);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "Finish One TaskAnalyze: %s---%s", this.taskResult.getTaskInfo().getTaskId(), this.taskResult.getTaskInfo().getTaskName()));
    }

    private void setTooException(Exception e) {
        LOGGER.error("evalate error.", e);
        this.taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_STOP);
        this.taskResult.setEvalTaskErrInfo(ResourceUtil.getString((String)"eval.host.task.except.stopped"));
        this.evalTaskParameters.getProgressUpdator().updateProgress(this.taskResult);
    }

    private void handleToolException(ToolException e) {
        if (TASK_FORCE_STOPPED.equals(e.getErrorId())) {
            LOGGER.info("Eval has been stopped.");
            this.taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_STOP);
            this.taskResult.setEvalTaskErrInfo(ResourceUtil.getString((String)TASK_FORCE_STOPPED));
        } else {
            this.taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_STOP);
            this.taskResult.setEvalTaskErrInfo(e.getErrorLocaleDescription());
        }
        this.evalTaskParameters.getProgressUpdator().updateProgress(this.taskResult);
    }

    private void initTaskResult() throws ToolException {
        this.handleTaskElementsByUrl(this.taskResult);
    }

    private void handleTaskElementsByUrl(EvalTaskResult result) throws ToolException {
        try {
            result.setTaskStatus(TaskStatusEnum.EVALUATING);
            this.evalTaskParameters.getProgressUpdator().updateProgress(result);
            String url = result.getTaskInfo().getTaskUrl();
            this.compatExcelHandler = CompatibilityExcelInfo.getInstance();
            Map<String, Object> excelDevMap = this.compatExcelHandler.getAllExcelContent(url);
            Object devMap = excelDevMap.get("deviceMap");
            Object taskVersion = excelDevMap.get("version");
            if (devMap instanceof Map) {
                Map devResultMap = (Map)devMap;
                this.compatExcelHandler.executePretreatmentResult(devResultMap);
                result.setProgressCurrent(result.getTaskProgressBar() + 10);
                this.evalTaskParameters.getProgressUpdator().updateProgress(this.taskResult);
                this.fillDevsResult(devResultMap, result);
                for (EvalItemResult itemResult : result.getEvalItemList()) {
                    itemResult.setHostEvalTask(result.getHostEvalTask());
                }
            }
            if (taskVersion instanceof String) {
                String version = (String)taskVersion;
                result.getTaskInfo().setTaskVersion(version);
            }
        }
        catch (ToolException e) {
            throw new ToolException(e.getErrorId(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Task Analyze By Url Error!", e);
            throw new ToolException("compatibility.compat.exception.result", (Throwable)e);
        }
    }

    private void fillDevsResult(Map<String, List<ItemInfo>> devResultMap, EvalTaskResult evalTaskResult) {
        for (Map.Entry<String, List<ItemInfo>> entry : devResultMap.entrySet()) {
            for (ItemInfo itemInfo : entry.getValue()) {
                EvalItemResult itemResult = new EvalItemResult();
                itemResult.setItemInfo(itemInfo);
                evalTaskResult.getEvalItemList().add(itemResult);
            }
        }
        this.singleDeviceProgress = 80.0f / (float)evalTaskResult.getEvalItemList().size();
    }

    private String createThreadName() {
        Integer taskId = this.taskResult.getTaskInfo().getTaskId();
        String taskName = this.taskResult.getTaskInfo().getTaskName();
        StringBuilder threadHead = new StringBuilder(this.threadPool);
        threadHead.append(taskId);
        threadHead.append("---");
        threadHead.append(taskName);
        return threadHead.toString();
    }

    private void createAnalyzeFlow() throws ToolException {
        try {
            this.taskResult.setEvaluTime(new Date());
            this.execAllItem();
            LOGGER.info(String.format(Locale.ENGLISH, "finish OneTaskItem: %s", this.taskResult.getTaskInfo().getTaskUId()));
            this.taskResult.setProgressCurrent(90.0f);
            this.taskResult.setReportTask(new GenerateReportTask(this.taskResult, this.evalResultReportUrl(this.taskResult)));
            this.evalTaskParameters.getProgressUpdator().updateEvalDetail(this.taskResult.getEvalItemList().get(this.taskResult.getEvalItemList().size() - 1));
            this.taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_FINISHED);
            HostEvalUtils.handleTaskStatus(this.taskResult);
            this.taskResult.setProgressCurrent(100.0f);
            if (!this.taskResult.isCheckFile()) {
                this.taskResult.setProgressCurrent(95.0f);
            }
            this.taskResult.setFinishTime(new Date());
            this.evalTaskParameters.getProgressUpdator().updateProgress(this.taskResult);
            this.generateReport(this.taskResult.getReportTask());
            this.saveUserOpdata(this.taskResult);
        }
        catch (ToolException e) {
            LOGGER.error("Toolexception Error!", e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("CreateAnalyzeFlow Error!", e);
            throw new ToolException("compatibility.compat.exception.result", (Throwable)e);
        }
    }

    public void generateReport(GenerateReportTask task) {
        LOGGER.info("***[start execute generateReport]***");
        if (null != task) {
            ReportGenerateTaskHelper.submit(task);
        }
    }

    public void autoPostBack(EvalTaskResult result) {
        LOGGER.info("Begin to copy Evaluation data.");
        String filePath = result.getHostEvalTask().getFileName();
        File copyFile = new File(filePath);
        File copyToDir = new File(UPLOAD_TMP_PATH);
        if (CommonUtils.copyRight(copyFile, copyToDir)) {
            CommonUtils.copyFile(copyFile, copyToDir, copyFile.getName());
            LOGGER.info("End to copy Evaluation data.");
        }
    }

    private void execAllItem() throws ToolException {
        this.taskResult.setStartEvaTime(new Date());
        List<EvalItemResult> currItemList = this.taskResult.getEvalItemList();
        for (EvalItemResult evalItemResult : currItemList) {
            try {
                this.checkIsTaskForceStopped(null);
                evalItemResult.setItemResultEnum(ItemResultEnum.EVALUATING);
                Date createDate = new Date();
                evalItemResult.setCreateTime(createDate);
                this.evalTaskParameters.getProgressUpdator().updateEvalDetail(evalItemResult);
                this.execOneItem(evalItemResult);
                HostEvalUtils.handleTaskStatus(this.taskResult);
                this.taskResult.setProgressCurrent(this.taskResult.getProgressCurrent() + this.singleDeviceProgress);
                this.evalTaskParameters.getProgressUpdator().updateProgress(this.taskResult);
            }
            catch (ToolException e) {
                evalItemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
                evalItemResult.setMessageType(EvalItemResult.EvalMessageType.EXCEPTION_MESSAGE);
                evalItemResult.setFailedReason(e.getErrorLocaleDescription());
                throw new ToolException(e.getErrorId(), (Throwable)e);
            }
            finally {
                this.evalTaskParameters.getProgressUpdator().updateEvalDetail(evalItemResult);
            }
        }
        LOGGER.info(String.format(Locale.ENGLISH, "finish AllDevItem: %s", this.taskResult.getEvalItemList().size()));
    }

    private synchronized void saveUserOpdata(EvalTaskResult evalTaskResult) {
        TaskStatusEnum enume;
        HostEvalUserOpData userop = new HostEvalUserOpData();
        List<EvalItemResult> evalItemList = evalTaskResult.getEvalItemList();
        userop.setIsScene(SceneUtils.isScene() ? 1 : 0);
        if (null != evalTaskResult.getStartEvaTime()) {
            userop.setTaskStartTime(evalTaskResult.getStartEvaTime());
        }
        if (null != evalTaskResult.getFinishTime()) {
            userop.setTaskEndTime(evalTaskResult.getFinishTime());
        }
        if (null != (enume = evalTaskResult.getTaskStatus())) {
            userop.setTaskStatus(enume);
        }
        List<DeviceDetails> deviceDetails = this.buildDeviceDate(evalItemList, userop);
        userop.setDeviceDetails(JSON.toJSONString(deviceDetails));
        LinkedList<HostEvalUserOpData> useropList = new LinkedList<HostEvalUserOpData>();
        useropList.add(userop);
        this.evaluContext.getUserOpDataMap().put(this.taskResult.getHostEvalTask().getIdentifier(), useropList);
    }

    private List<DeviceDetails> buildDeviceDate(List<EvalItemResult> evalItemList, HostEvalUserOpData userop) {
        ArrayList<DeviceDetails> deviceDetails = new ArrayList<DeviceDetails>();
        int totaldeviceNum = 0;
        for (EvalItemResult evalItemResult : evalItemList) {
            String infoGrabMetaMsg;
            ItemInfo itemInfo = evalItemResult.getItemInfo();
            DeviceDetails deviceDetail = new DeviceDetails();
            deviceDetail.setDeviceType(itemInfo.getDevInfo());
            deviceDetail.setDeviceVersion(itemInfo.getOsName());
            deviceDetail.setHbaVersion(itemInfo.getHbaTimeOut());
            deviceDetail.setMultipathVersion(itemInfo.getMultiSoftEdition());
            deviceDetail.setNetWork(itemInfo.getFcNetInfo());
            deviceDetail.setSupperUser(itemInfo.getSuperUser());
            deviceDetail.setEvaluationResults(evalItemResult.getItemResultEnum());
            if (org.apache.commons.lang3.StringUtils.isBlank(userop.getStorageType()) && org.apache.commons.lang3.StringUtils.isNotBlank(infoGrabMetaMsg = itemInfo.getInfoGrabMetaMsg("StorageModel"))) {
                JSONObject jsonObject = new JSONObject(infoGrabMetaMsg);
                userop.setStorageType(jsonObject.getString("deviceType"));
                userop.setStorageVersion(jsonObject.getString("productVersion"));
            }
            List<EvalFeatureResult> featureResultList = evalItemResult.getFeatureResultList();
            for (EvalFeatureResult evalFeatureResult : featureResultList) {
                ItemResultEnum itemResult = evalFeatureResult.getItemResult();
                switch (itemResult) {
                    case CANNOTEVAL: {
                        deviceDetail.getCanNoteValItem().add(evalFeatureResult.getFeatureId());
                        break;
                    }
                    case NOTPASS: {
                        deviceDetail.getNotPassItem().add(evalFeatureResult.getFeatureId());
                        break;
                    }
                }
            }
            deviceDetails.add(deviceDetail);
            ++totaldeviceNum;
        }
        userop.setDeviceTotalNums(totaldeviceNum);
        return deviceDetails;
    }

    private void execOneItem(EvalItemResult evalItemResult) throws ToolException {
        Map<ItDeviceType, EvaluationFlow> currEvaluationFlowMap = this.ruleManager.getEvaluationTypeFlow();
        List<RuleItem> ruleList = this.ruleManager.findCurrentItemFlow(currEvaluationFlowMap, evalItemResult.getItemInfo());
        if (null == ruleList) {
            evalItemResult.setItemResultEnum(ItemResultEnum.CANNOTEVAL);
            evalItemResult.setFailedReason(ResourceUtil.getString((String)"compatibility.compat.exception.no.rule.list"));
            return;
        }
        this.execAllRuleItem(ruleList, evalItemResult);
    }

    private void execAllRuleItem(List<RuleItem> ruleList, EvalItemResult evalItemResult) throws ToolException {
        for (RuleItem ruleItem : ruleList) {
            this.checkIsTaskForceStopped(evalItemResult);
            this.analyzeMethod.handleRules(ruleItem, evalItemResult, this.jythonExecuter);
            LOGGER.info(String.format(Locale.ENGLISH, "finish oneRuleItem: %s", ruleItem.getItemTitle()));
            this.dealwith4Report(evalItemResult);
        }
    }

    private void dealwith4Report(EvalItemResult evalItemResult) {
        List<EvalFeatureResult> allFeatureResult = evalItemResult.getFeatureResultList();
        EvalFeatureResult featureResult = allFeatureResult.get(allFeatureResult.size() - 1);
        featureResult.setOsName(evalItemResult.getItemInfo().getOsName());
        featureResult.setDevType(evalItemResult.getItemInfo().getDevInfo());
        String failDesc = featureResult.getFailDesc();
        String suggestFlag = CompatibilityResourceUtils.getUIString("feature.eval.detail.dialog.suggest.flag");
        String activeFlag = CompatibilityResourceUtils.getUIString("feature.eval.detail.dialog.actions.flag");
        if (failDesc.contains(suggestFlag) || failDesc.contains(activeFlag)) {
            int suggestIndex = -1 == failDesc.indexOf(suggestFlag) ? failDesc.indexOf(activeFlag) : failDesc.indexOf(suggestFlag);
            int suggestLength = -1 == failDesc.indexOf(suggestFlag) ? activeFlag.length() : suggestFlag.length();
            String suggest = failDesc.substring(suggestIndex + suggestLength + 1);
            failDesc = failDesc.substring(0, suggestIndex);
            if (!StringUtils.isNULLStr((String)suggest)) {
                featureResult.setSuggest(suggest);
            }
        }
        featureResult.setFailDesc(failDesc);
    }

    private void checkIsTaskForceStopped(EvalItemResult evalItemResult) throws ToolException {
        if (HostEvalContext.isTaskForceStopped()) {
            if (null != evalItemResult) {
                evalItemResult.setItemResultEnum(ItemResultEnum.NOTEVAL);
                this.evalTaskParameters.getProgressUpdator().updateEvalDetail(evalItemResult);
            }
            throw new ToolException(TASK_FORCE_STOPPED);
        }
    }

    private String evalResultReportUrl(EvalTaskResult evalTaskResult) {
        File sourceFile = new File(evalTaskResult.getTaskInfo().getTaskUrl());
        String resultExcelDefault = sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf("."));
        Object reportPath = HibernateContainer.getInstance().get((Object)"offLineReportDir");
        File reportDirFile = HostEvalContext.getInstance().getReportDir();
        String reportDirPath = "";
        if (null != reportDirFile) {
            reportDirPath = FilesUtil.getCanonicalPath((File)reportDirFile);
        }
        String reportFile = reportPath != null ? reportPath.toString() : reportDirPath;
        reportFile = reportFile + File.separator + "temp";
        StringBuffer fileName = new StringBuffer();
        fileName.append(resultExcelDefault);
        fileName.append("_EvalResult");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        fileName.append(simpleDateFormat.format(new Date()));
        fileName.append(".xls");
        evalTaskResult.setEvalResultUrl(reportFile + File.separator + fileName.toString());
        evalTaskResult.setOriginalExcelUrl(fileName.toString());
        return reportFile + File.separator + fileName.toString();
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setProcessNumber(Integer processNumber) {
        this.processNumber = processNumber;
    }

    public Integer getProcessNumber() {
        return this.processNumber;
    }

    public EvalTaskResult getTaskResult() {
        return this.taskResult;
    }

    public void setTaskResult(EvalTaskResult taskResult) {
        this.taskResult = taskResult;
    }

    public EvalTaskParameters getEvalTaskParameters() {
        return this.evalTaskParameters;
    }

    public void setEvalTaskParameters(EvalTaskParameters evalTaskParameters) {
        this.evalTaskParameters = evalTaskParameters;
    }

    public static final class GenerateReportTask
    implements Callable<EvalTaskResult> {
        private EvalTaskResult taskResult;
        private String evalResultReportUrl;

        public GenerateReportTask(EvalTaskResult taskResult, String evalResultReportUrl) {
            this.taskResult = taskResult;
            this.evalResultReportUrl = evalResultReportUrl;
        }

        public EvalTaskResult getTaskResult() {
            return this.taskResult;
        }

        public void setTaskResult(EvalTaskResult taskResult) {
            this.taskResult = taskResult;
        }

        @Override
        public EvalTaskResult call() {
            try {
                ExcelCreater.getInstance().exportCampabilityReport(this.taskResult, this.evalResultReportUrl);
            }
            catch (Exception e) {
                LOGGER.error("generate report error.", e);
            }
            return this.taskResult;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.taskResult == null || this.taskResult.getHostEvalTask() == null ? 0 : this.taskResult.getHostEvalTask().getIdentifier().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenerateReportTask other = (GenerateReportTask)obj;
            return !(this.taskResult == null ? other.taskResult != null : !this.taskResult.equals(other.taskResult));
        }
    }
}

