/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.google.common.base.Objects;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.obase.ui.upgrade.UpgradeModePanel;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.ui.DevModifyOperationLayout;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallable;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallableOver;
import com.huawei.ism.tool.upgradeevalu.ui.card.EvaluStrategyCard;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class DevModifyOperationDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(DevModifyOperationDialog.class);
    private static final int WIDTH = 620;
    private static final int HEIGHT_ZH = 680;
    private static final int HEIGHT_EN = 750;
    private static final String A8000 = "OceanProtect A8000";
    private int DYNAMIC_HEIGHT_ZH = 50;
    private int DYNAMIC_HEIGHT_EN = 65;
    private Pattern containerPattern = Pattern.compile("^\\d+\\.\\d+\\.\\d*[RC|T]*\\d+(\\.(SPC)?\\d+)?$");
    private EvaluDevNode dev;
    private IUiObserver uiObserver;
    private DevModifyOperationLayout layout = null;
    private List<String> keyWordList = new ArrayList<String>();

    public DevModifyOperationDialog(JDialog parent, EvaluDevNode dev, IUiObserver uiObserver) {
        super((Dialog)parent, true);
        this.keyWordList.add("V200R002");
        this.dev = dev;
        this.uiObserver = uiObserver;
        this.layout = new DevModifyOperationLayout(dev);
        this.initUi();
        this.initData();
        this.addListener();
    }

    private void initUi() {
        this.setLayoutComboxExplainLabel();
        UpgradeModePanel upgradeModelPanel = this.getUpgradeModePanel();
        if (this.dev.isStorageImageUpgrade()) {
            this.layout.setContainerModePanel(this.getContainerUpgradeModePanel());
        }
        this.layout.initUi(upgradeModelPanel);
        this.layout.setCompName();
        this.pack();
        this.setResizable(false);
        this.setTitle(ResourceUtil.getString((String)"eualu.ui.modifyDev.title"));
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setDialogHeight();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
    }

    @NotNull
    private UpgradeModePanel getUpgradeModePanel() {
        UpgradeModePanel upgradeModelPanel = new UpgradeModePanel(EvaluCommUtil.getUpgradeScene(this.dev));
        upgradeModelPanel.setParent((JDialog)this);
        boolean showParallel = Products.Feature.isSupportParallUpgrade((String)this.dev.getDeviceType().toString(), (String)this.dev.getProductVersion());
        upgradeModelPanel.setShowParallel(showParallel);
        upgradeModelPanel.setShowStopHosBusiness(true);
        upgradeModelPanel.setShowApollo(this.dev.isSupportApollo());
        upgradeModelPanel.setCurrentVersion(this.dev.getProductVersion());
        return upgradeModelPanel;
    }

    private UpgradeModePanel getContainerUpgradeModePanel() {
        UpgradeModePanel upgradeModePanel = new UpgradeModePanel(EvaluCommUtil.getContainerScene(this.dev));
        upgradeModePanel.setParent((JDialog)this);
        upgradeModePanel.setShowParallel(false);
        upgradeModePanel.setShowStopHosBusiness(false);
        upgradeModePanel.setMaxWidth(550);
        upgradeModePanel.setCurrentVersion(this.dev.getContainerVersion());
        return upgradeModePanel;
    }

    private void setDialogHeight() {
        int dialogHeight = 680;
        String currLoc = LanguageManager.getInstance().getCurrentLanguage().getLanguage();
        if (currLoc.contains("en")) {
            dialogHeight = 750;
        }
        this.setSize(620, dialogHeight);
    }

    private void setLayoutComboxExplainLabel() {
        String devId = this.dev.getId();
        String devType = devId.split("_")[0].trim();
        log.info("devType={}", (Object)devType);
        if (A800Utils.isA800(devType)) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.a800explain"));
            return;
        }
        if (Products.isOceanProtectDev((String)devType)) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"secondaryupgrade.evalu.ui.card.addStrategy.combox.explain"));
            return;
        }
        if (Products.DORADO_V6_DEV.contains(devType)) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.explainNew"));
        } else {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.explainOld"));
        }
    }

    private void initData() {
        this.layout.getUpgradeModePanel().setSelectedModeUI(this.dev.getUpgradeModeUI().toMode());
        this.layout.getUpgradeModePanel().getStopHostBusinessCbx().setSelected(this.dev.isStopHostBusiness());
        if (this.dev.isStorageImageUpgrade()) {
            this.layout.getContainerModePanel().setSelectedModeUI(this.dev.getContainerUpgradeModeUI().toMode());
        }
        if (EvaluCommUtil.isStorageOrA800(this.dev.getItDeviceType())) {
            IsmTextField input = this.layout.getTargetVersionInput();
            String destVersion = this.dev.getDestVersion();
            if (this.dev.getDestVersion().contains(" Kunpeng")) {
                destVersion = this.dev.getDestVersion().split(" ")[0];
            }
            input.setText(destVersion);
            this.layout.hideTargetVersion(false);
        } else {
            this.layout.hideTargetVersion(true);
        }
        if (this.dev.isStorageImageUpgrade()) {
            this.layout.getContainerTargetVerInput().setText(this.dev.getContainerDestVersion());
        }
    }

    private void addListener() {
        String curDeviceVersion;
        JButton confirmBtn = this.layout.getConfirmBtn();
        confirmBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DevModifyOperationDialog.this.modifyOperation()) {
                    ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click confirm button");
                    DevModifyOperationDialog.this.closeJDialog();
                }
            }
        });
        JButton cancelBtn = this.layout.getCancelBtn();
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click cancel button");
                DevModifyOperationDialog.this.closeJDialog();
            }
        });
        for (String item : this.keyWordList) {
            if (!this.dev.getProductVersion().contains(item)) continue;
            this.layout.getUpgradeModePanel().setNeedOfflineWarning(true);
            return;
        }
        IsmTextField targetVerInput = this.layout.getTargetVersionInput();
        KeyListener[] keyListeners = targetVerInput.getKeyListeners();
        if (keyListeners != null) {
            for (KeyListener keyListener : keyListeners) {
                targetVerInput.removeKeyListener(keyListener);
            }
        }
        if ((curDeviceVersion = this.dev.getProductVersion()).compareTo("V3") >= 0) {
            this.targetVerInputListener();
        }
        if (this.dev.isStorageImageUpgrade()) {
            this.addContainerTargetVerInputKeyListener();
        }
    }

    private boolean isModifyStrategy() {
        UpgradeMode upgradeMode = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedModeUI().name());
        return !this.dev.getUpgradeModeUI().equals((Object)upgradeMode) || EvaluCommUtil.isStorageOrA800(this.dev.getItDeviceType()) && !this.dev.getDestVersion().equals(this.layout.getTargetVersionInput().getText().trim()) || this.dev.isStopHostBusiness() != this.layout.getUpgradeModePanel().getStopHostBusinessCbx().isSelected();
    }

    private boolean isModifyContainerStrategy() {
        if (!this.dev.isStorageImageUpgrade()) {
            return true;
        }
        UpgradeMode containerMode = UpgradeMode.valueOf(this.layout.getContainerModePanel().getSelectedModeUI().name());
        return !Objects.equal((Object)this.dev.getContainerUpgradeModeUI(), (Object)containerMode) || !Objects.equal(this.dev.getContainerDestVersion(), this.layout.getContainerTargetVerInput().getText().trim());
    }

    private boolean modifyOperation() {
        String errKey;
        if (!this.isModifyStrategy() && !this.isModifyContainerStrategy()) {
            return true;
        }
        if (this.layout.getUpgradeModePanel().getSelectedMode() == UpgradeModePanel.UpgradeMode.APOLLO && !StringUtils.isNULLStr((String)this.layout.getTargetVersionInput().getText()) && !this.dev.getProductVersion().equals(this.layout.getTargetVersionInput().getText())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.warn"));
        }
        if (this.cheakDeviceType()) {
            return false;
        }
        if (this.dev.isStorageImageUpgrade() && !StringUtils.isNULLStr((String)(errKey = this.validContainerDestVersion()))) {
            DialogUtils.showInfoDialog((JDialog)this, (String)errKey);
            return false;
        }
        if (this.setDeviceUpgradeMode()) {
            return false;
        }
        this.dev.reset();
        this.uiObserver.updateDevTableRow(this.dev);
        this.uiObserver.refreshDetailList(false);
        try {
            ToolLoggerFactory.getLogger(DevModifyOperationDialog.class).info("Device: " + this.dev.getIp() + " modified success. upgrade mode: " + (Object)((Object)this.dev.getUpgradeMode()) + ", dest version: " + this.dev.getDestVersion());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(DevModifyOperationDialog.class).error("Log records failed.", e);
        }
        return true;
    }

    private boolean setDeviceUpgradeMode() {
        UpgradeMode tmpUpgradeModeUI = this.dev.getUpgradeModeUI();
        UpgradeMode tmpUpgradeMode = this.dev.getUpgradeMode();
        String tmpDestVersion = this.dev.getDestVersion();
        UpgradeMode upgradeMode = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedMode().name());
        UpgradeMode upgradeModeUI = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedModeUI().name());
        this.dev.setUpgradeMode(upgradeMode);
        this.dev.setUpgradeModeUI(upgradeModeUI);
        this.dev.setStopHostBusiness(this.layout.getUpgradeModePanel().getStopHostBusinessCbx().isSelected());
        if (this.dev.isStorageImageUpgrade()) {
            UpgradeMode containerMode = UpgradeMode.valueOf(this.layout.getContainerModePanel().getSelectedMode().name());
            UpgradeMode containerModeUI = UpgradeMode.valueOf(this.layout.getContainerModePanel().getSelectedModeUI().name());
            this.dev.setContainerUpgradeMode(containerMode);
            this.dev.setContainerUpgradeModeUI(containerModeUI);
            this.dev.setContainerDestVersion(this.layout.getContainerTargetVerInput().getText().trim());
        }
        this.modifyDestVersion();
        if (!this.loadStrategy()) {
            this.dev.setUpgradeModeUI(tmpUpgradeModeUI);
            this.dev.setUpgradeMode(tmpUpgradeMode);
            this.dev.setDestVersion(tmpDestVersion);
            IsmTextField input = this.layout.getTargetVersionInput();
            input.setText("");
            this.initData();
            return true;
        }
        return false;
    }

    private boolean cheakDeviceType() {
        ToolLoggerFactory.getLogger(DevModifyOperationDialog.class).info("device type=" + this.dev.getItDeviceType());
        if (EvaluCommUtil.isStorageOrA800(this.dev.getItDeviceType())) {
            String errKey = this.validDestVersion();
            if (!StringUtils.isNULLStr((String)errKey)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)errKey);
                return true;
            }
            boolean isFastAndRollType = this.dev.isFastAndRollType();
            if (isFastAndRollType && !StringUtils.isNULLStr((String)(errKey = this.invalidUpgradeMode(this.dev)))) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)errKey));
                ToolLoggerFactory.getLogger(this.getClass()).info("Evaluation strategy set failed. invalidUpgradeMode");
                return true;
            }
            if (this.dev.isStorageImageUpgrade() && !StringUtils.isNULLStr((String)(errKey = this.invalidContainerMode(this.dev)))) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)errKey));
                log.info("Evaluation strategy set failed. invalidUpgradeMode");
                return true;
            }
        }
        return false;
    }

    private void modifyDestVersion() {
        if (this.layout.getUpgradeModePanel().getSelectedMode() == UpgradeModePanel.UpgradeMode.APOLLO) {
            this.dev.setDestVersion(this.dev.getProductVersion());
        } else if (EvaluCommUtil.isStorageOrA800(this.dev.getItDeviceType())) {
            String destVersion = this.layout.getTargetVersionInput().getText().trim();
            if (this.dev.getProductVersion().contains("Kunpeng") && !destVersion.contains("Kunpeng")) {
                destVersion = destVersion + " Kunpeng";
            }
            this.dev.setDestVersion(destVersion);
        }
    }

    private String validContainerDestVersion() {
        String destVersion = this.layout.getContainerTargetVerInput().getText().trim();
        Matcher matcher = this.containerPattern.matcher(destVersion);
        if (!matcher.find()) {
            return ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.valid");
        }
        UpgradeModePanel.UpgradeMode upgradeMode = this.layout.getContainerModePanel().getSelectedMode();
        if (this.isPatchContainerModel(upgradeMode) && !DevModifyOperationDialog.isPatchPackage(destVersion) || !this.isPatchContainerModel(upgradeMode) && DevModifyOperationDialog.isPatchPackage(destVersion)) {
            return ResourceUtil.getString((String)"secondaryupgrade.upgrade.utils.pkg.not.patch.model");
        }
        String srcVersion = this.dev.getContainerVersion();
        if (this.isPatchContainerModel(upgradeMode)) {
            return this.checkVersionByPatchContainer(destVersion, srcVersion);
        }
        if (Products.compareVersion((String)srcVersion, (String)destVersion) > 0) {
            ToolLoggerFactory.getLogger(EvaluStrategyCard.class).debug("the destversion smaller than srcversion.");
            return ResourceUtil.getString((String)"original.less.to.target");
        }
        if (srcVersion.compareToIgnoreCase(destVersion) == 0) {
            ToolLoggerFactory.getLogger(EvaluStrategyCard.class).debug("the destversion equals srcversion.");
            return ResourceUtil.getString((String)"original.equal.to.target");
        }
        return "";
    }

    private String validDestVersion() {
        if (this.layout.getUpgradeModePanel().getSelectedMode() == UpgradeModePanel.UpgradeMode.APOLLO) {
            return "";
        }
        String destVersion = this.layout.getTargetVersionInput().getText().trim();
        ProductCfg matchedProd = this.dev.getProduct(CrossVersionType.INNERVERSION);
        String destRegex = matchedProd.getDestVerRegex();
        Pattern pattern = Pattern.compile(destRegex);
        Matcher matcher = pattern.matcher(destVersion);
        if (!StringUtils.isNULLStr((String)destRegex) && !matcher.find()) {
            return ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.valid");
        }
        String srcVersion = "";
        srcVersion = this.dev.isSecondaryUpgrade() ? this.dev.getContainerVersion() : this.dev.getProductVersion();
        if (!this.dev.isStorageImageUpgrade() && this.dev.isSecondaryUpgrade()) {
            UpgradeModePanel.UpgradeMode upgradeMode = this.layout.getUpgradeModePanel().getSelectedMode();
            if (this.isPatchContainerModel(upgradeMode) && !DevModifyOperationDialog.isPatchPackage(destVersion) || !this.isPatchContainerModel(upgradeMode) && DevModifyOperationDialog.isPatchPackage(destVersion)) {
                return ResourceUtil.getString((String)"secondaryupgrade.upgrade.utils.pkg.not.patch.model");
            }
            if (this.isPatchContainerModel(upgradeMode)) {
                return this.checkVersionByPatchContainer(destVersion, srcVersion);
            }
        }
        if (this.isNotThrUpgradePathOf6199(destVersion, srcVersion)) {
            return "";
        }
        if (Products.compareVersion((String)srcVersion, (String)destVersion) > 0) {
            ToolLoggerFactory.getLogger(DevModifyOperationDialog.class).info("the destversion smaller than srcversion.");
            return ResourceUtil.getString((String)"original.less.to.target");
        }
        if (srcVersion.compareToIgnoreCase(destVersion) == 0) {
            ToolLoggerFactory.getLogger(DevModifyOperationDialog.class).info("the destversion equal srcversion.");
            return ResourceUtil.getString((String)"original.equal.to.target");
        }
        return "";
    }

    private boolean isNotThrUpgradePathOf6199(String destVersion, String srcVersion) {
        return srcVersion.contains("6.1.99") && !destVersion.contains("6.1.99") && Products.compareVersion((String)destVersion, (String)"6.1.7RC1") >= 0;
    }

    private String checkVersionByPatchContainer(String destVersion, String srcVersion) {
        if (Products.compareVersion((String)destVersion, (String)this.dev.getContainerVersion()) <= 0) {
            return ResourceUtil.getStringWithParams((String)"secondaryupgrade.upgrade.utils.patch.pkg.version", (Object[])new Object[]{destVersion, srcVersion});
        }
        return "";
    }

    private boolean isPatchContainerModel(UpgradeModePanel.UpgradeMode upgradeMode) {
        return UpgradeModePanel.UpgradeMode.PATCH_CONTAINER == upgradeMode;
    }

    private static boolean isPatchPackage(String pkgVersion) {
        return pkgVersion.contains("SPC");
    }

    private String invalidUpgradeMode(EvaluDevNode selectedDev) {
        UpgradeMode selectedUpgradeMode;
        String destVersion = this.layout.getTargetVersionInput().getText().trim();
        List<UpgradeMode> supportUpgradeModeList = EvaluCommUtil.getSupportModeList(selectedDev, destVersion);
        if (supportUpgradeModeList.contains((Object)(selectedUpgradeMode = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedMode().name())))) {
            return "";
        }
        return "evalu.ui.card.addStrategy.upgrademode.valid";
    }

    private String invalidContainerMode(EvaluDevNode selectedDev) {
        String destVersion = this.layout.getContainerTargetVerInput().getText().trim();
        selectedDev.setDeviceType(DeviceType.valueOf((String)(selectedDev.getDeviceType().toString() + "_container")));
        List<UpgradeMode> supportUpgradeModeList = EvaluCommUtil.getSupportModeList(selectedDev, destVersion);
        this.clearContainerSuffix(selectedDev);
        UpgradeMode selectedUpgradeMode = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedMode().name());
        if (supportUpgradeModeList.contains((Object)selectedUpgradeMode)) {
            return "";
        }
        return "evalu.ui.card.addStrategy.containermode.valid";
    }

    private void clearContainerSuffix(EvaluDevNode node) {
        node.setDeviceType(DeviceType.valueOf((String)node.getDeviceType().toString().replace("_container", "")));
    }

    private boolean loadStrategy() {
        List retList = AsyncExcutor.execute((Window)this, (boolean)true, (long)50000L, (Callable[])new Callable[]{new LoadEvaluItemCallable(this.dev)});
        if (retList.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.card.addStrategy.execute.timeout"));
            return false;
        }
        if (!((LoadEvaluItemCallableOver)retList.get(0)).getSuccess().booleanValue()) {
            String resultId = ((LoadEvaluItemCallableOver)retList.get(0)).getResult().getResultId();
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)resultId));
            return false;
        }
        return true;
    }

    private void addContainerTargetVerInputKeyListener() {
        this.layout.getContainerTargetVerInput().addKeyListener((KeyListener)new MyKeyAdapter());
    }

    private void targetVerInputListener() {
        this.layout.getTargetVersionInput().addKeyListener((KeyListener)new MyKeyAdapter());
    }

    private void closeJDialog() {
        this.dispose();
    }

    private static class MyKeyAdapter
    extends KeyAdapter {
        private MyKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.setKeyChar(String.valueOf(e.getKeyChar()).toUpperCase(Locale.US).charAt(0));
        }
    }
}

