/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.ui.upgrade.UpgradeModePanel;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.ui.listenner.InputListener;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DevModifyOperationLayout
extends JPanel {
    private static final int PREFERRED_WIDTH = 594;
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color(242, 242, 242);
    private final Dimension defaultScrollSize = new Dimension(594, 580);
    private final Dimension defaultTextSize = new Dimension(594, 50);
    private JButton confirmBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"evalu.ui.modifyDev.button.confirm"), (char)'O');
    private JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"evalu.ui.modifyDev.button.cancel"), (char)'C');
    private EvaluDevNode dev;
    private ButtonGroup group = new ButtonGroup();
    private IsmTextField targetVerInput = null;
    private IsmTextField containerTargetVerInput;
    private JTextPane comboxExplainLabel = null;
    private JTextPane containerComboxExplain;
    private JLabel comboxLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.devModify.combox.label"));
    private JLabel containerCombox = new JLabel(ResourceUtil.getString((String)"evalu.ui.devModify.combox.label"));
    private UpgradeModePanel upgradeModePanel;
    private UpgradeModePanel containerModePanel;

    public DevModifyOperationLayout(EvaluDevNode dev) {
        this.dev = dev;
    }

    public void hideTargetVersion(boolean isHide) {
        if (isHide) {
            this.targetVerInput.setVisible(false);
            this.comboxLabel.setText(" ");
        } else {
            this.targetVerInput.setVisible(true);
            this.comboxLabel.setText(ResourceUtil.getString((String)"evalu.ui.devModify.combox.label"));
        }
    }

    public void initUi(UpgradeModePanel panel) {
        this.upgradeModePanel = panel;
        this.comboxExplainLabel.setPreferredSize(this.defaultTextSize);
        this.targetVerInput = new IsmTextField(null, "", 25);
        this.targetVerInput.setEditable(true);
        this.containerTargetVerInput = new IsmTextField(null, "", 25);
        this.containerTargetVerInput.setEditable(true);
        JComponent comp = this.buildScrollPane(UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), this.buildComp()}), this.defaultScrollSize);
        if (EvaluContext.isDisableModifySetting()) {
            this.targetVerInput.setEnabled(false);
            this.upgradeModePanel.disableAll();
        }
        this.addListener();
        JComponent btncom = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalGlue(), new JSeparator(0), Box.createVerticalStrut(0), UCD.buildHBoxCentert((Component[])new Component[]{this.confirmBtn, this.cancelBtn}), Box.createVerticalStrut(1)});
        this.setLayout(new BorderLayout());
        this.add((Component)comp, "North");
        this.add((Component)btncom, "South");
    }

    private JComponent buildScrollPane(JComponent innerComponent, Dimension dimension) {
        JScrollPane jScrollPane = new JScrollPane(innerComponent);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().setBackground(DEFAULT_BACKGROUND_COLOR);
        return jScrollPane;
    }

    private void addListener() {
        this.targetVerInput.getDocument().addDocumentListener(new InputListener(this.upgradeModePanel, this.targetVerInput));
        this.containerTargetVerInput.getDocument().addDocumentListener(new InputListener(this.containerModePanel, this.containerTargetVerInput));
    }

    private JComponent buildComp() {
        String deviceSerNumber = this.dev.getDeviceSerialNumber();
        if (StringUtils.hasNULLStr((String[])new String[]{deviceSerNumber})) {
            deviceSerNumber = ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.support");
        }
        JComponent nameComp = UCD.buildVerticalBox(null, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"evalu.ui.devModify.table.ip")), new JLabel(ResourceUtil.getString((String)"evalu.ui.devModify.table.dev.sn")), Box.createVerticalStrut(0)});
        JComponent valueComp = UCD.buildVerticalBox(null, (Component[])new Component[]{new JLabel(this.dev.getIp()), new JLabel(deviceSerNumber), Box.createVerticalStrut(0)});
        JComponent devInfoComp = UCD.buildHorizotalBox((Border)BorderFactory.createTitledBorder(ResourceUtil.getString((String)"evalu.ui.devModify.table.device.info")), (Component[])new Component[]{Box.createHorizontalStrut(0), nameComp, valueComp, Box.createHorizontalStrut(0)});
        UCD.setPreferredWidth((Component)devInfoComp, (int)594);
        JComponent upgradeInfoComp = UCD.buildVerticalBox((Border)BorderFactory.createTitledBorder(ResourceUtil.getString((String)"evalu.ui.devModify.table.upgrade.info")), (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{this.comboxLabel, this.targetVerInput}), UCD.buildHBoxLeft((Component[])new Component[]{this.comboxExplainLabel}), Box.createVerticalStrut(0), this.upgradeModePanel.getPanel()})})});
        ArrayList componentList = new ArrayList();
        if (this.dev.isStorageImageUpgrade()) {
            Collections.addAll(componentList, devInfoComp, upgradeInfoComp, this.initContainerUpgradeUI());
        } else {
            Collections.addAll(componentList, devInfoComp, upgradeInfoComp);
        }
        return this.buildFrameSpace(UCD.buildTopAlignVBox((Component[])componentList.toArray(new Component[0])), 12);
    }

    private JComponent initContainerUpgradeUI() {
        return UCD.buildVerticalBox((Border)BorderFactory.createTitledBorder(ResourceUtil.getString((String)"secondaryupgrade.evalu.title.conupgradeinfo")), (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{this.containerCombox, this.containerTargetVerInput}), UCD.buildHBoxLeft((Component[])new Component[]{this.containerComboxExplain}), Box.createVerticalStrut(0), this.containerModePanel.getPanel()})})});
    }

    public JButton getConfirmBtn() {
        return this.confirmBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public IsmTextField getTargetVersionInput() {
        return this.targetVerInput;
    }

    public void setCompName() {
        this.confirmBtn.setName("_JButton_confirmBtn");
        this.cancelBtn.setName("_JButton_cancelBtn");
        this.comboxLabel.setName("_JLabel_comboxLabel");
    }

    private JComponent buildFrameSpace(JComponent component, int margin) {
        component.setBorder(new EmptyBorder(margin, margin, margin, margin));
        return component;
    }

    public void setComboxExplainLabel(String comboxExplainLabelStr) {
        this.comboxExplainLabel = UiMethod.createTextPaneWithDefaultLeftIdent((String)comboxExplainLabelStr);
        this.containerComboxExplain = UiMethod.createTextPaneWithDefaultLeftIdent((String)comboxExplainLabelStr);
    }

    public UpgradeModePanel getUpgradeModePanel() {
        return this.upgradeModePanel;
    }

    public IsmTextField getContainerTargetVerInput() {
        return this.containerTargetVerInput;
    }

    public UpgradeModePanel getContainerModePanel() {
        return this.containerModePanel;
    }

    public void setContainerModePanel(UpgradeModePanel containerModePanel) {
        this.containerModePanel = containerModePanel;
    }
}

