/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.util.CaseLinkUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import utils.FilesUtil;

public class EvalResultDescLayout
extends JPanel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvalResultDescLayout.class);
    private static final String NEWLINE = "\n";
    private static final int WIDTH = 500;
    private static final int REFPAN_HEIGHT = 180;
    private static final int RESULTPAN_HEIGHT = 90;
    private static final String HTML_PAGE_CONRENTTYPE = "text/html;charset=\"UTF-8\"";
    private JButton close = UiMethod.createButton((String)CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.button.close"));
    private JEditorPane reference = new JEditorPane();
    private JEditorPane result = new JEditorPane();
    private JScrollPane referencePan = new JScrollPane(this.reference);
    private JScrollPane resultPan = new JScrollPane(this.result);
    private ToolHyperLinkLabel showMore = new ToolHyperLinkLabel(CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.linkLabel"));
    private String showMoreText = "";
    private transient EvalFeatureResult item;

    public EvalResultDescLayout(EvalFeatureResult item) {
        this.item = item;
        this.initUI();
        this.initData();
        this.setCompName();
    }

    private void initUI() {
        JLabel referenceLabel = new JLabel(CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.refer.tip"));
        JLabel resultLabel = new JLabel(CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.result.tip2"));
        this.referencePan = new JScrollPane(this.reference);
        this.resultPan = new JScrollPane(this.result);
        this.referencePan.setPreferredSize(new Dimension(500, 180));
        this.resultPan.setPreferredSize(new Dimension(500, 90));
        JComponent pan = null;
        pan = !"".equals(this.item.getOriginalInfo()) ? UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)referenceLabel), this.referencePan, UCD.buildHorizontalBoxLeft((Component)resultLabel), this.resultPan, UCD.buildHorizontalBoxLeft((Component)this.showMore), UCD.buildHBoxRight((Component[])new Component[]{this.close})}) : UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)referenceLabel), this.referencePan, UCD.buildHorizontalBoxLeft((Component)resultLabel), this.resultPan, UCD.buildHBoxRight((Component[])new Component[]{this.close})});
        this.reference.setEditable(false);
        this.reference.setFocusable(true);
        this.reference.setMargin(this.getTextInset());
        this.result.setEditable(false);
        this.result.setFocusable(true);
        this.result.setMargin(this.getTextInset());
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)pan, (int)12), "Center");
    }

    private void scorll2top() {
        this.reference.setCaretPosition(0);
        this.result.setCaretPosition(0);
    }

    private Insets getTextInset() {
        return new Insets(0, 5, 0, 0);
    }

    public void initData() {
        String method = this.item.getCheckMethod();
        String criterion = this.item.getCheckCriterion();
        String suggestion = this.item.getSuggest();
        StringBuffer refText = new StringBuffer();
        StringBuffer context = new StringBuffer();
        this.appendRefText(refText);
        this.appendMethod(method, context);
        this.appendCriterion(criterion, context);
        this.appendSuggestion(suggestion, context);
        refText.append(context.toString().replaceAll(NEWLINE, "<br>"));
        refText.append("<br><br></body>");
        refText.append("</html>");
        String referenceText = refText.toString();
        referenceText = CaseLinkUtils.getSuggest(this.item, referenceText, EvalResultDescLayout.getScpritPath());
        this.reference.setContentType(HTML_PAGE_CONRENTTYPE);
        this.reference.setText(referenceText);
        this.reference.setEditable(false);
        this.reference.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                EvalResultDescLayout.this.doHyperLinkEvent(hyperlinkEvent);
            }
        });
        String ret = this.buildRetText(this.item);
        this.result.setContentType(HTML_PAGE_CONRENTTYPE);
        this.result.setText(ret);
        this.result.setEditable(false);
        this.showMoreText = this.processHtmlText(this.item.getOriginalInfo());
        this.scorll2top();
    }

    private void appendSuggestion(String suggestion, StringBuffer context) {
        if (!StringUtils.isNULLStr((String)suggestion)) {
            context.append(NEWLINE).append(NEWLINE).append("<span><b>").append(CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.refer.desc3")).append("</b></span>").append(NEWLINE).append(suggestion);
        }
    }

    private void appendCriterion(String criterion, StringBuffer context) {
        if (!StringUtils.isNULLStr((String)criterion)) {
            context.append(NEWLINE).append(NEWLINE).append("<span><b>").append(CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.refer.desc2")).append("</b></span>").append(NEWLINE).append(criterion);
        }
    }

    private void appendMethod(String method, StringBuffer context) {
        if (!StringUtils.isNULLStr((String)method)) {
            context.append("<span><b>").append(CompatibilityResourceUtils.getUIString("evalu.ui.itemDetail.refer.desc1")).append("</b></span>").append(NEWLINE).append(method);
        }
    }

    private void appendRefText(StringBuffer refText) {
        refText.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ").append("\"").append(HtmlEnums.XHTML_TRANSITIONAL.getResourceValue()).append("\">").append(System.lineSeparator()).append("<html xmlns=\"").append(HtmlEnums.XHTML.getResourceValue()).append("\">").append(System.lineSeparator()).append("<head>").append(System.lineSeparator()).append("<style type= \"text/css\">").append("body{ font-size:9px;color:#464646;}").append("spn{font-size:13px;color:#ffffff;font-weight:bold;font-style:italic;}").append("selected::selection{color:#ffffff;background:#990000;}").append("selected::-moz-selection{background:#990000;}").append("</style>").append(System.lineSeparator()).append("</head>").append(System.lineSeparator()).append("<body>").append(System.lineSeparator());
    }

    private static String getScpritPath() {
        String workDir = SystemEnvUtil.getDefaultUserDir();
        File helpFilePath = new File(workDir, "help");
        return FilesUtil.getCanonicalPath((File)helpFilePath) + File.separator;
    }

    private String buildRetText(EvalFeatureResult evaluItem) {
        StringBuffer resultText = new StringBuffer();
        this.appendRefText(resultText);
        ItemResultEnum resultEnum = this.item.getItemResult();
        String ret = CompatibilityResourceUtils.getUIString("report.detail.view.result." + (Object)((Object)resultEnum));
        if (!ItemResultEnum.PASS.equals((Object)resultEnum)) {
            ret = ret + NEWLINE + NEWLINE + this.item.getFailDesc();
        }
        resultText.append(ret.replaceAll(NEWLINE, "<br>")).append("</body></html>");
        return resultText.toString();
    }

    private String processHtmlText(String content) {
        content = content.replaceAll(">", "&gt;");
        content = content.replaceAll("<", "&lt;");
        content = "<html><head><title>cli</title></head><body><pre><font size=3 color=\"#333333\">" + content + "</font></pre></body></html>";
        return content;
    }

    public JButton getClose() {
        return this.close;
    }

    public ToolHyperLinkLabel getShowMore() {
        return this.showMore;
    }

    public String getShowMoreText() {
        return this.showMoreText;
    }

    private void doHyperLinkEvent(HyperlinkEvent event) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
            LOGGER.info("start to open the case.");
            String helpFileStr = event.getDescription();
            if (helpFileStr.contains("http")) {
                OSCmdUtils.openWbesite((String)helpFileStr);
            } else {
                OSCmdUtils.explorerFile((File)new File(helpFileStr));
            }
        }
    }

    private void setCompName() {
        this.close.setName("_JButton_close");
        this.showMore.setName("_Label_showMore");
        this.reference.setName("_JEditorPane_reference_");
        this.result.setName("_JEditorPane_result_");
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }
}

