/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.ui.EvalResultDescDialog;
import com.huawei.ism.tool.upgradeevalu.util.EvaluConstants;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class EvalResultInfoDialog
extends JDialog {
    private static final long serialVersionUID = -3017022141546625567L;
    private static final Dimension DIALOG_SIZE = new Dimension(400, 450);
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"evalu.ui.import.info.analyze.support.dialog.okbtn"), (char)'C');
    private JLabel desc = new JLabel(ResourceUtil.getString((String)"evalu.ui.resultInfoDialog.dev.table.assess.result"));
    private String[] infoHeader = new String[]{ResourceUtil.getString((String)"evalu.ui.resultInfoDialog.dev.table.assess.featureId"), ResourceUtil.getString((String)"evalu.ui.resultInfoDialog.dev.table.assess.pass"), ResourceUtil.getString((String)"evalu.card.step1.table.step")};
    private DefaultTableModel infoTableModel = new DefaultTableModel(this.infoHeader, new int[0]);
    private IsmTable infoTable = new IsmTable((TableModel)this.infoTableModel);

    public EvalResultInfoDialog(Window parent, EvalItemResult item) {
        super(parent);
        this.initUI();
        this.initData(item);
        this.addListeners();
        if (!StringUtils.isNULLStr((String)item.getFailedReason()) && item.getFeatureResultList().isEmpty()) {
            this.desc.setText(item.getFailedReason());
        }
    }

    private void addListeners() {
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvalResultInfoDialog.this.dispose();
            }
        });
    }

    private void initData(EvalItemResult item) {
        for (EvalFeatureResult result : item.getFeatureResultList()) {
            DefaultTableRow row = new DefaultTableRow(3, (Object)result.getFeatureId());
            row.setValueAt(0, (Object)this.featureIdDesc(result.getFeatureId()));
            row.setValueAt(1, (Object)this.getIconByIsPass(result.getItemResult()));
            if (ItemResultEnum.PASS.equals((Object)result.getItemResult())) {
                result.setFailDesc(result.getRemark());
            }
            if ("".equals(result.getFailDesc().trim())) {
                row.setValueAt(2, (Object)"");
            } else {
                row.setValueAt(2, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"host.comp.eval.device.eval.viewdetailsmall"), (ActionListener)new HyperLinkCellListener(result)));
            }
            this.infoTableModel.addRow(new TableRow[]{row});
        }
    }

    private IsmTableCell.IconCell getIconByIsPass(ItemResultEnum itemResultEnum) {
        IsmTableCell.IconCell evaluResult = null;
        switch (itemResultEnum) {
            case PASS: {
                evaluResult = new IsmTableCell.IconCell((Icon)EvaluConstants.SUCCESS_IMG, ResourceUtil.getString((String)"host.comp.eval.device.eval.pass"));
                break;
            }
            case NOTPASS: {
                evaluResult = new IsmTableCell.IconCell((Icon)EvaluConstants.FAILED_IMG, ResourceUtil.getString((String)"host.comp.eval.device.eval.not.pass"));
                break;
            }
            case OPTIM_RECOMD: {
                evaluResult = new IsmTableCell.IconCell((Icon)EvaluConstants.WARING_IMG, ResourceUtil.getString((String)"host.comp.eval.device.eval.optimization.recommended"));
                break;
            }
            default: {
                evaluResult = new IsmTableCell.IconCell((Icon)EvaluConstants.NOCHECK_IMG, ResourceUtil.getString((String)"host.comp.eval.device.eval.cannot.eval"));
                evaluResult.setColor(Color.RED);
            }
        }
        return evaluResult;
    }

    private String featureIdDesc(String featureId) {
        return ResourceUtil.getString((String)("evalu.ui.resultInfoDialog.dev.table.assess." + featureId));
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.table.check.result"));
        this.setMinimumSize(DIALOG_SIZE);
        this.pack();
        this.setResizable(true);
        this.setModal(true);
        SwingUtil.putScreenCenter((Window)this);
        JComponent mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{this.desc}), this.createMainPanel()});
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)mainCom, (int)12));
    }

    private JComponent createMainPanel() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{new JScrollPane((Component)this.infoTable), UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
    }

    private class HyperLinkCellListener
    implements ActionListener {
        private EvalFeatureResult evalFeatureResult;

        public HyperLinkCellListener(EvalFeatureResult result) {
            this.evalFeatureResult = result;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EvalResultDescDialog(EvalResultInfoDialog.this, this.evalFeatureResult).setVisible(true);
        }
    }
}

