/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.common.data.ToolLoginUser;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluMode;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.scene.PreUpgradeSceneSettingDialog;
import com.huawei.ism.tool.upgradeevalu.ui.EvaluModelDialogLayout;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.ui.OnlineEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.ui.StorageInfoHelper;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.HVSDevUtils;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class EvaluModelDialog
extends PublicDialog {
    private ProgressDialog progressDialog = null;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluModelDialog.class);
    private EvaluModelDialogLayout layout = null;
    private static final long LONG1024 = 1024L;
    private EvaluContext evaluContext = EvaluContext.getInstance();

    public EvaluModelDialog() {
        this.setRunRole();
        this.initTool();
        this.checkTmpDir();
        this.initNeedOpenVersions();
        if (SceneUtils.isScene()) {
            this.initByScene();
        } else {
            this.initUI();
            this.addListener();
        }
    }

    private void checkTmpDir() {
        File tmpDir = new File(this.evaluContext.getHome() + File.separator + "tmp");
        String confSize = UserOpDataSaveUtil.getToolIniProp((String)"tool.tmp.memory");
        if (StringUtils.isDigit((String)confSize) && tmpDir.getFreeSpace() < (long)StringUtils.str2Int((String)confSize) * 1024L * 1024L) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.evalModeDialog.insufficiency"), confSize));
            this.evaluContext.fireToolStopped();
            this.dispose();
        }
    }

    private void initByScene() {
        switch (EvaluSceneUtils.getSceneArg()) {
            case "CompatibilityAnalysis": {
                this.evaluContext.setEvaluMode(EvaluMode.HOST_EAV);
                this.initHostEval();
                break;
            }
            case "setting": {
                this.evaluContext.setEvaluMode(EvaluMode.LINK);
                this.initSceneSetting();
                break;
            }
            default: {
                this.evaluContext.setEvaluMode(EvaluMode.LINK);
                this.initUpgradeEval();
            }
        }
    }

    private void initSceneSetting() {
        EvaluContext.setAutoAddDevice(true);
        EvaluContext.setDisableModifySetting(SceneUtils.isSceneStepExcuted());
        PreUpgradeSceneSettingDialog mainDialog = new PreUpgradeSceneSettingDialog(null);
        UiMethod.putScreenCenter((Window)mainDialog);
        ToolThreadFactory.newDefaultThread((Runnable)new LoadProductConfigForSetting(mainDialog)).start();
        mainDialog.setVisible(true);
    }

    private void initHostEval() {
        GrabContext.getInstance().setUpgradeEval(true);
        HostEvaluMainDialog mainDialog = new HostEvaluMainDialog(null);
        UiMethod.putScreenCenter((Window)mainDialog);
        HostEvalContext.getInstance().setUiObserver(mainDialog);
        this.progressDialog = new CustMsgProgressDialog((Window)mainDialog, null, 380);
        StorageInfoHelper.startLoadTask(mainDialog, this.progressDialog);
        mainDialog.setVisible(true);
    }

    private void initUpgradeEval() {
        OnlineEvaluMainDialog mainDialog = new OnlineEvaluMainDialog(null);
        UiMethod.putScreenCenter((Window)mainDialog);
        this.evaluContext.setUiObserver(mainDialog);
        ToolThreadFactory.newDefaultThread((Runnable)new LoadProductConfig(mainDialog)).start();
        mainDialog.setVisible(true);
    }

    private void initNeedOpenVersions() {
        EvaluContext.getInstance().setNeedOpenVersions(ProductParser.getInstance().loadOpenTlvProduct());
    }

    private void initTool() {
        ApplicationContext.getInstance().setUpgradeEvaluTool(true);
        File tmpDir = new File(this.evaluContext.getHome() + File.separator + "tmp");
        FileUtils.createDir((File)tmpDir);
        this.evaluContext.setTmpDir(tmpDir);
        File reportDir = this.evaluContext.getReportDir();
        FileUtils.createDir((File)reportDir);
        File htmlDir = this.evaluContext.getHtmlDir();
        FileUtils.createDir((File)htmlDir);
    }

    private void initUI() {
        this.layout = new EvaluModelDialogLayout();
        this.layout.setCompName();
        this.getContentPanel().add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"evalu.ui.evaluModel.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setIconImage(ResourceUtil.getImage((String)"upgradeEvaluation.png").getImage());
        this.setDefaultCloseOperation(2);
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private void setRunRole() {
        ToolLoginUser toolLoginUser = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolLoginUser();
        if (toolLoginUser.getUserRunRole() == null) {
            String toolRunRole = System.getenv("toolRunRole");
            if (StringUtils.isNULLStr((String)toolRunRole)) {
                LOGGER.info(String.format(Locale.ENGLISH, "tool login user: %s, set role to:%s", toolLoginUser.toString(), ToolUserRole.GUEST.toString()));
                EvaluContext.getInstance().setRunRole(ToolUserRole.GUEST);
            } else {
                LOGGER.info(String.format(Locale.ENGLISH, "tool login user: %s, set role to:%s", toolLoginUser.toString(), com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)toolRunRole)));
                EvaluContext.getInstance().setRunRole(ToolUserRole.getRoleInfo((String)toolRunRole));
            }
            return;
        }
        ToolUserRole runRole = toolLoginUser.getUserRunRole();
        LOGGER.info(String.format(Locale.ENGLISH, "current run role: %s", runRole.toString()));
        EvaluContext.getInstance().setRunRole(runRole);
    }

    private void addListener() {
        this.okBtnListener();
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationContext.getInstance().setUpgradeEvaluTool(false);
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click cancel button");
                EvaluModelDialog.this.evaluContext.fireToolStopped();
                EvaluModelDialog.this.dispose();
            }
        });
        this.layout.getOnline().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LOGGER.info("Mouse click link.");
                EvaluModelDialog.this.evaluContext.setEvaluMode(EvaluMode.LINK);
            }
        });
        this.layout.getOnline().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LOGGER.info("The keyboard is moved to link.");
                EvaluModelDialog.this.evaluContext.setEvaluMode(EvaluMode.LINK);
            }
        });
        this.layout.getOffline().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LOGGER.info("Mouse click host eval.");
                EvaluModelDialog.this.evaluContext.setEvaluMode(EvaluMode.HOST_EAV);
            }
        });
        this.layout.getOffline().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LOGGER.info("The keyboard is moved to host eval.");
                EvaluModelDialog.this.evaluContext.setEvaluMode(EvaluMode.HOST_EAV);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: close EvaluModelDialog");
                EvaluModelDialog.this.evaluContext.fireToolStopped();
            }
        });
    }

    private void okBtnListener() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ToolLoggerFactory.getLogger(this.getClass()).info("Selected evaluation mode: " + (Object)((Object)EvaluModelDialog.this.evaluContext.getEvaluMode()));
                }
                catch (Exception eobj) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("Log records failed.", eobj);
                }
                EvaluModelDialog.this.dispose();
                if (EvaluMode.HOST_EAV.equals((Object)EvaluModelDialog.this.evaluContext.getEvaluMode())) {
                    List allDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
                    if (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isSpecificDeviceMode()) {
                        List<DevNode> devLis = HVSDevUtils.getDevFromEnv();
                        LOGGER.info(String.format(Locale.ENGLISH, "devLis: %s", devLis));
                        for (DevNode devNode : devLis) {
                            com.huawei.ism.tool.obase.entity.DevNode allDevNode = EntityUtils.toOldDev((DevNode)devNode);
                            allDevNodes.add(allDevNode);
                        }
                    }
                    try {
                        DefaultNodeProviderImpl.getInstance().addNodes((Collection)allDevNodes);
                    }
                    catch (ToolException e1) {
                        LOGGER.error(String.format(Locale.ENGLISH, "the exception is : %s", new Object[]{e1}));
                    }
                    LOGGER.info(String.format(Locale.ENGLISH, "allDevNodes: %s", allDevNodes));
                    if (allDevNodes.isEmpty() || HostEvaluMainDialog.isAllLimitDevice(allDevNodes)) {
                        DialogUtils.showInfoDialog((JDialog)((Object)EvaluModelDialog.this), (String)CompatibilityResourceUtils.getServiceString("eval.upgradeEvaluation.mode.errormsg"));
                        EvaluModelDialog.this.evaluContext.fireToolStopped();
                    }
                    EvaluModelDialog.this.initHostEval();
                    return;
                }
                EvaluModelDialog.this.initUpgradeEval();
            }
        });
    }

    private static final class LoadProductConfigForSetting
    implements Runnable {
        private final PreUpgradeSceneSettingDialog mainDialog;

        private LoadProductConfigForSetting(PreUpgradeSceneSettingDialog mainDialog) {
            this.mainDialog = mainDialog;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("load-product-config");
            this.mainDialog.loadCfg();
        }
    }

    private static final class LoadProductConfig
    implements Runnable {
        private final OnlineEvaluMainDialog mainDialog;

        private LoadProductConfig(OnlineEvaluMainDialog mainDialog) {
            this.mainDialog = mainDialog;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("load-product-config");
            this.mainDialog.loadCfg();
        }
    }
}

