/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.ui.render.ProgressBar;
import com.huawei.ism.tool.obase.entity.ListCellEntity;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.util.EvaluConstants;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.slf4j.Logger;
import utils.GifAssistant;

public class HostEvaluItemsListCellRenderer
extends DefaultListCellRenderer {
    public static final int OBJNAME_WIDTH = 240;
    public static final int NAME_WIDTH = 300;
    public static final int PREG_WIDTH = 130;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HostEvaluItemsListCellRenderer.class);
    private static final Dimension DATE_LABLE_SIZE = new Dimension(160, 20);
    private static final Dimension SCRIPT_LABEL_SIZE = new Dimension(600, 20);
    private static final Dimension ERROR_MESSAGE_SIZE = new Dimension(300, 20);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String LIST_DROPCELLBACKGROUND = "List.dropCellBackground";
    private static final String SETFOREGROUND = "setForeground";

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (null != dropLocation && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor(LIST_DROPCELLBACKGROUND);
            isSelected = true;
        }
        JPanel viewPan = new JPanel();
        JComponent view = null;
        if (value instanceof ListCellEntity) {
            view = this.buildEvalItemDetail((ListCellEntity<ItemResultEnum>)((ListCellEntity)value));
        } else {
            EvalItemResult evaluItem = (EvalItemResult)value;
            view = this.buildEvalItemDetail(evaluItem);
        }
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        viewPan.setToolTipText(view.getToolTipText());
        if (isSelected) {
            viewPan.setBackground(null == bg ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)SETFOREGROUND, (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    private JComponent buildEvalItemDetail(ListCellEntity<ItemResultEnum> value) {
        if (value.isShowSingleTip()) {
            String valueTxt = value.getMessageTip();
            if (value.isHighLight()) {
                valueTxt = "<html><font color='red'>" + valueTxt + "</font></html>";
            }
            JComponent valueLabel = this.getFirstComp(new JLabel(valueTxt));
            switch (value.getHorizotalLoc()) {
                case "Center": {
                    return new ProgressBar(null, 0, UCD.buildHBoxCentert((int)0, (Component[])new Component[]{valueLabel}));
                }
                case "Right": {
                    return new ProgressBar(null, 0, UCD.buildHBoxRight((int)0, (Component[])new Component[]{valueLabel}));
                }
            }
            return new ProgressBar(null, 0, UCD.buildHBoxLeft((int)0, (Component[])new Component[]{valueLabel}));
        }
        return this.buildPGDetailBar(value.getOperDate(), value.getObject(), value.getOperation(), value.getProgress(), this.getStatusLabel((ItemResultEnum)((Object)value.getResultEnum())));
    }

    private JComponent buildEvalItemDetail(EvalItemResult evaluItem) {
        JComponent view = null;
        try {
            view = this.createViewByItem(evaluItem);
        }
        catch (Exception e) {
            LOGGER.error("add item to detailList error.", e);
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String dateStr = format.format(date);
            JLabel dataLabel = new JLabel(dateStr);
            dataLabel.setPreferredSize(DATE_LABLE_SIZE);
            JLabel errorTipLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.error"));
            errorTipLabel.setPreferredSize(SCRIPT_LABEL_SIZE);
            JLabel errorMessageLabel = new JLabel(e.getMessage());
            errorMessageLabel.setPreferredSize(ERROR_MESSAGE_SIZE);
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dataLabel, Box.createHorizontalStrut(12), errorTipLabel, Box.createHorizontalStrut(12), errorMessageLabel});
        }
        return view;
    }

    private JComponent createViewByItem(EvalItemResult item) throws ToolException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        JLabel statusLabel = null;
        statusLabel = this.getStatusLabel(item.getItemResultEnum());
        return this.createResultItemView(item, dateFormat, statusLabel);
    }

    public JLabel getStatusLabel(ItemResultEnum status) {
        JLabel statusLabel;
        if (status == null) {
            return new JLabel();
        }
        switch (status) {
            case EVALUATING: {
                statusLabel = new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait", (Object[])new Object[0]));
                statusLabel.setIcon(EvaluConstants.WAITING_IMG);
                EvaluConstants.WAITING_IMG.setImageObserver((HostEvaluMainDialog)HostEvalContext.getInstance().getUiObserver());
                GifAssistant.getInstance().getProcessingImage().setImageObserver(HostEvalContext.getInstance().getImageObserver());
                break;
            }
            case PASS: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"host.comp.eval.device.eval.pass"));
                statusLabel.setIcon(EvaluConstants.SUCCESS_IMG);
                break;
            }
            case NOTPASS: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"host.comp.eval.device.eval.not.pass"));
                statusLabel.setIcon(EvaluConstants.FAILED_IMG);
                break;
            }
            case OPTIM_RECOMD: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"host.comp.eval.device.eval.optimization.recommended"));
                statusLabel.setIcon(EvaluConstants.WARING_IMG);
                break;
            }
            case EVALUATION_STOP: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"host.comp.eval.task.eval.stopped.status"));
                statusLabel.setIcon(EvaluConstants.EVAL_EXPT_IMG);
                break;
            }
            case NOTEVAL: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"host.comp.eval.task.unEval"));
                statusLabel.setIcon(EvaluConstants.NOTEVALU_IMG);
                break;
            }
            case WAIT_TOGO: {
                statusLabel = new JLabel(ResourceUtil.getString((String)status.getDescKey()));
                statusLabel.setIcon(EvaluConstants.WAIT_EVALU_IMG);
                break;
            }
            default: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"host.comp.eval.device.eval.cannot.eval"));
                statusLabel.setIcon(EvaluConstants.NOCHECK_IMG);
            }
        }
        statusLabel.setForeground(new Color(4359891));
        return statusLabel;
    }

    private JComponent createResultItemView(EvalItemResult item, SimpleDateFormat dateFormat, JLabel statusLabel) {
        String desc = "--";
        String time = "--";
        String descTip = "--";
        String ip = item.getItemInfo().getIp();
        String[] ips = ip.split(",");
        ip = ips.length > 1 ? ips[0] + "..." : ip;
        desc = this.getDesc(ips[0], "host.comp.eval.task.eval.detail.desc.evaling", item);
        if (ItemResultEnum.EVALUATING.equals((Object)item.getItemResultEnum())) {
            if (null != item.getItemInfo()) {
                desc = this.getDesc(ips[0], "host.comp.eval.task.eval.detail.desc.evaling", item);
                descTip = this.getDesc(item.getItemInfo().getIp(), "host.comp.eval.task.eval.detail.desc.evaling", item);
            }
            if (item.getCreateTime() != null) {
                time = dateFormat.format(item.getCreateTime());
            }
        } else if (ItemResultEnum.EXCEPTION.equals((Object)item.getItemResultEnum())) {
            if (null != item.getItemInfo()) {
                desc = item.getFailedReason();
                statusLabel = new JLabel();
            }
            if (item.getCreateTime() == null) {
                item.setCreateTime(new Date());
            }
            time = dateFormat.format(item.getCreateTime());
        } else if (ItemResultEnum.NOTEVAL.equals((Object)item.getItemResultEnum())) {
            if (null != item.getItemInfo()) {
                desc = this.getUnEval(item, ip).toString();
                descTip = this.getNnEvalTip(item).toString();
            }
            if (item.getCreateTime() == null) {
                item.setCreateTime(new Date());
            }
            time = dateFormat.format(item.getCreateTime());
        } else if (ItemResultEnum.WAIT_TOGO.equals((Object)item.getItemResultEnum())) {
            desc = this.getBeEvalDesc(item, ip).toString();
            descTip = this.getBeEvalDescTip(item).toString();
        } else {
            if (null != item.getItemInfo()) {
                desc = this.getDesc(ip, "host.comp.eval.task.eval.detail.desc.finish", item);
                descTip = this.getDesc(item.getItemInfo().getIp(), "host.comp.eval.task.eval.detail.desc.finish", item);
            }
            if (item.getCreateTime() != null) {
                time = dateFormat.format(item.getCreateTime());
            }
        }
        JComponent comp = this.initView(time, desc, item, statusLabel);
        comp.setToolTipText(descTip);
        return comp;
    }

    private StringBuilder getBeEvalDescTip(EvalItemResult item) {
        StringBuilder sbTip = new StringBuilder();
        sbTip.append(ResourceUtil.getStringWithParams((String)("host.comp.eval.task.eval.detail.desc." + item.getItemInfo().getDeviceType().getName()), (Object[])new Object[]{item.getItemInfo().getIp()}));
        sbTip.append(ResourceUtil.getString((String)"host.comp.eval.task.to.be.eval"));
        return sbTip;
    }

    private StringBuilder getBeEvalDesc(EvalItemResult item, String ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResourceUtil.getStringWithParams((String)("host.comp.eval.task.eval.detail.desc." + item.getItemInfo().getDeviceType().getName()), (Object[])new Object[]{ip}));
        sb.append(ResourceUtil.getString((String)"host.comp.eval.task.to.be.eval"));
        return sb;
    }

    private StringBuilder getUnEval(EvalItemResult item, String ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResourceUtil.getStringWithParams((String)("host.comp.eval.task.eval.detail.desc." + item.getItemInfo().getDeviceType().getName()), (Object[])new Object[]{ip}));
        sb.append(ResourceUtil.getString((String)"host.comp.eval.task.unEval"));
        return sb;
    }

    private StringBuilder getNnEvalTip(EvalItemResult item) {
        StringBuilder sbTip = this.getUnEval(item, item.getItemInfo().getIp());
        return sbTip;
    }

    private String getDesc(String ip, String str, EvalItemResult item) {
        return ResourceUtil.getStringWithParams((String)("host.comp.eval.task.eval.detail.desc." + item.getItemInfo().getDeviceType().getName()), (Object[])new Object[]{ip}) + ResourceUtil.getString((String)str);
    }

    private JComponent initView(String time, String desc, EvalItemResult item, JLabel statusLabel) {
        JLabel deviceNameLabel;
        JLabel nameLabel = new JLabel(desc);
        if (ItemResultEnum.EXCEPTION.equals((Object)item.getItemResultEnum())) {
            nameLabel.setForeground(Color.RED);
        }
        nameLabel.setPreferredSize(SCRIPT_LABEL_SIZE);
        JLabel dataLabel = new JLabel(time);
        if (ItemResultEnum.EXCEPTION.equals((Object)item.getItemResultEnum())) {
            dataLabel.setForeground(Color.RED);
        }
        dataLabel.setPreferredSize(DATE_LABLE_SIZE);
        JComponent dateComp = this.getFirstComp(dataLabel);
        String deviceNameTxt = this.getDeviceTypename(item);
        if (NodeAddEnum.COLLECT_FILE.equals((Object)item.getEvalDevNode().getNodeAddType())) {
            deviceNameLabel = new JLabel(deviceNameTxt, ResourceUtil.getImage((String)"fileHostIcon.png"), 2);
            deviceNameLabel.setHorizontalTextPosition(2);
        } else {
            deviceNameLabel = new JLabel(deviceNameTxt);
        }
        deviceNameLabel.setPreferredSize(new Dimension(240, (int)deviceNameLabel.getPreferredSize().getHeight()));
        nameLabel.setPreferredSize(new Dimension(300, (int)deviceNameLabel.getPreferredSize().getHeight()));
        JLabel progLabel = new JLabel();
        if (ItemResultEnum.EVALUATING.equals((Object)item.getItemResultEnum())) {
            StringBuilder statueLabel = new StringBuilder(ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.table.progress"));
            statueLabel.append(':').append(item.getProcessBar()).append("%   ");
            progLabel.setText(statueLabel.toString());
        }
        progLabel.setPreferredSize(new Dimension(130, (int)deviceNameLabel.getPreferredSize().getHeight()));
        return this.buildPGDetailBar(dateComp, deviceNameLabel, nameLabel, progLabel, statusLabel);
    }

    public JComponent getFirstComp(JLabel dataLabel) {
        return UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), dataLabel});
    }

    private ProgressBar buildPGDetailBar(Date date, String deviceNameLabel, String nameLabel, float progLabel, JLabel statusLabel) {
        StringBuilder pregLabelStr = new StringBuilder();
        if (progLabel < 100.0f) {
            pregLabelStr.append(ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.table.progress"));
            pregLabelStr.append(':').append(String.format(Locale.ENGLISH, "%.2f", Float.valueOf(progLabel))).append("%   ");
        }
        JLabel devNameLabel = new JLabel(deviceNameLabel);
        devNameLabel.setPreferredSize(new Dimension(240, (int)devNameLabel.getPreferredSize().getHeight()));
        JLabel nLabel = new JLabel(nameLabel);
        nLabel.setPreferredSize(new Dimension(300, (int)devNameLabel.getPreferredSize().getHeight()));
        JLabel pLabel = new JLabel(pregLabelStr.toString());
        pLabel.setPreferredSize(new Dimension(130, (int)pLabel.getPreferredSize().getHeight()));
        JLabel dataLab = new JLabel(DateUtil.formatDate((Date)date, (String)DATE_FORMAT));
        dataLab.setPreferredSize(DATE_LABLE_SIZE);
        return this.buildPGDetailBar(this.getFirstComp(dataLab), devNameLabel, nLabel, pLabel, statusLabel);
    }

    private ProgressBar buildPGDetailBar(JComponent dateComp, JLabel deviceNameLabel, JLabel nameLabel, JLabel progLabel, JLabel statusLabel) {
        ProgressBar bar = new ProgressBar(null, 0, dateComp, Box.createHorizontalStrut(2), deviceNameLabel, Box.createHorizontalStrut(2), nameLabel, Box.createHorizontalStrut(2), progLabel, UCD.buildHBoxLeft((Component[])new Component[]{statusLabel, Box.createHorizontalStrut(2)}));
        return bar;
    }

    public String getDeviceTypename(EvalItemResult item) {
        ItDeviceType devType = item.getEvalDevNode().getItDeviceType();
        if (ItDeviceType.Database.equals((Object)devType)) {
            return item.getEvalDevNode().getDeviceName();
        }
        DeviceType deviceType = item.getEvalDevNode().getDeviceType();
        String deviceNameTxt = deviceType == null ? item.getEvalDevNode().getDeviceName() : deviceType.toString();
        return deviceNameTxt;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }
}

