/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.utils.FileHostUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.grab.GrabThread;
import com.huawei.ism.tool.infograb.intf.worktaker.AddDeviceService;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.parser.InfoGrabItemPaser;
import com.huawei.ism.tool.infograb.swing.IDeviceManageService;
import com.huawei.ism.tool.infograb.ui.StorUpAddDevDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.ListCellEntity;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.entity.UpgradeHostInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.tool.upgradeevalu.config.ParseConfCallable;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluProcessTip;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalUserOpData;
import com.huawei.ism.tool.upgradeevalu.entity.NotAdminUserDeviceInfo;
import com.huawei.ism.tool.upgradeevalu.entity.TaskDeviceTnfo;
import com.huawei.ism.tool.upgradeevalu.entity.TaskInfoByUserOPDate;
import com.huawei.ism.tool.upgradeevalu.entity.TaskUserOPDate;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.enums.TaskStatusEnum;
import com.huawei.ism.tool.upgradeevalu.iterface.IEvalObserver;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskParameters;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataExtendUtil;
import com.huawei.ism.tool.upgradeevalu.service.CompatibilityExcelInfo;
import com.huawei.ism.tool.upgradeevalu.service.StorInfoProgressUpdater;
import com.huawei.ism.tool.upgradeevalu.task.HostComAnalyze;
import com.huawei.ism.tool.upgradeevalu.task.IHostComAnalyze;
import com.huawei.ism.tool.upgradeevalu.ui.EvalResultInfoDialog;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialogLayout;
import com.huawei.ism.tool.upgradeevalu.ui.LabelHyperlinkCell;
import com.huawei.ism.tool.upgradeevalu.ui.NotAdminUserInfoDialog;
import com.huawei.ism.tool.upgradeevalu.ui.SetAssociationDialog;
import com.huawei.ism.tool.upgradeevalu.ui.SimpleDetailInfoDialog;
import com.huawei.ism.tool.upgradeevalu.ui.action.AddDeviceListner;
import com.huawei.ism.tool.upgradeevalu.ui.action.DownLoadAction;
import com.huawei.ism.tool.upgradeevalu.ui.action.GetOfflineFileAction;
import com.huawei.ism.tool.upgradeevalu.ui.action.OffLineBatchImportAction;
import com.huawei.ism.tool.upgradeevalu.ui.action.ShowHostViewListener;
import com.huawei.ism.tool.upgradeevalu.ui.action.ViewReportListner;
import com.huawei.ism.tool.upgradeevalu.util.EvalTimePropertiesUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluConstants;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.tool.upgradeevalu.util.StorageInfoQryTask;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.RootPaneUI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import utils.FilesUtil;
import utils.GifAssistant;

public class HostEvaluMainDialog
extends JDialog
implements IEvalObserver,
GifAssistant.IGifUiObserver,
com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack,
INodeObserver,
AddDeviceService {
    private static final Dimension PAGE_SIZE = new Dimension(980, 600);
    private static final String IMPORT_FILE_PATH_KEY = "eval.offline.import";
    private static final int EXEC_STATUS_IMG_INDEX = 7;
    private static final int RESULT_STATUS_IMG_INDEX = 8;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HostEvaluMainDialog.class);
    private static final String SAVEPATH_DEFAULT_ID = "offLineReportDir";
    private static final String START_EVALUTEXT = ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.button.execute");
    private static final String END_EVALUTEXT = ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.button.interrupt");
    private static final String END_TIP = ResourceUtil.getString((String)"evalu.ui.out.line.dialog.complete.view.end.tip");
    private static volatile HostEvaluMainDialog instance = null;
    private static Map<String, EvalItemResult> evaluateItemMap = new HashMap<String, EvalItemResult>();
    private static Map<String, String> cacheStorageTableMap = new HashMap<String, String>();
    private static Map<String, String> cacheDetailsMap = new HashMap<String, String>();
    private AtomicInteger evaluatingTaskCount = null;
    private EvaluProcessTip evaluProcessTip;
    private ProgressDialog inerrrutpDialog = null;
    private HostEvalContext evaluContext = HostEvalContext.getInstance();
    private HostEvaluMainDialogLayout layout;
    private transient GifAssistant gifAssistant = GifAssistant.getInstance();
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private transient EvaluSceneUtils sceneUtil = new EvaluSceneUtils();
    private static final Object lock = new Object();
    private Map<DevNode, String> deviceImportResult = new LinkedHashMap<DevNode, String>();
    private static TaskUserOPDate userDate = new TaskUserOPDate();

    public HostEvaluMainDialog(Window parent) {
        super(parent);
        HostEvalContext.getInstance().setImageObserver(this);
        DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)this);
        this.precheck();
        this.initUI();
        this.initStorageTable();
        this.addListner();
        HostEvaluMainDialog.setInstance(this);
        InfoGrabItemPaser.getInstance().createGrabFlowByXML();
        com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().init();
        userDate.setTaskStartTime(new Date());
    }

    private void precheck() {
        HostEvalUtils.checkStroageNeedAddOracle();
    }

    public void loadCfg() {
        List fs = AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new ParseConfCallable()});
        Boolean result = (Boolean)fs.get(0);
        if (!result.booleanValue()) {
            String str = ResourceUtil.getString((String)"evalu.ui.mainDialog.load.config.error");
            SimpleDetailInfoDialog dialog = new SimpleDetailInfoDialog(str, this);
            dialog.setVisible(true);
            LOGGER.error("parse config failed.");
        }
    }

    private void initUI() {
        this.layout = new HostEvaluMainDialogLayout();
        this.layout.setCompName();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.rootPaneUI.setHelpActionCallBack((com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack)this);
        this.setTitle(ResourceUtil.getString((String)"evalu.host.enter.title"));
        this.setModal(true);
        this.setResizable(true);
        this.validate();
        this.pack();
        this.setIconImage(ResourceUtil.getImage((String)"upgradeEvaluation.png").getImage());
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void addListner() {
        this.layout.getCommandListLabel().addClickListener((ToolHyperLinkLabel.ClickListener)new DownLoadAction(this, "commandTemplate"));
        this.layout.getOffLineCollectLabel().addClickListener((ToolHyperLinkLabel.ClickListener)new GetOfflineFileAction(this));
        this.addDevListener();
        this.addConfigBtnListener();
        this.addOpenReportListener();
        this.executBtnListener();
        this.layout.getOfflineImportBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<File> selectFiles = HostEvaluMainDialog.this.selectImportFiles();
                if (!HostEvaluMainDialog.this.checkImportFiles(selectFiles)) {
                    return;
                }
                HostEvaluMainDialog.this.checkAndStoAssDialogIfneeded(selectFiles);
                HostEvaluMainDialog.this.evaluContext.setUseOfflineImport(2);
            }
        });
        this.detailListListener();
        IsmTable ismTable = this.layout.getDevEvaluTable();
        ListSelectionModel selectionModel = ismTable.getSelectionModel();
        selectionModel.addListSelectionListener(new TableSelectedListener());
        this.openResultBtnListener();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click close button");
                HostEvaluMainDialog.this.exitEvaluTool();
            }
        });
        this.setSceneReportDir();
    }

    private void openResultBtnListener() {
        JButton openResultBtn = this.layout.getOpenEvaluResult();
        openResultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Operate: click open result dir button");
                this.openResultDir();
            }

            private void openResultDir() {
                try {
                    File reportFile;
                    Object reportPath = HibernateContainer.getInstance().get((Object)HostEvaluMainDialog.SAVEPATH_DEFAULT_ID);
                    File file = reportFile = reportPath != null ? new File(reportPath.toString()) : HostEvaluMainDialog.this.evaluContext.getReportDir();
                    if (null == reportFile) {
                        LOGGER.error("report dir is null.");
                        return;
                    }
                    LOGGER.info("Open directory reportDir={}", (Object)reportFile);
                    String path = reportFile.getCanonicalPath();
                    OSCmdUtils.openFile((File)new File(path));
                }
                catch (IOException ex) {
                    LOGGER.error("Open dic error", ex);
                }
                catch (Exception ex) {
                    LOGGER.error("Open dic error", ex);
                }
            }
        });
    }

    private void executBtnListener() {
        JButton executBtn = this.layout.getStartEvaluBtn();
        executBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click execut evalu button");
                ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HostEvaluMainDialog.this.startOrEndEvaluAction();
                    }
                }).start();
            }
        });
    }

    public DevNode addDevByFiles(File mannualGrabFile, IDeviceManageService service) {
        GrabDevNode1 dev = new GrabDevNode1();
        dev.setDevInfoPkgPath(FilesUtil.getCanonicalPath((File)mannualGrabFile));
        dev.setNodeAddType(NodeAddEnum.GRAB_FILE);
        dev.setLoginUser(new User("root", null));
        TaskResult result = service.addDevice(dev);
        if (TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
            HostEvalContext.getInstance().getOffHostDevs().add(dev);
            dev.setErrorDecs(null);
        } else {
            dev.setErrorDecs(result.getErrorLocaleDescription());
        }
        return dev;
    }

    private boolean checkImportFiles(List<File> selectFiles) {
        OffLineBatchImportAction action = new OffLineBatchImportAction(this);
        if (!action.checkFilePath(selectFiles)) {
            return false;
        }
        if (!action.checkFileSize(selectFiles)) {
            return false;
        }
        if (!action.preCheck(selectFiles)) {
            return false;
        }
        return action.checkSelectedFile(selectFiles);
    }

    public List<File> selectImportFiles() {
        List selectFiles = ToolFileChooser.selectFiles((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.offlinebtn"), (String[])new String[]{"zip", "data"}, (String)IMPORT_FILE_PATH_KEY, (String)"*.zip,*.data", (int)0);
        return selectFiles;
    }

    public void checkAndStoAssDialogIfneededForDataFile(List<DevNode> foundDevs) {
        List evalNodes = this.layout.getDevEvaluTable().getAllRows();
        for (DevNode devNode : foundDevs) {
            boolean isHaveBindedDev = false;
            for (TableRow tableRow : evalNodes) {
                HostEvalNode node = (HostEvalNode)tableRow.getUserObject();
                if (!this.isAddedBefore(devNode, node.getStorageMappingHosts())) continue;
                isHaveBindedDev = true;
                break;
            }
            if (isHaveBindedDev) continue;
            HostEvalContext.setExistNotAssociated(false);
            this.startSetting();
            break;
        }
    }

    public void checkAndStoAssDialogIfneeded(List<File> selectFiles) {
        List<DevNode> foundDevs = this.addDevsFileToList(selectFiles);
        List evalNodes = this.layout.getDevEvaluTable().getAllRows();
        for (DevNode devNode : foundDevs) {
            boolean isHaveBindedDev = false;
            for (TableRow tableRow : evalNodes) {
                HostEvalNode node = (HostEvalNode)tableRow.getUserObject();
                if (!this.isAddedBefore(devNode, node.getStorageMappingHosts())) continue;
                isHaveBindedDev = true;
                break;
            }
            if (isHaveBindedDev) continue;
            HostEvalContext.setExistNotAssociated(false);
            this.startSetting();
            break;
        }
    }

    public void startSetting() {
        SetAssociationDialog setAssociationDialog = new SetAssociationDialog(this, ToolWizardDialog.Navigation.Previous, ToolWizardDialog.Navigation.Next, ToolWizardDialog.Navigation.Complete);
        this.startWizard(setAssociationDialog);
    }

    private List<String[]> getSteps() {
        ArrayList<String[]> steps = new ArrayList<String[]>();
        String[] step0 = new String[]{ResourceUtil.getString((String)"eval.associate.main.page.navigate.label.storage.host"), ResourceUtil.getString((String)"eval.associate.wizard.storage.host.title.desc")};
        steps.add(step0);
        String[] step1 = new String[]{ResourceUtil.getString((String)"eval.associate.main.page.navigate.label.db.host"), ResourceUtil.getString((String)"eval.associate.wizard.db.host.title.desc")};
        steps.add(step1);
        return steps;
    }

    private void startWizard(SetAssociationDialog welcomeStep) {
        welcomeStep.setPreviousCard(welcomeStep);
        final ToolWizardDialog toolWizardDialog = new ToolWizardDialog((Window)this, this.getSteps(), null, true);
        String wizardName = String.format(Locale.ENGLISH, ResourceUtil.getString((String)"eval.associate.wizard.title.desc"), this.getSteps().size());
        toolWizardDialog.setWizardName(wizardName);
        welcomeStep.setWizardDialog(toolWizardDialog);
        toolWizardDialog.setTitle("Welcome");
        toolWizardDialog.setResizable(false);
        toolWizardDialog.setFirstCard((ToolWizardDialog.Card)welcomeStep);
        toolWizardDialog.setHelpActionCallBack(new IHelpActionCallBack(){

            public String getListenerName() {
                return this.getClass().getName();
            }

            public void doHelpActionWork() {
                HostEvaluMainDialog.this.openHelpFile("UpgradeEvaluation_Compatibility", (Window)toolWizardDialog);
            }
        });
        UiMethod.setComponentSize((Dimension)PAGE_SIZE, (Component[])new Component[]{toolWizardDialog});
        SwingUtil.putScreenCenter((Window)toolWizardDialog);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                toolWizardDialog.setVisible(true);
            }
        });
    }

    public void addDeviceToPage(List<DevNode> foundDevs, List<ItemInfo> ieList, String zipPath) {
        if (ieList == null) {
            return;
        }
        for (ItemInfo it : ieList) {
            boolean isHost = AddDeviceListner.getSupportHostType().contains(it.getDevInfo());
            boolean isDb = AddDeviceListner.getSupportDbType().contains(it.getOsName());
            if (!isHost && !isDb) continue;
            DevNode devNode = new DevNode();
            Map<String, String> evalMap = this.fillNodeAttr(zipPath, it, isHost, devNode);
            if (isHost) {
                String aluaInfo = evalMap.get("aluaLauncher");
                Launcher launcher = JSONObject.parseObject(aluaInfo, Launcher.class);
                GrabContext.getInstance().getLauncherMap().put(devNode.getDevKey(), launcher);
            }
            this.addDevNode(devNode, null);
            this.updateDevNode(devNode);
            foundDevs.add(devNode);
        }
    }

    public Map<String, String> fillNodeAttr(String zipPath, ItemInfo it, boolean isHost, DevNode devNode) {
        devNode.setDeviceType(DeviceType.valueOf((String)it.getOsName()));
        devNode.setDevTypeLevel2(DeviceType.valueOf((String)it.getDeviceType().getName()));
        devNode.setIp(it.getIp());
        devNode.setDevInfoPkgPath(zipPath);
        devNode.setNodeAddType(NodeAddEnum.GRAB_PKG);
        devNode.setLoginUser(new User(null, null));
        devNode.setDeviceName(it.getDevInfo());
        devNode.setDeviceNameAlias(isHost ? it.getDeviceName() : it.getOsName() + ' ' + it.getDatabaseVersion());
        devNode.setItDeviceType(isHost ? ItDeviceType.Host : ItDeviceType.Database);
        Map<String, String> evalMap = it.getInfoGrabMetaMsg();
        devNode.setDeviceSerialNumber(evalMap.get("deviceSerialNumber").trim());
        return evalMap;
    }

    public HostEvalNode getFirstNodeOnPage() {
        List evalNodes = this.layout.getDevEvaluTable().getAllRows();
        TableRow tr = (TableRow)evalNodes.get(0);
        HostEvalNode node = (HostEvalNode)tr.getUserObject();
        return node;
    }

    public List<DevNode> addDevsFileToList(List<File> selectFiles) {
        ArrayList<DevNode> foundDevs = new ArrayList<DevNode>();
        CompatibilityExcelInfo compatibilityExcelInfo = new CompatibilityExcelInfo();
        for (File file : selectFiles) {
            String filePath = FilesUtil.getCanonicalPath((File)file);
            try {
                if (!file.getName().endsWith(".zip")) continue;
                Map<String, Object> excelDevMap = compatibilityExcelInfo.getAllExcelContent(filePath);
                for (Map.Entry<String, Object> entry : excelDevMap.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof Map)) continue;
                    List ieList = (List)((Map)value).get("HostReport");
                    this.addDeviceToPage(foundDevs, ieList, filePath);
                    ieList = (List)((Map)value).get("DatabaseReport");
                    this.addDeviceToPage(foundDevs, ieList, filePath);
                }
            }
            catch (Exception e1) {
                LOGGER.error("reslove files error.", e1);
            }
        }
        return foundDevs;
    }

    private void addOpenReportListener() {
        this.layout.getOpenEvaluReport().addActionListener(new ViewReportListner(this));
    }

    private void detailListListener() {
        JList detailList = this.layout.getDetailList();
        detailList.addMouseListener(new ListMouseAdapter());
    }

    private void addDevListener() {
        JButton addBtn = this.layout.getAddEvaluDevBtn();
        addBtn.addActionListener(new AddDeviceListner(this, HostEvalContext.isNeedAddOracleDatabase()));
    }

    private void addConfigBtnListener() {
        JButton configBtn = this.layout.getConfigBtn();
        configBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostEvaluMainDialog.this.startSetting();
            }
        });
    }

    private void setSceneReportDir() {
        if (this.sceneUtil.isScene()) {
            try {
                this.evaluContext.setReportDir(new File(this.sceneUtil.sceneResultPath()));
            }
            catch (RuntimeException e) {
                LOGGER.error("something wrong.", e);
            }
            catch (Exception e) {
                LOGGER.error("set scene evalu dir failed!", e);
            }
        }
    }

    private void exitEvaluTool() {
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.out.line.dialog.exit.tool.tip"));
        if (0 == wd.getValue()) {
            ApplicationContext.getInstance().getUserOpData().setToolName("compatibilityEvaluation");
            List<TaskInfoByUserOPDate> taskUserDateList = HostEvalContext.getInstance().getTaskUserDateList();
            if (!taskUserDateList.isEmpty()) {
                userDate.setTaskNums(taskUserDateList.size());
                userDate.setOpenEvaluHelpFile(this.evaluContext.getOpenHelpFile());
                userDate.setScriptGrab(this.evaluContext.getScriptGrab());
                userDate.setUseOfflineImport(this.evaluContext.getUseOfflineImport());
                userDate.setIsScene(SceneUtils.isScene() ? 1 : 0);
                userDate.setTaskInfo(taskUserDateList);
            }
            userDate.setTaskEndTime(new Date());
            ArrayList<TaskUserOPDate> userDatelist = new ArrayList<TaskUserOPDate>();
            userDatelist.add(userDate);
            UserOpDataSaveUtil.batchSaveUserOpdataForHostEval(userDatelist);
            Map<String, List<HostEvalUserOpData>> userOpDataMap = this.evaluContext.getUserOpDataMap();
            if (!userOpDataMap.isEmpty()) {
                for (Map.Entry<String, List<HostEvalUserOpData>> userOpData : userOpDataMap.entrySet()) {
                    List<HostEvalUserOpData> userOplist = userOpData.getValue();
                    for (HostEvalUserOpData hostEvalUserOpData : userOplist) {
                        hostEvalUserOpData.setOpenHelpFile(this.evaluContext.getOpenHelpFile());
                    }
                    UserOpDataSaveUtil.batchSaveUserOpdataForHostEval(userOplist);
                }
            }
            this.finishedScene();
            this.writeDeviceToxml();
            this.saveEvalEndTimeToConfig();
            com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().setUpgradeEvaluTool(false);
            this.evaluContext.fireToolStopped();
            this.dispose();
        }
    }

    private void writeDeviceToxml() {
        List hostOrDbDevs;
        if (this.sceneUtil.isScene() && !(hostOrDbDevs = DefaultNodeProviderImpl.getInstance().getHostDbNodeList()).isEmpty()) {
            List devs = EntityUtils.toNewDevList((List)hostOrDbDevs);
            FileHostUtils.writeDevNodeToSceneFile((List)devs);
        }
    }

    private void saveEvalEndTimeToConfig() {
        if (!EvaluSceneUtils.isHostScene()) {
            LOGGER.info("is not in Scene.");
            return;
        }
        String evalEndTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        if (this.hasOneEvalEnd()) {
            EvalTimePropertiesUtil.getInstance().writeProperty(EvalTimePropertiesUtil.getInstance().getEvalEndTimeKey(), evalEndTime);
        }
    }

    private boolean hasOneEvalEnd() {
        for (Map.Entry<String, EvalTaskResult> entry : HostEvalContext.getHostRvalResult().entrySet()) {
            if ((int)entry.getValue().getProgressCurrent() != 100) continue;
            return true;
        }
        return false;
    }

    private void finishedScene() {
        if (this.sceneUtil.isScene()) {
            try {
                this.sceneUtil.finishedSceneTask();
            }
            catch (Exception e) {
                LOGGER.error("scene data error.", e);
            }
        }
    }

    public void setToolEvaluState(boolean isEvalu) {
        if (isEvalu) {
            this.evaluContext.setTaskExecuting(true);
            this.layout.getAddEvaluDevBtn().setEnabled(false);
            this.layout.getOpenEvaluReport().setEnabled(false);
            this.layout.getOfflineImportBtn().setEnabled(false);
            this.layout.getConfigBtn().setEnabled(false);
            this.layout.getStartEvaluBtn().setText(END_EVALUTEXT);
            UCD.formatMnemonicDisplay((AbstractButton)this.layout.getStartEvaluBtn());
            this.layout.getStartEvaluBtn().setToolTipText(END_TIP);
            return;
        }
        this.layout.getAddEvaluDevBtn().setEnabled(true);
        this.layout.getOfflineImportBtn().setEnabled(true);
        this.layout.getConfigBtn().setEnabled(true);
        this.evaluContext.setTaskExecuting(false);
        this.layout.getStartEvaluBtn().setEnabled(true);
        this.layout.getOpenEvaluReport().setEnabled(true);
        this.layout.getStartEvaluBtn().setText(START_EVALUTEXT);
        this.layout.getStartEvaluBtn().setMnemonic('E');
        UCD.formatMnemonicDisplay((AbstractButton)this.layout.getStartEvaluBtn());
    }

    public List<HostEvalNode> getSelectDevNode() {
        ArrayList<HostEvalNode> nodeList = new ArrayList<HostEvalNode>();
        List rows = this.layout.getDevEvaluTable().getMarkedRows();
        for (TableRow tr : rows) {
            HostEvalNode node = (HostEvalNode)tr.getUserObject();
            nodeList.add(node);
        }
        return nodeList;
    }

    private void startOrEndEvaluAction() {
        if (this.endEvalu()) {
            return;
        }
        this.setToolEvaluState(true);
        List<HostEvalNode> tabDevs = this.getSelectDevNode();
        if (this.hasTabDevNumLimit(tabDevs)) {
            return;
        }
        List<HostEvalNode> tabTasks = this.getSelectedTasks(tabDevs);
        ArrayList<DevNode> allHostDev = new ArrayList<DevNode>();
        HashSet<String> ipSet = new HashSet<String>();
        this.getAllHostDev(tabTasks, allHostDev);
        this.getIpSet(allHostDev, ipSet);
        if (this.checkTabTasks(tabTasks)) {
            return;
        }
        if (this.checkStorageMappingHosts(tabTasks)) {
            return;
        }
        if (!this.checkIsDbUnAssociated()) {
            this.setToolEvaluState(false);
            return;
        }
        boolean keepExec = this.checkMappedStorage(tabTasks);
        if (!keepExec) {
            return;
        }
        this.gifAssistant.setObserver((GifAssistant.IGifUiObserver)this);
        this.gifAssistant.start();
        this.layout.getListModel().clear();
        this.resetSelectedDev(tabTasks);
        int onlineThreadNums = 0;
        ArrayList<DevNode> pendingGrabHosts = new ArrayList<DevNode>();
        for (HostEvalNode pendingEvalStrgNode : tabTasks) {
            List<DevNode> toEvalDevs = pendingEvalStrgNode.getStorageMappingHosts();
            for (DevNode toEvalDev : toEvalDevs) {
                if (!toEvalDev.getNodeAddType().equals((Object)NodeAddEnum.ONLINE) && !toEvalDev.isFileNode() || pendingGrabHosts.contains(toEvalDev)) continue;
                pendingGrabHosts.add(toEvalDev);
                ++onlineThreadNums;
            }
        }
        GrabContext.countDownLatch = new CountDownLatch(onlineThreadNums);
        LOGGER.info("the countDownLatch counts down from\uff1a{}", (Object)onlineThreadNums);
        EvalHostTask callable = new EvalHostTask(tabTasks);
        AsyncExcutor.submit((Callable)callable);
    }

    private boolean hasTabDevNumLimit(List<HostEvalNode> tabDevs) {
        if (tabDevs.size() > 10) {
            this.setToolEvaluState(false);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.out.line.dialog.selected.task.outsid"));
            return true;
        }
        return false;
    }

    private boolean checkMappedStorage(List<HostEvalNode> tabTasks) {
        boolean keepExec = true;
        for (HostEvalNode node : tabTasks) {
            if (node.getMappedStorage() == null || node.getMappedStorage().getErrorCode() != 0) continue;
            keepExec = false;
            LOGGER.info("Initializing the pop-up window.");
            StorUpAddDevDialog storUpAddDevDialog = new StorUpAddDevDialog(this);
            LOGGER.info("Start displaying the pop-up window");
            storUpAddDevDialog.show();
            if (storUpAddDevDialog.getValue() != 0) {
                this.setToolEvaluState(false);
                keepExec = false;
                break;
            }
            keepExec = true;
            break;
        }
        return keepExec;
    }

    private boolean checkStorageMappingHosts(List<HostEvalNode> tabTasks) {
        for (HostEvalNode node : tabTasks) {
            if (!node.getStorageMappingHosts().isEmpty()) continue;
            this.setToolEvaluState(false);
            String tipKey = HostEvalContext.isNeedAddOracleDatabase() ? "eval.host.dev.host.none.host.db.tip" : "eval.host.dev.host.none.host.tip";
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)tipKey));
            return true;
        }
        return false;
    }

    private boolean checkTabTasks(List<HostEvalNode> tabTasks) {
        if (null == tabTasks || tabTasks.isEmpty()) {
            this.setToolEvaluState(false);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"eval.host.dev.storage.none.tip"));
            return true;
        }
        return false;
    }

    private void getIpSet(List<DevNode> allHostDev, Set<String> ipSet) {
        for (DevNode dev : allHostDev) {
            ipSet.add(dev.getDeviceSerialNumber());
        }
    }

    private void getAllHostDev(List<HostEvalNode> tabTasks, List<DevNode> allHostDev) {
        if (null != tabTasks) {
            for (HostEvalNode tabTask : tabTasks) {
                allHostDev.addAll(tabTask.getStorageMappingHosts());
            }
        }
    }

    private boolean endEvalu() {
        if (this.evaluContext.isTaskExecuting()) {
            try {
                this.interruptEvalu();
                String res = this.evaluContext.isEndEvalu() ? "true" : "false";
                LOGGER.info("evalu is doing. set evalu status  isEndEvalu: {}", (Object)res);
            }
            catch (Exception e) {
                LOGGER.error("Log records failed.", e);
            }
            return true;
        }
        return false;
    }

    private boolean checkIsDbUnAssociated() {
        List nodeDevs = DefaultNodeProviderImpl.getInstance().getNodeList();
        Map<DevNode, DevNode> devs = HostEvalContext.getHostMappedDb();
        for (DevNode dNode : nodeDevs) {
            if (!ItDeviceType.Database.equals((Object)dNode.getItDeviceType()) || devs.containsValue(dNode)) continue;
            WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"eval.associate.db.notassociate.evalu.tip"), (String)ResourceUtil.getString((String)"evalu.ui.modifyDev.button.confirm"), (String)ResourceUtil.getString((String)"evalu.ui.modifyDev.button.ignore"), (int)88, (int)88);
            if (wd.getValue() == 0) {
                this.startSetting();
                return false;
            }
            return true;
        }
        return true;
    }

    private List<HostEvalNode> getSelectedTasks(List<HostEvalNode> tabDevs) {
        if (!this.checkSelectDev(tabDevs) || !this.checkFileLimit()) {
            return null;
        }
        if (!this.checkWithHostUser(tabDevs)) {
            return null;
        }
        return tabDevs;
    }

    private boolean checkWithHostUser(List<HostEvalNode> tabDevs) {
        ArrayList<NotAdminUserDeviceInfo> allNotAdminUserDeviceInfo = new ArrayList<NotAdminUserDeviceInfo>();
        for (HostEvalNode hostEvalNode : tabDevs) {
            allNotAdminUserDeviceInfo.addAll(hostEvalNode.getNotAdminUserDeviceInfo());
        }
        if (!allNotAdminUserDeviceInfo.isEmpty()) {
            NotAdminUserInfoDialog dialog = new NotAdminUserInfoDialog((Window)this, allNotAdminUserDeviceInfo);
            dialog.setVisible(true);
            if (0 != dialog.getClickValue()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkFileLimit() {
        File parentFile;
        Object reportPath = HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID);
        File file = parentFile = reportPath != null ? new File(reportPath.toString()) : HostEvalContext.getInstance().getReportDir();
        if (null == parentFile) {
            LOGGER.error("report dir is null.");
            return false;
        }
        File[] listFile = parentFile.listFiles();
        if (null == listFile) {
            LOGGER.info("Folder does not read permissions.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.host.mainDialog.generation.report.task.errorcontents"));
            return false;
        }
        File file2 = new File(parentFile, "canWriteTestDelete.temp");
        try {
            if (file2.exists()) {
                LOGGER.info("the result of delete the file is: {}", (Object)file2.delete());
            }
            if (!file2.createNewFile()) {
                LOGGER.info("Folder does not write permissions.");
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.host.mainDialog.generation.report.task.errorcontents"));
                return false;
            }
            LOGGER.info("the result of delete the file is: {}", (Object)file2.delete());
        }
        catch (IOException e) {
            LOGGER.error("Checking is IO Error.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.host.mainDialog.generation.report.task.errorcontents"));
            return false;
        }
        catch (Error e) {
            LOGGER.error("Folder does not read permissions.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.host.mainDialog.generation.report.task.errorcontents"));
            return false;
        }
        return true;
    }

    private boolean checkSelectDev(List<HostEvalNode> tabDevs) {
        long totalHosts = 0L;
        long maxSize = totalHosts * 0x100000L * 5L;
        File reportFile = HostEvalContext.getInstance().getReportDir();
        if (null == reportFile) {
            LOGGER.error("report dir is null.");
            return false;
        }
        String filePath = FilesUtil.getCanonicalPath((File)reportFile);
        if (!FileUtils.isDiskFull((String)filePath, (long)maxSize)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"compatibility.compat.exception.disk.not.enough", (Object[])new Object[]{totalHosts * 5L}));
            return false;
        }
        return true;
    }

    private void submitPkgsToEval(List<HostEvalNode> toEvalPkgs) {
        this.evaluatingTaskCount = new AtomicInteger(toEvalPkgs.size());
        this.evaluProcessTip = new EvaluProcessTip();
        this.evaluProcessTip.setTaskCount(toEvalPkgs.size());
        this.evaluProcessTip.setStartTime(System.currentTimeMillis());
        if (HostEvalContext.getInstance().isEndEvalu()) {
            return;
        }
        TaskInfoByUserOPDate taskUserDate = new TaskInfoByUserOPDate();
        List<TaskInfoByUserOPDate> taskUserDateList = HostEvalContext.getInstance().getTaskUserDateList();
        taskUserDateList.add(taskUserDate);
        GrabContext.getInstance().getTaskMap().clear();
        for (HostEvalNode hostEvalTask : toEvalPkgs) {
            TaskDeviceTnfo taskDeviceInfo = new TaskDeviceTnfo(hostEvalTask);
            taskUserDate.getStorageMap().put(hostEvalTask.getIdentifier(), taskDeviceInfo);
            EvalTaskParameters evalTaskParameters = new EvalTaskParameters();
            evalTaskParameters.setCollectResultFile(hostEvalTask.getFileName());
            File reportFile = HostEvalContext.getInstance().getReportDir();
            if (null == reportFile) {
                LOGGER.error("report dir is null.");
                return;
            }
            String filePath = FilesUtil.getCanonicalPath((File)reportFile);
            evalTaskParameters.setEvalResultReportUrl(filePath);
            evalTaskParameters.setHostEvalTask(hostEvalTask);
            evalTaskParameters.setProgressUpdator(this);
            IHostComAnalyze analyzeService = HostComAnalyze.getInstance();
            EvalTaskResult result = analyzeService.onlineAnalyzeCompatibility(evalTaskParameters);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String taskFolderName = "EvaluResult_Storage_" + simpleDateFormat.format(new Date());
            InfoGrabDirPropertiesUtil.setPathParam("info.grab.directory.suffix", taskFolderName);
            result.setTaskFolderName(taskFolderName);
        }
    }

    private void interruptEvalu() {
        if (!this.evaluContext.isEndEvalu()) {
            WarningDialog endWarning = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.out.line.dialog.task.warn.end"));
            if (0 == endWarning.getValue()) {
                Map<GrabDevNode2, GrabThread> grabTaskMap = GrabEngine.getInstance().getCurrThreadMap();
                for (Map.Entry<GrabDevNode2, GrabThread> entry : grabTaskMap.entrySet()) {
                    entry.getValue().setStop(true);
                }
                this.notifyEvalEnd();
                this.layout.getEvaluProcessLabel().setText("");
                return;
            }
            return;
        }
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.out.line.dialog.task.showInfo.end"));
    }

    private void notifyEvalEnd() {
        if (this.evaluContext.isTaskExecuting()) {
            this.setToolEvaluState(false);
            HostEvalContext.setEndEvalu(true);
            this.inerrrutpDialog = new CustMsgProgressDialog((Window)this, ResourceUtil.getString((String)"host.comp.eval.task.eval.stopping.desc"), 395);
            ToolThreadFactory.newDefaultThread((Runnable)new CheckStatusTask()).start();
            this.inerrrutpDialog.setVisible(true);
            return;
        }
    }

    private void setReportDir() {
        Object path = HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID);
        if (path == null) {
            HibernateContainer.getInstance().put(SAVEPATH_DEFAULT_ID, (Object)new File(FileUtil.getDefaultDirectory(), "EvalResult").getAbsoluteFile());
        }
        String[] exts = new String[]{};
        File file = ToolFileChooser.selectFile((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic"), (String[])exts, (String)SAVEPATH_DEFAULT_ID, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.file"), (int)1);
        if (!this.validFile(file)) {
            LOGGER.info("set report for upgrade evalu failed. validFile");
            return;
        }
        if (!file.canWrite()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic.not.canWrite"));
            LOGGER.info("set report directory is not canWrite");
            return;
        }
        this.evaluContext.setReportDir(file);
        LOGGER.info("Set report directory for upgrade evalu: {} success", (Object)FilesUtil.getCanonicalPath((File)file));
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic.success"));
    }

    private boolean validFile(File reportDir) {
        if (null == reportDir) {
            return false;
        }
        try {
            String path = reportDir.getCanonicalPath();
            if (!FileUtil.checkNormalPath(path)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                this.setReportDir();
                return false;
            }
            if (!FileUtil.checkBlankPath(path)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                this.setReportDir();
                return false;
            }
        }
        catch (IOException e1) {
            LOGGER.error("save collect dir failed!!!", e1);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic.error"));
            return false;
        }
        return true;
    }

    public void refreshDetailList(boolean isRewriteDetail) {
        List<HostEvalNode> devs = this.getSelectDevNode();
        if (!isRewriteDetail) {
            return;
        }
        this.layout.getDetailList().setListData(new Object[0]);
        if (devs.size() > 1 || devs.isEmpty()) {
            return;
        }
        HostEvalNode dev = devs.get(0);
        EvalTaskResult resultItems = HostEvalContext.getHostRvalResult().get(dev.getIdentifier());
        this.handleNoDevTip(dev, resultItems);
        this.updateStorageDetail(resultItems);
    }

    public void handleNoDevTip(HostEvalNode dev, EvalTaskResult resultItems) {
        if (!resultItems.getEvalItemList().isEmpty()) {
            ListCellEntity entity = new ListCellEntity();
            entity.setMessageTip(ResourceUtil.getString((String)"eval.ui.start.load.storage.info.end"));
            entity.setShowSingleTip(true);
            resultItems.getEvalDetailListHead().remove(entity);
            entity.setMessageTip(ResourceUtil.getString((String)"eval.ui.start.load.storage.info.start"));
            resultItems.getEvalDetailListHead().remove(entity);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }

    private IsmTableCell.IconCell getExecIconByEvaluState(TaskStatusEnum state) {
        IsmTableCell.IconCell iconCell = null;
        String evalueStateStr = "";
        ImageIcon imageIcon = null;
        switch (state) {
            case NOT_EVALUATION: 
            case WAIT_TOGO: {
                evalueStateStr = ResourceUtil.getString((String)"host.comp.eval.task.eval.wait.for.eval");
                imageIcon = EvaluConstants.WAIT_EVALU_IMG;
                break;
            }
            case EVALUATING: {
                evalueStateStr = ResourceUtil.getString((String)TaskStatusEnum.EVALUATING.getStatusI18nStr());
                imageIcon = this.evaluContext.getProcessingImage();
                break;
            }
            case EVALUATION_STOP: {
                evalueStateStr = ResourceUtil.getString((String)"host.comp.eval.task.eval.stopped.status");
                imageIcon = EvaluConstants.EVAL_EXPT_IMG;
                break;
            }
            default: {
                evalueStateStr = ResourceUtil.getString((String)"host.comp.eval.task.eval.finish.status");
                imageIcon = EvaluConstants.SUCCESS_IMG;
            }
        }
        this.startGifSwitch(state);
        iconCell = new IsmTableCell.IconCell((Icon)imageIcon, evalueStateStr);
        return iconCell;
    }

    private IsmTableCell.IconCell getIconByEvaluState(TaskStatusEnum state) {
        IsmTableCell.IconCell iconCell = null;
        String evalueStateStr = ResourceUtil.getString((String)state.getStatusI18nStr());
        ImageIcon imageIcon = null;
        switch (state) {
            case EVALUATION_PASS: {
                imageIcon = EvaluConstants.SUCCESS_IMG;
                break;
            }
            case EVALUATION_CAN_NOTEVAL: {
                imageIcon = EvaluConstants.NOCHECK_IMG;
                break;
            }
            case EXCEPTION_STOP: {
                break;
            }
            case EVALUATION_STOP: {
                imageIcon = EvaluConstants.EVAL_EXPT_IMG;
                break;
            }
            case EVALUATION_NOTPASS: {
                imageIcon = EvaluConstants.FAILED_IMG;
                break;
            }
            default: {
                imageIcon = EvaluConstants.WARING_IMG;
            }
        }
        this.startGifSwitch(state);
        iconCell = new IsmTableCell.IconCell((Icon)imageIcon, evalueStateStr);
        return iconCell;
    }

    private void startGifSwitch(TaskStatusEnum state) {
        if (TaskStatusEnum.EVALUATING.equals((Object)state) && !this.gifAssistant.isStart()) {
            this.gifAssistant.setObserver((GifAssistant.IGifUiObserver)this);
            this.gifAssistant.start();
        }
    }

    public void refreshLoadingPic() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List loadingRows = HostEvaluMainDialog.this.findLoadingRows();
                if (!HostEvaluMainDialog.this.isTaskRunning()) {
                    HostEvaluMainDialog.this.gifAssistant.stopGifLoading();
                    return;
                }
                for (TableRow row : loadingRows) {
                    IsmTableCell.IconCell iconCellStatus = new IsmTableCell.IconCell((Icon)HostEvaluMainDialog.this.gifAssistant.getProcessingImage(), ResourceUtil.getString((String)TaskStatusEnum.EVALUATING.getStatusI18nStr()));
                    iconCellStatus.setCellAlign(0);
                    row.setValueAt(7, (Object)iconCellStatus);
                }
                HostEvaluMainDialog.this.layout.getDevEvaluTable().repaint();
            }
        });
    }

    private boolean isTaskRunning() {
        for (Map.Entry<String, EvalTaskResult> entry : HostEvalContext.getHostRvalResult().entrySet()) {
            EvalTaskResult result = entry.getValue();
            if (null == result.getTaskStatus() || TaskStatusEnum.isTaskFinished(result.getTaskStatus())) continue;
            return true;
        }
        return false;
    }

    private List<TableRow> findLoadingRows() {
        LinkedList<TableRow> loadingRows = new LinkedList<TableRow>();
        List allRows = this.layout.getTableModel().getAllRows();
        for (TableRow row : allRows) {
            if (!this.isLoadingRow((TableRow<com.huawei.ism.tool.framework.pubservice.entity.DevNode, String>)row)) continue;
            loadingRows.add(row);
        }
        return loadingRows;
    }

    private boolean isLoadingRow(TableRow<com.huawei.ism.tool.framework.pubservice.entity.DevNode, String> row) {
        IsmTableCell.IconCell iconCell = (IsmTableCell.IconCell)row.getValueAt(7);
        if (iconCell == null) {
            return false;
        }
        return iconCell.toString().equals(ResourceUtil.getString((String)TaskStatusEnum.WAIT_TOGO.getStatusI18nStr())) || iconCell.toString().equals(ResourceUtil.getString((String)TaskStatusEnum.EVALUATING.getStatusI18nStr()));
    }

    public HostEvaluMainDialogLayout getMainLayout() {
        return this.layout;
    }

    private void resetSelectedDev(List<HostEvalNode> evaluDevs) {
        EvalTaskResult initalStatus = new EvalTaskResult();
        initalStatus.setProgressCurrent(0.0f);
        initalStatus.setTaskStatus(TaskStatusEnum.WAIT_TOGO);
        initalStatus.setCreateTime(new Date());
        HostEvalContext.getCurHostRvalResult().clear();
        for (HostEvalNode dev : evaluDevs) {
            initalStatus.setHostEvalTask(dev);
            this.updateDevTableRow(dev, initalStatus);
            EvalTaskResult evalTaskResult = new EvalTaskResult();
            evalTaskResult.setHostEvalTask(dev);
            for (DevNode node : dev.getStorageMappingHosts()) {
                EvalItemResult evalItemResult = this.initDetailRow(node);
                if (!evalTaskResult.getEvalItemList().contains(evalItemResult)) {
                    evalTaskResult.getEvalItemList().add(evalItemResult);
                }
                evalItemResult.setCreateTime(new Date());
                evalItemResult.setItemResultEnum(ItemResultEnum.WAIT_TOGO);
                evalItemResult.setHostEvalTask(dev);
                this.updateEvalDetail(evalItemResult);
            }
            HostEvalContext.getHostRvalResult().put(dev.getIdentifier(), evalTaskResult);
            HostEvalContext.getCurHostRvalResult().put(dev.getIdentifier(), evalTaskResult);
        }
        this.layout.getEvaluProcessLabel().setText("");
    }

    public TableRow<HostEvalNode, String> getTableRowById(String id) {
        List tableRows = this.layout.getDevEvaluTable().getAllRows();
        for (TableRow row : tableRows) {
            if (!row.getIdentifier().equals(id)) continue;
            return row;
        }
        return null;
    }

    private void modifyTableRow(HostEvalNode dev, EvalTaskResult taskResult) {
        LOGGER.info("dev info:{}", (Object)dev.getIdentifier());
        TableRow<HostEvalNode, String> row = this.getTableRowById(dev.getIdentifier());
        if (null == row || taskResult.getTaskStatus() == null) {
            LOGGER.info("row or taskResult.getTaskStatus() is null . dev info:{}", (Object)dev.getIdentifier());
            return;
        }
        TaskStatusEnum evaluState = taskResult.getTaskStatus();
        if (!this.isTaskRunning()) {
            this.gifAssistant.stopGifLoading();
        }
        IsmTableCell.IconCell iconCellResult = this.getIconByEvaluState(evaluState);
        iconCellResult.setCellAlign(0);
        row.setValueAt(8, (Object)iconCellResult);
        if (TaskStatusEnum.isTaskFinished(evaluState)) {
            if (TaskStatusEnum.EVALUATION_STOP.equals((Object)evaluState)) {
                row.setValueAt(8, (Object)"");
            }
        } else {
            row.setValueAt(8, (Object)"");
        }
        IsmTableCell.IconCell iconCellStatus = this.getExecIconByEvaluState(evaluState);
        iconCellStatus.setCellAlign(0);
        row.setValueAt(7, (Object)iconCellStatus);
        row.setValueAt(6, (Object)new IsmTableCell.ProgressCell(taskResult.getTaskProgressBar().intValue()));
        row.setValueAt(4, (Object)DateUtil.formatDate((Date)taskResult.getStartEvaTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.layout.getDevEvaluTable().repaint();
    }

    private void openHelpFile(String fileName, Window parent) {
        String htmlFileName = fileName + "_" + LanguageManager.getInstance().getCurrentLanguage().getLanguage() + (ApplicationContext.getInstance().isWindowsOS() ? ".chm" : ".pdf");
        String workDir = ApplicationContext.getInstance().getWorkPath();
        File helpFilePath = new File(workDir, "help");
        File helpFile = new File(helpFilePath, htmlFileName);
        LOGGER.info("explorer help file:{}", (Object)helpFile);
        if (!helpFile.exists()) {
            this.evaluContext.setOpenHelpFile(2);
            if (ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString((String)"evalu.help.warning"));
        } else {
            OSCmdUtils.openFile((File)helpFile);
            this.evaluContext.setOpenHelpFile(1);
        }
    }

    public void updateDevTableRow(final HostEvalNode dev, final EvalTaskResult taskResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HostEvaluMainDialog.this.modifyTableRow(dev, taskResult);
                }
                catch (Exception e) {
                    LOGGER.error("Exec error", e);
                }
            }
        });
    }

    public void showTaskErr(String errMsg) {
        DialogUtils.showErrorDialog((JDialog)this, (String)errMsg);
    }

    public void doHelpActionWork() {
        this.openHelpFile("UpgradeEvaluation_Compatibility", this);
    }

    public String getListenerName() {
        return "HelpTitleDialog:" + this.getClass().getSimpleName();
    }

    @Override
    public void updateEvaluProcessTip() {
        Map<String, EvalTaskResult> resultMap = HostEvalContext.getCurHostRvalResult();
        block4: for (Map.Entry<String, EvalTaskResult> entry : resultMap.entrySet()) {
            EvalTaskResult taskResult = entry.getValue();
            switch (taskResult.getTaskStatus()) {
                case EVALUATION_PASS: {
                    this.evaluProcessTip.setPassCount(this.evaluProcessTip.getPassCount() + 1);
                    continue block4;
                }
                case EVALUATION_CAN_NOTEVAL: {
                    this.evaluProcessTip.setCanNotEvaluCount(this.evaluProcessTip.getCanNotEvaluCount() + 1);
                    continue block4;
                }
            }
            this.evaluProcessTip.setNotPassCount(this.evaluProcessTip.getNotPassCount() + 1);
        }
    }

    private void hideBzyDialogIfEvalStopped() {
        if (this.inerrrutpDialog != null) {
            this.inerrrutpDialog.setVisible(false);
            this.inerrrutpDialog.dispose();
            this.inerrrutpDialog = null;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    @Override
    public void updateEvalDetail(final EvalItemResult itemResult) {
        List<HostEvalNode> selectDevs = this.getSelectDevNode();
        if (selectDevs.size() > 1) {
            this.layout.getDetailList().setListData(new Object[0]);
            return;
        }
        if (selectDevs.size() != 1 || !selectDevs.get(0).getIdentifier().equals(itemResult.getHostEvalTask().getIdentifier())) {
            return;
        }
        LOGGER.info("{}====================================", (Object)itemResult);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EvalTaskResult taskResult = HostEvalContext.getHostRvalResult().get(itemResult.getHostEvalTask().getIdentifier());
                HostEvaluMainDialog.this.updateStorageDetail(taskResult);
            }
        });
    }

    @Override
    public void updateProgress(EvalTaskResult taskResult) {
        this.updateDevTableRow(taskResult.getHostEvalTask(), taskResult);
    }

    public void updateStorageDetail(EvalTaskResult taskResult) {
        List<HostEvalNode> selectDevs = this.getSelectDevNode();
        if (selectDevs.size() > 1) {
            this.layout.getDetailList().setListData(new Object[0]);
            return;
        }
        if (selectDevs.size() != 1 || !selectDevs.get(0).getIdentifier().equals(taskResult.getHostEvalTask().getIdentifier())) {
            return;
        }
        List<ListCellEntity<ItemResultEnum>> cellDetailListEnd = taskResult.getEvalDetailListEnd();
        List<ListCellEntity<ItemResultEnum>> cellDetailListStart = taskResult.getEvalDetailListHead();
        Object[] details = taskResult.getEvalItemList().toArray();
        Object[] detailsStart = cellDetailListStart.toArray(new Object[0]);
        Object[] detailsCell = cellDetailListEnd.toArray(new Object[0]);
        Object[] detailsNew = new Object[details.length + cellDetailListEnd.size()];
        System.arraycopy(details, 0, detailsNew, 0, details.length);
        System.arraycopy(detailsCell, 0, detailsNew, details.length, detailsCell.length);
        Object[] detailsFinal = new Object[detailsNew.length + cellDetailListStart.size()];
        System.arraycopy(detailsStart, 0, detailsFinal, 0, cellDetailListStart.size());
        System.arraycopy(detailsNew, 0, detailsFinal, detailsStart.length, detailsNew.length);
        this.layout.getDetailList().setListData(detailsFinal);
    }

    private static void setInstance(HostEvaluMainDialog instance) {
        HostEvaluMainDialog.instance = instance;
    }

    public static HostEvaluMainDialog getInstance() {
        return instance;
    }

    private void initStorageTable() {
        List allDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        for (DevNode devNode : allDevNodes) {
            this.createStorageTableRow(devNode);
        }
    }

    private void createStorageTableRow(DevNode devNode) {
        EvalTaskResult evalTaskResult = new EvalTaskResult();
        com.huawei.ism.tool.framework.pubservice.entity.TaskResult taskResult = new com.huawei.ism.tool.framework.pubservice.entity.TaskResult();
        if (this.checkDevSupport(devNode, taskResult)) {
            return;
        }
        if (!ItDeviceType.Storage.equals((Object)devNode.getItDeviceType())) {
            return;
        }
        if (HostEvaluMainDialog.isLimitDevice(devNode)) {
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.import.tv1.fail"));
            this.deviceImportResult.put(devNode, taskResult.getErrorLocaleDescription());
            return;
        }
        HostEvalNode hostEvalNode = this.initHostEvalNode(devNode);
        taskResult.setResult(TaskResult.Result.SUCCESS);
        String successDes = CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.import.success");
        taskResult.setErrorLocaleDescription(successDes);
        taskResult.setResultObject((Object)hostEvalNode);
        this.fill2Table(taskResult);
        evalTaskResult.setHostEvalTask(hostEvalNode);
        HostEvalContext.getHostRvalResult().put(hostEvalNode.getIdentifier(), evalTaskResult);
        this.deviceImportResult.put(devNode, taskResult.getErrorLocaleDescription());
    }

    private boolean checkDevSupport(DevNode devNode, com.huawei.ism.tool.framework.pubservice.entity.TaskResult taskResult) {
        if (HostEvaluMainDialog.isNotNeedExcuteHostComp(devNode)) {
            LOGGER.info("the device upgrade mode is OFFLINECUSTOMIZE or OFFLINE");
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.offline.custom.model"));
            this.deviceImportResult.put(devNode, taskResult.getErrorLocaleDescription());
            return true;
        }
        if (HostEvaluMainDialog.isPeerDevice(devNode)) {
            LOGGER.info("the device is peer device and in svp");
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.svp.add.device"));
            this.deviceImportResult.put(devNode, taskResult.getErrorLocaleDescription());
            return true;
        }
        if (ArrayUtils.isHighEndDevOuterSvp((DevNode)devNode) && !devNode.canEnterDiagnose()) {
            LOGGER.info("the device is hign end add not in svp");
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.outer.svp.add.device"));
            this.deviceImportResult.put(devNode, taskResult.getErrorLocaleDescription());
            return true;
        }
        return false;
    }

    public static boolean isNotNeedExcuteHostComp(DevNode devNode) {
        Map<String, String> devSceneDataExt;
        SceneDataSerialize dataOperate = new SceneDataSerialize();
        Map upgradeSettings = (Map)dataOperate.deserialize();
        String key = devNode.getIp() + "_" + devNode.getDeviceSerialNumber();
        if (null == upgradeSettings) {
            LOGGER.error("the scene setting file is empty");
            return false;
        }
        UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
        if (null == data) {
            LOGGER.error("the data is null");
            return false;
        }
        LOGGER.info("the device is:{},the upgrade mode is :{}", (Object)key, (Object)data.getUpgradeMode());
        boolean supportShareCard = false;
        boolean stopHostBusiness = false;
        Map<String, Map<String, String>> sceneDataExtMap = SceneDataExtendUtil.getInstance().parseSceneDataExt();
        if (null != sceneDataExtMap && null != (devSceneDataExt = sceneDataExtMap.get(key))) {
            supportShareCard = Boolean.parseBoolean(devSceneDataExt.get("supportShareCard"));
            stopHostBusiness = Boolean.parseBoolean(devSceneDataExt.get("stopBusiness"));
        }
        String upgradeMode = EvaluCommUtil.getActualMode(data.getUpgradeMode());
        return supportShareCard || UpgradeMode.OFFLINE.toString().equalsIgnoreCase(upgradeMode) || UpgradeMode.ONLINE.toString().equalsIgnoreCase(upgradeMode) && stopHostBusiness;
    }

    public static boolean isPeerDevice(DevNode devNode) {
        LOGGER.info("the device is: ,it is :{}", (Object)devNode.isIpListAreInnerIp());
        if (!LocalHostUtil.isRunInV3LaterSvp()) {
            return false;
        }
        return !devNode.isIpListAreInnerIp();
    }

    private HostEvalNode initHostEvalNode(DevNode devNode) {
        HostEvalNode hostEvalNode = new HostEvalNode();
        hostEvalNode.setStorageIp(devNode.getIp());
        hostEvalNode.setStorageName(devNode.getDeviceName());
        hostEvalNode.setStorageSn(devNode.getDeviceSerialNumber());
        hostEvalNode.setImportTime(new Date());
        hostEvalNode.setProgress(0);
        hostEvalNode.setStorageProductVersion(devNode.getProductVersion());
        hostEvalNode.setStorageType(devNode.getDeviceType().toString());
        HostEvalContext.getStorageMap().put(devNode.getDeviceSerialNumber(), hostEvalNode);
        return hostEvalNode;
    }

    private void fill2Table(com.huawei.ism.tool.framework.pubservice.entity.TaskResult taskResult) {
        TableRow<HostEvalNode, String> row;
        DefaultTableModel tableModel = this.getMainLayout().getTableModel();
        List rows = tableModel.getAllRows();
        if (!rows.contains(row = this.createTableRow(taskResult, tableModel.getColumnCount()))) {
            rows.add(0, row);
            RowSorter rowSorter = this.getMainLayout().getDevEvaluTable().getRowSorter();
            if (rowSorter != null) {
                rowSorter.setSortKeys(new ArrayList());
            }
            tableModel.removeAll();
            tableModel.addRows(rows);
        } else {
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(ResourceUtil.getString((String)"evalu.ui.import.info.analyze.importinfo.result.exist"));
        }
    }

    private TableRow<HostEvalNode, String> createTableRow(com.huawei.ism.tool.framework.pubservice.entity.TaskResult taskResult, int columnCount) {
        HostEvalNode evaluateNode = (HostEvalNode)taskResult.getResultObject();
        String identifier = evaluateNode.getIdentifier();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)evaluateNode, (Object)identifier);
        int columnNum = 0;
        row.setValueAt(columnNum++, (Object)evaluateNode.getStorageType());
        row.setValueAt(columnNum++, (Object)evaluateNode.getStorageProductVersion());
        row.setValueAt(columnNum++, (Object)evaluateNode.getStorageIp());
        row.setValueAt(columnNum++, (Object)evaluateNode.getStorageSn());
        row.setValueAt(columnNum++, (Object)"--");
        this.updateQueryStorageProgress((TableRow<HostEvalNode, String>)row, columnNum, true, 0.0f);
        int n = ++columnNum;
        row.setValueAt(n, (Object)new IsmTableCell.ProgressCell(0));
        IsmTableCell.IconCell iconCell = new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"notevalu.png"), ResourceUtil.getString((String)TaskStatusEnum.NOT_EVALUATION.getStatusI18nStr()));
        iconCell.setCellAlign(0);
        int n2 = ++columnNum;
        ++columnNum;
        row.setValueAt(n2, (Object)iconCell);
        return row;
    }

    public void updateQueryStorageProgress(TableRow<HostEvalNode, String> row, int columnNum, boolean isLoading, float progressNum) {
        IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)EvaluConstants.WAITING_IMG, ResourceUtil.getStringWithParams((String)"eval.prepare.query.storageinfo.progress.tip", (Object[])new Object[]{String.format(Locale.ENGLISH, "%.2f", Float.valueOf(progressNum))}));
        cell.setCellAlign(0);
        row.setValueAt(columnNum, (Object)cell);
        if (isLoading) {
            EvaluConstants.WAITING_IMG.setImageObserver(this);
            this.gifAssistant.setObserver((GifAssistant.IGifUiObserver)this);
            this.gifAssistant.start();
        }
    }

    public List<HostEvalNode> addHostOrDbDevice(DevNode devNode, List<String> storageSns, boolean automatic) {
        ArrayList<HostEvalNode> hostEvalNodes = new ArrayList<HostEvalNode>();
        try {
            if (null == devNode || devNode.getItDeviceType() == null || ItDeviceType.Storage.equals((Object)devNode.getItDeviceType())) {
                return hostEvalNodes;
            }
            if (this.isEmpty(storageSns) && devNode.getItDeviceType().equals((Object)ItDeviceType.Host)) {
                storageSns = this.getStorageSnByHostDevice(devNode);
            }
            LOGGER.info("***[host: {}, SN: {}, associate storage: {}]***", devNode.getIp(), devNode.getDeviceSerialNumber(), storageSns);
            for (String storageSn : storageSns) {
                HostEvalNode hostEvalNode = this.doModify(storageSn, devNode, automatic);
                if (null != hostEvalNode) {
                    hostEvalNodes.add(hostEvalNode);
                    this.updateStorageAddedHostNumber(hostEvalNode);
                }
                this.refreshDetailList(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("***[update added hosts numbers fail]***", e);
        }
        return hostEvalNodes;
    }

    public List<HostEvalNode> addHostOrDbDevice(DevNode devNode, String storageSn, boolean automatic) {
        ArrayList<String> storageSns = new ArrayList<String>();
        if (StringUtils.isNotBlank(storageSn)) {
            storageSns.add(storageSn);
        }
        return this.addHostOrDbDevice(devNode, storageSns, automatic);
    }

    public void removeHostOrDbDevice(DevNode devNode, HostEvalNode hostEvalNode) {
        if (null != hostEvalNode) {
            this.removeDevice(hostEvalNode, devNode);
            this.removeStorageAssociatedDetailItem(hostEvalNode.getStorageSn(), devNode);
        }
    }

    public void removeHostOrDbDevice(List<DevNode> notSelectDevices, HostEvalNode hostEvalNode) {
        for (DevNode dev : notSelectDevices) {
            this.removeHostOrDbDevice(dev, hostEvalNode);
        }
        this.refreshDetailList(true);
        this.updateStorageAddedHostNumber(hostEvalNode);
    }

    private void removeDevice(HostEvalNode hostEvalNode, DevNode devNode) {
        if (this.isAddedBefore(devNode, hostEvalNode.getStorageMappingHosts())) {
            hostEvalNode.getStorageMappingHosts().remove(devNode);
        }
        if (!this.isAddedBefore(devNode, hostEvalNode.getUnAssociateHosts())) {
            hostEvalNode.getUnAssociateHosts().add(devNode);
        }
        if (this.isAddedBefore(devNode, hostEvalNode.getManulAssociatedHosts())) {
            hostEvalNode.getManulAssociatedHosts().remove(devNode);
        }
    }

    public void setStorageAndHostAssociation(List<DevNode> devNodes, String storageSn) {
        HostEvalNode hostEvalNode = (HostEvalNode)HostEvalContext.getStorageMap().get(storageSn);
        if (null == hostEvalNode) {
            return;
        }
        this.cacheAndClearMainDialogTableData(storageSn, hostEvalNode);
        for (DevNode devNode : devNodes) {
            this.addHostOrDbDevice(devNode, storageSn, false);
        }
    }

    private void cacheAndClearMainDialogTableData(String storageSn, HostEvalNode hostEvalNode) {
        List oldRows = this.layout.getDevEvaluTable().getAllRows();
        String rowsJsonStr = JSON.toJSONString(oldRows);
        cacheStorageTableMap.put(storageSn, rowsJsonStr);
        EvalTaskResult evalTaskResult = HostEvalContext.getHostRvalResult().get(storageSn);
        String detailJsonStr = JSON.toJSONString(evalTaskResult.getEvalItemList());
        cacheDetailsMap.put(storageSn, detailJsonStr);
    }

    public void restoreMainDialogTableData(String storageSn) {
        String rowsJsonStr = cacheStorageTableMap.get(storageSn);
        List<TableRow> cloneRows = JSON.parseObject(rowsJsonStr, new TypeReference<List<TableRow>>(){}, new Feature[0]);
        EvalTaskResult evalTaskResult = HostEvalContext.getHostRvalResult().get(storageSn);
        if (null == cloneRows || null == evalTaskResult) {
            return;
        }
        DefaultTableModel tableModel = this.getMainLayout().getTableModel();
        tableModel.removeAll();
        tableModel.addRows(cloneRows);
        String detailJsonStr = cacheDetailsMap.get(storageSn);
        List<EvalItemResult> details = JSON.parseObject(detailJsonStr, new TypeReference<List<EvalItemResult>>(){}, new Feature[0]);
        evalTaskResult.setEvalItemList(details);
    }

    public void addOrRemoveDb(DevNode devNode, String storageSn) {
        try {
            if (null == devNode || !devNode.getItDeviceType().equals((Object)ItDeviceType.Database)) {
                return;
            }
            this.doModify(storageSn, devNode, true);
        }
        catch (Exception e) {
            LOGGER.error("***[add or remove added database fail]***", e);
        }
    }

    private HostEvalNode doModify(String storageSn, DevNode devNode, boolean automatic) {
        HostEvalNode hostEvalNode = null;
        if (null != storageSn && null != (hostEvalNode = this.getHostEvalNodeFromRow(storageSn)) && !this.isAddedBefore(devNode, hostEvalNode.getStorageMappingHosts())) {
            this.addedNumber(hostEvalNode, devNode, automatic);
            this.addStorageAssociatedDetailItem(storageSn, devNode);
        }
        return hostEvalNode;
    }

    private HostEvalNode getHostEvalNodeFromRow(String storageSn) {
        HostEvalNode hostEvalNode = null;
        TableRow<HostEvalNode, String> row = this.getTableRowById(storageSn);
        if (row != null) {
            hostEvalNode = (HostEvalNode)row.getUserObject();
        } else {
            LOGGER.error("getTableRowById is filed,row =null");
        }
        return hostEvalNode;
    }

    public void updateDevs(String storageSn, DevNode devNode, HostEvalNode hostEvalNode) {
        try {
            List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
            if (!NodeAddEnum.ONLINE.equals((Object)devNode.getNodeAddType())) {
                this.removeSameDev(devNode, devs);
            }
            List<DevNode> storDevs = hostEvalNode.getStorageMappingHosts();
            this.replaceDev(devNode, storDevs);
            this.replaceDev(devNode, hostEvalNode.getManulAssociatedHosts());
            this.replaceDev(devNode, hostEvalNode.getUnAssociateHosts());
            HostEvalContext.getStorageMap().put(storageSn, hostEvalNode);
        }
        catch (Exception e) {
            LOGGER.error("delete devnode error", e);
        }
    }

    public void replaceDev(DevNode devNode, List<DevNode> storDevs) {
        if (this.isAddedBefore(devNode, storDevs)) {
            for (int i = 0; i < storDevs.size(); ++i) {
                if (!this.isDevSame(devNode, storDevs.get(i))) continue;
                storDevs.remove(i);
                storDevs.add(i, devNode);
                break;
            }
        }
    }

    public boolean isAddedBefore(DevNode devNode, List<DevNode> devs) {
        for (DevNode dv : devs) {
            if (!this.isDevSame(devNode, dv)) continue;
            return true;
        }
        return false;
    }

    public boolean isDevSame(DevNode devNode, DevNode dv) {
        return dv.getDeviceSerialNumber().contains(devNode.getDeviceSerialNumber()) || devNode.getDeviceSerialNumber().contains(dv.getDeviceSerialNumber());
    }

    public void removeSameDev(DevNode devNode, List<DevNode> devs) {
        for (DevNode dv : devs) {
            if (!dv.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber())) continue;
            try {
                DefaultNodeProviderImpl.getInstance().removeNode(dv);
            }
            catch (ToolException e) {
                LOGGER.error("execute cmd error", e);
            }
        }
    }

    private void addStorageAssociatedDetailItem(String storageSn, DevNode devNode) {
        EvalTaskResult evalTaskResult = HostEvalContext.getHostRvalResult().get(storageSn);
        EvalItemResult evalItemResult = this.initDetailRow(devNode);
        this.removeDuplicated(evalTaskResult, evalItemResult);
        evalTaskResult.getEvalItemList().add(evalItemResult);
        evaluateItemMap.put(devNode.getDeviceSerialNumber(), evalItemResult);
    }

    public void removeDuplicated(EvalTaskResult evalTaskResult, EvalItemResult evalItemResult) {
        Iterator<EvalItemResult> it = evalTaskResult.getEvalItemList().iterator();
        while (it.hasNext()) {
            EvalItemResult item = it.next();
            if (!item.equals(evalItemResult) || item.getEvalDevNode() == null || evalItemResult.getEvalDevNode() == null || !item.getEvalDevNode().getDeviceSerialNumber().equals(evalItemResult.getEvalDevNode().getDeviceSerialNumber())) continue;
            it.remove();
            break;
        }
    }

    private void removeStorageAssociatedDetailItem(String storageSn, DevNode devNode) {
        EvalTaskResult evalTaskResult = HostEvalContext.getHostRvalResult().get(storageSn);
        Iterator<EvalItemResult> it = evalTaskResult.getEvalItemList().iterator();
        while (it.hasNext()) {
            EvalItemResult result = it.next();
            if (!devNode.getDeviceSerialNumber().equals(result.getEvalDevNode().getDeviceSerialNumber()) || !devNode.getDevKey().equals(result.getEvalDevNode().getDevKey())) continue;
            it.remove();
        }
    }

    private void addedNumber(HostEvalNode hostEvalNode, DevNode devNode, boolean automatic) {
        hostEvalNode.getStorageMappingHosts().add(devNode);
        if (!automatic) {
            if (!this.isAddedBefore(devNode, hostEvalNode.getManulAssociatedHosts())) {
                hostEvalNode.getManulAssociatedHosts().add(devNode);
            }
            if (this.isAddedBefore(devNode, hostEvalNode.getUnAssociateHosts())) {
                hostEvalNode.getUnAssociateHosts().remove(devNode);
            }
        }
    }

    private List<String> getStorageSnByHostDevice(DevNode devNode) {
        List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
        return this.checkHostWwnMapping(storageInfos, devNode);
    }

    private List<String> getWwns(Launcher launcher) {
        ArrayList<String> wwns = new ArrayList<String>();
        if (null == launcher) {
            return wwns;
        }
        wwns.addAll(launcher.getFcWwns());
        wwns.addAll(launcher.getiSCSIWwns());
        wwns.addAll(launcher.getIBWwns());
        wwns.addAll(launcher.getNVMEWwns());
        return wwns;
    }

    private List<String> checkHostWwnMapping(List<StorageInfo> storageInfos, DevNode devNode) {
        ArrayList<String> storageSns = new ArrayList<String>();
        Launcher launcher = GrabContext.getInstance().getLauncher(devNode.getDevKey());
        List<String> wwns = this.getWwns(launcher);
        if (!this.hasStoragesAndWwns(storageInfos)) {
            return storageSns;
        }
        for (StorageInfo storageInfo : storageInfos) {
            if (this.checkStorageHostsAssociation(storageInfo, devNode, wwns)) {
                storageSns.add(storageInfo.getStorageSn());
                continue;
            }
            this.saveNotAllowAssociateStorage(devNode, wwns, storageInfo, launcher);
        }
        return storageSns;
    }

    private void saveNotAllowAssociateStorage(DevNode devNode, List<String> wwns, StorageInfo storageInfo, Launcher launcher) {
        if (this.checkNotAllowAssociate(storageInfo, launcher)) {
            LOGGER.info("***[host: {}, not allow associte to storage: {}]***", (Object)devNode.getIp(), (Object)storageInfo.getStorageSn());
            List<String> notAllowAssociatedStorages = HostEvalContext.getNotAllowAssociatedStorageMap().get(devNode.getDevKey());
            if (this.isEmpty(notAllowAssociatedStorages)) {
                notAllowAssociatedStorages = new ArrayList<String>();
                HostEvalContext.getNotAllowAssociatedStorageMap().put(devNode.getDevKey(), notAllowAssociatedStorages);
            }
            notAllowAssociatedStorages.add(storageInfo.getStorageSn());
        }
    }

    private boolean checkNotAllowAssociate(StorageInfo storageInfo, Launcher launcher) {
        try {
            if (null == launcher || null == launcher.getOtherDataMap().get("queryWwnSuccess")) {
                return false;
            }
            Boolean hostQueryFlag = (Boolean)launcher.getOtherDataMap().get("queryWwnSuccess");
            return true == hostQueryFlag && storageInfo.getErrorCode() == 0;
        }
        catch (Exception e) {
            LOGGER.error("***[checkNotAllowAssociate error]***", e);
            return false;
        }
    }

    private boolean checkStorageHostsAssociation(StorageInfo storageInfo, DevNode devNode, List<String> wwns) {
        int oneVsmultipleMappingNumber = this.getMappingNumber(storageInfo, devNode, wwns);
        this.saveOneVsMultipleNumber(storageInfo, devNode.getDeviceSerialNumber(), oneVsmultipleMappingNumber);
        return oneVsmultipleMappingNumber > -1;
    }

    public void checkStorageHostsAssociation(StorageInfo storageInfo, List<DevNode> devNodes) {
        for (DevNode devNode : devNodes) {
            Launcher launcher = GrabContext.getInstance().getLauncher(devNode.getDevKey());
            List<String> wwns = this.getWwns(launcher);
            this.getMappingNumber(storageInfo, devNode, wwns);
        }
    }

    private int getMappingNumber(StorageInfo storageInfo, DevNode devNode, List<String> wwns) {
        int oneVsmultipleMappingNumber = -1;
        List hosts = storageInfo.getHostList();
        if (hosts == null) {
            return oneVsmultipleMappingNumber;
        }
        for (UpgradeHostInfo upgradeHostInfo : hosts) {
            List inits = upgradeHostInfo.getInitList();
            if (!this.checkWwnMapping(wwns, inits, storageInfo.getStorageSn())) continue;
            LOGGER.info("***[host: {}, wwns: {}, storage: {}, inits{}]***", devNode.getIp(), wwns, storageInfo.getStorageSn(), inits);
            ++oneVsmultipleMappingNumber;
        }
        return oneVsmultipleMappingNumber;
    }

    private void saveOneVsMultipleNumber(StorageInfo storageInfo, String deviceSn, int multipleMappingNumber) {
        HostEvalNode hostEvalNode;
        if (multipleMappingNumber > 0 && null != (hostEvalNode = this.getHostEvalNodeFromRow(storageInfo.getStorageSn()))) {
            hostEvalNode.getOneVsMultipleLogicalHostMap().put(deviceSn, multipleMappingNumber);
        }
    }

    private boolean checkWwnMapping(List<String> wwns, List<Map<String, String>> inits, String storageSn) {
        boolean isHostMapped = false;
        for (String wwn : wwns) {
            for (Map<String, String> map : inits) {
                String mappingWwn = this.removeHexHead(map.get("ID"));
                String tempWwn = this.removeHexHead(wwn);
                if (StringUtils.isBlank(mappingWwn) || StringUtils.isBlank(tempWwn)) {
                    return false;
                }
                if (!this.removeHexHead(wwn).equalsIgnoreCase(this.removeHexHead(mappingWwn))) continue;
                map.put("WWN_MAPPED", String.valueOf(true));
                map.put("WWN_MAPPED_STORAGE", storageSn);
                isHostMapped = true;
            }
        }
        return isHostMapped;
    }

    private String removeHexHead(String hexString) {
        String newHexStr = hexString.replaceAll("^0[x|X]", "");
        return newHexStr;
    }

    private boolean hasStoragesAndWwns(List<StorageInfo> storageInfos) {
        return !this.isEmpty(storageInfos);
    }

    private <T> boolean isEmpty(List<T> list) {
        return null == list || list.isEmpty();
    }

    public EvalItemResult initDetailRow(DevNode devNode) {
        EvalItemResult evaluateItem = new EvalItemResult();
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setDeviceType(devNode.getItDeviceType());
        itemInfo.setIp(devNode.getIp());
        evaluateItem.setItemInfo(itemInfo);
        evaluateItem.setEvalDevNode(EntityUtils.toNewDev((DevNode)devNode));
        evaluateItem.setItemResultEnum(ItemResultEnum.NOTEVAL);
        return evaluateItem;
    }

    public void updateStorageAddedHostNumber(String devSn, StorageInfo storageinfo) {
        if (null == devSn) {
            return;
        }
        TableRow<HostEvalNode, String> row = this.getTableRowById(devSn);
        if (null == row) {
            return;
        }
        HostEvalNode hostEvalNode = (HostEvalNode)row.getUserObject();
        hostEvalNode.setMappedStorage(storageinfo);
        if (this.queryStorageInfo(storageinfo, row, hostEvalNode)) {
            return;
        }
        Object value = row.getValueAt(5);
        String num = hostEvalNode.getHostAddedAndNotAddedNumbers();
        if (num.equals("0/0")) {
            row.setValueAt(5, (Object)num);
        } else if (value instanceof IsmTableCell.HyperlinkCell) {
            IsmTableCell.HyperlinkCell addedLinkcell = (IsmTableCell.HyperlinkCell)value;
            this.updateCellWordColor(hostEvalNode, num, addedLinkcell);
        } else {
            LabelHyperlinkCell lHLinkCell = new LabelHyperlinkCell(null, num, new ShowHostViewListener(this, hostEvalNode));
            row.setValueAt(5, (Object)lHLinkCell);
        }
        this.layout.getDevEvaluTable().repaint();
    }

    private boolean queryStorageInfo(StorageInfo storageinfo, TableRow<HostEvalNode, String> row, final HostEvalNode hostEvalNode) {
        if (storageinfo.getErrorCode() != 0) {
            String errMesage = ResourceUtil.getString((String)storageinfo.getErrorMsg());
            LabelHyperlinkCell addedLinkcell = new LabelHyperlinkCell(ResourceUtil.getString((String)"evalu.ui.table.storage.host.query.error.requery.tip"), ResourceUtil.getString((String)"evalu.ui.table.storage.host.query.error.requery.retry"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List nodeList = DefaultNodeProviderImpl.getInstance().getNodeList();
                            DevNode dNode = null;
                            if ((dNode = HostEvaluMainDialog.this.getDevNode(nodeList, dNode, hostEvalNode)) == null) {
                                LOGGER.warn("query devnode error...");
                                return;
                            }
                            try {
                                StorInfoProgressUpdater callback = new StorInfoProgressUpdater(dNode);
                                callback.refresh(0.0f);
                                StorageInfoQryTask task = new StorageInfoQryTask(dNode, callback);
                                Future result = AsyncExcutor.submit((Callable)task);
                                LOGGER.info("query storage info error {}", result.get());
                                Object object = lock;
                                synchronized (object) {
                                    List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
                                    StorageInfo si = (StorageInfo)result.get();
                                    storageInfos = HostEvaluMainDialog.this.getStorageInfos(storageInfos, si);
                                    storageInfos.add(si);
                                    HostEvalContext.getStorageMap().put("storageInfo", storageInfos);
                                    LOGGER.info("exec result:{}", (Object)storageInfos);
                                }
                            }
                            catch (Exception e1) {
                                LOGGER.error("query storageinfo errorr.", e1);
                            }
                        }
                    }).start();
                }
            }, errMesage);
            ((IsmTableCellRenderer)addedLinkcell.getRender()).setHorizontalAlignment(0);
            row.setValueAt(5, (Object)addedLinkcell);
            return true;
        }
        return false;
    }

    private List<StorageInfo> getStorageInfos(List<StorageInfo> storageInfos, StorageInfo si) {
        if (storageInfos == null) {
            storageInfos = new ArrayList<StorageInfo>();
        } else {
            storageInfos.remove(si);
        }
        return storageInfos;
    }

    private DevNode getDevNode(List<DevNode> nodeList, DevNode dNode, HostEvalNode hostEvalNode) {
        for (DevNode devNode : nodeList) {
            if (!devNode.getDeviceSerialNumber().equals(hostEvalNode.getStorageSn())) continue;
            dNode = devNode;
            break;
        }
        return dNode;
    }

    public void updateStorageAddedHostNumber(HostEvalNode hostEvalNode) {
        this.updateStorageAddedHostNumber(hostEvalNode.getStorageSn(), hostEvalNode.getMappedStorage());
    }

    public void updateCellWordColor(HostEvalNode hostEvalNode, String num, IsmTableCell.HyperlinkCell addedLinkcell) {
        if (hostEvalNode.getNotAddedInitNumbers() == 0) {
            addedLinkcell.setDescription(num, "#008000");
        } else {
            addedLinkcell.setDescription(num);
        }
    }

    public void setBtnEnabled(boolean enabled) {
        try {
            this.getMainLayout().getAddEvaluDevBtn().setEnabled(enabled);
            this.getMainLayout().getOfflineImportBtn().setEnabled(enabled);
            this.getMainLayout().getStartEvaluBtn().setEnabled(enabled);
            this.getMainLayout().getConfigBtn().setEnabled(enabled);
        }
        catch (Exception e) {
            LOGGER.error("***[exec error!***]", e);
        }
    }

    public void fireNodeAdd(DevNode dev) throws ToolException {
        if (EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)dev)) {
            EntityUtils.convertComputeStorageToOldDevNode((DevNode)dev).forEach(this::setUpgradeDev);
        } else {
            this.setUpgradeDev(dev);
        }
    }

    private void setUpgradeDev(DevNode dev) {
        if (ItDeviceType.Storage.equals((Object)dev.getItDeviceType())) {
            return;
        }
        this.addDevNode(dev, null);
        this.updateDevNode(dev);
    }

    public void updateDevNode(DevNode dev) {
        List evalNodes = this.layout.getDevEvaluTable().getAllRows();
        for (TableRow tr : evalNodes) {
            HostEvalNode node = (HostEvalNode)tr.getUserObject();
            this.updateDevs(node.getStorageSn(), dev, node);
        }
    }

    public void addDevNode(DevNode dev, String storageSn) {
        List<HostEvalNode> hostEvalNodes = this.addHostOrDbDevice(dev, storageSn, true);
        if (this.isEmpty(hostEvalNodes)) {
            this.saveUnAssociateHost(dev);
        }
    }

    private void saveUnAssociateHost(DevNode dev) {
        List tableRows = this.layout.getDevEvaluTable().getAllRows();
        for (TableRow row : tableRows) {
            HostEvalNode hostEvalNode = (HostEvalNode)row.getUserObject();
            this.saveUnAssociateHost(dev, tableRows.size(), hostEvalNode);
        }
    }

    private void saveUnAssociateHost(DevNode dev, int rowSize, HostEvalNode hostEvalNode) {
        if (this.isAddedBefore(dev, hostEvalNode.getUnAssociateHosts())) {
            this.replaceDev(dev, hostEvalNode.getUnAssociateHosts());
        } else if (this.isAddedBefore(dev, hostEvalNode.getManulAssociatedHosts())) {
            this.replaceDev(dev, hostEvalNode.getManulAssociatedHosts());
        } else if (this.notAllowAssociate(dev, rowSize)) {
            if (this.isAddedBefore(dev, hostEvalNode.getNotAllowAssociatedHosts())) {
                this.replaceDev(dev, hostEvalNode.getNotAllowAssociatedHosts());
                return;
            }
            hostEvalNode.getNotAllowAssociatedHosts().add(dev);
            HostEvalContext.setExistNotAllowAssociatedHosts(true);
            HostEvalContext.setExistNotAssociated(hostEvalNode.isHostAdded());
        } else {
            hostEvalNode.getUnAssociateHosts().add(dev);
            HostEvalContext.setExistNotAssociated(hostEvalNode.isHostAdded());
        }
    }

    private boolean notAllowAssociate(DevNode dev, int rowSize) {
        List<String> notAllowStroages = HostEvalContext.getNotAllowAssociatedStorageMap().get(dev.getDevKey());
        if (this.isEmpty(notAllowStroages)) {
            return false;
        }
        return notAllowStroages.size() >= rowSize;
    }

    public int getUnRelatedHostNum() {
        List tableRows = this.layout.getDevEvaluTable().getAllRows();
        if (tableRows.isEmpty()) {
            return 0;
        }
        HostEvalNode hostEvalNode = (HostEvalNode)((TableRow)tableRows.get(0)).getUserObject();
        return hostEvalNode.getUnAssociateHosts().size();
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }

    @Override
    public void notifyAllTaskEnd() {
        if (!this.evaluContext.isTaskExecuting()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HostEvaluMainDialog.this.updateEvaluProcessTip();
                HostEvaluMainDialog.this.setToolEvaluState(false);
                HostEvaluMainDialog.this.layout.getEvaluProcessLabel().setText(HostEvaluMainDialog.this.evaluProcessTip.getEvaluProcessTip());
                HostEvaluMainDialog.this.hideBzyDialogIfEvalStopped();
            }
        });
    }

    @Override
    public void notifyReportGenStart(int pregress) {
        if (this.evaluContext.isTaskExecuting()) {
            this.layout.getEvaluProcessLabel().setText(ResourceUtil.getStringWithParams((String)"eval.hsot.evalend.report.start.gen", (Object[])new Object[]{pregress}));
        }
    }

    @Override
    public void resetPageStatus() {
        this.hideBzyDialogIfEvalStopped();
        this.setToolEvaluState(false);
    }

    @Override
    public void noticeAddDevice2Complete() {
        if (HostEvalContext.isExistNotAssociated()) {
            HostEvalContext.setExistNotAssociated(false);
            this.openSetAssociationDialog();
        }
    }

    private void openSetAssociationDialog() {
        LOGGER.info("***[automatic open SetAssociationDialog]***");
        try {
            this.startSetting();
        }
        catch (Exception e) {
            LOGGER.error("***[automatic open SetAssociationDialog error]***");
        }
    }

    public void showImportInfoDialog() {
        List allDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        LinkedList failRet = new LinkedList();
        for (DevNode devNode : allDevNodes) {
            String errorLocaleDescription = this.deviceImportResult.get(devNode);
            String failDescription = CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.import.tv1.fail");
            String failDescriptionUpgradeModel = CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.offline.custom.model");
            String failDescriptionNotSvpDev = CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.svp.add.device");
            String failDescriptionOuterSvp = CompatibilityResourceUtils.getServiceString("upgradeEvaluation.device.outer.svp.add.device");
            if (!failDescription.equalsIgnoreCase(errorLocaleDescription) && !failDescriptionUpgradeModel.equalsIgnoreCase(errorLocaleDescription) && !failDescriptionNotSvpDev.equalsIgnoreCase(errorLocaleDescription) && !failDescriptionOuterSvp.equalsIgnoreCase(errorLocaleDescription)) continue;
            LOGGER.info("the devNode was filtered ,it was : {}", (Object)devNode.toString());
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(devNode.getIp());
            tmp.add(devNode.getDeviceType().toString());
            tmp.add(errorLocaleDescription);
            failRet.add(tmp);
            try {
                DefaultNodeProviderImpl.getInstance().removeNode(devNode);
            }
            catch (ToolException e) {
                LOGGER.error("Remove TV1 DevNode Error.", e);
            }
        }
        if (!failRet.isEmpty()) {
            SubDialogUtils.showMultiInfoDialog((Window)this, (String)CompatibilityResourceUtils.getServiceString("upgradeEvaluation.layout.device.import.deviceadddialog.batcherror"), (String[])new String[]{CompatibilityResourceUtils.getServiceString("upgradeEvaluation.layout.device.errormsg.ip"), CompatibilityResourceUtils.getServiceString("upgradeEvaluation.layout.device.errormsg.name"), CompatibilityResourceUtils.getServiceString("upgradeEvaluation.layout.device.errormsg.reason")}, failRet);
        }
    }

    public static boolean isAllLimitDevice(List<DevNode> allDevNodes) {
        int i = 0;
        int count = allDevNodes.size();
        for (DevNode devNode : allDevNodes) {
            if (!HostEvaluMainDialog.isLimitDevice(devNode) && !HostEvaluMainDialog.isNotNeedExcuteHostComp(devNode) && !HostEvaluMainDialog.isPeerDevice(devNode) && !ArrayUtils.isHighEndDevOuterSvp((DevNode)devNode)) continue;
            ++i;
        }
        return i == count;
    }

    public static boolean isLimitDevice(DevNode devNode) {
        boolean isDoradoLimitDevice;
        String deviceType = devNode.getDeviceType().toString().toUpperCase(Locale.ENGLISH);
        String productVersion = devNode.getProductVersion().toUpperCase(Locale.ENGLISH);
        LOGGER.info("productVersion ={} deviceType ={}", (Object)productVersion, (Object)deviceType);
        boolean isTv1Device = productVersion.startsWith("V1") && (deviceType.endsWith("T") || deviceType.startsWith("S")) && !deviceType.startsWith("H");
        boolean bl = isDoradoLimitDevice = deviceType.contains("DORADO5100") || deviceType.contains("DORADO2100");
        return isTv1Device || isDoradoLimitDevice;
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        private ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            LOGGER.info("Operate: click change link");
            if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
                return;
            }
            int index = HostEvaluMainDialog.this.getListIndex(mouseEvent.getPoint(), HostEvaluMainDialog.this.layout.getDetailList());
            if (-1 == index) {
                return;
            }
            Object value = HostEvaluMainDialog.this.layout.getDetailList().getSelectedValue();
            if (!(value instanceof EvalItemResult)) {
                ListCellEntity en;
                if (value instanceof ListCellEntity && !StringUtils.isEmpty((en = (ListCellEntity)value).getMessageTip())) {
                    DialogUtils.showInfoDialog((JDialog)HostEvaluMainDialog.this, (String)en.getMessageTip());
                }
                return;
            }
            List<HostEvalNode> devs = HostEvaluMainDialog.this.getSelectDevNode();
            DefaultListModel listModel = HostEvaluMainDialog.this.layout.getListModel();
            listModel.removeAllElements();
            if (devs.size() != 1) {
                return;
            }
            EvalItemResult res = (EvalItemResult)value;
            this.handleDetailedList(res);
        }

        private void handleDetailedList(Object obj) {
            if (!(obj instanceof EvalItemResult)) {
                return;
            }
            EvalItemResult item = (EvalItemResult)obj;
            if (this.needShowResultInfo(item)) {
                new EvalResultInfoDialog((Window)HostEvaluMainDialog.this, item).setVisible(true);
            }
            if (ItemResultEnum.NOTSUPPORT.equals((Object)item.getItemResultEnum()) && !com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)item.getFailedReason())) {
                this.handleNotSupportMsg(item);
            } else if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)item.getFailedReason())) {
                DialogUtils.showInfoDialog((JDialog)HostEvaluMainDialog.this, (String)item.getFailedReason());
            }
        }

        public boolean needShowResultInfo(EvalItemResult item) {
            return !ItemResultEnum.EVALUATING.equals((Object)item.getItemResultEnum()) && !ItemResultEnum.NOTEVAL.equals((Object)item.getItemResultEnum()) && !ItemResultEnum.EVALUATION_STOP.equals((Object)item.getItemResultEnum()) && !ItemResultEnum.NOTSUPPORT.equals((Object)item.getItemResultEnum()) && (!ItemResultEnum.CANNOTEVAL.equals((Object)item.getItemResultEnum()) || com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)item.getFailedReason()));
        }

        public void handleNotSupportMsg(EvalItemResult item) {
            String deviceType = item.getItemInfo().getDevInfo().toLowerCase(Locale.ENGLISH);
            if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)deviceType)) {
                deviceType = item.getItemInfo().getOsName().toLowerCase(Locale.ENGLISH);
            }
            String tips = CommonUtils.getNotSupportMessage(deviceType);
            DialogUtils.showInfoDialog((JDialog)HostEvaluMainDialog.this, (String)tips);
        }
    }

    private class TableSelectedListener
    implements ListSelectionListener {
        private TableSelectedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            HostEvaluMainDialog.this.refreshDetailList(true);
        }
    }

    private final class EvalHostTask
    implements Callable<Boolean> {
        private List<HostEvalNode> tabDevs;

        public EvalHostTask(List<HostEvalNode> tabDevs) {
            this.tabDevs = tabDevs;
        }

        @Override
        public Boolean call() {
            HostEvalContext.setEndEvalu(false);
            HostEvaluMainDialog.this.refreshDetailList(true);
            HostEvaluMainDialog.this.submitPkgsToEval(this.tabDevs);
            return true;
        }
    }

    private final class CheckStatusTask
    implements Runnable {
        private CheckStatusTask() {
        }

        @Override
        public void run() {
            Integer i = 0;
            while (i < 500 && !this.checkIsStop()) {
            }
        }

        private boolean checkIsStop() {
            boolean isTaskRunning;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.error("error", e);
            }
            boolean bl = isTaskRunning = !HostEvaluMainDialog.this.findLoadingRows().isEmpty();
            if (!isTaskRunning) {
                if (HostEvaluMainDialog.this.inerrrutpDialog != null) {
                    HostEvaluMainDialog.this.inerrrutpDialog.setEnabled(false);
                    HostEvaluMainDialog.this.inerrrutpDialog.dispose();
                }
                return true;
            }
            return false;
        }
    }
}

