/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.report.TemplateFactory;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.tool.upgradeevalu.util.PackageUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;

public class ItemDetailLayout
extends JPanel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ItemDetailLayout.class);
    private static final String NEWLINE = "\n";
    private static final String HTTP = "http:";
    private static final String WWW = "www.";
    private static final String HTTPS = "https:";
    private static final int WIDTH = 450;
    private static final int REFPAN_HEIGHT = 150;
    private static final int RESULTPAN_HEIGHT = 60;
    private static final int FONT_SIZE = 13;
    private static final String POINT_COM = ".com";
    private static final String POINT_METHOD = ".method";
    private static final String POINT_HELPHREF = ".helphref";
    private static final String POINT_SUGGESTION = ".suggestion";
    private static final String POINT_CRITERION = ".criterion";
    private static final String CLI = "cli";
    private static final String SOURCECLITEMPLATE_HTML = "sourceCliTemplate.html";
    private static final String HTML_PAGE_CONRENTTYPE = "text/html;charset=\"UTF-8\"";
    private JButton close = UiMethod.createButton((String)ResourceUtil.getString((String)"evalu.ui.itemDetail.button.close"));
    private JEditorPane reference = new JEditorPane();
    private JEditorPane result = new JEditorPane();
    private JScrollPane refPan = new JScrollPane(this.reference);
    private JScrollPane resultPan = new JScrollPane(this.result);
    private ToolHyperLinkLabel showMore = new ToolHyperLinkLabel(ResourceUtil.getString((String)"evalu.ui.itemDetail.linkLabel"));
    private String showMoreText = "";
    private transient EvaluDevManager evaluDevMgr = EvaluDevManager.getInstance();
    private transient EvaluItem item;

    public ItemDetailLayout(EvaluItem item) {
        this.item = item;
        JLabel refLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.tip"));
        JLabel retLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.itemDetail.result.tip2"));
        this.refPan = new JScrollPane(this.reference);
        this.resultPan = new JScrollPane(this.result);
        this.refPan.setPreferredSize(new Dimension(450, 150));
        this.resultPan.setPreferredSize(new Dimension(450, 60));
        JComponent pan = null;
        pan = item.isShowOrigin() ? UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)refLabel), this.refPan, UCD.buildHorizontalBoxLeft((Component)retLabel), this.resultPan, UCD.buildHorizontalBoxLeft((Component)this.showMore), UCD.buildHBoxRight((Component[])new Component[]{this.close})}) : UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)refLabel), this.refPan, UCD.buildHorizontalBoxLeft((Component)retLabel), this.resultPan, UCD.buildHBoxRight((Component[])new Component[]{this.close})});
        this.reference.setEditable(false);
        this.reference.setMargin(this.getTextInset());
        this.result.setMargin(this.getTextInset());
        this.reference.setFocusable(true);
        this.result.setFocusable(true);
        this.result.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)pan, (int)12));
    }

    private void scorll2top() {
        this.reference.setCaretPosition(0);
        this.result.setCaretPosition(0);
    }

    private Insets getTextInset() {
        return new Insets(0, 5, 0, 0);
    }

    private SimpleAttributeSet getTextFontStyle() {
        SimpleAttributeSet attribute = new SimpleAttributeSet();
        StyleConstants.setBold(attribute, true);
        StyleConstants.setItalic(attribute, true);
        StyleConstants.setFontSize(attribute, 13);
        return attribute;
    }

    private void setReferenceWithStyle(JEditorPane textArea, String criterion, String method, String suggestion) throws BadLocationException {
        textArea.getDocument().insertString(textArea.getDocument().getLength(), "<span class=\"font\">" + ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.desc1") + "</span><br>", this.getTextFontStyle());
        textArea.getDocument().insertString(textArea.getDocument().getLength(), method + "<br><br><br>", new SimpleAttributeSet());
        textArea.getDocument().insertString(textArea.getDocument().getLength(), "<span class=\"font\">" + ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.desc2") + "</span><br>", this.getTextFontStyle());
        textArea.getDocument().insertString(textArea.getDocument().getLength(), criterion + "<br><br><br>", new SimpleAttributeSet());
        textArea.getDocument().insertString(textArea.getDocument().getLength(), "<span class=\"font\">" + ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.desc3") + "</span><br>", this.getTextFontStyle());
        textArea.getDocument().insertString(textArea.getDocument().getLength(), suggestion + "<br><br><br>", new SimpleAttributeSet());
        textArea.getDocument().insertString(textArea.getDocument().getLength(), "</body></html>", new SimpleAttributeSet());
    }

    public void setValue() {
        ResultItem retItem = this.item.getRetItem();
        String method = "";
        String suggestion = "";
        String criterion = "";
        String helpHref = "";
        String id = this.item.getId();
        EvaluDevNode dev = this.evaluDevMgr.getTabDevById(this.item.getDevID());
        if (dev == null) {
            throw new NullPointerException("getTabDevById faild = " + this.item.getDevID());
        }
        KeyOrderedHashMap<CrossVersionType, ProductCfg> products = dev.getProducts();
        suggestion = this.item.getString(id + POINT_SUGGESTION);
        String scriptPath = FileUtil.getCanonicalPath(((ProductCfg)products.get((Object)this.item.getCrossVersionType())).getProductDir());
        PackageUtils.deCompressResourceFile(scriptPath, false);
        try {
            helpHref = this.item.getString(id + POINT_HELPHREF);
            suggestion = EvaluService.getInstance().replaceLink(suggestion, helpHref, scriptPath);
        }
        catch (MissingResourceException e) {
            LOGGER.error("not exist " + id + POINT_HELPHREF + " !");
        }
        catch (Exception e) {
            LOGGER.error("getter " + id + POINT_HELPHREF + " error", e);
        }
        StringBuffer refText = new StringBuffer();
        StringBuffer context = new StringBuffer();
        this.appendRefText(refText);
        method = this.appendMethod(method, id, context);
        criterion = this.appendCriterion(criterion, id, context);
        context.append(ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.desc3")).append("</b></span>").append(NEWLINE).append(suggestion);
        String contextStr = context.toString().replaceAll(NEWLINE, "<br>");
        contextStr = contextStr.replaceAll("\\\\n", "<br>");
        refText.append(contextStr);
        refText.append("<br><br></body>");
        refText.append("</html>");
        this.addHyperlinkListener(method, suggestion, criterion, refText);
        String ret = this.buildRetText(this.item);
        this.result.setContentType(HTML_PAGE_CONRENTTYPE);
        this.result.setText(ret);
        this.result.setEditable(false);
        this.showMoreText = this.processHtmlText(retItem.getSourceInfo());
        this.scorll2top();
    }

    private void addHyperlinkListener(String method, String suggestion, String criterion, StringBuffer refText) {
        try {
            this.setReferenceWithStyle(this.reference, criterion, method, suggestion);
            this.reference.setContentType(HTML_PAGE_CONRENTTYPE);
            this.reference.setText(refText.toString());
            this.reference.setEditable(false);
            this.reference.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ItemDetailLayout.this.doHyperLinkEvent(e);
                }
            });
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("set reference failed. ", e);
            this.reference.setContentType(HTML_PAGE_CONRENTTYPE);
            this.reference.setText(refText.toString());
            this.reference.setEditable(false);
            this.reference.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ItemDetailLayout.this.doHyperLinkEvent(e);
                }
            });
        }
    }

    private String appendMethod(String method, String id, StringBuffer context) {
        if (this.item.isShowMethod()) {
            method = this.item.getString(id + POINT_METHOD);
            context.append("<span><b>").append(ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.desc1")).append("</b></span>").append(NEWLINE).append(method).append(NEWLINE).append(NEWLINE);
        }
        return method;
    }

    private String appendCriterion(String criterion, String id, StringBuffer context) {
        if (this.item.isShowCriterion()) {
            criterion = this.item.getString(id + POINT_CRITERION);
            context.append("<span><b>").append(ResourceUtil.getString((String)"evalu.ui.itemDetail.refer.desc2")).append("</b></span>").append(NEWLINE).append(criterion).append(NEWLINE).append(NEWLINE).append("<span><b>");
        }
        return criterion;
    }

    private void appendRefText(StringBuffer refText) {
        refText.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ").append("\"").append(HtmlEnums.XHTML_TRANSITIONAL.getResourceValue()).append("\">" + System.lineSeparator()).append("<html xmlns=\"").append(HtmlEnums.XHTML.getResourceValue()).append("\">" + System.lineSeparator()).append("<head>" + System.lineSeparator()).append("<style type= \"text/css\">").append("body{ font-size:9px;color:#464646;}").append("spn{font-size:13px;color:#ffffff;font-weight:bold;font-style:italic;}").append("selected::selection{color:#ffffff;background:#990000;}").append("selected::-moz-selection{background:#990000;}").append("</style>" + System.lineSeparator()).append("</head>" + System.lineSeparator()).append("<body>" + System.lineSeparator());
    }

    private String buildRetText(EvaluItem evaluItem) {
        StringBuffer resultText = new StringBuffer();
        this.appendRefText(resultText);
        String ret = "";
        ResultItem rec = evaluItem.getRetItem();
        ResultFlag flag = rec.getRetFlag();
        String errorInfo = rec.getErrorInfo();
        switch (flag) {
            case NOTPASS: {
                ret = ResourceUtil.getString((String)"evalu.ui.itemDetail.return.failure");
                ret = this.showErrorMsg(errorInfo, ret);
                break;
            }
            case NOSUPPORT: {
                ret = ResourceUtil.getString((String)"evalu.ui.itemDetail.return.not.support");
                ret = this.showErrorMsg(errorInfo, ret);
                break;
            }
            case NOCHECK: {
                ret = ResourceUtil.getString((String)"evalu.ui.itemDetail.return.not.check");
                ret = this.showErrorMsg(errorInfo, ret);
                break;
            }
            case WARN: {
                ret = ResourceUtil.getString((String)"evalu.ui.itemDetail.return.warn");
                ret = this.showErrorMsg(errorInfo, ret);
                break;
            }
            case PASS: {
                ret = ResourceUtil.getString((String)"evalu.ui.itemDetail.return.success");
                errorInfo = "";
                ret = this.showErrorMsg(errorInfo, ret);
                break;
            }
        }
        resultText.append(ret.replaceAll(NEWLINE, "<br>")).append("</body></html>");
        return resultText.toString();
    }

    private String showErrorMsg(String errorInfo, String ret) {
        ret = ret + NEWLINE + errorInfo;
        return ret;
    }

    private String processHtmlText(String content) {
        content = content.replaceAll(">", "&gt;");
        content = content.replaceAll("<", "&lt;");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(CLI, content);
        return TemplateFactory.processorFtl(SOURCECLITEMPLATE_HTML, data);
    }

    public JButton getClose() {
        return this.close;
    }

    public ToolHyperLinkLabel getShowMore() {
        return this.showMore;
    }

    public String getShowMoreText() {
        return this.showMoreText;
    }

    private void doHyperLinkEvent(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            String helpFileStr = e.getDescription();
            try {
                if (helpFileStr.startsWith(HTTP) || helpFileStr.startsWith(HTTPS) || helpFileStr.startsWith(WWW)) {
                    FileUtils.openHtmlFile((String)helpFileStr);
                } else {
                    OSCmdUtils.explorerFile((File)new File(helpFileStr));
                }
            }
            catch (Exception ex) {
                LOGGER.error("open the file failed", ex);
            }
        }
    }

    public void setCompName() {
        this.close.setName("_JButton_close");
        this.showMore.setName("_Label_showMore");
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }
}

