/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ObjectStreamException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class LabelHyperlinkCell
extends IsmTableCell {
    private static final long serialVersionUID = 6315256100146227653L;
    private static final Color COLOR_MOUSE_OVER = new Color(4359891);
    private static final Color COLOR_AFTER_CLICK = new Color(26879);
    private static LabelAndHyperlinkRenderer render = new LabelAndHyperlinkRenderer();
    private JLabel label = new JLabel();
    private String description;
    private JLabel linkLabel = new JLabel();
    private Color labelColor = Color.black;
    private transient ActionListener acListener = null;
    private static boolean isShowtipFlag = false;
    private static String errMesageTip = "";
    private static final String LINEBREAK = "<br>";

    public LabelHyperlinkCell(String labelDesc, String linkDesc, ActionListener action) {
        this.label.setText(labelDesc);
        this.setLinkDesc(linkDesc);
        this.acListener = action;
    }

    public LabelHyperlinkCell(String labelDesc, String linkDesc, ActionListener action, String errMesage) {
        this.label.setText(labelDesc);
        this.setLinkDesc(linkDesc);
        this.acListener = action;
        errMesageTip = this.addLineFeedInStr(errMesage, 40);
    }

    public String addLineFeedInStr(String errMesage, int placeNumber) {
        int strIndex = 0;
        int conutNumber = 0;
        boolean isAddLineFeed = false;
        String chinese = "[\u0391-\uffe5]";
        StringBuffer processStr = new StringBuffer();
        if (StringUtils.isNULLStr((String)errMesage)) {
            return "";
        }
        for (int i = 0; i < errMesage.length(); ++i) {
            String temp = errMesage.substring(i, i + 1);
            processStr = processStr.append(temp);
            if (temp.matches(chinese)) {
                strIndex += 2;
                isAddLineFeed = true;
            } else {
                ++strIndex;
                isAddLineFeed = false;
            }
            if (" ".equals(temp)) {
                isAddLineFeed = true;
            }
            if (strIndex / placeNumber <= conutNumber || !isAddLineFeed) continue;
            processStr = processStr.append(LINEBREAK);
            ++conutNumber;
        }
        return processStr.toString();
    }

    public TableCellRenderer getRender() {
        return render;
    }

    public ActionListener getAction() {
        return this.acListener;
    }

    public String toString() {
        return this.description;
    }

    public boolean isMouseInBounds(MouseEvent event, Rectangle rect) {
        Rectangle bounds = this.linkLabel.getBounds();
        Point tableCellLocation = rect.getLocation();
        Point mousePosition = event.getPoint();
        Point mouseRelativeLocation = new Point();
        mouseRelativeLocation.setLocation(mousePosition.getX() - tableCellLocation.getX(), mousePosition.getY() - tableCellLocation.getY());
        if (!StringUtils.isNULLStr((String)errMesageTip)) {
            Rectangle lableBounds = this.label.getBounds();
            boolean isLableContains = lableBounds.contains(mouseRelativeLocation);
            isShowtipFlag = isLableContains;
        }
        return bounds.contains(mouseRelativeLocation);
    }

    public final void setLinkDesc(String desc) {
        this.description = null == desc ? "" : desc;
        this.linkLabel.setText(desc);
    }

    public int compareTo(IsmTableCell ismTableCell) {
        if (!(ismTableCell instanceof LabelHyperlinkCell)) {
            return -1;
        }
        String thisVal = this.label.getText();
        String thatVal = ((LabelHyperlinkCell)ismTableCell).label.getText();
        return thisVal.compareTo(thatVal);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof LabelHyperlinkCell)) {
            return false;
        }
        LabelHyperlinkCell cell = (LabelHyperlinkCell)((Object)obj);
        return this.label.getText().equals(cell.label.getText()) && this.description.equals(cell.description);
    }

    public int hashCode() {
        return this.label.getText().hashCode();
    }

    protected Object readResolve() throws ObjectStreamException {
        return new LabelHyperlinkCell(this.label.getText(), "", null);
    }

    private static class LabelAndHyperlinkRenderer
    extends IsmTableCellRenderer {
        private static final long serialVersionUID = -872602276192708959L;
        private static final int LABEL_LINK_SEP = 5;

        public LabelAndHyperlinkRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel lable = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!(table instanceof IsmTable)) {
                return lable;
            }
            IsmTable ismTable = (IsmTable)table;
            if (value instanceof LabelHyperlinkCell) {
                JPanel jPanel = new JPanel();
                LabelHyperlinkCell cell = (LabelHyperlinkCell)((Object)value);
                if (!StringUtils.isNULLStr((String)cell.label.getText())) {
                    jPanel.add(cell.label);
                }
                jPanel.add(cell.linkLabel);
                cell.label.setForeground(cell.labelColor);
                if (ismTable.getCurRolloverRow() == row && ismTable.getCurRolloverColumn() == column) {
                    cell.linkLabel.setForeground(COLOR_AFTER_CLICK);
                } else {
                    cell.linkLabel.setForeground(COLOR_MOUSE_OVER);
                }
                if (isSelected) {
                    jPanel.setBackground(table.getSelectionBackground());
                    if (Color.black.equals(cell.labelColor)) {
                        cell.label.setForeground(Color.white);
                    }
                }
                this.setBackGround(table, isSelected, row, jPanel);
                if (isShowtipFlag) {
                    jPanel.setToolTipText(errMesageTip);
                }
                return jPanel;
            }
            return lable;
        }
    }
}

