/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.upgradeevalu.config.ItemParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.Module;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.PythonEngine;
import com.huawei.ism.tool.upgradeevalu.exception.JythonException;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallableOver;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class LoadEvaluItemCallable
implements Callable<LoadEvaluItemCallableOver> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LoadEvaluItemCallable.class);
    private static final String LOAD_ITEM_TASK = "load_items_task";
    private List<EvaluDevNode> selectDevs;
    private EvaluService evaluService = EvaluService.getInstance();
    private ItemParser itemParser = ItemParser.getInstance();
    private static final String LIMIT_PATH_CHECK_NAME = "limitPathCheck.py";

    public LoadEvaluItemCallable(List<EvaluDevNode> selectedDevs) {
        this.selectDevs = selectedDevs;
    }

    public LoadEvaluItemCallable(EvaluDevNode dev) {
        this.selectDevs = new ArrayList<EvaluDevNode>();
        this.selectDevs.add(dev);
    }

    @Override
    public LoadEvaluItemCallableOver call() throws ToolException {
        String name = LOAD_ITEM_TASK;
        Thread.currentThread().setName(name);
        LoadEvaluItemCallableOver result = new LoadEvaluItemCallableOver();
        try {
            for (EvaluDevNode dev : this.selectDevs) {
                KeyOrderedHashMap<CrossVersionType, ProductCfg> prodMap = this.evaluService.queryProdcut(dev);
                if (null == prodMap) {
                    LOGGER.warn("query cross product failed " + dev.getIp() + ", dest version input error.");
                    result.setSuccess(false);
                    result.setResult(LoadEvaluItemCallableOver.ExecuteResult.QUERY_CROSSPRODUCT_ERROR);
                    return result;
                }
                if (prodMap.isEmpty()) {
                    LOGGER.error("there is not product Conf for dev " + dev.getIp());
                    result.setSuccess(false);
                    result.setResult(LoadEvaluItemCallableOver.ExecuteResult.DEFUALT_ERROR);
                    return result;
                }
                dev.setProducts(prodMap);
                boolean isLimitPath = this.checkLimitEvaPath(dev);
                if (isLimitPath) {
                    LOGGER.error("This eva path is limit for dev " + dev.getIp());
                    result.setSuccess(false);
                    result.setResult(LoadEvaluItemCallableOver.ExecuteResult.QUERY_EVA_LIMIT_PATH);
                    return result;
                }
                if (!this.loadInnerProductItem(dev, (ProductCfg)prodMap.get((Object)CrossVersionType.INNERVERSION))) {
                    LOGGER.error("load innerProduct for dev " + dev.getIp() + " failed.");
                    result.setSuccess(false);
                    result.setResult(LoadEvaluItemCallableOver.ExecuteResult.LOAD_INNERPRODCT_ITEM_ERROR);
                    return result;
                }
                result.setSuccess(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("execute fresh FreshEvaluStrategy failed.", e);
            result.setSuccess(false);
            result.setResult(LoadEvaluItemCallableOver.ExecuteResult.DEFUALT_ERROR);
        }
        return result;
    }

    private boolean loadInnerProductItem(EvaluDevNode dev, ProductCfg innerProd) {
        if (null == innerProd) {
            LOGGER.error("there isn't innerProduct for the selected evaluDev.");
            return false;
        }
        Document itemsDoc = this.evaluService.getEvaluFile(dev, innerProd);
        if (null == itemsDoc) {
            LOGGER.error("get the inner evaluItem file failed.");
            return false;
        }
        List<Module> modules = this.itemParser.parseModuleByDoc(itemsDoc, dev, innerProd);
        if (modules.isEmpty()) {
            LOGGER.error("get the inner evaluItem file failed.");
            return false;
        }
        innerProd.setModules(modules);
        innerProd.setDynamicModules(new ArrayList<Module>());
        this.itemParser.setInnerItemByDev(dev);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLimitEvaPath(EvaluDevNode dev) throws JythonException {
        boolean isLimitPath = false;
        PythonEngine pyEngine = null;
        HashMap<String, Object> dic = new HashMap<String, Object>();
        try {
            dic.put("dev", (Object)dev);
            dic.put("logger", LOGGER);
            KeyOrderedHashMap<CrossVersionType, ProductCfg> prodMap = dev.getProducts();
            ProductCfg prod = (ProductCfg)prodMap.get((Object)CrossVersionType.INNERVERSION);
            File dir = prod.getProductDir().getParentFile();
            File scriptFile = new File(dir, LIMIT_PATH_CHECK_NAME);
            if (!scriptFile.exists()) {
                LOGGER.info("check limit eva path file is not exists.");
                boolean bl = false;
                return bl;
            }
            pyEngine = new PythonEngine(dev.getClssPath(), dic);
            List<Object> rets = pyEngine.execute(scriptFile);
            boolean bl = isLimitPath = ((Boolean)rets.get(0)).booleanValue();
            return bl;
        }
        finally {
            if (null != pyEngine) {
                pyEngine.clean();
            }
        }
    }
}

