/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.ui.NeedPwdDialogLayout;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

public class NeedPwdDialog
extends JDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(450, 530);
    private NeedPwdDialogLayout layout = new NeedPwdDialogLayout();

    public NeedPwdDialog(JDialog parent, List<EvaluDevNode> devList) {
        super(parent);
        this.setResizable(false);
        this.layout.setCompName();
        this.initTableData(devList);
        this.initListener();
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
        this.setTitle(ResourceUtil.getString((String)"evalu.ui.supportDevice.debug.title"));
        this.add(this.layout);
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getConfirmeBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click confirme button");
                NeedPwdDialog.this.confirmeAction();
            }
        });
    }

    private TableRow<String, String> createTableRow(EvaluDevNode dev) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumns(), (Object)dev.getIp(), (Object)dev.getIp());
        row.setValueAt(0, (Object)dev.getDeviceName());
        row.setValueAt(1, (Object)dev.getIp());
        return row;
    }

    private void initTableData(List<EvaluDevNode> devList) {
        this.layout.getTableModel().removeAll();
        for (EvaluDevNode dev : devList) {
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(dev)});
        }
    }

    private void confirmeAction() {
        this.dispose();
    }
}

