/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.upgradeevalu.entity.NotAdminUserDeviceInfo;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public class NotAdminUserInfoDialog
extends JDialog {
    public static final int CONFIRM_CLICKED = 0;
    public static final int CANCEL_CLICKED = 1;
    private static final long serialVersionUID = 3374635204788409020L;
    private static final Dimension DIALOG_SIZE = new Dimension(600, 450);
    private JButton continueBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.button.confirm"), (char)'O');
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.button.cancel"), (char)'C');
    private String[] infoHeader = new String[]{ResourceUtil.getString((String)"evalu.ui.mainDialog.task.table.name"), ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.device.ip"), ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.device.type"), ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.excel.row.num")};
    private DefaultTableModel infoTableModel = new DefaultTableModel(this.infoHeader, new int[0]);
    private IsmTable infoTable = new IsmTable((TableModel)this.infoTableModel);
    private transient List<NotAdminUserDeviceInfo> messages;
    private int clickValue = -1;

    public NotAdminUserInfoDialog(Window parent, List<NotAdminUserDeviceInfo> messages) {
        super(parent);
        this.messages = messages;
        this.initUI();
        this.initData();
        this.addListeners();
    }

    public int getClickValue() {
        return this.clickValue;
    }

    private void addListeners() {
        this.continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotAdminUserInfoDialog.this.clickValue = 0;
                NotAdminUserInfoDialog.this.dispose();
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotAdminUserInfoDialog.this.clickValue = 1;
                NotAdminUserInfoDialog.this.dispose();
            }
        });
    }

    private void initData() {
        if (null == this.messages) {
            return;
        }
        for (NotAdminUserDeviceInfo notAdminUserDeviceInfo : this.messages) {
            DefaultTableRow row = new DefaultTableRow(4, (Object)String.valueOf(notAdminUserDeviceInfo.hashCode()));
            row.setValueAt(0, (Object)notAdminUserDeviceInfo.getTaskName());
            row.setValueAt(1, (Object)notAdminUserDeviceInfo.getDeviceIp());
            row.setValueAt(2, (Object)notAdminUserDeviceInfo.getDeviceType());
            row.setValueAt(3, (Object)notAdminUserDeviceInfo.getRowNum());
            this.infoTableModel.addRow(new TableRow[]{row});
            this.infoTableModel.setVisibleColumns(new int[]{0, 1, 2});
        }
    }

    private void initUI() {
        JLabel desc = new JLabel(ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.tips"));
        desc.setIcon(ResourceUtil.getImage((String)"comfirmdialog_warn.png"));
        JComponent mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{desc}), this.createMainPanel()});
        this.setTitle(ResourceUtil.getString((String)"not.admin.user.device.warning.dialog.title"));
        this.setModal(true);
        this.setPreferredSize(DIALOG_SIZE);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)mainCom, (int)12));
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
    }

    private JComponent createMainPanel() {
        this.getRootPane().setDefaultButton(this.closeBtn);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{new IsmTableScrollPane(this.infoTable, false), UCD.buildHorizontalBoxRight((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{this.continueBtn, this.closeBtn}))});
    }

    @Override
    public void processWindowEvent(WindowEvent event) {
        switch (event.getID()) {
            case 200: {
                this.closeBtn.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }
}

