/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.former.service.IntelligentComputeSceneImpl;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ManualConfigItemMgr;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ProcessUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.tool.upgradeevalu.config.ParseConfCallable;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluResultXml;
import com.huawei.ism.tool.upgradeevalu.entity.ExtraCheckItem;
import com.huawei.ism.tool.upgradeevalu.entity.IsClickUpgTips;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.SceneParam;
import com.huawei.ism.tool.upgradeevalu.entity.UpgEvaUserOpData;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluState;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluTaskManager;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataExtendUtil;
import com.huawei.ism.tool.upgradeevalu.ui.DevModifyOperationDialog;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.ui.ItemDetailDialog;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallable;
import com.huawei.ism.tool.upgradeevalu.ui.OnlineEvaluMainDialogLayout;
import com.huawei.ism.tool.upgradeevalu.ui.SimpleDetailInfoDialog;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluConstants;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.tool.upgradeevalu.util.GifAssistant;
import com.huawei.ism.tool.upgradeevalu.util.ItemProgressUpdateUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.RootPaneUI;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import utils.Products;

public class OnlineEvaluMainDialog
extends JDialog
implements IUiObserver,
IHelpActionCallBack {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OnlineEvaluMainDialog.class);
    private static final String WIZARD_DEFINE_PATH = "config/wizard/ElementDefine.xml";
    private static final String WIZARD_FLOW_PATH = "config/wizard/UpgradeEvaluationFlow.xml";
    private static final String A800_WIZARD_FLOW_PATH = "config/wizard/A800UpgradeEvaluationFlow.xml";
    private static final String SAVEPATH_DEFAULT_ID = "reportDir";
    private static final String EVALU_MANAGER = "evalu_task_manager";
    private static final String START_EVALUTEXT = ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.button.execute");
    private static final String END_EVALUTEXT = ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.button.interrupt");
    private static final String END_TIP = ResourceUtil.getString((String)"evalu.ui.mainDialog.complete.view.end.tip");
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private transient EvaluDevManager devMgr = EvaluDevManager.getInstance();
    private OnlineEvaluMainDialogLayout layout;
    private transient GifAssistant gifAssistant = GifAssistant.getInstance();
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private transient EvaluSceneUtils sceneUtil = new EvaluSceneUtils();
    private static final String DEFAULT_INDEX = "index.html";
    private static final String SUMMARY_INDEX = "summary.html";
    private static final int INT_3 = 3;

    public OnlineEvaluMainDialog(Window parent) {
        super(parent);
        List<EvaluDevNode> evaludevs = null;
        if (SceneUtils.isScene()) {
            EvaluContext.setAutoAddDevice(true);
            evaludevs = this.initData();
        }
        this.initUI();
        if (evaludevs != null && !evaludevs.isEmpty()) {
            this.layout.getAddEvaluDevBtn().setEnabled(false);
            this.layout.getDelDevBtn().setEnabled(false);
            this.layout.getReportDirBtn().setEnabled(false);
            this.addDev2Table(evaludevs);
        }
        this.addListner();
        this.evaluContext.setMainDialog(this);
        String workPath = ApplicationContext.getInstance().getWorkPath();
        if (workPath.lastIndexOf("tools") != -1) {
            String toolkitPath = workPath.substring(0, workPath.lastIndexOf("tools"));
            String ignoreItemPath = toolkitPath + "tools//ArrayUpgrade//ignoreitem.txt";
            ManualConfigItemMgr.getInstance().init(new File(ignoreItemPath));
        }
    }

    public void loadCfg() {
        List fs = AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new ParseConfCallable()});
        Boolean result = (Boolean)fs.get(0);
        if (!result.booleanValue()) {
            String str = ResourceUtil.getString((String)"evalu.ui.mainDialog.load.config.error");
            SimpleDetailInfoDialog dialog = new SimpleDetailInfoDialog(str, this);
            dialog.setVisible(true);
            LOGGER.error("parse config failed.");
        }
    }

    private void initUI() {
        this.layout = new OnlineEvaluMainDialogLayout();
        this.layout.setCompName();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        if (!ApplicationContext.getInstance().isOEM()) {
            this.rootPaneUI.setShowHelp(false);
        }
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)this);
        this.setTitle(ResourceUtil.getString((String)"evalu.enter.title"));
        this.setModal(true);
        this.setResizable(true);
        this.validate();
        this.pack();
        this.setIconImage(ResourceUtil.getImage((String)"upgradeEvaluation.png").getImage());
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private List<EvaluDevNode> initData() {
        List devsXML = SceneXmlData.getInstance().loadSceneFromFile();
        SceneDataSerialize dataOperate = new SceneDataSerialize();
        Map upgradeSettings = (Map)dataOperate.deserialize();
        Map<String, Map<String, String>> sceneDataExtMap = SceneDataExtendUtil.getInstance().parseSceneDataExt();
        if (null == devsXML || devsXML.isEmpty() || null == upgradeSettings) {
            return null;
        }
        if (A800Utils.isA800UpgradeCheck()) {
            this.addAiNodeFromEnv();
            devsXML.forEach(devNode -> devNode.setUuid(this.getUuid((com.huawei.ism.tool.framework.pubservice.entity.DevNode)devNode)));
        }
        String sceneArg = EvaluSceneUtils.getSceneArg();
        ArrayList<EvaluDevNode> evaludevs = new ArrayList<EvaluDevNode>();
        for (com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode2 : devsXML) {
            String key = devNode2.getIp() + "_" + devNode2.getDeviceSerialNumber();
            UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
            if (null == data) continue;
            if (A800Utils.isA800Upgrade()) {
                for (com.huawei.ism.tool.framework.pubservice.entity.DevNode zone : A800Utils.getZones(devNode2)) {
                    this.bulidEvaluDevNode(SceneParam.builder().sceneDataExtMap(sceneDataExtMap).sceneArg(sceneArg).data(data).evaludevs(evaludevs).devNode(zone).key(key).build());
                }
                continue;
            }
            this.bulidEvaluDevNode(SceneParam.builder().sceneArg(sceneArg).data(data).evaludevs(evaludevs).devNode(devNode2).sceneDataExtMap(sceneDataExtMap).key(key).build());
        }
        return evaludevs;
    }

    private void addAiNodeFromEnv() {
        IntelligentComputeSceneImpl intelligentComputeScene = new IntelligentComputeSceneImpl();
        List aiDevNodes = intelligentComputeScene.readExtend();
        aiDevNodes.forEach(devNode -> {
            try {
                DefaultNodeProviderImpl.getInstance().addNode((DevNode)devNode);
            }
            catch (ToolException e) {
                LOGGER.error("[Add device >> {} ][Failed]", devNode, (Object)e);
            }
        });
    }

    private String getUuid(com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode) {
        return A800Utils.getZoneByDevNode(devNode).map(DevNode::getUuid).orElse(devNode.getUuid());
    }

    private void bulidEvaluDevNode(SceneParam sceneParam) {
        com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode = sceneParam.getDevNode();
        EvaluDevNode evaluDev = new EvaluDevNode(devNode);
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            evaluDev.setSvpIp(devNode.getIp());
            evaluDev.setIp((String)devNode.getIpList().get(0));
        }
        String sceneArg = sceneParam.getSceneArg();
        UpgradeSceneData data = sceneParam.getData();
        this.saveUpgradeSceneData(sceneArg, devNode, data, evaluDev);
        sceneParam.getEvaludevs().add(evaluDev);
        this.evaluContext.putIsClickUpgTipsOfDevToMap(evaluDev, false);
        Map<String, Map<String, String>> sceneDataExtMap = sceneParam.getSceneDataExtMap();
        if (null == sceneDataExtMap) {
            return;
        }
        String key = sceneParam.getKey();
        Map<String, String> devSceneDataExt = sceneDataExtMap.get(key);
        if (null != devSceneDataExt) {
            this.saveSceneDataExt(evaluDev, devSceneDataExt, sceneArg);
        }
    }

    private void saveSceneDataExt(EvaluDevNode evaluDev, Map<String, String> devSceneDataExt, String sceneArg) {
        boolean isAllUpgrade = Boolean.parseBoolean(devSceneDataExt.get("isAllUpgrade"));
        evaluDev.setUpgPatchPkgVer(devSceneDataExt.get("upgPatchPkgVer"));
        evaluDev.setFastAndRollType(Boolean.parseBoolean(devSceneDataExt.get("isFastAndRollType")));
        evaluDev.setStopHostBusiness(Boolean.parseBoolean(devSceneDataExt.get("stopBusiness")));
        evaluDev.setDeviceKernelVersion(devSceneDataExt.get("currentKernelVersion"));
        evaluDev.setTargetKernelVersion(devSceneDataExt.get("targetKernelVersion"));
        evaluDev.setSupportApollo(Boolean.parseBoolean(devSceneDataExt.get("supportApollo")));
        evaluDev.setContainerVersion(devSceneDataExt.get("containerVersion"));
        evaluDev.setSecondaryUpgrade(Boolean.parseBoolean(devSceneDataExt.get("isSecondaryUpgrade")));
        evaluDev.setStorageImageUpgrade(isAllUpgrade);
        if (isAllUpgrade) {
            evaluDev.setContainerDestVersion(devSceneDataExt.get("containerDestVersion"));
            this.modifyArraySceneInfo(evaluDev, sceneArg);
        }
    }

    private void modifyArraySceneInfo(EvaluDevNode evaluDev, String sceneArg) {
        if ("array".equals(sceneArg)) {
            evaluDev.setSecondaryUpgrade(false);
            evaluDev.setContainerVersion("");
        }
    }

    private void saveUpgradeSceneData(String sceneArg, com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode, UpgradeSceneData data, EvaluDevNode evaluDev) {
        evaluDev.setUpgradeMode(UpgradeMode.valueOf(EvaluCommUtil.getActualMode(data.getUpgradeMode())));
        evaluDev.setUpgradeModeUI(UpgradeMode.valueOf(data.getUpgradeMode()));
        if (data.isStorageImageUpgrade()) {
            evaluDev.setContainerUpgradeMode(UpgradeMode.valueOf(data.getContainerUpgradeMode()));
            evaluDev.setContainerUpgradeModeUI(UpgradeMode.valueOf(data.getContainerUpgradeMode()));
            evaluDev.setContainerDestVersion(data.getContainerDestVersion());
        }
        evaluDev.setDestVersion(data.getTargetVersion());
        evaluDev.setDeviceType(this.getDeviceType(sceneArg, devNode.getDeviceType(), data));
    }

    private String getDestVersion(UpgradeSceneData data, String sceneArg) {
        return this.isContainerEvaluation(data, sceneArg) ? data.getContainerDestVersion() : data.getTargetVersion();
    }

    private String getUpgradeMode(UpgradeSceneData data, String sceneArg) {
        return this.isContainerEvaluation(data, sceneArg) ? data.getContainerUpgradeMode() : data.getUpgradeMode();
    }

    private boolean isContainerEvaluation(UpgradeSceneData data, String sceneArg) {
        return data.isStorageImageUpgrade() && "container".equals(sceneArg);
    }

    private DeviceType getDeviceType(String sceneArg, DeviceType deviceType, UpgradeSceneData data) {
        return this.isContainerEvaluation(data, sceneArg) ? DeviceType.valueOf((String)String.join((CharSequence)"_", deviceType.toString(), "container")) : deviceType;
    }

    private void addListner() {
        this.addDevListner();
        JButton delBtn = this.layout.getDelDevBtn();
        delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LOGGER.info("Operate: delete confirme button");
                OnlineEvaluMainDialog.this.delDevAction();
            }
        });
        JButton reportBtn = this.layout.getReportDirBtn();
        reportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LOGGER.info("Operate: click set report button");
                OnlineEvaluMainDialog.this.setReportDir();
            }
        });
        JButton executBtn = this.layout.getStartEvaluBtn();
        executBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Operate: click execut evalu button");
                OnlineEvaluMainDialog.this.startOrEndEvaluAction();
            }
        });
        this.detailListListener();
        IsmTable ismTable = this.layout.getDevEvaluTable();
        ListSelectionModel selectionModel = ismTable.getSelectionModel();
        selectionModel.addListSelectionListener(new TableSelectedListener());
        this.openResultBtnListener();
        this.viewBtnListener();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LOGGER.info("Operate: click close button");
                OnlineEvaluMainDialog.this.exitEvaluTool();
            }
        });
        this.setSceneReportDir();
        this.setSceneHostInfoDir();
    }

    private void viewBtnListener() {
        JButton viewBtn = this.layout.getViewEvaluReport();
        viewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Operate: click view button");
                if (OnlineEvaluMainDialog.this.evaluContext.isRunEvaluing()) {
                    DialogUtils.showInfoDialog((JDialog)OnlineEvaluMainDialog.this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.not.view.report.tip"));
                } else {
                    OnlineEvaluMainDialog.this.viewReport();
                }
            }
        });
    }

    private void openResultBtnListener() {
        JButton openResultBtn = this.layout.getOpenEvaluResult();
        openResultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Operate: click open result dir button");
                this.openResultDir();
            }

            private void openResultDir() {
                File reportDir = OnlineEvaluMainDialog.this.evaluContext.getReportDir();
                LOGGER.info(String.format(Locale.ENGLISH, "Open directory reportDir=%s", reportDir));
                if (OSCmdUtils.openFile((File)reportDir) != 0) {
                    DialogUtils.showErrorDialog((JDialog)OnlineEvaluMainDialog.this, (String)"");
                }
            }
        });
    }

    private void detailListListener() {
        JList detailList = this.layout.getDetailList();
        detailList.addMouseListener(new ListMouseAdapter());
    }

    private void addDevListner() {
        JButton addBtn = this.layout.getAddEvaluDevBtn();
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Operate: click add button");
                OnlineEvaluMainDialog.this.addDevAction();
            }
        });
    }

    private void setSceneReportDir() {
        if (SceneUtils.isScene()) {
            try {
                this.evaluContext.setReportDir(new File(this.sceneUtil.sceneResultPath()));
            }
            catch (Exception e) {
                LOGGER.error("set scene evalu dir failed!", e);
            }
        }
    }

    private void setSceneHostInfoDir() {
        LOGGER.info(String.format(Locale.ENGLISH, "current scene is :%s", this.sceneUtil.getCurrentSubScene()));
        if ("Upgrade Check".equals(this.sceneUtil.getCurrentSubScene())) {
            String hostfilePath = this.sceneUtil.sceneHostResultPath();
            LOGGER.info(String.format(Locale.ENGLISH, "Host info file(hostInfo4PreUpgradeCheck.csv) path is :%s", hostfilePath));
            if (null == hostfilePath || "".equals(hostfilePath)) {
                return;
            }
            try {
                File hostFile = new File(hostfilePath);
                if (hostFile.exists() && hostFile.isFile()) {
                    FileUtils.deleteFile((File)hostFile);
                    if (hostFile.isFile()) {
                        LOGGER.error("exist host file!");
                        DialogUtils.showErrorDialog((JDialog)this, (String)MessageFormat.format(ResourceUtil.getString((String)"scene.oper.host.file.error"), hostfilePath));
                        com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().setUpgradeEvaluTool(false);
                        FileUtils.clearDir((String)FileUtil.getCanonicalPath(this.evaluContext.getHtmlDir()));
                        this.evaluContext.fireToolStopped();
                        this.dispose();
                        return;
                    }
                }
                this.sceneUtil.setSceneHostPath(hostFile);
            }
            catch (Exception e) {
                LOGGER.error("set scene host info path failed!", e);
                DialogUtils.showErrorDialog((JDialog)this, (String)MessageFormat.format(ResourceUtil.getString((String)"scene.oper.host.file.error"), hostfilePath));
                com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().setUpgradeEvaluTool(false);
                FileUtils.clearDir((String)FileUtil.getCanonicalPath(this.evaluContext.getHtmlDir()));
                this.evaluContext.fireToolStopped();
                this.dispose();
            }
        }
    }

    private void exitEvaluToolDirect() {
        try {
            List<EvaluDevNode> devNodes = this.getEvaluDevNodeAll();
            for (EvaluDevNode evaluDevNode : devNodes) {
                if (EvaluService.isNeedOpenOrCloseTlv(evaluDevNode)) {
                    EvaluService.closeTlv(evaluDevNode);
                }
                if (EvaluState.RUN == evaluDevNode.getEvaluState()) {
                    this.evaluContext.setUserOpTaskInfo(evaluDevNode);
                    LOGGER.info(String.format(Locale.ENGLISH, "Set the UserOp info of dev: %s in state: %s success!", evaluDevNode.getIp(), evaluDevNode.getIp()));
                }
                EvaluResultXml.getInstance().setEvaluRes(evaluDevNode);
            }
            EvaluResultXml.getInstance().saveResultXml();
            this.saveUserOpdata();
            this.updateSceneData();
            this.finishedScene();
            com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().setUpgradeEvaluTool(false);
            boolean killflag = ProcessUtil.killSilenceCollect();
            LOGGER.error("kill silence Collect result:" + killflag);
        }
        catch (Exception e) {
            LOGGER.error("exit exception.", e);
        }
        FileUtils.clearDir((String)FileUtil.getCanonicalPath(this.evaluContext.getHtmlDir()));
        this.evaluContext.fireToolStopped();
        this.dispose();
    }

    private void updateSceneData() {
        SceneDataSerialize dataOperate = new SceneDataSerialize();
        Map upgradeSettings = (Map)dataOperate.deserialize();
        if (null == upgradeSettings) {
            return;
        }
        List<EvaluDevNode> devNodes = this.getEvaluDevNodeAll();
        for (EvaluDevNode evaluDevNode : devNodes) {
            String key = ApplicationContext.getInstance().isSpecificDeviceMode() ? evaluDevNode.getSvpIp() + "_" + evaluDevNode.getDeviceSerialNumber() : evaluDevNode.getIp() + "_" + evaluDevNode.getDeviceSerialNumber();
            UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
            if (null == data) continue;
            data.setNeedInstallPatch(evaluDevNode.getResultHelper().isNeedInstallPatch());
            data.setAdvisePatchVersion(evaluDevNode.getResultHelper().getInstallPatchSuggestion());
        }
        dataOperate.serialize((Object)upgradeSettings);
    }

    private void exitEvaluTool() {
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.exit.tool.tip"));
        if (0 == wd.getValue()) {
            this.exitEvaluToolDirect();
        }
    }

    private void finishedScene() {
        if (this.sceneUtil.isScene()) {
            try {
                this.sceneUtil.finishedSceneTask();
            }
            catch (Exception e) {
                LOGGER.error("scene data error.", e);
            }
        }
    }

    private void saveUserOpdata() {
        UserOpDataSaveUtil.batchSaveUserOpdata(this.evaluContext.getUseropList());
    }

    private void viewReport() {
        File rpIndex;
        String index = DEFAULT_INDEX;
        if (EvaluContext.getInstance().isCustomerRole() || EvaluContext.getInstance().isGuestRole()) {
            index = SUMMARY_INDEX;
        }
        if ((rpIndex = new File(this.evaluContext.getHtmlDir(), index)).exists()) {
            String path = FileUtil.getCanonicalPath(rpIndex);
            OSCmdUtils.openFile((File)new File(path));
            Map<EvaluDevNode, UpgEvaUserOpData> userOpDatas = this.evaluContext.getUserOpData();
            for (UpgEvaUserOpData opData : userOpDatas.values()) {
                opData.setUseEvaluReport(true);
            }
            return;
        }
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.not.report"));
    }

    public void setToolEvaluState(boolean isEvalu) {
        if (isEvalu) {
            this.evaluContext.setRunEvaluing(true);
            this.layout.getAddEvaluDevBtn().setEnabled(false);
            this.layout.getReportDirBtn().setEnabled(false);
            this.layout.getViewEvaluReport().setEnabled(false);
            this.layout.getStartEvaluBtn().setText(END_EVALUTEXT);
            this.layout.getStartEvaluBtn().setMnemonic('I');
            if (this.isAllSelectInnerCheckDev()) {
                this.layout.getStartEvaluBtn().setEnabled(false);
            } else {
                this.layout.getStartEvaluBtn().setEnabled(true);
            }
            UCD.formatMnemonicDisplay((AbstractButton)this.layout.getStartEvaluBtn());
            this.layout.getStartEvaluBtn().setToolTipText(END_TIP);
            return;
        }
        this.evaluContext.setRunEvaluing(false);
        if (!EvaluContext.isAutoAddDevice()) {
            this.layout.getAddEvaluDevBtn().setEnabled(true);
        }
        this.layout.getReportDirBtn().setEnabled(true);
        if (this.sceneUtil.isScene()) {
            this.layout.getReportDirBtn().setEnabled(false);
        }
        this.layout.getStartEvaluBtn().setEnabled(true);
        this.layout.getViewEvaluReport().setEnabled(true);
        this.layout.getStartEvaluBtn().setText(START_EVALUTEXT);
        this.layout.getStartEvaluBtn().setMnemonic('E');
        UCD.formatMnemonicDisplay((AbstractButton)this.layout.getStartEvaluBtn());
    }

    private boolean isAllSelectInnerCheckDev() {
        List<EvaluDevNode> selectDevNodes = this.getSelectDevNode();
        for (EvaluDevNode devNode : selectDevNodes) {
            if (Products.Feature.isSupportInnerCheck((String)devNode.getDeviceModel(), (String)devNode.getProductVersion())) continue;
            return false;
        }
        return true;
    }

    private List<EvaluDevNode> getSelectDevNode() {
        ArrayList<EvaluDevNode> nodeList = new ArrayList<EvaluDevNode>();
        List rows = this.layout.getDevEvaluTable().getMarkedRows();
        for (TableRow tr : rows) {
            EvaluDevNode node = (EvaluDevNode)((Object)tr.getUserObject());
            nodeList.add(node);
        }
        return nodeList;
    }

    private void startOrEndEvaluAction() {
        if (this.evaluContext.isRunEvaluing()) {
            this.interruptEvalu();
            try {
                String res = this.evaluContext.isEndEvalu() ? "true" : "false";
                LOGGER.info(String.format(Locale.ENGLISH, "evalu is doing. set evalu status  isEndEvalu: %s", res));
                if (this.evaluContext.isEndEvalu()) {
                    Map<EvaluDevNode, UpgEvaUserOpData> allDevUserOpDatas = this.evaluContext.getUserOpData();
                    for (UpgEvaUserOpData opData : allDevUserOpDatas.values()) {
                        opData.setInterrupt(true);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Log records failed.", e);
            }
            return;
        }
        final List<EvaluDevNode> tabDevs = this.getSelectDevNode();
        if (EvaluContext.isAutoAddDevice()) {
            AsyncExcutor.execute((Window)this, (boolean)true, (long)50000L, (Callable[])new Callable[]{new LoadEvaluItemCallable(tabDevs)});
        }
        if (tabDevs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.not.selected.dev"));
            return;
        }
        final File resultDir = this.evaluContext.getHtmlDir();
        this.refreshDetailList(false);
        this.resetSelectedDev(tabDevs);
        this.devMgr.getEvaluDevs().addAll(tabDevs);
        this.devMgr.setOriginalNum(tabDevs.size());
        this.addDevsToUserOpMap(tabDevs);
        ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(OnlineEvaluMainDialog.EVALU_MANAGER);
                EvaluTaskManager mgr = new EvaluTaskManager(tabDevs, OnlineEvaluMainDialog.this, resultDir);
                mgr.evaluDevs();
            }
        }).start();
        this.setToolEvaluState(true);
    }

    private void addDevsToUserOpMap(List<EvaluDevNode> devs) {
        for (EvaluDevNode dev : devs) {
            UpgEvaUserOpData userOpData = new UpgEvaUserOpData();
            userOpData.setDevNode(dev);
            userOpData.setToVersion(dev.getDestVersion());
            userOpData.setUpgradeType(dev.getUpgradeModeUI());
            if (this.evaluContext.getIsClickUpgTipsMap().get((Object)dev).booleanValue()) {
                userOpData.setIsClickUpgTips(IsClickUpgTips.CLICKED);
            }
            this.evaluContext.getUserOpData().put(dev, userOpData);
            LOGGER.info(String.format(Locale.ENGLISH, "Bind the userOpInfo with dev: %s success.", dev.getIp()));
        }
    }

    private void interruptEvalu() {
        if (!this.evaluContext.isEndEvalu()) {
            WarningDialog endWarning = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.warn.end"));
            if (0 == endWarning.getValue()) {
                this.evaluContext.setEndEvalu(true);
                return;
            }
            return;
        }
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"eualu.ui.mainDialog.dev.showInfo.end"));
    }

    private void delDevAction() {
        if (0 == this.layout.getDevEvaluTable().getMarkedRows().size()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.selected.delete.dev"));
            return;
        }
        ArrayList<EvaluDevNode> nods = new ArrayList<EvaluDevNode>();
        List rows = this.layout.getDevEvaluTable().getMarkedRows();
        ArrayList<TableRow> rmRows = new ArrayList<TableRow>();
        this.getNotRunDev(nods, rows, rmRows);
        if (nods.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.dev.run.not.delete"));
            LOGGER.info("Remove device failed. Selected device have exsit.");
            return;
        }
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.is.conform.delete.dev"));
        if (0 == wd.getValue()) {
            this.layout.getTableModel().removeRow(rmRows);
            this.devMgr.delTabDevs(nods);
            DefaultListModel listModel = this.layout.getListModel();
            listModel.removeAllElements();
            this.refreshDetailList(true);
        }
        if (this.layout.getTableModel().getAllRows().isEmpty()) {
            this.layout.getEvaluProcessLabel().setText("");
        }
        wd.dispose();
    }

    private void getNotRunDev(List<EvaluDevNode> nods, List<TableRow> rows, List<TableRow> rmRows) {
        for (TableRow row : rows) {
            EvaluDevNode node = (EvaluDevNode)((Object)row.getUserObject());
            if (this.devMgr.getEvaluDevs().contains((Object)node)) continue;
            nods.add(node);
            rmRows.add(row);
        }
    }

    private void setReportDir() {
        String[] exts = new String[]{};
        File file = ToolFileChooser.selectFile((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic"), (String[])exts, (String)SAVEPATH_DEFAULT_ID, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.file"), (int)1);
        if (!this.validFile(file)) {
            LOGGER.info("set report for upgrade evalu failed. validFile");
            return;
        }
        this.evaluContext.setReportDir(file);
        LOGGER.info(String.format(Locale.ENGLISH, "Set report directory for upgrade evalu: %s success", file));
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic.success"));
    }

    private boolean validFile(File reportDir) {
        if (null == reportDir) {
            return false;
        }
        try {
            String path = reportDir.getCanonicalPath();
            if (!FileUtil.checkNormalPath(path)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                this.setReportDir();
                return false;
            }
            if (!FileUtil.checkBlankPath(path)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                this.setReportDir();
                return false;
            }
        }
        catch (IOException e1) {
            LOGGER.error("save collect dir failed!!!", e1);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.set.dic.error"));
            return false;
        }
        return true;
    }

    private void showBeforeCheckItemDetail(EvaluItem item) {
        if (item.getRetItem().getRetFlag().equals((Object)ResultFlag.NOTPASS) || item.getRetItem().getRetFlag().equals((Object)ResultFlag.WARN)) {
            SimpleDetailInfoDialog dialog = new SimpleDetailInfoDialog(item.getRetItem().getErrorInfo(), this);
            dialog.setVisible(true);
        }
    }

    @Override
    public void refreshDetailList(boolean isRewriteDetail) {
        List<EvaluDevNode> devs = this.getSelectDevNode();
        this.addScrollBarListener();
        DefaultListModel listModel = this.layout.getListModel();
        listModel.removeAllElements();
        if (devs.size() != 1 || !isRewriteDetail) {
            return;
        }
        EvaluDevNode dev = devs.get(0);
        ExtraCheckItem extraCheckItem = dev.getExtraCheckItem();
        this.showExtraCheckItem(extraCheckItem.getBeforeCheckItems());
        List<EvaluItem> items = dev.getAllEvaluItem();
        for (EvaluItem item : items) {
            ResultItem ri = item.getRetItem();
            if (null == ri) continue;
            listModel.addElement(item);
        }
        this.showExtraCheckItem(extraCheckItem.getAfterCheckItems());
    }

    private void addScrollBarListener() {
        final JScrollBar scrollBar = this.layout.getScrollPane().getVerticalScrollBar();
        if (scrollBar == null) {
            return;
        }
        scrollBar.setValue(scrollBar.getMaximum());
        scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TableRow tableRow = OnlineEvaluMainDialog.this.layout.getDevEvaluTable().getMarkedRow();
                if (tableRow == null) {
                    return;
                }
                EvaluDevNode markedDev = (EvaluDevNode)((Object)tableRow.getUserObject());
                if (!markedDev.isEvaluFinish()) {
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            }
        });
    }

    private void showExtraCheckItem(List<EvaluItem> extraCheckItems) {
        DefaultListModel listModel = this.layout.getListModel();
        for (EvaluItem extraItem : extraCheckItems) {
            if (null == extraItem.getRetItem().getRetFlag()) continue;
            listModel.addElement(extraItem);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }

    private void addDevAction() {
        if (!this.evaluContext.isExistsPkg()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"eualu.ui.listener.addDev.not.product"));
            return;
        }
        ClassLoader classLoader = OnlineEvaluMainDialog.class.getClassLoader();
        if (classLoader == null) {
            return;
        }
        List results = AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new AddDeviceCall(this, this.evaluContext, classLoader)});
        Boolean addResult = (Boolean)results.get(0);
        if (addResult == null || !addResult.booleanValue()) {
            LOGGER.error("initial FlowWizardDialog failed!");
            return;
        }
    }

    @Override
    public void addDev2Table(List<EvaluDevNode> evaludevs) {
        this.devMgr.addTabDevs(evaludevs);
        IsmTable ismTab = this.layout.getDevEvaluTable();
        DefaultTableModel defaultTab = this.layout.getTableModel();
        RowSorter rowSorter = ismTab.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(new ArrayList());
        }
        ArrayList<TableRow> oldRows = new ArrayList<TableRow>();
        ArrayList<EvaluDevNode> storageDev = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> totalDev = new ArrayList<EvaluDevNode>();
        for (EvaluDevNode devNode : this.devMgr.getTabDevs()) {
            switch (devNode.getItDeviceType()) {
                case A800_NODE: 
                case Storage: {
                    storageDev.add(devNode);
                    break;
                }
                case Host: {
                    totalDev.add(devNode);
                    break;
                }
            }
        }
        totalDev.addAll(storageDev);
        defaultTab.removeAll();
        this.checkSupportDev(oldRows, totalDev);
        defaultTab.addRow(oldRows.toArray(new TableRow[oldRows.size()]));
        this.sceneSelectDev(oldRows);
    }

    private void checkSupportDev(List<TableRow> oldRows, List<EvaluDevNode> totalDev) {
        String msg;
        String ipStr;
        ArrayList<String> otherDevsInSvp = new ArrayList<String>();
        ArrayList<String> highDevsOutSvp = new ArrayList<String>();
        int cols = this.layout.getTableHeaders().length;
        for (EvaluDevNode evaluDev : totalDev) {
            if (!evaluDev.isIpListAreInnerIp() && LocalHostUtil.isRunInV3LaterSvp() && !evaluDev.canEnterDiagnose()) {
                LOGGER.info("the other dev in svp device:{1}", (Object)evaluDev.getSvpIp());
                otherDevsInSvp.add(evaluDev.getSvpIp());
                continue;
            }
            if (ArrayUtils.isHighEndDevOuterSvp((DevNode)EntityUtils.toOldDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)evaluDev)) && !evaluDev.canEnterDiagnose()) {
                LOGGER.info("the has svp module device not in svp:{1}", (Object)evaluDev.getIp());
                highDevsOutSvp.add(evaluDev.getIp());
                continue;
            }
            TableRow<EvaluDevNode, String> row = this.createDevEvaluTabRow(cols, evaluDev);
            oldRows.add(row);
        }
        if (!otherDevsInSvp.isEmpty()) {
            ipStr = StringUtils.join(otherDevsInSvp, ",");
            msg = ResourceUtil.getStringWithParams((String)"preupgradeCheck.upgradeEvaluation.device.svp.add.other.device", (Object[])new Object[]{ipStr});
            DialogUtils.showInfoDialog((JDialog)this, (String)msg);
        }
        if (!highDevsOutSvp.isEmpty()) {
            ipStr = StringUtils.join(highDevsOutSvp, ",");
            msg = ResourceUtil.getStringWithParams((String)"preupgradeCheck.upgradeEvaluation.device.add.svp.device.notSvp", (Object[])new Object[]{ipStr});
            DialogUtils.showInfoDialog((JDialog)this, (String)msg);
        }
    }

    private void sceneSelectDev(List<TableRow> oldRows) {
        int rowNum = 0;
        for (TableRow row : oldRows) {
            EvaluDevNode node = (EvaluDevNode)((Object)row.getUserObject());
            if (this.sceneUtil.isScene() && this.sceneUtil.sceneSelectDevNode(node.getDeviceSerialNumber())) {
                this.layout.getDevEvaluTable().addRowSelectionInterval(rowNum, rowNum);
            }
            ++rowNum;
        }
    }

    private TableRow<EvaluDevNode, String> createDevEvaluTabRow(int columns, EvaluDevNode dev) {
        DefaultTableRow row = new DefaultTableRow(columns, (Object)dev, (Object)dev.getId());
        int number0 = 0;
        number0 = this.createDevTypeTabCell(dev, (TableRow<EvaluDevNode, String>)row, number0);
        row.setValueAt(number0++, (Object)(com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)dev.getDeviceName()) ? "--" : dev.getDeviceName()));
        row.setValueAt(number0++, (Object)dev.getDeviceSerialNumber());
        row.setValueAt(number0++, (Object)dev.getDeviceType().toString());
        row.setValueAt(number0++, (Object)dev.getIp());
        row.setValueAt(number0++, (Object)this.getDeviceVerison(dev));
        row.setValueAt(number0++, (Object)this.getTargetVersion(dev));
        row.setValueAt(number0++, (Object)dev.getUpgradeModeUI().getDesc());
        int progress = dev.getEvaluProgress();
        row.setValueAt(number0++, (Object)new IsmTableCell.ProgressCell(progress));
        row.setValueAt(number0++, (Object)this.getIconByEvaluState(dev.getEvaluState()));
        if (!dev.getEvaluState().equals((Object)EvaluState.SUCCESS)) {
            row.setValueAt(number0++, (Object)"");
        } else {
            row.setValueAt(number0++, (Object)this.getIconByEvaluRet(dev));
        }
        if (!EvaluContext.isAutoAddDevice()) {
            row.setValueAt(number0++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"evalu.ui.tabel.row.update"), (ActionListener)new AlertHyperLink(dev)));
        }
        return row;
    }

    @NotNull
    private String getTargetVersion(EvaluDevNode dev) {
        StringBuilder targetVersion = new StringBuilder(dev.getDestVersion());
        if (dev.getUpgradeMode() == UpgradeMode.APOLLO) {
            targetVersion.append(String.format(Locale.ROOT, ResourceUtil.getString((String)"evalu.ui.mainWindow.table.content.kernelversion"), dev.getTargetKernelVersion()));
        }
        return targetVersion.toString();
    }

    @NotNull
    private String getDeviceVerison(EvaluDevNode dev) {
        StringBuilder deviceVersion = new StringBuilder(dev.getProductVersion());
        if (dev.getUpgradeMode() == UpgradeMode.APOLLO) {
            deviceVersion.append(String.format(Locale.ROOT, ResourceUtil.getString((String)"evalu.ui.mainWindow.table.content.kernelversion"), dev.getDeviceKernelVersion()));
        } else if (dev.getUpgradeMode() == UpgradeMode.PATCH_CONTAINER || dev.getUpgradeMode() == UpgradeMode.OFFLINE_CONTAINER) {
            deviceVersion = new StringBuilder(dev.getContainerVersion());
        }
        return deviceVersion.toString();
    }

    private IsmTableCell.IconCell getIconByEvaluRet(EvaluDevNode dev) {
        IsmTableCell.IconCell evaluResult = null;
        ResultFlag retFlag = dev.getEvaluRet().getRetFlag();
        ImageIcon imageIcon = EvaluConstants.FAILED_IMG;
        String passString = ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.pass");
        if (ResultFlag.PASS.equals((Object)retFlag) || ResultFlag.NOSUPPORT.equals((Object)retFlag)) {
            imageIcon = EvaluConstants.SUCCESS_IMG;
            passString = ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.pass");
        }
        evaluResult = new IsmTableCell.IconCell((Icon)imageIcon, passString);
        return evaluResult;
    }

    private int createDevTypeTabCell(EvaluDevNode dev, TableRow<EvaluDevNode, String> row, int num) {
        String devType = "";
        switch (dev.getItDeviceType()) {
            case A800_NODE: 
            case Storage: {
                devType = ResourceUtil.getString((String)"evalu.ui.mainDialog.table.row.storage");
                break;
            }
            case Host: {
                devType = ResourceUtil.getString((String)"evalu.ui.mainDialog.table.row.host");
                break;
            }
            case Switch: {
                devType = ResourceUtil.getString((String)"evalu.ui.mainDialog.table.row.switch");
                break;
            }
            default: {
                devType = "--";
            }
        }
        row.setValueAt(num++, (Object)devType);
        return num;
    }

    private IsmTableCell.IconCell getIconByEvaluState(EvaluState state) {
        IsmTableCell.IconCell iconCell = null;
        String evalueStateStr = "";
        ImageIcon imageIcon = null;
        if (EvaluState.WAIT.equals((Object)state)) {
            evalueStateStr = ResourceUtil.getString((String)"evalu.evaluState.wait.evaluation");
            imageIcon = EvaluConstants.NOTEVALU_IMG;
        } else if (EvaluState.RUN.equals((Object)state)) {
            evalueStateStr = ResourceUtil.getString((String)"evalu.evaluState.under.evaluation");
            imageIcon = this.evaluContext.getProcessingImage();
        } else if (EvaluState.FAILURE.equals((Object)state)) {
            evalueStateStr = ResourceUtil.getString((String)"evalu.svaluState.failure.evaluation");
            imageIcon = EvaluConstants.FAILED_IMG;
        } else if (EvaluState.SUCCESS.equals((Object)state)) {
            evalueStateStr = ResourceUtil.getString((String)"evalu.svaluState.success.evaluation");
            imageIcon = EvaluConstants.SUCCESS_IMG;
        }
        this.startGifSwitch(state);
        iconCell = new IsmTableCell.IconCell((Icon)imageIcon, evalueStateStr);
        return iconCell;
    }

    private void observeStatusChange() {
        WarningDialog wd;
        if (!SceneUtils.isScene()) {
            return;
        }
        List<EvaluDevNode> allEvaluNodes = this.getEvaluDevNodeAll();
        int succeedDevNum = 0;
        for (EvaluDevNode evaluNodes : allEvaluNodes) {
            if (evaluNodes.getEvaluState() == EvaluState.RUN) {
                EvaluContext.setStartTime(new Date());
                return;
            }
            if (evaluNodes.getEvaluState() == EvaluState.SUCCESS && evaluNodes.getEvaluRet().getRetFlag() == ResultFlag.PASS) {
                ++succeedDevNum;
                EvaluContext.setEndTime(new Date());
                continue;
            }
            if (evaluNodes.getEvaluState() != EvaluState.FAILURE) continue;
            LOGGER.info(String.format(Locale.ENGLISH, "set end time:%s", new Date()));
            EvaluContext.setEndTime(new Date());
        }
        if (!this.evaluContext.isRunEvaluing() && succeedDevNum > 0 && succeedDevNum == allEvaluNodes.size() && 0 == (wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.finish.exit.tool"))).getValue()) {
            this.exitEvaluToolDirect();
        }
    }

    private void startGifSwitch(EvaluState state) {
        if (EvaluState.RUN.equals((Object)state) && !this.gifAssistant.isStart()) {
            this.gifAssistant.start();
        }
        if (EvaluState.RUN.equals((Object)state) || EvaluState.WAIT.equals((Object)state)) {
            return;
        }
        for (EvaluDevNode devNode : this.devMgr.getEvaluDevs()) {
            if (!EvaluState.RUN.equals((Object)devNode.getEvaluState())) continue;
            return;
        }
        this.gifAssistant.stopGifLoading();
    }

    @Override
    public void refreshLoadingPic() {
        List<TableRow> loadingRows = this.findLoadingRows();
        if (loadingRows.isEmpty()) {
            this.gifAssistant.stopGifLoading();
            return;
        }
        for (TableRow row : loadingRows) {
            row.setValueAt(9, (Object)new IsmTableCell.IconCell((Icon)this.evaluContext.getProcessingImage(), ResourceUtil.getString((String)"evalu.evaluState.under.evaluation")));
        }
        this.layout.getDevEvaluTable().repaint();
    }

    private List<TableRow> findLoadingRows() {
        LinkedList<TableRow> loadingRows = new LinkedList<TableRow>();
        List allRows = this.layout.getTableModel().getAllRows();
        for (TableRow row : allRows) {
            if (!this.isLoadingRow((TableRow<com.huawei.ism.tool.framework.pubservice.entity.DevNode, String>)row)) continue;
            loadingRows.add(row);
        }
        return loadingRows;
    }

    private boolean isLoadingRow(TableRow<com.huawei.ism.tool.framework.pubservice.entity.DevNode, String> row) {
        IsmTableCell.IconCell iconCell = (IsmTableCell.IconCell)row.getValueAt(9);
        if (iconCell == null) {
            return false;
        }
        return iconCell.toString().equals(ResourceUtil.getString((String)"evalu.evaluState.under.evaluation"));
    }

    public OnlineEvaluMainDialogLayout getMainLayout() {
        return this.layout;
    }

    @Override
    public void finishAll() {
        this.setToolEvaluState(false);
        this.evaluContext.setEndEvalu(false);
        this.observeStatusChange();
    }

    private void resetSelectedDev(List<EvaluDevNode> evaluDevs) {
        if (evaluDevs.isEmpty()) {
            return;
        }
        for (EvaluDevNode dev : evaluDevs) {
            dev.reset();
            this.evaluProcessTip("");
            this.updateDevTableRow(dev);
        }
    }

    private TableRow<EvaluDevNode, String> getTableRowById(String id) {
        List tableRows = this.layout.getDevEvaluTable().getAllRows();
        for (TableRow row : tableRows) {
            if (!row.getIdentifier().equals(id)) continue;
            return row;
        }
        return null;
    }

    private void modifyTableRow(EvaluDevNode dev) {
        TableRow<EvaluDevNode, String> row = this.getTableRowById(dev.getId());
        if (null == row) {
            return;
        }
        row.setValueAt(5, (Object)this.getDeviceVerison(dev));
        row.setValueAt(6, (Object)this.getTargetVersion(dev));
        this.modifyTableSevenLine(row, dev);
        row.setValueAt(8, (Object)new IsmTableCell.ProgressCell(dev.getEvaluProgress()));
        EvaluState evaluState = dev.getEvaluState();
        row.setValueAt(9, (Object)this.getIconByEvaluState(evaluState));
        if (!evaluState.equals((Object)EvaluState.SUCCESS)) {
            row.setValueAt(10, (Object)"");
        } else {
            row.setValueAt(10, (Object)this.getIconByEvaluRet(dev));
        }
        this.layout.getDevEvaluTable().repaint();
        this.observeStatusChange();
    }

    private void modifyTableSevenLine(TableRow row, EvaluDevNode dev) {
        row.setValueAt(7, (Object)dev.getUpgradeModeUI().getDesc());
    }

    private void openHelpFile(String fileName, Window parent) {
        String htmlFileName = fileName + "_" + this.evaluContext.getLoc().getLanguage() + ".chm";
        String workDir = this.evaluContext.getHome();
        File helpFilePath = new File(workDir, "help");
        File helpFile = new File(helpFilePath, htmlFileName);
        LOGGER.info(String.format(Locale.ENGLISH, "explorer help file:%s", helpFile));
        if (!helpFile.exists()) {
            if (ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString((String)"evalu.help.warning"));
        } else {
            OSCmdUtils.explorerFile((File)helpFile);
        }
    }

    @Override
    public void updateDevTableRow(final EvaluDevNode dev) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnlineEvaluMainDialog.this.modifyTableRow(dev);
            }
        });
    }

    @Override
    public void updateDetailList(final EvaluItem item) {
        List<EvaluDevNode> selectDevs = this.getSelectDevNode();
        if (selectDevs.size() != 1 || !selectDevs.get(0).getId().equals(item.getDevID())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OnlineEvaluMainDialog.this.layout.getListModel().contains(item)) {
                    int itemIndex = OnlineEvaluMainDialog.this.layout.getListModel().indexOf(item);
                    OnlineEvaluMainDialog.this.layout.getListModel().set(itemIndex, item);
                } else {
                    OnlineEvaluMainDialog.this.layout.getListModel().addElement(item);
                }
            }
        });
    }

    @Override
    public void updateChildItems(EvaluDevNode evaluDev, String moduleId, Map<String, Object> jsonMsg) {
        List<EvaluItem> childItems = this.convertMsg2CheckItems(jsonMsg, evaluDev);
        ProductCfg product = evaluDev.getProduct(CrossVersionType.INNERVERSION);
        product.setDynamicEvaluItems(moduleId, childItems);
        this.updateDetailList(evaluDev.getId(), childItems);
    }

    public void updateDetailList(String devId, final List<EvaluItem> items) {
        List<EvaluDevNode> selectDevs = this.getSelectDevNode();
        if (selectDevs.size() != 1 || !selectDevs.get(0).getId().equals(devId)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (EvaluItem item : items) {
                    OnlineEvaluMainDialog.this.layout.getListModel().removeElement(item);
                    OnlineEvaluMainDialog.this.layout.getListModel().addElement(item);
                }
            }
        });
    }

    private List<EvaluItem> convertMsg2CheckItems(Map<String, Object> jsonMsg, EvaluDevNode evaluDevNode) {
        ArrayList<EvaluItem> items = new ArrayList<EvaluItem>();
        List mpItems = PyJavaUtils.convertPyList2Jlist((Object)jsonMsg.get("checkitems"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map item : mpItems) {
            EvaluItem checkItem = new EvaluItem();
            checkItem.setItemType("innerCheck");
            checkItem.setShowOrigin(false);
            checkItem.setDevID(evaluDevNode.getId());
            String suggession = item.get("suggession").toString();
            ResultItem retItem = new ResultItem();
            retItem.setErrorInfo(suggession);
            retItem.setSourceInfo("");
            int status = Integer.parseInt(item.get("status").toString());
            retItem.setRetFlag(ResultFlag.valueOf(status));
            String ctrl = item.get("ctrl").toString();
            checkItem.setRetItem(retItem);
            String name = item.get("name").toString();
            checkItem.setName(name);
            if (item.containsKey("startTime")) {
                String startTime = item.get("startTime").toString();
                try {
                    Date date = simpleDateFormat.parse(startTime);
                    retItem.setFinishTime(date);
                }
                catch (ParseException e) {
                    retItem.setFinishTime(Calendar.getInstance().getTime());
                    LOGGER.error(String.format(Locale.ENGLISH, "parse exception, startTime=%s", startTime));
                }
            }
            if (item.containsKey("nameId")) {
                String nameId = item.get("nameId").toString();
                checkItem.setId(nameId);
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(checkItem.getId() + "_" + ctrl);
            checkItem.setIdentifier(buffer.toString());
            if (item.containsKey("extras")) {
                Object extras = item.get("extras");
                checkItem.setExtras(extras);
                evaluDevNode.getExtraEvaluItems().put(checkItem.getId(), checkItem);
            }
            items.add(checkItem);
        }
        return items;
    }

    @Override
    public void showTaskErr(String errMsg) {
        DialogUtils.showErrorDialog((JDialog)this, (String)errMsg);
    }

    public void doHelpActionWork() {
        this.openHelpFile("UpgradeEvaluation", this);
    }

    public String getListenerName() {
        return "HelpTitleDialog:" + this.getClass().getSimpleName();
    }

    @Override
    public void evaluProcessTip(String msg) {
        this.layout.getEvaluProcessLabel().setText(msg);
    }

    private List<EvaluDevNode> getEvaluDevNodeAll() {
        List rows = this.layout.getDevEvaluTable().getAllRows();
        ArrayList<EvaluDevNode> nodeList = new ArrayList<EvaluDevNode>();
        for (TableRow tr : rows) {
            EvaluDevNode node = (EvaluDevNode)((Object)tr.getUserObject());
            nodeList.add(node);
        }
        return nodeList;
    }

    @Override
    public void updateItemProgress(EvaluDevNode dev, int progress, String itemId) {
        this.updateItemProgress(dev, progress, "", itemId);
    }

    @Override
    public synchronized void updateItemProgress(EvaluDevNode dev, int progress, String timeLeft, String itemId) {
        try {
            if (0 > progress || 100 < progress) {
                return;
            }
            int itemSize = this.layout.getListModel().getSize();
            EvaluItem currentItem = (EvaluItem)this.layout.getListModel().get(itemSize - 1);
            if (!itemId.equals(currentItem.getId())) {
                return;
            }
            List<EvaluDevNode> selectDevs = this.getSelectDevNode();
            if (selectDevs.size() != 1 || !selectDevs.get(0).getId().equals(currentItem.getDevID()) || !dev.getId().equals(currentItem.getDevID())) {
                return;
            }
            ItemProgressUpdateUtil.INS.setProgress(currentItem.getDevID(), progress, timeLeft);
        }
        catch (Exception e) {
            LOGGER.error("update item progress error", e);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    private class AlertHyperLink
    implements ActionListener {
        private EvaluDevNode dev;

        public AlertHyperLink(EvaluDevNode dev) {
            this.dev = dev;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.info("Operate: click change link");
            if (OnlineEvaluMainDialog.this.devMgr.getEvaluDevs().contains((Object)this.dev) && OnlineEvaluMainDialog.this.evaluContext.isRunEvaluing()) {
                DialogUtils.showInfoDialog((JDialog)OnlineEvaluMainDialog.this, (String)ResourceUtil.getString((String)"evalu.ui.table.row.update.tip"));
            } else {
                DevModifyOperationDialog devModeifyOper = new DevModifyOperationDialog(OnlineEvaluMainDialog.this, this.dev, OnlineEvaluMainDialog.this);
                SwingUtil.putParentCenter((Window)devModeifyOper, (Window)OnlineEvaluMainDialog.this);
                devModeifyOper.setVisible(true);
            }
        }
    }

    private static class AddDeviceCall
    implements Callable<Boolean> {
        private EvaluContext evaluContext;
        private ClassLoader classLoader;
        private OnlineEvaluMainDialog mainDialogObj;

        public AddDeviceCall(OnlineEvaluMainDialog mainDialogObj, EvaluContext evaluContext, ClassLoader classLoader) {
            this.evaluContext = evaluContext;
            this.classLoader = classLoader;
            this.mainDialogObj = mainDialogObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            InputStream defXmlStream = this.classLoader.getResourceAsStream(OnlineEvaluMainDialog.WIZARD_DEFINE_PATH);
            InputStream flowXmlStream = this.classLoader.getResourceAsStream(this.getFlowXmlPath());
            FlowWizardDialog wizard = null;
            try {
                this.evaluContext.setIsClickUpgTips(false);
                wizard = new FlowWizardDialog((Window)this.mainDialogObj, this.evaluContext.getLoc(), this.classLoader, defXmlStream, flowXmlStream, null);
                this.evaluContext.setWizDialog(wizard);
                UiMethod.putScreenCenter((Window)wizard);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)flowXmlStream);
                StreamUtils.closeStream(null, (InputStream)defXmlStream);
            }
            wizard.setVisible(true);
            return true;
        }

        @NotNull
        private String getFlowXmlPath() {
            return A800Utils.isA800UpgradeCheck() ? OnlineEvaluMainDialog.A800_WIZARD_FLOW_PATH : OnlineEvaluMainDialog.WIZARD_FLOW_PATH;
        }
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        private ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LOGGER.info("Operate: click change link");
            if (SwingUtilities.isRightMouseButton(e) || e.getClickCount() > 1) {
                return;
            }
            int index = OnlineEvaluMainDialog.this.getListIndex(e.getPoint(), OnlineEvaluMainDialog.this.layout.getDetailList());
            if (-1 == index) {
                return;
            }
            DefaultListModel model = (DefaultListModel)OnlineEvaluMainDialog.this.layout.getDetailList().getModel();
            Object obj = model.getElementAt(index);
            this.handleDetailedList(obj);
        }

        private void handleDetailedList(Object obj) {
            if (obj instanceof EvaluItem) {
                EvaluItem item = (EvaluItem)obj;
                if (item.isForgeItem()) {
                    OnlineEvaluMainDialog.this.showBeforeCheckItemDetail(item);
                    return;
                }
                if (EvaluContext.getInstance().isCustomerRole() || EvaluContext.getInstance().isGuestRole()) {
                    return;
                }
                ItemDetailDialog detailDialog = new ItemDetailDialog(OnlineEvaluMainDialog.this, item);
                detailDialog.setVisible(true);
            }
        }
    }

    private class TableSelectedListener
    implements ListSelectionListener {
        private TableSelectedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            OnlineEvaluMainDialog.this.refreshDetailList(true);
        }
    }
}

