/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.MultiInfoDialog;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.upgradeevalu.entity.HostAssociationSetting;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.entity.HostTableRow;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.ui.SetAssociationDialogLayout;
import com.huawei.ism.tool.upgradeevalu.ui.SetHostDBAssociationDialogLayout;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAssociationDialog
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(SetAssociationDialog.class);
    private static final int MAPPED_STORAGE_ROWINDEX = 3;
    private static final long serialVersionUID = 7739171721492578816L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SetAssociationDialog.class);
    private SetAssociationDialogLayout storageHostAssocPageLayout;
    private ToolWizardDialog mainWizardDialog;
    private JLabel topDes;
    private SetHostDBAssociationDialogLayout hostDBAssociationDialogLayout;
    private HostEvaluMainDialog mainDialog;
    private JPanel cardPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private JLabel selectedAssocType;
    private Map<DevNode, DevNode> hostDbMapCache = new HashMap<DevNode, DevNode>();
    private static final Color COLOR_BLUE = new Color(73, 157, 242);
    private JLabel storageHostLabel = new JLabel(ResourceUtil.getString((String)"eval.associate.main.page.navigate.label.storage.host"), 0);
    private JLabel dbHostLabel = new JLabel(ResourceUtil.getString((String)"eval.associate.main.page.navigate.label.db.host"), 0);

    public void setWizardDialog(ToolWizardDialog wizardDialog) {
        this.mainWizardDialog = wizardDialog;
    }

    public void initPage(HostEvaluMainDialog parent) {
        this.initStorageHostAssociatePage(parent);
        this.initDBHostAssociatePage(parent);
        this.setLayout(new BorderLayout());
        this.add(this.buildTopTab(), "North");
        this.add(this.cardPanel, "Center");
        this.addTabPages();
        this.setLabelSelectedBorder(this.storageHostLabel, true);
        this.initListener();
    }

    public void setPreviousCard(ToolWizardDialog.Card previousCard) {
        super.setPreviousCard(previousCard);
    }

    public void setMainDialog(HostEvaluMainDialog mainDialog) {
        this.mainDialog = mainDialog;
    }

    public SetAssociationDialog(HostEvaluMainDialog parent, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(null, supportedNavigation);
        this.initPage(parent);
        ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Previous)).setVisible(false);
        ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Complete)).setVisible(false);
        UiMethod.setComponentSameMaxWidthSize((JComponent[])this.getNavigationButtons().values().toArray(new JButton[this.getNavigationButtons().size()]));
    }

    public void addTabPages() {
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add(ResourceUtil.getString((String)"eval.associate.main.page.navigate.label.storage.host"), this.storageHostAssocPageLayout);
        this.cardPanel.add(ResourceUtil.getString((String)"eval.associate.main.page.navigate.label.db.host"), this.hostDBAssociationDialogLayout);
    }

    private void setLabelSelectedBorder(JLabel label, boolean isChangeSelected) {
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, COLOR_BLUE));
        if (isChangeSelected) {
            this.selectedAssocType = label;
        }
    }

    private Component buildTopTab() {
        JLabel dbDes;
        this.topDes = dbDes = new JLabel(ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.storagehost.topDes"));
        this.topDes.setToolTipText(ResourceUtil.getString((String)"eval.associate.wizard.setting.guide.tip"));
        JComponent component = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((int)10, (Component[])new Component[]{this.topDes}), Box.createVerticalStrut(1)});
        this.topDes.setFont(new Font(this.dbHostLabel.getFont().getName(), 0, LanguageManager.isEnglish() ? 12 : 13));
        component.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(153, 153, 153)));
        return component;
    }

    public void initStorageHostAssociatePage(HostEvaluMainDialog parent) {
        this.mainDialog = parent;
        this.storageHostAssocPageLayout = new SetAssociationDialogLayout();
        this.init();
    }

    public void init() {
        this.initTableData();
    }

    public void initTableData() {
        List allDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (null == allDevNodes || allDevNodes.isEmpty()) {
            LOGGER.info("devnode list is null or empty");
            return;
        }
        for (DevNode devNode : allDevNodes) {
            if (null != devNode.getItDeviceType() && !ItDeviceType.Storage.equals((Object)devNode.getItDeviceType())) continue;
            this.addRow2StorageTable(devNode);
        }
        this.storageHostAssocPageLayout.getStorageTable().setRowSelectionInterval(0, 0);
        List<HostAssociationSetting> selectedStorageDevs = this.getSelectedStorageRows();
        if (!selectedStorageDevs.isEmpty()) {
            HostAssociationSetting setting = selectedStorageDevs.get(0);
            this.updateDynamicMiddleDes(setting);
            this.initHostTable(setting);
            this.storageHostAssocPageLayout.setVisibleOfViewLink(!setting.getNotAllowAssociatedHosts().isEmpty());
        }
    }

    private void addRow2StorageTable(DevNode devNode) {
        List rows = this.storageHostAssocPageLayout.getStorageModel().getAllRows();
        TableRow<HostAssociationSetting, String> row = this.createStorageTableRow(devNode);
        rows.add(0, row);
        RowSorter rowSorter = this.storageHostAssocPageLayout.getStorageTable().getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(new ArrayList());
        }
        this.storageHostAssocPageLayout.getStorageModel().removeAll();
        this.storageHostAssocPageLayout.getStorageModel().addRow(rows);
    }

    public void initHostTable(HostAssociationSetting setting) {
        HostEvalNode hostEvaluNode = (HostEvalNode)HostEvalContext.getStorageMap().get(setting.getStorageDevice().getDeviceSerialNumber());
        if (null != hostEvaluNode) {
            this.storageHostAssocPageLayout.getHostModel().removeAll();
            int needmarkRows = this.addManualAssociatedHost2HostTable(setting);
            this.addUnAssociatedHost2HostTable(setting);
            if (needmarkRows > 0) {
                this.storageHostAssocPageLayout.getHostTable().setRowSelectionInterval(0, needmarkRows - 1);
            }
        }
        this.storageHostAssocPageLayout.removeHostTableTips();
    }

    private int addManualAssociatedHost2HostTable(HostAssociationSetting setting) {
        List<DevNode> hosts = setting.getManulAssociatedHosts();
        return this.insertHost2HostTable(hosts);
    }

    private int addUnAssociatedHost2HostTable(HostAssociationSetting setting) {
        List<DevNode> unAssociateHosts = setting.getUnAssociateHosts();
        List<DevNode> errDevList = HostEvalContext.getErrHostDevs();
        if (!errDevList.isEmpty()) {
            unAssociateHosts.removeAll(errDevList);
        }
        return this.insertHost2HostTable(unAssociateHosts);
    }

    private int insertHost2HostTable(List<DevNode> hosts) {
        if (null == hosts || hosts.isEmpty()) {
            return 0;
        }
        int num = 0;
        for (DevNode host : hosts) {
            if (!ItDeviceType.Host.equals((Object)host.getItDeviceType())) continue;
            this.storageHostAssocPageLayout.getHostModel().addRow(new TableRow[]{this.createHostTableRow(host)});
            ++num;
        }
        return num;
    }

    private TableRow<HostTableRow, String> createHostTableRow(DevNode host) {
        HostTableRow hostTableRow = new HostTableRow(host);
        DefaultTableRow row = new DefaultTableRow(SetAssociationDialogLayout.getHostTableHeader().length, (Object)hostTableRow, (Object)host.getDevKey());
        int index = 0;
        String deviceName = !StringUtils.isNULLStr((String)host.getDeviceNameAlias()) ? host.getDeviceNameAlias() : host.getDeviceName();
        row.setValueAt(index++, (Object)deviceName);
        row.setValueAt(index++, (Object)host.getDeviceType());
        row.setValueAt(index++, (Object)host.getIp());
        return row;
    }

    private TableRow<HostAssociationSetting, String> createStorageTableRow(DevNode device) {
        HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(device.getDeviceSerialNumber());
        HostAssociationSetting setting = this.makeAssociationSetting(hostNode, device);
        DefaultTableRow row = new DefaultTableRow(SetAssociationDialogLayout.getStorageTableHeader().length, (Object)setting, (Object)device.getDeviceSerialNumber());
        this.initRow(device, hostNode, (TableRow<HostAssociationSetting, String>)row);
        return row;
    }

    private void initRow(DevNode device, HostEvalNode hostNode, TableRow<HostAssociationSetting, String> row) {
        int index = 0;
        String deviceName = !StringUtils.isNULLStr((String)device.getDeviceNameAlias()) ? device.getDeviceNameAlias() : device.getDeviceName();
        row.setValueAt(index++, (Object)deviceName);
        row.setValueAt(index++, (Object)device.getDeviceType());
        row.setValueAt(index++, (Object)device.getProductVersion());
        row.setValueAt(index++, (Object)device.getIp());
        row.setValueAt(index++, (Object)device.getDeviceSerialNumber());
    }

    private HostAssociationSetting makeAssociationSetting(HostEvalNode hostNode, DevNode device) {
        List<DevNode> unAssociateHosts = HostEvalUtils.copyDeeplyList(hostNode.getUnAssociateHosts());
        List<DevNode> manulAssociatedHosts = HostEvalUtils.copyDeeplyList(hostNode.getManulAssociatedHosts());
        List<DevNode> notAllowAssociatedHosts = HostEvalUtils.copyDeeplyList(hostNode.getNotAllowAssociatedHosts());
        HostAssociationSetting setting = new HostAssociationSetting(unAssociateHosts, manulAssociatedHosts, notAllowAssociatedHosts, device);
        return setting;
    }

    private void initListener() {
        this.storageHostAssocPageLayout.getStorageTable().addListSelectionListener((ListSelectionListener)new ClickStroageTableListener());
        SaveBtnAction saveLinstner = new SaveBtnAction();
        CloseBtnAction closeLinstner = new CloseBtnAction();
        this.storageHostAssocPageLayout.getSaveBtn().addActionListener(saveLinstner);
        this.storageHostAssocPageLayout.getCloseBtn().addActionListener(closeLinstner);
        this.storageHostAssocPageLayout.getHostTable().addListSelectionListener((ListSelectionListener)new ClickHostTableListener());
        if (null != this.storageHostAssocPageLayout.getViewMiddleLabel2()) {
            this.storageHostAssocPageLayout.getViewMiddleLabel2().addClickListener((ToolHyperLinkLabel.ClickListener)new ViewNotAllowAssociateHostAction());
        }
        this.storageHostLabel.addMouseListener(new LabelSelectListner());
        this.dbHostLabel.addMouseListener(new LabelSelectListner());
        this.hostDBAssociationDialogLayout.getDBTable().addListSelectionListener((ListSelectionListener)new DbSelectedListner());
        this.hostDBAssociationDialogLayout.getHostTable().addListSelectionListener((ListSelectionListener)new ClickHostForDbTableListener());
        this.hostDBAssociationDialogLayout.getSaveBtn().addActionListener(saveLinstner);
        this.hostDBAssociationDialogLayout.getCloseBtn().addActionListener(closeLinstner);
    }

    private void initDBHostAssociatePage(HostEvaluMainDialog parent) {
        this.hostDBAssociationDialogLayout = new SetHostDBAssociationDialogLayout();
        this.initHostDbMappingTable();
        if (!this.hostDBAssociationDialogLayout.getDBTable().getAllRows().isEmpty()) {
            this.hostDBAssociationDialogLayout.getDBTable().setRowSelectionInterval(0, 0);
        }
        this.resetDbHostTable();
    }

    private void initHostDbMappingTable() {
        List allDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        this.hostDbMapCache.clear();
        this.hostDbMapCache.putAll(HostEvalContext.getHostMappedDb());
        if (null == allDevNodes || allDevNodes.isEmpty()) {
            LOGGER.info("devnode list is null or empty when filldb host table");
            return;
        }
        HashSet<DevNode> toAddDevs = new HashSet<DevNode>();
        toAddDevs.addAll(this.getAllUnMappedHost());
        toAddDevs.addAll(allDevNodes);
        toAddDevs.addAll(HostEvalContext.getAllDbs());
        this.initDbTableWhenMappingDb(toAddDevs);
        if (!toAddDevs.isEmpty()) {
            this.hostDBAssociationDialogLayout.removeHostTableTips();
        }
    }

    public void initDbTableWhenMappingDb(Set<DevNode> allDevNodes) {
        this.hostDBAssociationDialogLayout.getDbTableModel().removeAll();
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        for (DevNode devNode : allDevNodes) {
            if (null == devNode.getItDeviceType() || !ItDeviceType.Database.equals((Object)devNode.getItDeviceType())) continue;
            tableRows.add(this.makeDbRow(devNode));
        }
        this.hostDBAssociationDialogLayout.getDbTableModel().addRow(tableRows);
        if (!tableRows.isEmpty()) {
            this.hostDBAssociationDialogLayout.removeDbTableTips();
        }
    }

    private void resetDbHostTable() {
        HashMap<DevNode, DevNode> hostDbMapCacheTemp = new HashMap<DevNode, DevNode>();
        hostDbMapCacheTemp.putAll(this.hostDbMapCache);
        this.initHostTableWhenMappingDb();
        this.hostDbMapCache.putAll(hostDbMapCacheTemp);
        this.selectMappingHostForDb();
    }

    private boolean checkIsDbUnAssociated() {
        List nodeDevs = DefaultNodeProviderImpl.getInstance().getNodeList();
        Map<DevNode, DevNode> devs = this.hostDbMapCache;
        for (DevNode dNode : nodeDevs) {
            if (!ItDeviceType.Database.equals((Object)dNode.getItDeviceType()) || devs.containsValue(dNode)) continue;
            return false;
        }
        return true;
    }

    private Set<DevNode> getAllUnMappedHost() {
        List<HostAssociationSetting> allStorageRows = this.getAllStorageRows();
        HashSet<DevNode> selectedDevNodes = new HashSet<DevNode>();
        for (HostAssociationSetting setting : allStorageRows) {
            selectedDevNodes.addAll(setting.getUnAssociateHosts());
        }
        return selectedDevNodes;
    }

    private Set<DevNode> getAllMappedHost() {
        List<HostAssociationSetting> allStorageRows = this.getAllStorageRows();
        HashSet<DevNode> selectedDevNodes = new HashSet<DevNode>();
        for (HostAssociationSetting setting : allStorageRows) {
            DevNode storageDev = setting.getStorageDevice();
            selectedDevNodes.addAll(setting.getManulAssociatedHosts());
            HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(storageDev.getDeviceSerialNumber());
            List<DevNode> storageMappingDevs = HostEvalUtils.copyDeeplyList(hostNode.getStorageMappingHosts());
            if (storageMappingDevs == null) {
                log.info("storageMappingDevs is null.");
                continue;
            }
            storageMappingDevs.removeAll(setting.getNotAllowAssociatedHosts());
            storageMappingDevs.removeAll(setting.getUnAssociateHosts());
            selectedDevNodes.addAll(storageMappingDevs);
        }
        return selectedDevNodes;
    }

    public void initHostTableWhenMappingDb() {
        List selectedDbRows = this.hostDBAssociationDialogLayout.getDBTable().getMarkedRows();
        this.hostDBAssociationDialogLayout.getHostModel().removeAll();
        Set<DevNode> selectedDevNodes = this.getAllMappedHost();
        ArrayList<TableRow> toAddRows = new ArrayList<TableRow>();
        for (DevNode toAddDev : selectedDevNodes) {
            if (null == toAddDev.getItDeviceType() || !ItDeviceType.Host.equals((Object)toAddDev.getItDeviceType())) continue;
            toAddRows.add(this.buildHostRow(toAddDev));
        }
        if (selectedDbRows.isEmpty()) {
            this.addOrRemiveNoDevTips(toAddRows);
            return;
        }
        this.addOrRemiveNoDevTips(toAddRows);
    }

    public void addOrRemiveNoDevTips(List<TableRow> toAddRows) {
        if (!toAddRows.isEmpty()) {
            this.hostDBAssociationDialogLayout.getHostModel().addRow(toAddRows);
            this.hostDBAssociationDialogLayout.removeHostTableTips();
        } else {
            this.hostDBAssociationDialogLayout.addTips2HostTable();
        }
    }

    private TableRow buildHostRow(DevNode devNode) {
        DefaultTableRow row = new DefaultTableRow(SetHostDBAssociationDialogLayout.getHostTableHeader().length, (Object)devNode, (Object)devNode.getDevKey());
        int index = 0;
        String deviceName = !StringUtils.isNULLStr((String)devNode.getDeviceNameAlias()) ? devNode.getDeviceNameAlias() : devNode.getDeviceName();
        row.setValueAt(index++, (Object)deviceName);
        row.setValueAt(index++, (Object)devNode.getDeviceType());
        row.setValueAt(index++, (Object)devNode.getIp());
        this.updateMappedStorages(devNode, (TableRow<DevNode, String>)row);
        return row;
    }

    public void updateMappedStorages(DevNode devNode, TableRow<DevNode, String> row) {
        String txt = this.getHostMappedStorageSns(devNode);
        IsmTableCell.TextCell iconCellStatus = new IsmTableCell.TextCell(txt);
        iconCellStatus.setHorizontalAlignment(0);
        row.setValueAt(3, (Object)iconCellStatus);
    }

    private String getHostMappedStorageSns(DevNode devNode) {
        StringBuilder result = new StringBuilder();
        List<HostAssociationSetting> allStorageRows = this.getAllStorageRows();
        for (HostAssociationSetting setting : allStorageRows) {
            HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(setting.getStorageDevice().getDeviceSerialNumber());
            List<DevNode> storageMappingDevs = hostNode.getStorageMappingHosts();
            if (!setting.getManulAssociatedHosts().contains(devNode) && !storageMappingDevs.contains(devNode)) continue;
            if (result.length() != 0) {
                result.append(',');
            }
            result.append(setting.getStorageDevice().getDeviceSerialNumber());
        }
        return result.toString();
    }

    private TableRow makeDbRow(DevNode devNode) {
        DefaultTableRow row = new DefaultTableRow(SetAssociationDialogLayout.getStorageTableHeader().length, (Object)devNode, (Object)devNode.getDeviceSerialNumber());
        int index = 0;
        String deviceName = !StringUtils.isNULLStr((String)devNode.getDeviceNameAlias()) ? devNode.getDeviceNameAlias() : devNode.getDeviceName();
        row.setValueAt(index++, (Object)deviceName);
        row.setValueAt(index++, (Object)devNode.getDeviceType());
        row.setValueAt(index++, (Object)devNode.getIp());
        return row;
    }

    private int findhostIdx(DevNode hostDev) {
        List allRows = this.hostDBAssociationDialogLayout.getHostTable().getAllRows();
        for (int idx = 0; idx < allRows.size(); ++idx) {
            if (!hostDev.equals(((TableRow)allRows.get(idx)).getUserObject())) continue;
            return idx;
        }
        return -1;
    }

    private void switchBtnClicked(MouseEvent e) {
        JLabel label = (JLabel)e.getSource();
        this.clickSwitch(label);
    }

    private void clickSwitch(JLabel label) {
        if (this.selectedAssocType.equals(label)) {
            return;
        }
        this.cardLayout.show(this.cardPanel, label.getText());
        this.selectedAssocType.setBorder(BorderFactory.createEmptyBorder());
        this.setLabelSelectedBorder(label, true);
    }

    public boolean checkIsDbSelectDiferentHost(List<DevNode> selectedHostRows, DevNode dbDev) {
        if (selectedHostRows.isEmpty()) {
            return false;
        }
        HashSet<String> types = new HashSet<String>();
        for (DevNode devNode : selectedHostRows) {
            types.add(devNode.getDeviceName());
        }
        if (types.size() > 1) {
            DialogUtils.showInfoDialog((JDialog)this.mainWizardDialog, (String)ResourceUtil.getStringWithParams((String)"eval.associate.db.host.mappto.different.host.type.tip", (Object[])new Object[]{dbDev.getIp()}));
            return true;
        }
        for (DevNode dev : selectedHostRows) {
            DevNode hostDev = dev;
            DevNode mappedDb = this.hostDbMapCache.get(hostDev);
            if (mappedDb == null || mappedDb.equals((Object)dbDev)) continue;
            DialogUtils.showInfoDialog((JDialog)this.mainWizardDialog, (String)ResourceUtil.getStringWithParams((String)"eval.associate.db.host.mappto.different.host.tip", (Object[])new Object[]{hostDev.getIp(), mappedDb.getIp()}));
            return true;
        }
        return false;
    }

    private boolean updateHostEvalNode(HostAssociationSetting setting) {
        HostEvalNode hostEvalNode = (HostEvalNode)HostEvalContext.getStorageMap().get(setting.getStorageDevice().getDeviceSerialNumber());
        try {
            this.mainDialog.removeHostOrDbDevice(setting.getUnAssociateHosts(), hostEvalNode);
            this.mainDialog.removeHostOrDbDevice(this.getAllDbs(setting), hostEvalNode);
            this.addMappedDbs(setting, hostEvalNode);
            this.mainDialog.setStorageAndHostAssociation(setting.getManulAssociatedHosts(), hostEvalNode.getStorageSn());
        }
        catch (Exception e) {
            LOGGER.error("***[updateHostEvalNode --> manual associate device error: %s]***", e);
            DialogUtils.showInfoDialog((JDialog)this.mainWizardDialog, (String)ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.savebtn.failure.tips"));
            this.mainDialog.restoreMainDialogTableData(hostEvalNode.getStorageSn());
            return false;
        }
        return true;
    }

    private void addMappedDbs(HostAssociationSetting setting, HostEvalNode hostEvalNode) {
        List<DevNode> devs = setting.getManulAssociatedHosts();
        HashSet<DevNode> nodes = new HashSet<DevNode>();
        nodes.addAll(devs);
        nodes.addAll(hostEvalNode.getStorageMappingHosts());
        for (DevNode node : nodes) {
            if (!this.hostDbMapCache.containsKey(node)) continue;
            setting.getManulAssociatedHosts().add(this.hostDbMapCache.get(node));
        }
    }

    private List<DevNode> getAllDbs(HostAssociationSetting setting) {
        List nodeDevs = DefaultNodeProviderImpl.getInstance().getNodeList();
        HashSet<DevNode> unMappedDb = new HashSet<DevNode>();
        nodeDevs.addAll(this.getAllUnMappedHost());
        for (DevNode dNode : nodeDevs) {
            if (!ItDeviceType.Database.equals((Object)dNode.getItDeviceType())) continue;
            unMappedDb.add(dNode);
        }
        ArrayList<DevNode> ret = new ArrayList<DevNode>(unMappedDb.size());
        ret.addAll(unMappedDb);
        return ret;
    }

    public int mannualAssociateHostNums(HostAssociationSetting setting) {
        int hostNum = 0;
        for (DevNode dev : setting.getManulAssociatedHosts()) {
            if (!ItDeviceType.Host.equals((Object)dev.getItDeviceType())) continue;
            ++hostNum;
        }
        return hostNum;
    }

    public void updateUnAssociateNumberColum(HostEvalNode hostEvalNode) {
        TableRow row = this.storageHostAssocPageLayout.getStorageTable().getMarkedRow();
        if (null != hostEvalNode) {
            if (null != row) {
                row.setValueAt(5, (Object)hostEvalNode.getNotAddedNumbers());
            } else {
                LOGGER.error("getMarkedRow() is filed,row =null");
            }
        }
    }

    private int fillSelectAndNotSelectDevices(List<DevNode> selectDevices, List<DevNode> notSelectDevices) {
        List rows = this.storageHostAssocPageLayout.getHostTable().getAllRows();
        int selectHostNumber = 0;
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            HostTableRow hostTableRow = (HostTableRow)this.storageHostAssocPageLayout.getHostModel().getRow(rowIndex).getUserObject();
            DevNode dev = hostTableRow.getDevNode();
            if (this.storageHostAssocPageLayout.getHostTable().isRowSelected(rowIndex)) {
                selectDevices.add(dev);
                if (!ItDeviceType.Host.equals((Object)dev.getItDeviceType())) continue;
                ++selectHostNumber;
                continue;
            }
            notSelectDevices.add(dev);
        }
        return selectHostNumber;
    }

    private void updateDbAndStorageRel() {
        List selectedDbRows = this.hostDBAssociationDialogLayout.getDBTable().getMarkedRows();
        if (selectedDbRows.isEmpty() || selectedDbRows.size() > 1) {
            return;
        }
        DevNode dbDev = (DevNode)((TableRow)selectedDbRows.get(0)).getUserObject();
        this.removeDbFromMappedStorages(dbDev);
        this.addDbToHostMappedStorage(dbDev);
    }

    public void removeDbFromMappedStorages(DevNode dbDev, List<HostAssociationSetting> allStorageRows) {
        for (HostAssociationSetting setting : allStorageRows) {
            DevNode storageDev = setting.getStorageDevice();
            HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(storageDev.getDeviceSerialNumber());
            while (hostNode.getStorageMappingHosts().contains(dbDev)) {
                hostNode.getStorageMappingHosts().remove(dbDev);
            }
            while (setting.getManulAssociatedHosts().contains(dbDev)) {
                setting.getManulAssociatedHosts().remove(dbDev);
            }
        }
    }

    public void removeDbFromMappedStorages(DevNode dbDev) {
        List<HostAssociationSetting> allStorageRows = this.getAllStorageRows();
        this.removeDbFromMappedStorages(dbDev, allStorageRows);
    }

    public void addDbToHostMappedStorage(DevNode dbDev) {
        List<HostAssociationSetting> allStorageRows = this.getAllStorageRows();
        List selectedHosts = this.hostDBAssociationDialogLayout.getHostTable().getMarkedRows();
        for (Map.Entry<DevNode, DevNode> entry : this.hostDbMapCache.entrySet()) {
            if (!entry.getValue().equals((Object)dbDev)) continue;
            DevNode hostDev = entry.getKey();
            for (HostAssociationSetting setting : allStorageRows) {
                DevNode storageDev = setting.getStorageDevice();
                HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(storageDev.getDeviceSerialNumber());
                if (setting.getManulAssociatedHosts().contains(hostDev) && this.isHostSelected(selectedHosts, hostDev)) {
                    setting.getManulAssociatedHosts().add(entry.getValue());
                    continue;
                }
                if (!hostNode.getStorageMappingHosts().contains(hostDev) || !this.isHostSelected(selectedHosts, hostDev)) continue;
                setting.getManulAssociatedHosts().add(entry.getValue());
            }
        }
    }

    private boolean isHostSelected(List<TableRow> selectedHosts, DevNode hostDev) {
        for (TableRow row : selectedHosts) {
            if (!row.getUserObject().equals(hostDev)) continue;
            return true;
        }
        return false;
    }

    public void selectMappingHostForDb() {
        List selectedDbRows = this.hostDBAssociationDialogLayout.getDBTable().getMarkedRows();
        if (selectedDbRows.isEmpty()) {
            return;
        }
        DevNode dbDev = (DevNode)((TableRow)selectedDbRows.get(0)).getUserObject();
        List hostRows = this.hostDBAssociationDialogLayout.getHostTable().getAllRows();
        HashMap<DevNode, DevNode> hostDbMapCacheTemp = new HashMap<DevNode, DevNode>();
        hostDbMapCacheTemp.putAll(this.hostDbMapCache);
        int idx = 0;
        for (TableRow tableRow : hostRows) {
            DevNode hostDev = (DevNode)tableRow.getUserObject();
            DevNode mappDbDev = (DevNode)hostDbMapCacheTemp.get(hostDev);
            if (mappDbDev != null && dbDev.getDevKey().equals(mappDbDev.getDevKey())) {
                this.hostDBAssociationDialogLayout.getHostTable().addRowSelectionInterval(idx, idx);
            }
            ++idx;
        }
    }

    public void clearCurrentSelectForDb(DevNode dbDev, List<TableRow> hostRows) {
        for (TableRow tr : hostRows) {
            if (!dbDev.equals((Object)this.hostDbMapCache.get(tr.getUserObject()))) continue;
            this.hostDbMapCache.remove(tr.getUserObject());
        }
    }

    private void updateDynamicMiddleDes(HostAssociationSetting setting) {
        JLabel label = this.storageHostAssocPageLayout.getDynamicMiddleLabel();
        if (HostEvalContext.isExistNotAllowAssociatedHosts()) {
            label.setText(ResourceUtil.getStringWithParams((String)"evalu.ui.setAssociationDialog.hostDes.filter.en1", (Object[])new Object[]{setting.getStorageDevice().getDeviceSerialNumber(), setting.getStorageDevice().getIp()}));
        } else {
            label.setText(ResourceUtil.getStringWithParams((String)"evalu.ui.setAssociationDialog.hostDes", (Object[])new Object[]{setting.getStorageDevice().getDeviceSerialNumber(), setting.getStorageDevice().getIp()}));
        }
    }

    public DevNode getSelectStorageDev() {
        int index = this.storageHostAssocPageLayout.getStorageTable().getSelectedRow();
        return (DevNode)this.storageHostAssocPageLayout.getStorageModel().getRow(index).getUserObject();
    }

    public SetAssociationDialogLayout getPageLayout() {
        return this.storageHostAssocPageLayout;
    }

    private List<HostAssociationSetting> getSelectedStorageRows() {
        return this.getStorageRows(this.storageHostAssocPageLayout.getStorageTable().getMarkedRows());
    }

    private List<HostAssociationSetting> getStorageRows(List<TableRow> rows) {
        ArrayList<HostAssociationSetting> storageRows = new ArrayList<HostAssociationSetting>();
        for (TableRow tr : rows) {
            HostAssociationSetting setting = (HostAssociationSetting)tr.getUserObject();
            storageRows.add(setting);
        }
        return storageRows;
    }

    private List<HostAssociationSetting> getAllStorageRows() {
        return this.getStorageRows(this.storageHostAssocPageLayout.getStorageTable().getAllRows());
    }

    public String getTitle() {
        return this.selectedAssocType.getText();
    }

    protected ToolWizardDialog.Card getNextCard() {
        return this;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    private List<DevNode> getDbMappedHosts(DevNode dbDev, Map<DevNode, DevNode> hostDbMap) {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        for (Map.Entry<DevNode, DevNode> entry : hostDbMap.entrySet()) {
            if (!dbDev.equals((Object)entry.getValue())) continue;
            devs.add(entry.getKey());
        }
        return devs;
    }

    private boolean doComplete() {
        List allDbs = this.hostDBAssociationDialogLayout.getDBTable().getAllRows();
        if (!this.isStorageHost()) {
            for (TableRow row : allDbs) {
                DevNode dbDev = (DevNode)row.getUserObject();
                List<DevNode> dbmappedHosts = this.getDbMappedHosts(dbDev, this.hostDbMapCache);
                if (!this.checkIsDbSelectDiferentHost(dbmappedHosts, dbDev)) continue;
                return false;
            }
        }
        if (this.dealIsDbUnAssociatedTip()) {
            return false;
        }
        final ArrayList flag = new ArrayList(1);
        final ProgressDialog dialog = new ProgressDialog((Window)this.mainWizardDialog);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List allStorageRows = SetAssociationDialog.this.getAllStorageRows();
                try {
                    for (int index = 0; index < allStorageRows.size(); ++index) {
                        HostAssociationSetting setting = (HostAssociationSetting)allStorageRows.get(index);
                        if (SetAssociationDialog.this.updateHostEvalNode(setting)) continue;
                        flag.add(false);
                        return;
                    }
                    if (!SetAssociationDialog.this.isStorageHost()) {
                        HostEvalContext.getHostMappedDb().clear();
                        HostEvalContext.getHostMappedDb().putAll(SetAssociationDialog.this.hostDbMapCache);
                        SetAssociationDialog.this.mainWizardDialog.dispose();
                    }
                }
                catch (Exception e1) {
                    LOGGER.error("***[save association error]***", e1);
                    DialogUtils.showInfoDialog((JDialog)SetAssociationDialog.this.mainWizardDialog, (String)ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.savebtn.failure.tips"));
                    flag.add(false);
                }
                finally {
                    SwingUtil.disPoseDialg((ProgressDialog)dialog);
                }
            }
        };
        AsyncExcutor.submit((Runnable)task);
        dialog.setVisible(true);
        return flag.isEmpty();
    }

    private boolean dealIsDbUnAssociatedTip() {
        WarningDialog wd;
        return !this.isStorageHost() && !this.checkIsDbUnAssociated() && (wd = DialogUtils.showYesNoDialog((Window)this.mainWizardDialog, (String)ResourceUtil.getString((String)"eval.associate.db.notassociate.setting.tip"), (String)ResourceUtil.getString((String)"evalu.ui.modifyDev.button.confirm"), (String)ResourceUtil.getString((String)"evalu.ui.modifyDev.button.ignore"), (int)(LanguageManager.isEnglish() ? 88 : 68), (int)(LanguageManager.isEnglish() ? 88 : 68))).getValue() == 0;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if ((ToolWizardDialog.Navigation.Next.equals((Object)navigation) || ToolWizardDialog.Navigation.Complete.equals((Object)navigation)) && !this.doComplete()) {
            return false;
        }
        if (ToolWizardDialog.Navigation.Next.equals((Object)navigation) || ToolWizardDialog.Navigation.Previous.equals((Object)navigation)) {
            this.clickSwitch(ToolWizardDialog.Navigation.Next.equals((Object)navigation) ? this.dbHostLabel : this.storageHostLabel);
            if (this.isStorageHost()) {
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Previous)).setVisible(false);
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Complete)).setVisible(false);
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Next)).setVisible(true);
                this.topDes.setText(ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.storagehost.topDes"));
            } else {
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Next)).setVisible(false);
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Previous)).setVisible(true);
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Complete)).setVisible(true);
                this.topDes.setText(ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.dbhost.topDes"));
            }
        }
        if (ToolWizardDialog.Navigation.Cancel.equals((Object)navigation)) {
            this.storageHostAssocPageLayout.getCloseBtn().getActionListeners()[0].actionPerformed(null);
        }
        return true;
    }

    public int getStep() {
        return this.isStorageHost() ? 0 : 1;
    }

    private boolean isStorageHost() {
        return this.selectedAssocType == null || this.selectedAssocType.getText().equals(this.storageHostLabel.getText());
    }

    private final class ClickHostTableListener
    implements ListSelectionListener {
        private ClickHostTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent selectionEvent) {
            if (selectionEvent.getValueIsAdjusting()) {
                return;
            }
            ArrayList<DevNode> selectDevices = new ArrayList<DevNode>();
            ArrayList<DevNode> notSelectDevices = new ArrayList<DevNode>();
            SetAssociationDialog.this.fillSelectAndNotSelectDevices(selectDevices, notSelectDevices);
            List selectedStorageRows = SetAssociationDialog.this.getSelectedStorageRows();
            if (selectedStorageRows.isEmpty()) {
                return;
            }
            HostAssociationSetting setting = (HostAssociationSetting)selectedStorageRows.get(0);
            LOGGER.info("***[StorageSn: {}, selectDevices size is: {}]***", (Object)setting.getStorageDevice().getDeviceSerialNumber(), (Object)selectDevices.size());
            LOGGER.info("***[StorageSn: {},notSelectDevices size is: {}]***", (Object)setting.getStorageDevice().getDeviceSerialNumber(), (Object)notSelectDevices.size());
            if (!selectDevices.isEmpty() || !notSelectDevices.isEmpty()) {
                setting.setManulAssociatedHosts(selectDevices);
                setting.setUnAssociateHosts(notSelectDevices);
            }
            List rowsDbHosts = SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostTable().getAllRows();
            Set allMappedHosts = SetAssociationDialog.this.getAllMappedHost();
            this.addNewSelectedToHostTableWhenMappingDb(allMappedHosts, rowsDbHosts);
            this.removeRelactionWhenUnSelectHosts(allMappedHosts, rowsDbHosts);
            int selectedDbIdx = SetAssociationDialog.this.hostDBAssociationDialogLayout.getDBTable().getSelectedColumn();
            this.triggerSelectDbTable(selectedDbIdx);
            SetAssociationDialog.this.storageHostAssocPageLayout.getHostScrollPane().getTablePane().updateIndexTable();
        }

        public void triggerSelectDbTable(int selectedDbIdx) {
            if (selectedDbIdx > -1) {
                SetAssociationDialog.this.hostDBAssociationDialogLayout.getDBTable().clearSelection();
                SetAssociationDialog.this.hostDBAssociationDialogLayout.getDBTable().setRowSelectionInterval(selectedDbIdx, selectedDbIdx);
            }
        }

        public void removeRelactionWhenUnSelectHosts(Set<DevNode> allMappedHosts, List<TableRow> rowsDbHosts) {
            ArrayList<DevNode> selectedList = new ArrayList<DevNode>();
            int rowIdx = 0;
            for (TableRow rowHost : rowsDbHosts) {
                List settings;
                boolean isRightTableHostNotMapped = false;
                DevNode dNode = (DevNode)rowHost.getUserObject();
                for (DevNode devMapped : allMappedHosts) {
                    if (!dNode.equals((Object)devMapped)) continue;
                    isRightTableHostNotMapped = true;
                    selectedList.add(dNode);
                    break;
                }
                if (!isRightTableHostNotMapped && !this.isAutoMappedHost(dNode)) {
                    this.removeHostFromTable(dNode, rowIdx);
                    settings = SetAssociationDialog.this.getAllStorageRows();
                    this.removeFromeMappingStorage(dNode, settings);
                }
                if (isRightTableHostNotMapped && this.isHostNotChecked(dNode)) {
                    settings = SetAssociationDialog.this.getSelectedStorageRows();
                    for (Map.Entry entry : SetAssociationDialog.this.hostDbMapCache.entrySet()) {
                        if (!((DevNode)entry.getKey()).equals((Object)dNode)) continue;
                        SetAssociationDialog.this.removeDbFromMappedStorages((DevNode)entry.getValue(), settings);
                    }
                    int rowIndex = SetAssociationDialog.this.findhostIdx(dNode);
                    if (rowIndex > -1 && rowIndex < SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostModel().getRowCount()) {
                        TableRow row = SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostModel().getRow(rowIndex);
                        SetAssociationDialog.this.updateMappedStorages(dNode, (TableRow<DevNode, String>)row);
                    }
                }
                ++rowIdx;
            }
            Set unMappedDevs = SetAssociationDialog.this.getAllUnMappedHost();
            for (DevNode dev : unMappedDevs) {
                SetAssociationDialog.this.hostDbMapCache.remove(dev);
            }
            for (TableRow hostRow : SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostTable().getAllRows()) {
                int selectIdx;
                if (!selectedList.contains(hostRow.getUserObject())) continue;
                SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostTable().addRowSelectionInterval(selectIdx = SetAssociationDialog.this.findhostIdx((DevNode)hostRow.getUserObject()), selectIdx++);
            }
        }

        private boolean isHostNotChecked(DevNode dNode) {
            List markedRows = SetAssociationDialog.this.storageHostAssocPageLayout.getHostTable().getMarkedRows();
            for (TableRow row : markedRows) {
                HostTableRow rowHost = (HostTableRow)row.getUserObject();
                if (!dNode.getDeviceSerialNumber().equals(rowHost.getDevNode().getDeviceSerialNumber())) continue;
                return false;
            }
            return true;
        }

        private boolean isAutoMappedHost(DevNode dNode) {
            List settings = SetAssociationDialog.this.getAllStorageRows();
            for (HostAssociationSetting setting : settings) {
                HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(setting.getStorageDevice().getDeviceSerialNumber());
                if (!hostNode.getStorageMappingHosts().contains(dNode) || setting.getManulAssociatedHosts().contains(dNode)) continue;
                return true;
            }
            return false;
        }

        public void addNewSelectedToHostTableWhenMappingDb(Set<DevNode> allMappedHosts, List<TableRow> rowsDbHosts) {
            ArrayList<TableRow> toAddRows = new ArrayList<TableRow>();
            for (DevNode devNode : allMappedHosts) {
                boolean isContains = false;
                DevNode dNode = devNode;
                for (TableRow rowHost : rowsDbHosts) {
                    if (!dNode.equals(rowHost.getUserObject())) continue;
                    isContains = true;
                    break;
                }
                if (isContains || null == dNode.getItDeviceType() || !ItDeviceType.Host.equals((Object)dNode.getItDeviceType())) continue;
                toAddRows.add(SetAssociationDialog.this.buildHostRow(dNode));
            }
            SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostModel().addRow(toAddRows);
        }

        public void removeFromeMappingStorage(DevNode dNode, List<HostAssociationSetting> settings) {
            for (HostAssociationSetting setting : settings) {
                setting.getUnAssociateHosts().add(dNode);
                setting.getManulAssociatedHosts().remove(dNode);
            }
        }

        public void removeHostFromTable(DevNode dNode, int rowIdx) {
            List selectedRows = SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostModel().getAllRows();
            for (TableRow tr : selectedRows) {
                DevNode devNode = (DevNode)tr.getUserObject();
                if (!dNode.equals((Object)devNode)) continue;
                SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostModel().removeRow(new TableRow[]{tr});
                SetAssociationDialog.this.hostDbMapCache.remove(devNode);
            }
        }
    }

    private final class ClickHostForDbTableListener
    implements ListSelectionListener {
        private ClickHostForDbTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent selectionEvent) {
            if (selectionEvent.getValueIsAdjusting()) {
                return;
            }
            List selectedDbRows = SetAssociationDialog.this.hostDBAssociationDialogLayout.getDBTable().getMarkedRows();
            if (selectedDbRows.isEmpty() || selectedDbRows.size() > 1) {
                return;
            }
            if (SetAssociationDialog.this.selectedAssocType.getText().equals(SetAssociationDialog.this.storageHostLabel.getText())) {
                return;
            }
            List selectedHostRows = SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostTable().getMarkedRows();
            DevNode dbDev = (DevNode)((TableRow)selectedDbRows.get(0)).getUserObject();
            SetAssociationDialog.this.clearCurrentSelectForDb(dbDev, SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostTable().getAllRows());
            for (TableRow hostRow : selectedHostRows) {
                DevNode hostDev = (DevNode)hostRow.getUserObject();
                SetAssociationDialog.this.hostDbMapCache.put(hostDev, dbDev);
            }
            SetAssociationDialog.this.updateDbAndStorageRel();
        }
    }

    private final class ClickStroageTableListener
    implements ListSelectionListener {
        private ClickStroageTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            List selectedStorageRows = SetAssociationDialog.this.getSelectedStorageRows();
            if (selectedStorageRows.isEmpty()) {
                SetAssociationDialog.this.storageHostAssocPageLayout.getHostModel().removeAll();
                SetAssociationDialog.this.storageHostAssocPageLayout.getMiddleLabelBox().setVisible(false);
                return;
            }
            if (selectedStorageRows.size() > 1) {
                SetAssociationDialog.this.storageHostAssocPageLayout.getHostModel().removeAll();
                DialogUtils.showInfoDialog((JDialog)SetAssociationDialog.this.mainWizardDialog, (String)ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.savebtn.multiple.device.tips"));
                SetAssociationDialog.this.storageHostAssocPageLayout.getMiddleLabelBox().setVisible(false);
                return;
            }
            SetAssociationDialog.this.storageHostAssocPageLayout.getMiddleLabelBox().setVisible(true);
            HostAssociationSetting setting = (HostAssociationSetting)selectedStorageRows.get(0);
            SetAssociationDialog.this.storageHostAssocPageLayout.setVisibleOfViewLink(!setting.getNotAllowAssociatedHosts().isEmpty());
            SetAssociationDialog.this.updateDynamicMiddleDes(setting);
            SetAssociationDialog.this.initHostTable(setting);
        }
    }

    private final class CloseBtnAction
    implements ActionListener {
        private CloseBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SetAssociationDialog.this.mainWizardDialog.dispose();
        }
    }

    private final class SaveBtnAction
    implements ActionListener {
        private SaveBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SetAssociationDialog.this.doComplete();
        }
    }

    private final class ViewNotAllowAssociateHostAction
    implements ToolHyperLinkLabel.ClickListener {
        private static final long serialVersionUID = -3661470624849640383L;

        private ViewNotAllowAssociateHostAction() {
        }

        public void clickLink(MouseEvent mouseEvent) {
            List selectedStorageRows = SetAssociationDialog.this.getSelectedStorageRows();
            if (selectedStorageRows.isEmpty() || selectedStorageRows.size() > 1) {
                return;
            }
            HostAssociationSetting setting = (HostAssociationSetting)selectedStorageRows.get(0);
            List<List<Object>> failRet = this.initDisplayHostDetail(setting);
            String[] headers = new String[]{ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostTable.devicetName"), ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostTable.deviceType"), ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostTable.deviceIP")};
            String msg = ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostDes.filter.prompt");
            MultiInfoDialog multiInfoDialog = new MultiInfoDialog((Window)SetAssociationDialog.this.mainWizardDialog, ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostDes.filter.title"), msg, headers, "info.png");
            JButton btn = new JButton(ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostDes.filter.add.associate"));
            btn.setToolTipText(ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostDes.filter.add.associate.tip"));
            btn.addActionListener(this.addAssociateListner(setting, multiInfoDialog));
            multiInfoDialog.getSouthBox().add((Component)btn, 0);
            multiInfoDialog.getSouthBox().add(Box.createHorizontalStrut(10), 1);
            this.showFilterHost(failRet, headers, multiInfoDialog);
        }

        public ActionListener addAssociateListner(final HostAssociationSetting setting, final MultiInfoDialog multiInfoDialog) {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (multiInfoDialog.getErrTable().getMarkedRows().isEmpty()) {
                        DialogUtils.showInfoDialog((JDialog)multiInfoDialog, (String)ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.hostDes.filter.add.nodev.tip"));
                        return;
                    }
                    String deviceSn = setting.getStorageDevice().getDeviceSerialNumber();
                    WarningDialog wd = DialogUtils.showYesNoDialog((Window)multiInfoDialog, (String)ResourceUtil.getStringWithParams((String)"evalu.ui.setAssociationDialog.hostDes.filter.add.notassociate.dev.tip", (Object[])new Object[]{deviceSn}));
                    if (wd.getValue() != 0) {
                        return;
                    }
                    HostEvalNode hostNode = (HostEvalNode)HostEvalContext.getStorageMap().get(deviceSn);
                    List rows = multiInfoDialog.getErrTable().getMarkedRows();
                    ViewNotAllowAssociateHostAction.this.addHostToAssociat(multiInfoDialog, rows);
                    ViewNotAllowAssociateHostAction.this.changeAssociateData(setting, hostNode, rows);
                    if (multiInfoDialog.getTableModel().getRowCount() == 0) {
                        multiInfoDialog.dispose();
                    }
                }
            };
        }

        private List<List<Object>> initDisplayHostDetail(HostAssociationSetting setting) {
            LinkedList<List<Object>> failRet = new LinkedList<List<Object>>();
            for (DevNode devNode : setting.getNotAllowAssociatedHosts()) {
                if (!ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
                ArrayList<DevNode> tmp = new ArrayList<DevNode>();
                tmp.add(devNode);
                failRet.add(tmp);
            }
            return failRet;
        }

        public void changeAssociateData(HostAssociationSetting setting, HostEvalNode hostNode, List<TableRow> rows) {
            for (TableRow row : rows) {
                DevNode dn = (DevNode)row.getUserObject();
                setting.getUnAssociateHosts().add(dn);
                setting.getNotAllowAssociatedHosts().remove(dn);
                hostNode.getNotAllowAssociatedHosts().remove(dn);
                SetAssociationDialog.this.storageHostAssocPageLayout.setVisibleOfViewLink(!hostNode.getNotAllowAssociatedHosts().isEmpty());
                hostNode.getUnAssociateHosts().add(dn);
            }
        }

        public void addHostToAssociat(MultiInfoDialog multiInfoDialog, List<TableRow> rows) {
            multiInfoDialog.getTableModel().removeRow(rows);
            boolean isHaveRow = SetAssociationDialog.this.storageHostAssocPageLayout.getHostTable().getAllRows().isEmpty();
            for (TableRow row : rows) {
                SetAssociationDialog.this.storageHostAssocPageLayout.getHostModel().addRow(new TableRow[]{SetAssociationDialog.this.createHostTableRow((DevNode)row.getUserObject())});
            }
            if (isHaveRow) {
                SetAssociationDialog.this.storageHostAssocPageLayout.removeHostTableTips();
            }
        }

        private void showFilterHost(List<List<Object>> failRet, String[] headers, MultiInfoDialog multiInfoDialog) {
            ArrayList<DefaultTableRow> tableRows = new ArrayList<DefaultTableRow>();
            for (List<Object> row : failRet) {
                DevNode devNode = (DevNode)row.get(0);
                ArrayList<String> tmp = new ArrayList<String>();
                String deviceName = !StringUtils.isNULLStr((String)devNode.getDeviceNameAlias()) ? devNode.getDeviceNameAlias() : devNode.getDeviceName();
                tmp.add(deviceName);
                tmp.add(devNode.getDeviceType().toString());
                tmp.add(devNode.getIp());
                DefaultTableRow tableRow = new DefaultTableRow(headers.length, (Object)devNode, (Object)StringUtils.getNoStripUUID());
                tableRow.setValues(tmp);
                tableRows.add(tableRow);
            }
            multiInfoDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
            multiInfoDialog.getErrTable().setSelectionMode(2);
            multiInfoDialog.setVisible(true);
        }
    }

    private class LabelSelectListner
    extends MouseAdapter {
        private LabelSelectListner() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            SetAssociationDialog.this.setCursor(Cursor.getPredefinedCursor(12));
            SetAssociationDialog.this.setLabelSelectedBorder((JLabel)event.getSource(), false);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            SetAssociationDialog.this.setCursor(Cursor.getDefaultCursor());
            if (!SetAssociationDialog.this.selectedAssocType.equals((JLabel)event.getSource())) {
                ((JLabel)event.getSource()).setBorder(BorderFactory.createEmptyBorder());
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            SetAssociationDialog.this.switchBtnClicked(event);
        }
    }

    private final class DbSelectedListner
    implements ListSelectionListener {
        private DbSelectedListner() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            List selectedRows = SetAssociationDialog.this.hostDBAssociationDialogLayout.getDBTable().getMarkedRows();
            if (selectedRows.isEmpty()) {
                SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostModel().removeAll();
                SetAssociationDialog.this.hostDBAssociationDialogLayout.getHostTable().clearSelection();
                return;
            }
            if (selectedRows.size() > 1) {
                SetAssociationDialog.this.storageHostAssocPageLayout.getHostModel().removeAll();
                DialogUtils.showInfoDialog((JDialog)SetAssociationDialog.this.mainWizardDialog, (String)ResourceUtil.getString((String)"evalu.ui.setAssociationDialog.savebtn.multiple.device.db.tips"));
                SetAssociationDialog.this.storageHostAssocPageLayout.getMiddleLabelBox().setVisible(false);
                return;
            }
            SetAssociationDialog.this.resetDbHostTable();
        }
    }
}

