/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.HostServiceFactory;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.swing.DefaultNodeTypeQuery;
import com.huawei.ism.tool.infograb.swing.DevNodeImportAsyncExcutor;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.IGrabCliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.ListCellEntity;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class StorageInfoHelper
implements Callable<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(StorageInfoHelper.class);
    private HostEvaluMainDialog parent;
    private final ProgressDialog progressDialog;
    private DefaultTableModel tableModel;
    private List<com.huawei.ism.tool.obase.entity.DevNode> devNodes = new ArrayList<com.huawei.ism.tool.obase.entity.DevNode>();
    private int hostQueryCount;

    public StorageInfoHelper(HostEvaluMainDialog parent, ProgressDialog progressDialog) {
        this.parent = parent;
        this.progressDialog = progressDialog;
        this.tableModel = this.parent.getMainLayout().getTableModel();
    }

    public static void updateRow(StorageInfo storageInfo, HostEvaluMainDialog dialog) {
        TableRow<HostEvalNode, String> row = StorageInfoHelper.getTableRowById(storageInfo.getStorageSn(), dialog);
        if (null == row) {
            return;
        }
        HostEvalNode hostEvalNode = (HostEvalNode)row.getUserObject();
        if (null == hostEvalNode) {
            return;
        }
        hostEvalNode.setMappedStorage(storageInfo);
        if (storageInfo.getErrorCode() != 0) {
            dialog.updateStorageAddedHostNumber(hostEvalNode);
            return;
        }
        hostEvalNode.setAllHostNumbers(storageInfo.getHostInitize());
        dialog.updateStorageAddedHostNumber(hostEvalNode);
    }

    private static TableRow<HostEvalNode, String> getTableRowById(String id, HostEvaluMainDialog dialog) {
        List tableRows = dialog.getMainLayout().getTableModel().getAllRows();
        for (TableRow row : tableRows) {
            if (!row.getIdentifier().equals(id)) continue;
            return row;
        }
        return null;
    }

    public static Future<Boolean> startLoadTask(HostEvaluMainDialog parent, ProgressDialog progressDialog) {
        Future execFuture = null;
        try {
            ListCellEntity entity = new ListCellEntity();
            List nodeList = DefaultNodeProviderImpl.getInstance().getNodeList();
            if (!nodeList.isEmpty()) {
                entity.setMessageTip(ResourceUtil.getString((String)"eval.ui.start.load.storage.info.start"));
                entity.setShowSingleTip(true);
                parent.getMainLayout().getDetailList().setListData(new Object[]{entity});
            }
            execFuture = AsyncExcutor.submit((Callable)new StorageInfoHelper(parent, progressDialog));
        }
        catch (Exception e) {
            DialogUtils.showInfoDialog((JDialog)parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.load.array.data.failure"));
        }
        return execFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        HostEvaluMainDialog mainDialog = (HostEvaluMainDialog)this.progressDialog.getParent();
        mainDialog.showImportInfoDialog();
        try {
            this.parent.setBtnEnabled(false);
            Thread.sleep(800L);
            List<StorageInfo> storageInfos = (List<StorageInfo>)HostEvalContext.getStorageMap().get("storageInfo");
            if (storageInfos != null) {
                Boolean bl = true;
                return bl;
            }
            this.parseSceneHostDeviceListXML();
            storageInfos = HostEvalUtils.getStorageInfoList();
            DefaultNodeProviderImpl.getInstance().addNodes(this.devNodes);
            this.removeDevList();
            ArrayList<ArrayList<Object>> datas = new ArrayList<ArrayList<Object>>();
            for (StorageInfo storageInfo : storageInfos) {
                TableRow<HostEvalNode, String> row = HostEvaluMainDialog.getInstance().getTableRowById(storageInfo.getStorageSn());
                Object node = null;
                this.checkRow(storageInfo, row);
                if (0 == storageInfo.getErrorCode()) {
                    this.checkStorageResult(datas, storageInfo, row);
                    continue;
                }
                if (0 == storageInfo.getErrorCode()) continue;
                datas.add(this.createStorageInfoShowData(storageInfo, ResourceUtil.getString((String)storageInfo.getErrorMsg())));
            }
            List<com.huawei.ism.tool.obase.entity.DevNode> devList = HostEvalContext.getErrHostDevs();
            this.addDatas(datas, devList);
            if (!datas.isEmpty()) {
                String msg = ResourceUtil.getString((String)"querytip.ui.mainDialog.task.table.storage.result.tip");
                StorageInfoHelper.showInfoTip(datas, msg);
            }
            LOGGER.info(String.format(Locale.ENGLISH, "***[storageInfos size is: %s]***", storageInfos.size()));
        }
        catch (Exception e) {
            LOGGER.error("error to show storage", e);
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.load.array.data.failure"));
        }
        finally {
            if (!HostEvaluMainDialog.getInstance().getMainLayout().getDevEvaluTable().getAllRows().isEmpty()) {
                this.parent.setBtnEnabled(true);
                this.parent.getMainLayout().getDetailList().setListData(new Object[0]);
            }
        }
        ToolUtils.executeAddDevice2Complete(this.parent);
        return true;
    }

    private void removeDevList() throws ToolException {
        List<com.huawei.ism.tool.obase.entity.DevNode> errDevList = HostEvalContext.getErrHostDevs();
        if (!errDevList.isEmpty()) {
            DefaultNodeProviderImpl.getInstance().removeNodes(errDevList);
        }
    }

    private void addDatas(List<ArrayList<Object>> datas, List<com.huawei.ism.tool.obase.entity.DevNode> devList) {
        if (!devList.isEmpty()) {
            for (com.huawei.ism.tool.obase.entity.DevNode dev : devList) {
                ArrayList<Object> data = new ArrayList<Object>();
                data.add(dev.getDeviceType());
                data.add(dev.getDeviceSerialNumber());
                data.add(dev.getIp());
                data.add(dev.getErrorDecs());
                datas.add(data);
            }
        }
    }

    private void checkStorageResult(List<ArrayList<Object>> datas, StorageInfo storageInfo, TableRow<HostEvalNode, String> row) throws ToolException {
        if (storageInfo.getContainsNfs()) {
            datas.add(this.createStorageInfoShowData(storageInfo, ResourceUtil.getString((String)"evalu.ui.mainDialog.task.table.storage.result.NFS.tip")));
        } else if (storageInfo.getHostList().isEmpty() || storageInfo.getHostInitize() == 0) {
            datas.add(this.createStorageInfoShowData(storageInfo, ResourceUtil.getString((String)"evalu.ui.mainDialog.task.table.storage.result.nohost.tip")));
            DefaultTableModel model = HostEvaluMainDialog.getInstance().getMainLayout().getTableModel();
            model.removeRow(new TableRow[]{row});
            DefaultNodeProviderImpl.getInstance().removeNode(storageInfo.getStorageSn());
            if (model.getAllRows().isEmpty()) {
                HostEvaluMainDialog.getInstance().getMainLayout().getDetailList().setListData(new Object[0]);
            }
        }
    }

    private void checkRow(StorageInfo storageInfo, TableRow<HostEvalNode, String> row) {
        if (null != row) {
            HostEvalNode node = (HostEvalNode)row.getUserObject();
            node.setMappedStorage(storageInfo);
        } else {
            LOGGER.error("getTableRowById() is filed,row =null");
        }
    }

    private void parseSceneHostDeviceListXML() {
        if (SceneUtils.isScene()) {
            String currentFile = SceneUtils.getSceneFilePath((String)"sceneHostDeviceList.xml");
            LOGGER.info(String.format(Locale.ENGLISH, "host xml path is :%s", currentFile));
            File devFile = new File(currentFile);
            if (devFile.exists()) {
                List<DevNode> devsXML = SceneXmlData.getInstance().loadSceneFromFile("sceneHostDeviceList.xml");
                if (devsXML == null) {
                    LOGGER.error("Parsing host xml result is null");
                    return;
                }
                devsXML.forEach(dev -> dev.setDeviceSerialNumber(dev.getDeviceSerialNumber().toUpperCase(Locale.ENGLISH)));
                devsXML = this.getAssociationHost(devsXML);
                if (!devsXML.isEmpty()) {
                    this.devNodes = EntityUtils.toOldDevList(devsXML);
                    this.getHostDevsAndAdminUser(this.devNodes);
                    QueryDeviceTask queryWwnTask = new QueryDeviceTask();
                    DevNodeImportAsyncExcutor.execute(this.parent, queryWwnTask);
                }
            }
        }
    }

    private ArrayList<Object> createStorageInfoShowData(StorageInfo storageInfo, String msg) {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(storageInfo.getProductVersion());
        data.add(storageInfo.getStorageSn());
        data.add(storageInfo.getStorageIp());
        data.add(msg);
        return data;
    }

    private List<DevNode> getAssociationHost(List<DevNode> devsXML) {
        List nodeList = DefaultNodeProviderImpl.getInstance().getNodeList();
        Iterator iterator = nodeList.iterator();
        while (iterator.hasNext()) {
            com.huawei.ism.tool.obase.entity.DevNode node = (com.huawei.ism.tool.obase.entity.DevNode)iterator.next();
            if (ItDeviceType.Storage.equals((Object)node.getItDeviceType())) continue;
            iterator.remove();
        }
        return devsXML;
    }

    public static void showInfoTip(List<ArrayList<Object>> datas, String msg) {
        String[] header = new String[]{ResourceUtil.getString((String)"evalu.ui.mainWindow.table.model"), ResourceUtil.getString((String)"evalu.ui.mainWindow.table.dev.sn"), ResourceUtil.getString((String)"evalu.ui.mainWindow.table.ip"), ResourceUtil.getString((String)"evalu.ui.mainDialog.task.table.storage.result")};
        SubDialogUtils.showMultiInfoDialog((Window)HostEvaluMainDialog.getInstance(), (String)msg, (String[])header, datas);
    }

    private void getHostDevsAndAdminUser(List<com.huawei.ism.tool.obase.entity.DevNode> devs) {
        for (com.huawei.ism.tool.obase.entity.DevNode devNode : devs) {
            User adminUser = devNode.getAdminUser();
            if (adminUser != null) {
                GrabContext.getInstance().getAdminNameAndPassMap().put(devNode.getIp(), adminUser);
            }
            if (!ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
            HostEvalContext.getHostDevs().add(devNode);
        }
    }

    private class QueryDeviceTask
    implements Callable<Boolean> {
        private QueryDeviceTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Boolean call() throws Exception {
            for (com.huawei.ism.tool.obase.entity.DevNode devNode : StorageInfoHelper.this.devNodes) {
                DevNodeImportAsyncExcutor.getDevNodeImportProgressDialog().setInitDevCount(StorageInfoHelper.this.devNodes.size(), 0);
                IGrabCliConnection con = null;
                if (!ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
                try {
                    HostService hostService = HostServiceFactory.createHostService((com.huawei.ism.tool.obase.entity.DevNode)devNode);
                    con = new DefaultNodeTypeQuery(null, null).getDbOrHostConnection(devNode);
                    if (con instanceof SshConnection) {
                        SshConnection.switchToRootIfNeeded((com.huawei.ism.tool.obase.entity.DevNode)devNode, (ICliConnection)con);
                    }
                    if (null != hostService && null != con) {
                        Launcher launcher = hostService.queryWwn((ICliConnection)con, devNode);
                        LOGGER.info(String.format(Locale.ENGLISH, "launcher :%s devKey:%s", launcher, devNode.getDevKey()));
                        GrabContext.getInstance().getLauncherMap().put(devNode.getDevKey(), launcher);
                        DevNodeImportAsyncExcutor.getDevNodeImportProgressDialog().refreshQueryTaskCount(++StorageInfoHelper.this.hostQueryCount);
                    } else {
                        LOGGER.error("query host Wwn failed");
                    }
                    if (null == con) continue;
                }
                catch (ToolException e) {
                    if (null == con) {
                        HostEvalContext.getHostDevs().remove(devNode);
                        devNode.setErrorDecs(ResourceUtil.getString((String)"querytip.ssh.connect.unknow.error"));
                        HostEvalContext.getErrHostDevs().add(devNode);
                        LOGGER.info("StorageInfoHelper query hostInfo error, delete in device list.");
                    }
                    LOGGER.error("StorageInfoHelper.queryHostWwn() Wwn error.");
                    if (null == con) continue;
                    SshConnectionManager.releaseConnection((ICliConnection)con);
                    continue;
                }
                catch (Exception e2) {
                    LOGGER.error("StorageInfoHelper.queryHostWwn() unknow error.");
                    if (null == con) continue;
                    {
                        catch (Throwable throwable) {
                            if (null != con) {
                                SshConnectionManager.releaseConnection(con);
                            }
                            throw throwable;
                        }
                    }
                    SshConnectionManager.releaseConnection((ICliConnection)con);
                    continue;
                }
                SshConnectionManager.releaseConnection((ICliConnection)con);
            }
            return true;
        }
    }
}

