/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.ui.SupportDeviceLayout;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;

public class SupportDeviceDialog
extends JDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(450, 530);
    private SupportDeviceLayout layout = new SupportDeviceLayout();
    private EvaluContext evaluContext = EvaluContext.getInstance();

    public SupportDeviceDialog(JDialog parent) {
        super(parent);
        this.setResizable(false);
        this.layout.setCompName();
        this.initTableData(this.evaluContext.getSupportVersionMap());
        this.initListener();
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
        this.setTitle(ResourceUtil.getString((String)"evalu.ui.supportDevice.title"));
        this.add(this.layout);
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getConfirmeBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click confir button");
                SupportDeviceDialog.this.confirmeAction();
            }
        });
    }

    private TableRow<String, String> createTableRow(String devType, Map<String, List<String>> supportVersionMap) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumns(), (Object)devType, (Object)devType);
        row.setValueAt(0, (Object)devType);
        List<String> versions = supportVersionMap.get(devType);
        StringBuffer supportVer = new StringBuffer();
        for (String ver : versions) {
            supportVer.append(",");
            supportVer.append(ver);
        }
        String supVerStr = supportVer.toString();
        if (!supVerStr.isEmpty()) {
            supVerStr = supVerStr.substring(",".length());
        }
        row.setValueAt(1, (Object)supVerStr);
        return row;
    }

    private void initTableData(Map<String, List<String>> supportVersionMap) {
        this.layout.getTableModel().removeAll();
        ArrayList<String> modelList = new ArrayList<String>(supportVersionMap.keySet());
        Collections.sort(modelList);
        for (String model : modelList) {
            if (model.contains("_container") || A800Utils.isA800UpgradeCheck() && !A800Utils.isA800(model)) continue;
            this.layout.getTableModel().addRow(new TableRow[]{this.createTableRow(model, supportVersionMap)});
        }
    }

    private void confirmeAction() {
        this.dispose();
    }
}

