/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AddDeviceAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AddDeviceAction.class);
    private static final String WIZARD_DEFINE_PATH = "config/wizard/ElementDefine.xml";
    private static final String WIZARD_FLOW_PATH = "config/wizard/UpgradeEvaluationFlow.xml";
    private static final String A800_WIZARD_FLOW_PATH = "config/wizard/A800UpgradeEvaluationFlow.xml";
    private static EvaluContext evaluContext = EvaluContext.getInstance();

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.addDevAction();
        }
        catch (Exception ex) {
            LOGGER.error("add device exception", ex);
        }
    }

    private void addDevAction() {
        if (!evaluContext.isExistsPkg()) {
            DialogUtils.showInfoDialog((JDialog)evaluContext.getMainDialog(), (String)ResourceUtil.getString((String)"eualu.ui.listener.addDev.not.product"));
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            return;
        }
        JDialog mainDialog = evaluContext.getMainDialog();
        List results = AsyncExcutor.execute((Window)mainDialog, (Callable[])new Callable[]{new AddDeviceCall(mainDialog, evaluContext, classLoader)});
        Boolean addResult = (Boolean)results.get(0);
        if (addResult == null || !addResult.booleanValue()) {
            LOGGER.error("initial FlowWizardDialog failed!");
            return;
        }
    }

    private static class AddDeviceCall
    implements Callable<Boolean> {
        private EvaluContext evaluContext;
        private ClassLoader classLoader;
        private JDialog mainDialogObj;

        public AddDeviceCall(JDialog mainDialogObj, EvaluContext evaluContext, ClassLoader classLoader) {
            this.evaluContext = evaluContext;
            this.classLoader = classLoader;
            this.mainDialogObj = mainDialogObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            InputStream defXmlStream = this.classLoader.getResourceAsStream(AddDeviceAction.WIZARD_DEFINE_PATH);
            InputStream flowXmlStream = this.classLoader.getResourceAsStream(this.getFlowXmlPath());
            FlowWizardDialog wizard = null;
            try {
                this.evaluContext.setIsClickUpgTips(false);
                wizard = new FlowWizardDialog((Window)this.mainDialogObj, this.evaluContext.getLoc(), this.classLoader, defXmlStream, flowXmlStream, null);
                wizard.setModal(true);
                this.evaluContext.setWizDialog(wizard);
                UiMethod.putScreenCenter((Window)wizard);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)flowXmlStream);
                StreamUtils.closeStream(null, (InputStream)defXmlStream);
            }
            wizard.setVisible(true);
            return true;
        }

        @NotNull
        private String getFlowXmlPath() {
            return A800Utils.isA800UpgradeCheck() ? AddDeviceAction.A800_WIZARD_FLOW_PATH : AddDeviceAction.WIZARD_FLOW_PATH;
        }
    }
}

