/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceManageService;
import com.huawei.ism.tool.devicemanager.service.IDeviceManageService;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.ui.action.DeviceListImpotOperator;
import com.huawei.ism.tool.devicemanager.ui.action.ImportFileType;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.devicemanager.ui.mainframe.DeviceManagementPanel;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.NetUtil;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class BatchImportAction
implements ToolHyperLinkLabel.ClickListener {
    private static final int IMPORT_SUCCESS = 0;
    private static final int IMPORT_FAILED = -1;
    private static final int IMPORT_OTHER = 8;
    private static final long IMPORT_FILE_SIZE = 0xA00000L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BatchImportAction.class);
    private int importXmlError = 2;
    private static final String EVALU_IMPORT_INPUT = "evalu_import_input_xls";
    private DeviceManagementPanel panel = null;
    private Map<String, String> deviceImportResult = null;
    private IDeviceManageService deviceManageService = new DeviceManageService();
    private JDialog parentDialog;
    private List<String> isTaskDevicesIp = new ArrayList<String>();
    private Collection<DevNode> deviceList;
    private EvaluContext evaluContext = EvaluContext.getInstance();

    public BatchImportAction(DeviceManagementPanel panel) {
        this.panel = panel;
    }

    public BatchImportAction(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public void clickLink(MouseEvent e) {
        LOGGER.info("do batch import device");
        this.deviceImportResult = new HashMap<String, String>();
        int ret = this.doImport();
        if (8 == ret) {
            this.isTaskDevicesIp.clear();
            return;
        }
        if (-1 == ret) {
            if (1 == DeviceContext.getInstance().getErrorStatus()) {
                DialogUtils.showInfoDialog((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String)ResourceUtil.getString((String)"toolbox.proy.name.errormsg"));
                return;
            }
            if (1 == this.importXmlError) {
                DialogUtils.showInfoDialog((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String)ResourceUtil.getString((String)"toolbox.xml.proy.errormsg"));
            } else if (this.deviceImportResult.isEmpty() && (null == this.deviceList || this.deviceList.isEmpty())) {
                DialogUtils.showInfoDialog((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.device.import.failed"));
            } else {
                DialogUtils.showInfoDialog((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String)ResourceUtil.getString((String)"toolbox.proy.errormsg"));
            }
        }
        if (null != this.panel) {
            this.panel.updateButtons();
        }
    }

    public int doImport() {
        File importFile = ToolFileChooser.selectFile((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.device.import.title"), (String[])new String[]{"xls"}, (String)EVALU_IMPORT_INPUT, (String)"*.xls", (int)0, (boolean)true, (boolean)false, (Locale)this.evaluContext.getLoc());
        if (importFile == null) {
            return 8;
        }
        if (!FileUtils.isDiskFull((String)FileUtil.getCanonicalPath(importFile), (long)0xA00000L)) {
            return 8;
        }
        ImportDeviceTask importDeviceTask = new ImportDeviceTask(importFile);
        if (null != this.panel) {
            AsyncExcutor.execute((Window)this.panel.getParentJFrame(), (Callable[])new Callable[]{importDeviceTask});
        } else {
            AsyncExcutor.execute((Window)this.parentDialog, (Callable[])new Callable[]{importDeviceTask});
        }
        if (this.deviceList == null) {
            return -1;
        }
        this.deviceList = null;
        this.showImportInfoDialog(this.deviceImportResult);
        this.deviceImportResult.clear();
        return 0;
    }

    private Collection<DevNode> parseDeviceFile(File importFile, Map<String, String> deviceImpResult) {
        String suffix = this.getFileSuffix(importFile);
        Collection devList = null;
        if (suffix.equals(ImportFileType.XML.getValue())) {
            try {
                devList = DeviceListImpotOperator.getDeviceList((File)importFile);
            }
            catch (SAXException e) {
                LOGGER.error("DeviceList.xml file parse error", e);
            }
            catch (IOException e) {
                LOGGER.error("", e);
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        }
        if (devList == null || devList.isEmpty()) {
            return null;
        }
        return devList;
    }

    private String getFileSuffix(File importFile) {
        String fileName = importFile.getName();
        String fileSuffix = fileName.substring(fileName.lastIndexOf(46) + 1);
        return fileSuffix;
    }

    private void showImportInfoDialog(Map<String, String> deviceMap) {
        ArrayList failRet = new ArrayList();
        for (Map.Entry<String, String> entry : deviceMap.entrySet()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(entry.getKey());
            tmp.add(entry.getValue());
            failRet.add(tmp);
        }
        SubDialogUtils.showMultiInfoDialog((Window)(null != this.panel ? this.panel.getParentJFrame() : this.parentDialog), (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.device.import.deviceadddialog.batcherror"), (String[])new String[]{ResourceUtil.getString((String)"evalu.ui.card.addDev.device.errormsg.ip"), ResourceUtil.getString((String)"evalu.ui.card.addDev.device.errormsg.reason")}, failRet);
    }

    private boolean generFalseStatus() {
        this.importXmlError = 1;
        this.deviceList = null;
        return false;
    }

    private TaskResult checkDeviceIsInvalid(DevNode devNode) {
        boolean deviceIllegal;
        TaskResult devNodeTaks = new TaskResult();
        devNodeTaks.setErrorId(devNode.getIp());
        String pwd = devNode.getLoginUser().getPassword();
        boolean passwdIllegal = StringUtils.isNULLStr((String)pwd);
        pwd = "";
        boolean usernameIllegal = StringUtils.isNULLStr((String)devNode.getLoginUser().getUserName());
        boolean portIllegal = devNode.getPort() < 0;
        boolean bl = deviceIllegal = passwdIllegal || usernameIllegal || portIllegal;
        if (deviceIllegal) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.errorMess"));
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        Socks5Proxy socks = devNode.getSocks5Proxy();
        boolean socksIllegal = this.checkSocks5Valid(socks);
        if (socksIllegal) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.socks5.errorMess"));
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        List ssh = devNode.getSshForwardList();
        boolean sshOK = this.checkSshValid(devNode, ssh);
        if (sshOK) {
            devNodeTaks.setErrorLocaleDescription(ResourceUtil.getString((String)"import.devNode.ssh.errorMess"));
            devNodeTaks.setResult(TaskResult.Result.FAILED);
            return devNodeTaks;
        }
        return null;
    }

    private boolean checkSocks5Valid(Socks5Proxy socks) {
        if (null == socks) {
            return false;
        }
        boolean ipIsOk = !NetUtil.isValidIP((String)socks.getServerIp());
        boolean socksName = StringUtils.isNULLStr((String)socks.getName());
        boolean portOK = StringUtils.isNULLStr((String)socks.getPort());
        if (socksName || portOK || ipIsOk) {
            return true;
        }
        if (!socks.isAuthentic()) {
            return false;
        }
        boolean usernameOk = StringUtils.isNULLStr((String)socks.getUser());
        boolean passwdOk = StringUtils.isNULLStr((String)socks.getPass());
        return usernameOk || passwdOk;
    }

    private boolean checkSshValid(DevNode devNode, List<MultiRouteNode> ssh) {
        if (null == ssh) {
            return false;
        }
        boolean sshNameInValid = StringUtils.isNULLStr((String)devNode.getSshName());
        if (sshNameInValid) {
            return true;
        }
        for (MultiRouteNode multiRouteNode : ssh) {
            boolean sshPortOK;
            boolean sshHostOK = !NetUtil.isValidIP((String)multiRouteNode.getHost());
            boolean sshPwdOK = StringUtils.isNULLStr((String)multiRouteNode.getPwd());
            boolean sshUserOK = StringUtils.isNULLStr((String)multiRouteNode.getUname());
            boolean bl = sshPortOK = multiRouteNode.getPort() < 0;
            if (!sshHostOK && !sshPwdOK && !sshUserOK && !sshPortOK) continue;
            return true;
        }
        return false;
    }

    private List<Socks5Proxy> addListChilden(List<Socks5Proxy> socks5List, Socks5Proxy socks5) {
        if (socks5List.isEmpty()) {
            socks5List.add(socks5);
            return socks5List;
        }
        int size = socks5List.size();
        for (int i = 0; i < size; ++i) {
            Socks5Proxy socks5Proxy = socks5List.get(i);
            if (!socks5Proxy.getName().equals(socks5.getName())) continue;
            ToolLoggerFactory.getLogger(this.getClass()).info("update socks5 !");
            socks5Proxy.setName(socks5.getName());
            socks5Proxy.setAuthentic(socks5.isAuthentic());
            String pass = socks5.getPass();
            socks5Proxy.setPass(pass);
            pass = "";
            socks5Proxy.setPort(socks5.getPort());
            socks5Proxy.setUser(socks5.getUser());
            socks5Proxy.setServerIp(socks5.getServerIp());
            break;
        }
        return socks5List;
    }

    private class ImportDeviceTask
    implements Callable<Boolean> {
        private File importFile;

        public ImportDeviceTask(File importFile) {
            this.importFile = importFile;
        }

        @Override
        public Boolean call() {
            BatchImportAction.this.deviceList = BatchImportAction.this.parseDeviceFile(this.importFile, BatchImportAction.this.deviceImportResult);
            if (BatchImportAction.this.deviceList == null) {
                return false;
            }
            this.checkIsSameDevNode();
            String jumpName = "";
            ArrayList socks5List = new ArrayList();
            socks5List.addAll(SettingService.getProxies());
            KeyOrderedHashMap sshMap = new KeyOrderedHashMap();
            sshMap.putAll((Map)SettingService.getSshForwards());
            KeyOrderedHashMap sshMapCollocate = SettingService.getSshMapCollocate();
            ArrayList sockLs = new ArrayList();
            TaskResult importResult = null;
            for (DevNode devNode : BatchImportAction.this.deviceList) {
                importResult = BatchImportAction.this.checkDeviceIsInvalid(devNode);
                if (null != importResult) {
                    BatchImportAction.this.deviceImportResult.put(devNode.getUid(), importResult.getErrorLocaleDescription());
                    continue;
                }
                importResult = BatchImportAction.this.deviceManageService.importDevice(devNode);
                if ((importResult = DeviceQueryErrorParser.parseErrorInfo((TaskResult)importResult)) == null) {
                    LOGGER.warn("operalog.name.importdevice importResult is null " + devNode.toString());
                    continue;
                }
                BatchImportAction.this.deviceImportResult.put(devNode.getUid(), importResult.getErrorLocaleDescription());
                if (TaskResult.Result.SUCCESS.equals((Object)importResult.getResult())) {
                    if (null != devNode.getSocks5Proxy()) {
                        sockLs.addAll(BatchImportAction.this.addListChilden(socks5List, devNode.getSocks5Proxy()));
                    }
                    if (null != devNode.getSshForwardList()) {
                        jumpName = devNode.getSshName();
                        sshMap.put((Object)devNode.getSshName(), sshMapCollocate.get((Object)jumpName));
                    }
                }
                LogUtils.addOperaLog((String)"operalog.name.importdevice", (DevNode)devNode, (TaskResult)importResult);
            }
            SettingService.saveProxies((KeyOrderedHashMap)sshMap, sockLs);
            return true;
        }

        private boolean checkIsSameDevNode() {
            ArrayList<DevNode> deviceLists = new ArrayList<DevNode>();
            deviceLists.addAll(BatchImportAction.this.deviceList);
            for (int i = 0; i < deviceLists.size() - 1; ++i) {
                DevNode firstNode = (DevNode)deviceLists.get(i);
                String firstIp = firstNode.getIp();
                this.traversalSameDevNode(deviceLists, firstNode, firstIp, i + 1);
            }
            return true;
        }

        private void traversalSameDevNode(List<DevNode> deviceLists, DevNode firstNode, String firstIp, int jLable) {
            for (int jSize = jLable; jSize < deviceLists.size(); ++jSize) {
                DevNode sendNode = deviceLists.get(jSize);
                String sendIp = sendNode.getIp();
                if (!firstIp.equals(sendIp) || !this.checkSameDevNode(firstNode, sendNode)) continue;
                firstNode.setUid();
                sendNode.setUid();
            }
        }

        private boolean checkSameDevNode(DevNode firstNode, DevNode sendNode) {
            boolean isSendSshNUll;
            boolean isProxyNull = null == firstNode.getSocks5Proxy() && null == sendNode.getSocks5Proxy();
            boolean isFirstSshNull = null == firstNode.getSshForwardList() || firstNode.getSshForwardList().isEmpty();
            boolean bl = isSendSshNUll = null == sendNode.getSshForwardList() || sendNode.getSshForwardList().isEmpty();
            if (isProxyNull && isFirstSshNull && isSendSshNUll) {
                return BatchImportAction.this.generFalseStatus();
            }
            if (null != firstNode.getSocks5Proxy() && null != sendNode.getSocks5Proxy() && firstNode.getSocks5Proxy() == sendNode.getSocks5Proxy()) {
                return BatchImportAction.this.generFalseStatus();
            }
            if (null != firstNode.getSshForwardList() && null != sendNode.getSshForwardList() && firstNode.getSshName().equals(sendNode.getSshName())) {
                return BatchImportAction.this.generFalseStatus();
            }
            return true;
        }
    }
}

