/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import utils.FilesUtil;

public class ExcelToHtmlByJXL {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExcelToHtmlByJXL.class);
    private Map<String, String> sheetTitleMap = new HashMap<String, String>();
    private List<String> passedResultList = Arrays.asList("\u901a\u8fc7", "Passed");
    private static final int BLANK_ASCII_CODE = 160;

    public ExcelToHtmlByJXL() {
        this.sheetTitleMap.put("Check Manually", ResourceUtil.getString((String)"eval.host.evaluation.reporter.manu.process.details"));
        this.sheetTitleMap.put("SwitchReport", ResourceUtil.getString((String)"eval.host.evaluation.reporter.switch.details"));
        this.sheetTitleMap.put("DatabaseReport", ResourceUtil.getString((String)"eval.host.evaluation.reporter.database.details"));
        this.sheetTitleMap.put("HostReport", ResourceUtil.getString((String)"eval.host.evaluation.reporter.host.details"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File process(File excelFile) {
        String htmlExcel;
        FileOutputStream writerStream;
        BufferedWriter writer;
        File htmlFile;
        block5: {
            String excelPath = FilesUtil.getCanonicalPath((File)excelFile);
            String htmlPath = excelPath.substring(0, excelPath.lastIndexOf(".")) + ".html";
            htmlFile = new File(htmlPath);
            writer = null;
            writerStream = null;
            htmlExcel = null;
            htmlExcel = this.getExcelInfo(excelFile);
            if (htmlExcel != null && !htmlExcel.isEmpty()) break block5;
            File file = null;
            StreamUtils.closeResource(writer, writer);
            StreamUtils.closeResource(writerStream, writerStream);
            return file;
        }
        try {
            writerStream = new FileOutputStream(htmlFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)writerStream, "UTF-8"));
            writer.write(htmlExcel);
        }
        catch (Exception e) {
            File file;
            try {
                LOGGER.error("[excelToHtmlByJXL] process error: " + e.toString());
                file = null;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(writer, writer);
                StreamUtils.closeResource(writerStream, writerStream);
                throw throwable;
            }
            StreamUtils.closeResource(writer, writer);
            StreamUtils.closeResource((Flushable)writerStream, (Closeable)writerStream);
            return file;
        }
        StreamUtils.closeResource((Flushable)writer, (Closeable)writer);
        StreamUtils.closeResource((Flushable)writerStream, (Closeable)writerStream);
        return htmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExcelInfo(File excelFile) {
        String string;
        HSSFWorkbook book = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(excelFile);
            book = new HSSFWorkbook(fis);
        }
        catch (Exception e) {
            LOGGER.error("[getExcelInfo] process error: " + e.toString());
            String string2 = null;
            StreamUtils.closeResource(null, (Closeable)book);
            StreamUtils.closeStream(null, (InputStream)fis);
            return string2;
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
            for (Sheet sheet : book) {
                sb.append("<title>" + ResourceUtil.getString((String)"eval.host.evaluation.reporter.title") + "</title>");
                String sheetTitle = this.sheetTitleMap.get(sheet.getSheetName());
                sb.append("<h2>" + sheetTitle + "</h2>");
                sb.append("<style>div {height:50px;  width:140px; overflow: auto; text-overflow: ellipsis; vertical-align: middle;}</style>");
                sb.append("<table>");
                int rowNum = sheet.getLastRowNum() + 1;
                for (int rowId = 0; rowId < rowNum; ++rowId) {
                    this.dealCellsInRow(sheet, rowId, sb);
                }
                sb.append("</table>");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            StreamUtils.closeResource(null, book);
            StreamUtils.closeStream(null, (InputStream)fis);
            throw throwable;
        }
        StreamUtils.closeResource(null, (Closeable)book);
        StreamUtils.closeStream(null, (InputStream)fis);
        return string;
    }

    private void dealCellsInRow(Sheet sheet, int rowId, StringBuffer sb) {
        Row row = sheet.getRow(rowId);
        int cellNum = row.getLastCellNum();
        if (cellNum == 0) {
            sb.append("<tr><td > &nbsp;</td></tr>");
            return;
        }
        boolean itemResult = false;
        sb.append("<tr>");
        for (int index = 0; index < cellNum; ++index) {
            Cell cellTmp = row.getCell(index);
            if (cellTmp == null) {
                sb.append("<td>&nbsp;</td>");
                continue;
            }
            String stringValue = POIUtils.getStringCellValue((Cell)cellTmp);
            if (this.passedResultList.contains(stringValue)) {
                itemResult = true;
            }
            sb.append("<td ");
            this.dealExcelStyle(cellTmp, sb, cellNum, itemResult);
            sb.append(">");
            if (stringValue == null || "".equals(stringValue.trim())) {
                sb.append(" &nbsp; ");
            } else {
                String source = stringValue.replace(String.valueOf('\u00a0'), "&nbsp;");
                String[] lines = source.split("\n");
                StringBuilder writeStr = new StringBuilder();
                for (String line : lines) {
                    writeStr.append(line).append("<br/>");
                }
                sb.append("<div>").append(writeStr.toString()).append("</div>");
            }
            sb.append("</td>");
        }
        sb.append("</tr>");
    }

    private void dealExcelStyle(Cell cell, StringBuffer sb, int cellNum, boolean itemResult) {
        int lastColumnId = cellNum - 1;
        CellStyle cellFormat = cell.getCellStyle();
        if (cellFormat != null) {
            int rowId = cell.getRowIndex();
            int columnId = cell.getColumnIndex();
            if (rowId == 0) {
                sb.append("align='center' ");
            } else {
                sb.append("align='left' ");
            }
            sb.append("valign='middle' ");
            sb.append("style= '");
            sb.append("font-weight:400;");
            sb.append("font-size: 110%;");
            sb.append("border-top:solid #000000 1px;border-right:solid #000000 1px;border-left:solid #000000 1px;border-bottom:solid #000000 1px;");
            if (rowId == 0) {
                sb.append("background-color: #499df2;");
            } else if (columnId == lastColumnId || columnId == lastColumnId - 1 && columnId != 0) {
                if (itemResult) {
                    sb.append("background-color: #3dcca6;");
                } else {
                    sb.append("background-color: #ff8833;");
                }
            }
            sb.append("' ");
        }
    }
}

