/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.action;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.infograb.swing.DefaultNodeTypeQuery;
import com.huawei.ism.tool.infograb.swing.DeviceManageService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.entity.NotAdminUserDeviceInfo;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.ui.ImportInfoDialog;
import com.huawei.ism.tool.upgradeevalu.util.EvalTimePropertiesUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import com.huawei.ism.tool.upgradeevalu.util.OffLineImportAsyncExcutor;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JDialog;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class OffLineBatchImportAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OffLineBatchImportAction.class);
    private static final String EVALU_IMPORT_INPUT = "evalu_import_input_zip";
    private static final String COLLECT_SCENARIO = ResourceUtil.getString((String)"evalu.ui.import.pkg.device.scenario.title");
    private static final String GRAB_VERSION_CN = ResourceUtil.getString((String)"evalu.ui.import.pkg.device.grabver.title", (Locale)Locale.SIMPLIFIED_CHINESE);
    private static final String GRAB_VERSION_EN = ResourceUtil.getString((String)"evalu.ui.import.pkg.device.grabver.title", (Locale)Locale.ENGLISH);
    private static final String COLLECT_SCENARIO_ELSE = Locale.CHINA.equals(LanguageManager.getInstance().getCurrentLanguage()) ? ResourceUtil.getString((String)"evalu.ui.import.pkg.device.scenario.title", (Locale)Locale.ENGLISH) : ResourceUtil.getString((String)"evalu.ui.import.pkg.device.scenario.title", (Locale)Locale.CHINESE);
    private static final String EXCEL_KEY_DEVICE_IS_ADMIN = ResourceUtil.getString((String)"infograb.excel.login.user.is.admin");
    private static final String EXCEL_KEY_DEVICE_IS_ADMIN_ELSE = Locale.CHINA.equals(LanguageManager.getInstance().getCurrentLanguage()) ? ResourceUtil.getString((String)"infograb.excel.login.user.is.admin", (Locale)Locale.ENGLISH) : ResourceUtil.getString((String)"infograb.excel.login.user.is.admin", (Locale)Locale.CHINESE);
    private static final String DEVICE_NOT_ADMIN_USER_FLAG = "NO";
    private static final int MOST_FILES_AMOUNT = 50;
    private static final int ERROR_INDEX = -1;
    private static final String SHEET_HOST_NAME = "HostReport";
    private static final String SHEET_DATABASE_NAME = "DatabaseReport";
    private static final String SHEET_SWITCH_NAME = "SwitchReport";
    private static final int TOOBIG = 150;
    private HostEvaluMainDialog parent;
    private List<File> files;
    private boolean isScene;

    public OffLineBatchImportAction(HostEvaluMainDialog parent) {
        this.parent = parent;
        this.parseLimitInfo();
    }

    public OffLineBatchImportAction(HostEvaluMainDialog parent, String defaultPath) {
        this(parent);
        this.isScene = true;
    }

    public boolean checkSelectedFile(List<File> selectedFiles) {
        return this.checkFileContent(selectedFiles);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.files = this.selectFiles();
        this.checkFilePath(this.files);
        if (!this.preCheck(this.files)) {
            return;
        }
        this.checkFileContent(this.files);
        this.files.clear();
    }

    public boolean checkFileContent(List<File> selectedFiles) {
        OffLineImportDeviceTask task = new OffLineImportDeviceTask(selectedFiles);
        List<?> result = OffLineImportAsyncExcutor.execute(this.parent, task);
        HashMap<String, String> message = new HashMap<String, String>();
        List taskResults = new ArrayList();
        if (result.get(0) instanceof List) {
            taskResults = (List)result.get(0);
        }
        for (TaskResult taskResult : taskResults) {
            if (!TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) continue;
            message.put(((HostEvalNode)taskResult.getResultObject()).getFileName(), taskResult.getErrorLocaleDescription());
        }
        List<ZipEntry> zipEntrys = HostEvalContext.getZipEntrys();
        List<File> dataFiles = HostEvalContext.getDataFiles();
        if (!message.isEmpty()) {
            zipEntrys.clear();
            dataFiles.clear();
            new ImportInfoDialog((Window)this.parent, message).setVisible(true);
            return false;
        }
        this.getZipFileTime(zipEntrys);
        this.getDataFileTime(dataFiles);
        HostEvalContext.getAllSuccessOffLineFiles().addAll(selectedFiles);
        return true;
    }

    public boolean checkFilePath(List<File> checkFiles) {
        String path = "";
        if (null == checkFiles) {
            return false;
        }
        if (checkFiles.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.format.error"));
            return false;
        }
        for (File file : checkFiles) {
            try {
                path = file.getCanonicalPath();
                if (!FileUtil.checkNormalPath(path)) {
                    DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                    this.files.clear();
                    return false;
                }
                if (FileUtil.checkBlankPath(path)) continue;
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                this.files.clear();
                return false;
            }
            catch (IOException e) {
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.format.error"));
                return false;
            }
        }
        return true;
    }

    public boolean checkFileSize(List<File> checkFiles) {
        String size = "";
        if (null == checkFiles) {
            return false;
        }
        if (checkFiles.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.format.error"));
            return false;
        }
        for (File file : checkFiles) {
            try {
                size = ToolFileChooser.getFileSize((File)file);
                if (Float.valueOf(size).intValue() <= 150) continue;
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.too.big"));
                this.files.clear();
                return false;
            }
            catch (NumberFormatException e) {
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.failed.get.size"));
                return false;
            }
        }
        return true;
    }

    private List<File> selectFiles() {
        List importFiles = ToolFileChooser.selectFiles((Window)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.device.import.title"), (String[])new String[]{"zip"}, (String)EVALU_IMPORT_INPUT, (String)"*.zip", (int)0);
        return importFiles;
    }

    public boolean preCheck(List<File> selectedFiles) {
        if (null == selectedFiles) {
            return false;
        }
        if (selectedFiles.size() > 50) {
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.import.morethan.50"));
            return false;
        }
        return true;
    }

    public void getFilesFromScenario(String path) {
        String lastEvalTime;
        this.files = new ArrayList<File>();
        File file = new File(path);
        if (file.exists()) {
            this.addFiles(file);
        }
        if (StringUtils.isNULLStr((String)(lastEvalTime = EvalTimePropertiesUtil.getInstance().readBeforeEvalTime()))) {
            LOGGER.info("the lastTime not write to the sceneEval properties");
            return;
        }
        if (this.getAfterLastFiles(lastEvalTime).isEmpty()) {
            LOGGER.info("there has no Eval pak after the lastEvalTime.");
            return;
        }
        this.files = this.getAfterLastFiles(lastEvalTime);
    }

    private List<File> getAfterLastFiles(String lastEvalTimeParm) {
        ArrayList<File> evalFiles = new ArrayList<File>();
        for (File fileItem : this.files) {
            if (!this.isRightZip(fileItem, lastEvalTimeParm)) continue;
            evalFiles.add(fileItem);
        }
        return evalFiles;
    }

    private boolean isRightZip(File file, String lastEvalTimeParm) {
        if (!file.getName().contains(".") || !file.getName().contains("_")) {
            return false;
        }
        String[] zipTimes = file.getName().split("_");
        String zipTime = zipTimes[zipTimes.length - 1];
        String[] times = zipTime.split("\\.");
        if (times.length > 0) {
            zipTime = times[0];
        }
        return this.isRightZipTime(zipTime) && this.isRightZipTime(lastEvalTimeParm) && zipTime.trim().compareToIgnoreCase(lastEvalTimeParm.trim()) > 0;
    }

    private boolean isRightZipTime(String zipTimeParm) {
        if (null == zipTimeParm) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]{14}");
        Matcher isNum = pattern.matcher(zipTimeParm);
        return isNum.matches();
    }

    private void addFiles(File directory) {
        if (directory.isDirectory()) {
            File[] allFiles = directory.listFiles();
            if (allFiles == null) {
                LOGGER.info("there is no file in the directory.");
                return;
            }
            for (File file : allFiles) {
                this.addFiles(file);
            }
        } else if (directory.getName().endsWith(".zip")) {
            if (EvaluSceneUtils.isHostScene()) {
                if (directory.getName().startsWith("Eval_")) {
                    LOGGER.info("Add file to import : {}", (Object)directory.getName());
                    this.files.add(directory);
                } else {
                    LOGGER.info("The file not meet the requirements  : {}", (Object)directory.getName());
                }
                return;
            }
            this.files.add(directory);
        }
    }

    private boolean checkDbType(String dbType) {
        return HostEvalContext.getInstance().isDatabaseLimit() && (StringUtils.isNULLStr((String)dbType) || !dbType.equals("Oracle"));
    }

    private boolean checkDevInfoSheetName(Sheet devInfoSheet, int scenarioIndex) throws ToolException {
        if (-1 == scenarioIndex) {
            if (!"overlengthInfo".equals(devInfoSheet.getSheetName())) {
                LOGGER.error("it's a package collected from old version InfoGrab.");
                throw new ToolException("eval.task.import.check.no.scene");
            }
            LOGGER.info("it a overlength info sheet .");
            return true;
        }
        return false;
    }

    private boolean checkOsInfo(String osInfo) {
        return HostEvalContext.getInstance().isHostLimit() && (StringUtils.isNULLStr((String)osInfo) || !osInfo.contains("SUSE"));
    }

    private int getScenarioIndex(Sheet devInfoSheet, int scenarioIndex) {
        if (-1 == scenarioIndex) {
            scenarioIndex = HostEvalUtils.getColIndexFromSheet(devInfoSheet, ResourceUtil.getString((String)"evalu.ui.import.pkg.device.scenario.title.compatible"), Locale.CHINA.equals(LanguageManager.getInstance().getCurrentLanguage()) ? ResourceUtil.getString((String)"evalu.ui.import.pkg.device.scenario.title.compatible", (Locale)Locale.ENGLISH) : ResourceUtil.getString((String)"evalu.ui.import.pkg.device.scenario.title.compatible", (Locale)Locale.CHINESE));
        }
        return scenarioIndex;
    }

    private void parseLimitInfo() {
        String devTypeLimit = UserOpDataSaveUtil.getToolIniProp((String)"device.type.limit");
        int limitValue = -1;
        try {
            limitValue = Integer.parseInt(devTypeLimit, 2);
        }
        catch (NumberFormatException e) {
            LOGGER.error("it happens a number format exception for input String: {}", (Object)devTypeLimit);
            return;
        }
        if (0 > limitValue || 7 < limitValue || 3 != devTypeLimit.length()) {
            LOGGER.info("do not get a correct value, please check the file 'tool.ini '. ");
            return;
        }
        char[] typeLimit = devTypeLimit.toCharArray();
        HostEvalContext.getInstance().setHostLimit("1".equals(String.valueOf(typeLimit[0])));
        HostEvalContext.getInstance().setSwitchLimit("1".equals(String.valueOf(typeLimit[1])));
        HostEvalContext.getInstance().setDatabaseLimit("1".equals(String.valueOf(typeLimit[2])));
    }

    private void getDataFileTime(List<File> dataFiles) {
        for (File dataFile : dataFiles) {
            String name = dataFile.getName();
            try {
                String[] paths = name.split("_");
                String dateStrs = paths[2];
                int len = dateStrs.length();
                if (len >= 13 && dateStrs.endsWith(".data")) {
                    String dateStr = dateStrs.substring(0, 8);
                    HostEvalContext.getOffImportDates().add(dateStr);
                    continue;
                }
                HostEvalContext.getOffImportDates().add("--");
            }
            catch (Exception e) {
                HostEvalContext.getOffImportDates().add("--");
            }
        }
        dataFiles.clear();
    }

    private void getZipFileTime(List<ZipEntry> zipEntrys) {
        for (ZipEntry zipEntry : zipEntrys) {
            String excelName = zipEntry.getName();
            if (excelName.startsWith("DeviceReport")) {
                try {
                    String dateStr = excelName.substring(12, excelName.lastIndexOf(".xls") - 6);
                    HostEvalContext.getOffImportDates().add(dateStr);
                }
                catch (Exception e) {
                    HostEvalContext.getOffImportDates().add("--");
                }
                continue;
            }
            HostEvalContext.getOffImportDates().add("--");
        }
        zipEntrys.clear();
    }

    private class OffLineImportDeviceTask
    implements Callable<List<TaskResult>> {
        private static final String LEAST_GRAB_VER = "v2r5c00rc3";
        private static final String LEAST_GRAB_VER_LONG = "v2r5c00rc03";
        private HostEvalNode singleEvalTask = null;
        private List<File> checkFiles;

        public OffLineImportDeviceTask(List<File> checkFiles) {
            this.checkFiles = checkFiles;
        }

        @Override
        public List<TaskResult> call() throws IOException, InterruptedException {
            ArrayList<TaskResult> allReaults = new ArrayList<TaskResult>();
            OffLineImportAsyncExcutor.getDevNodeImportProgressDialog().setInitDevCount(this.checkFiles.size(), 0);
            ArrayList<File> allZipFile = new ArrayList<File>();
            ArrayList<File> allDataFile = new ArrayList<File>();
            this.groupFileByType(allZipFile, allDataFile);
            for (File file : allZipFile) {
                TaskResult oneTaskResult = new TaskResult();
                HostEvalNode hostEvalTask = new HostEvalNode();
                oneTaskResult.setResult(TaskResult.Result.SUCCESS);
                oneTaskResult.setResultObject((Object)hostEvalTask);
                hostEvalTask.setFileName(file.getCanonicalPath());
                hostEvalTask.setImportTime(new Date());
                hostEvalTask.setProgress(0);
                this.singleEvalTask = hostEvalTask;
                try {
                    this.checkFile(file, oneTaskResult);
                }
                catch (ToolException e) {
                    oneTaskResult.setResult(TaskResult.Result.FAILED);
                    oneTaskResult.setErrorLocaleDescription(ResourceUtil.getString((String)e.getErrorId()));
                }
                TimeUnit.MILLISECONDS.sleep(50L);
                OffLineImportAsyncExcutor.getDevNodeImportProgressDialog().handledDevCount();
                allReaults.add(oneTaskResult);
            }
            this.checkManualGrabFile(allReaults, allDataFile);
            return allReaults;
        }

        public void checkManualGrabFile(List<TaskResult> allReaults, List<File> allDataFile) throws IOException, InterruptedException {
            DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(null, ShowSysConstans.getShowSysCmds());
            DeviceManageService service = new DeviceManageService(nodeTypeQuery);
            ArrayList<DevNode> foundDevs = new ArrayList<DevNode>();
            for (File dataFile : allDataFile) {
                DevNode dev = OffLineBatchImportAction.this.parent.addDevByFiles(dataFile, service);
                if (dev.getErrorDecs() != null) {
                    TaskResult oneTaskResult = new TaskResult();
                    HostEvalNode hostEvalTask = new HostEvalNode();
                    oneTaskResult.setResult(TaskResult.Result.SUCCESS);
                    oneTaskResult.setResultObject((Object)hostEvalTask);
                    hostEvalTask.setFileName(dataFile.getCanonicalPath());
                    hostEvalTask.setImportTime(new Date());
                    oneTaskResult.setResult(TaskResult.Result.FAILED);
                    String errorMsg = ResourceUtil.getString((String)"evalu.ui.import.pkg.exception");
                    if (!"".equals(dev.getErrorDecs())) {
                        errorMsg = dev.getErrorDecs();
                    }
                    oneTaskResult.setErrorLocaleDescription(errorMsg);
                    allReaults.add(oneTaskResult);
                } else {
                    HostEvalContext.getDataFiles().add(dataFile);
                    if (null != dev.getItDeviceType() && dev.getItDeviceType().equals((Object)ItDeviceType.Database)) {
                        HostEvalContext.getAllDbs().add(dev);
                    }
                    foundDevs.add(dev);
                }
                TimeUnit.MILLISECONDS.sleep(50L);
                OffLineImportAsyncExcutor.getDevNodeImportProgressDialog().handledDevCount();
            }
            OffLineBatchImportAction.this.parent.checkAndStoAssDialogIfneededForDataFile(foundDevs);
        }

        public void groupFileByType(List<File> allZipFile, List<File> allDataFile) {
            for (File file : this.checkFiles) {
                if (file.getName().endsWith(".zip")) {
                    allZipFile.add(file);
                }
                if (!file.getName().endsWith(".data")) continue;
                allDataFile.add(file);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void checkFile(File file, TaskResult oneTaskResult) throws ToolException {
            if (!file.getName().endsWith(".zip")) {
                throw new ToolException("evalu.ui.import.pkg.not.zip");
            }
            ZipFile zf = null;
            ZipEntry excelEntry = null;
            ZipEntry versionEntry = null;
            InputStream in = null;
            InputStream sign = null;
            try {
                zf = new ZipFile(file);
                Enumeration<? extends ZipEntry> zipEntrys = zf.entries();
                while (zipEntrys.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntrys.nextElement();
                    if (zipEntry.getName().endsWith(".xls")) {
                        HostEvalContext.getZipEntrys().add(zipEntry);
                        excelEntry = zipEntry;
                        continue;
                    }
                    if (!zipEntry.getName().endsWith(".sign")) continue;
                    versionEntry = zipEntry;
                }
                if (null == excelEntry) throw new ToolException("evalu.ui.import.pkg.read.failed");
                if (null == versionEntry) {
                    throw new ToolException("evalu.ui.import.pkg.read.failed");
                }
                in = zf.getInputStream(excelEntry);
                sign = zf.getInputStream(versionEntry);
                int numOfHosts = this.parseXlsAllHostInfo(in);
                if (0 == numOfHosts) {
                    throw new ToolException("evalu.ui.import.pkg.exception");
                }
                ((HostEvalNode)oneTaskResult.getResultObject()).setNumOfHosts(numOfHosts);
            }
            catch (NoSuchElementException e) {
                try {
                    LOGGER.error("read zip package error.", e);
                    throw new ToolException("evalu.ui.import.pkg.read.failed", (Throwable)e);
                    catch (ToolException e2) {
                        throw new ToolException(e2.getErrorId(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        LOGGER.error("get input stream error.", e3);
                        throw new ToolException("evalu.ui.import.pkg.read.failed", (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, in);
                    StreamUtils.closeResource(null, (Closeable)zf);
                    StreamUtils.closeStream(null, sign);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, (InputStream)in);
            StreamUtils.closeResource(null, (Closeable)zf);
            StreamUtils.closeStream(null, (InputStream)sign);
        }

        private int parseXlsAllHostInfo(InputStream in) throws ToolException {
            int validDeviceCount = 0;
            HSSFWorkbook workbook = null;
            try {
                workbook = new HSSFWorkbook(in);
                this.preCheckSheet(workbook);
                for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                    HSSFSheet devInfoSheet = workbook.getSheetAt(i);
                    int oneTypeDevicesCout = this.checkWithDeviceType(devInfoSheet);
                    validDeviceCount += oneTypeDevicesCout;
                }
            }
            catch (IOException e) {
                throw new ToolException("evalu.ui.import.pkg.read.failed", (Throwable)e);
            }
            finally {
                StreamUtils.closeResource(null, (Closeable)workbook);
            }
            return validDeviceCount;
        }

        private void preCheckSheet(HSSFWorkbook workbook) throws ToolException {
            List<HSSFName> sheets = workbook.getAllNames();
            boolean hasHostReport = false;
            boolean hasSwtichReport = false;
            for (HSSFName sheet : sheets) {
                if (OffLineBatchImportAction.SHEET_HOST_NAME.equals(sheet.getSheetName())) {
                    hasHostReport = true;
                    continue;
                }
                if (!OffLineBatchImportAction.SHEET_SWITCH_NAME.equals(sheet.getSheetName())) continue;
                hasSwtichReport = true;
            }
            if (HostEvalContext.getInstance().isHostLimit() && !hasHostReport) {
                LOGGER.error("there is no valid host in this package.");
                throw new ToolException("eval.task.import.check.no.valid.host");
            }
            if (HostEvalContext.getInstance().isSwitchLimit() && !hasSwtichReport) {
                LOGGER.error("there is no valid switch in this package.");
                throw new ToolException("eval.task.import.check.no.valid.switch");
            }
        }

        private int checkWithDeviceType(Sheet devInfoSheet) throws ToolException {
            int oneTypeDevicesCout = this.getSingleSheetInfo(devInfoSheet);
            if (oneTypeDevicesCout == 0) {
                if (OffLineBatchImportAction.SHEET_HOST_NAME.equals(devInfoSheet.getSheetName())) {
                    if (HostEvalContext.getInstance().isHostLimit()) {
                        LOGGER.error("there is no valid host in this package.");
                        throw new ToolException("eval.task.import.check.no.valid.host");
                    }
                } else if (OffLineBatchImportAction.SHEET_SWITCH_NAME.equals(devInfoSheet.getSheetName())) {
                    if (HostEvalContext.getInstance().isSwitchLimit()) {
                        LOGGER.error("there is no valid switch in this package.");
                        throw new ToolException("eval.task.import.check.no.valid.switch");
                    }
                } else {
                    LOGGER.error("there is no valid info in this package.");
                }
            }
            return oneTypeDevicesCout;
        }

        private int getSingleSheetInfo(Sheet devInfoSheet) throws ToolException {
            int scenarioIndex = HostEvalUtils.getColIndexFromSheet(devInfoSheet, COLLECT_SCENARIO, COLLECT_SCENARIO_ELSE);
            if (OffLineBatchImportAction.this.checkDevInfoSheetName(devInfoSheet, scenarioIndex = OffLineBatchImportAction.this.getScenarioIndex(devInfoSheet, scenarioIndex))) {
                return 0;
            }
            int grabVerIndex = HostEvalUtils.getColIndexFromSheet(devInfoSheet, GRAB_VERSION_CN, GRAB_VERSION_EN);
            int validDeviceCount = 0;
            int startLine = 1;
            int rows = devInfoSheet.getLastRowNum() + 1;
            String deviceReportType = devInfoSheet.getSheetName();
            while (startLine < rows) {
                String dbType;
                String appScenario;
                block8: {
                    appScenario = null;
                    String grabVersion = null;
                    try {
                        appScenario = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(startLine++).getCell(scenarioIndex));
                        grabVersion = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(startLine - 1).getCell(grabVerIndex));
                        grabVersion = grabVersion.toLowerCase(Locale.ENGLISH);
                        if (grabVersion.contains("spc")) {
                            grabVersion = grabVersion.substring(0, grabVersion.indexOf("spc"));
                        }
                        if (this.checkGrabVersion(grabVersion)) {
                        }
                        break block8;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LOGGER.error("read excel error.", e);
                    }
                    continue;
                }
                if (!CommonUtils.checkScenario(appScenario)) continue;
                if (OffLineBatchImportAction.SHEET_HOST_NAME.equals(deviceReportType)) {
                    String osInfo = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(startLine - 1).getCell(4));
                    if (OffLineBatchImportAction.this.checkOsInfo(osInfo)) continue;
                    this.dealwithAdminUser(devInfoSheet, startLine - 1);
                } else if (OffLineBatchImportAction.SHEET_DATABASE_NAME.equals(deviceReportType) && OffLineBatchImportAction.this.checkDbType(dbType = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(startLine - 1).getCell(1)))) continue;
                ++validDeviceCount;
            }
            return validDeviceCount;
        }

        private boolean checkGrabVersion(String grabVersion) {
            return LEAST_GRAB_VER.length() == grabVersion.length() ? LEAST_GRAB_VER.compareTo(grabVersion) > 0 : LEAST_GRAB_VER_LONG.compareTo(grabVersion) > 0;
        }

        private void dealwithAdminUser(Sheet devInfoSheet, int currentLine) {
            int deviceIsAdminIndex = HostEvalUtils.getColIndexFromSheet(devInfoSheet, EXCEL_KEY_DEVICE_IS_ADMIN, EXCEL_KEY_DEVICE_IS_ADMIN_ELSE);
            if (-1 == deviceIsAdminIndex) {
                return;
            }
            String isAdminUserFalg = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(currentLine).getCell(deviceIsAdminIndex));
            if (OffLineBatchImportAction.DEVICE_NOT_ADMIN_USER_FLAG.equals(isAdminUserFalg)) {
                String deviceIp = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(currentLine).getCell(0));
                String deviceType = POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(currentLine).getCell(3));
                NotAdminUserDeviceInfo naudi = new NotAdminUserDeviceInfo();
                naudi.setDeviceIp(deviceIp);
                naudi.setDeviceType(deviceType);
                naudi.setRowNum(currentLine + 1);
                naudi.setTaskName(this.singleEvalTask.getIdentifier());
                this.singleEvalTask.getNotAdminUserDeviceInfo().add(naudi);
            }
        }
    }
}

