/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.hostmultipath.pojo.HostBaseInfo;
import com.huawei.ism.tool.infograb.report.TemplateFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.entity.UpgradeHostInfo;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataExtendUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.utils.ToolConstants;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import utils.FilesUtil;

public class ShowHostViewListener
implements ActionListener {
    private HostEvalNode evaluateNode;
    private Window window;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ShowHostViewListener.class);
    private String hostInfoHmtlFilePath;

    public ShowHostViewListener(Window window, HostEvalNode evaluateNode) {
        this.window = window;
        this.evaluateNode = evaluateNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String curStorageSn = ShowHostViewListener.this.evaluateNode.getStorageSn();
                Map<String, String> hostIdCheckResult = SceneDataExtendUtil.getInstance().getCheckedHostIdResultMap(ShowHostViewListener.this.evaluateNode.getStorageIp(), curStorageSn);
                List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
                for (StorageInfo storageInfo : storageInfos) {
                    if (StringUtils.isNULLStr((String)curStorageSn) || !storageInfo.getStorageSn().equals(curStorageSn)) continue;
                    List allHostInfo = storageInfo.getHostList();
                    List addHostInfo = ShowHostViewListener.this.hostFilter(ShowHostViewListener.this.evaluateNode.getStorageMappingHosts());
                    HashMap hostInfoData = ShowHostViewListener.this.initHostInfoData(allHostInfo, addHostInfo, hostIdCheckResult);
                    return ShowHostViewListener.this.prepareAndWriteToFileHtml(hostInfoData);
                }
                LOGGER.error("No storage info...");
                return false;
            }
        };
        List list = AsyncExcutor.execute((Window)this.window, (Callable[])new Callable[]{task});
        if (((Boolean)list.get(0)).booleanValue() && new File(this.hostInfoHmtlFilePath).exists()) {
            OSCmdUtils.openFile((File)new File(this.hostInfoHmtlFilePath));
        } else {
            DialogUtils.showInfoDialog((Window)this.window, (String)ResourceUtil.getString((String)"evalu.ui.host.mainDialog.showhostviewlistener.no.html"));
        }
    }

    private boolean prepareAndWriteToFileHtml(HashMap<String, ArrayList<HostBaseInfo>> hostInfoData) {
        try {
            String path = FilesUtil.getCanonicalPath((File)EvaluContext.getInstance().getReportDir());
            this.setHostInfoHmtlFilePath(path + File.separator + "hostInfo_" + this.evaluateNode.getStorageSn() + ".html");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("storageInfoData", this.evaluateNode.getStorageIp());
            data.put("hostInfoData", hostInfoData);
            data.put("devSNData", this.evaluateNode.getStorageSn());
            return TemplateFactory.processorFtl("hostInfo.html", data, this.hostInfoHmtlFilePath);
        }
        catch (Exception e) {
            LOGGER.error("prepareAndWriteToFileHtml error", e);
            return false;
        }
    }

    private HashMap<String, ArrayList<HostBaseInfo>> initHostInfoData(List<UpgradeHostInfo> allHostInfo, List<DevNode> addHostInfo, Map<String, String> hostIdCheckResult) {
        String strAllFcIbwIscsis = this.getaddHostWwnStr(addHostInfo);
        HashMap<String, ArrayList<HostBaseInfo>> hostInfoData = new HashMap<String, ArrayList<HostBaseInfo>>();
        ArrayList<HostBaseInfo> hostBaseInfo = new ArrayList<HostBaseInfo>();
        ArrayList<HostBaseInfo> checkedHostBaseInfo = new ArrayList<HostBaseInfo>();
        if (!allHostInfo.isEmpty()) {
            for (UpgradeHostInfo info : allHostInfo) {
                StringBuilder matchWwnBuilder = new StringBuilder();
                boolean colorFlag = false;
                List<String> wwns = this.getWwns(info);
                for (String wwn : wwns) {
                    if (strAllFcIbwIscsis.toLowerCase(Locale.ENGLISH).contains(wwn.toLowerCase(Locale.ENGLISH))) {
                        matchWwnBuilder.append(this.setColorLabel(wwn, false)).append(",");
                        continue;
                    }
                    matchWwnBuilder.append(this.setColorLabel(wwn, true)).append(",");
                    colorFlag = true;
                }
                String wwnStr = matchWwnBuilder.toString();
                String hostName = this.setColorLabel(info.getHostName(), colorFlag);
                int hostId = info.getHostId();
                if (StringUtils.isNULLStr((String)wwnStr)) continue;
                String checkResult = hostIdCheckResult.get(Integer.toString(hostId));
                if (ToolConstants.CheckResultE.SUCCESS.getStatusValue().equals(checkResult) || ToolConstants.CheckResultE.FAIL.getStatusValue().equals(checkResult)) {
                    checkedHostBaseInfo.add(new HostBaseInfo(hostName, wwnStr.substring(0, wwnStr.length() - 1), hostId, checkResult));
                    continue;
                }
                hostBaseInfo.add(new HostBaseInfo(hostName, wwnStr.substring(0, wwnStr.length() - 1), hostId, "-1"));
            }
        }
        hostInfoData.put("checkedHostInfo", this.dataFilter(checkedHostBaseInfo));
        hostInfoData.put("hostInfo", this.dataFilter(hostBaseInfo));
        LOGGER.info(String.format(Locale.ENGLISH, "initHostInfoData hostInfoData:%s", hostInfoData.toString()));
        return hostInfoData;
    }

    private String setColorLabel(String colorStr, boolean isNeed) {
        colorStr = !isNeed ? "<span style ='color:#666666;'>" + colorStr + "</span>" : "<span style ='color:#3399ff;'>" + colorStr + "</span>";
        return colorStr;
    }

    private ArrayList<HostBaseInfo> dataFilter(List<HostBaseInfo> hostBaseInfo) {
        if (hostBaseInfo.isEmpty()) {
            hostBaseInfo.add(new HostBaseInfo(ResourceUtil.getString((String)"evalu.ui.host.mainDialog.showhostviewlistener.none"), ResourceUtil.getString((String)"evalu.ui.host.mainDialog.showhostviewlistener.none")));
        }
        return (ArrayList)hostBaseInfo;
    }

    private String getaddHostWwnStr(List<DevNode> addHostInfo) {
        StringBuilder strAllFcIbwIscsis = new StringBuilder();
        for (DevNode dev : addHostInfo) {
            Launcher lau = GrabContext.getInstance().getLauncherMap().get(dev.getDevKey());
            strAllFcIbwIscsis.append(lau.getFcWwns());
            strAllFcIbwIscsis.append(lau.getIBWwns());
            strAllFcIbwIscsis.append(lau.getNVMEWwns());
            strAllFcIbwIscsis.append(lau.getiSCSIWwns());
        }
        return strAllFcIbwIscsis.toString();
    }

    private List<String> getWwns(UpgradeHostInfo info) {
        ArrayList<String> wwns = new ArrayList<String>();
        for (Map wwnMap : info.getInitList()) {
            String wwn = (String)wwnMap.get("ID");
            if (StringUtils.isNULLStr((String)wwn)) continue;
            wwns.add(wwn);
        }
        return wwns;
    }

    private List<DevNode> hostFilter(List<DevNode> storageMappingHosts) {
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        for (DevNode devNode : storageMappingHosts) {
            if (!devNode.getItDeviceType().equals((Object)ItDeviceType.Host)) continue;
            devNodes.add(devNode);
        }
        return devNodes;
    }

    public void setHostInfoHmtlFilePath(String hostInfoHmtlFilePath) {
        this.hostInfoHmtlFilePath = hostInfoHmtlFilePath;
    }
}

