/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.action;

import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.tool.upgradeevalu.ui.EvaluModelDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Locale;
import org.slf4j.Logger;

public class UpagradeEvaluAction
implements IStartAction {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UpagradeEvaluAction.class);
    private static final int SLEEP_TIME = 300000;

    public void actionPerformed(Window parent, ActionEvent e) {
        ApplicationContext appContext = ApplicationContext.getInstance();
        if (appContext.isSpecificDeviceMode()) {
            this.requestFileLock("runningFlag");
        }
        EvaluModelDialog dialog = new EvaluModelDialog();
        dialog.setVisible(true);
    }

    private synchronized void requestFileLock(final String id) {
        ToolThreadFactory.newDefaultThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                String lockFile = id;
                FileOutputStream fos = null;
                FileLock lock = null;
                try {
                    fos = new FileOutputStream(lockFile);
                    lock = fos.getChannel().tryLock();
                    if (null != lock) {
                        ApplicationContext.getInstance().setToolLockStream(fos);
                        LOGGER.info(String.format(Locale.ENGLISH, "Obtained file lock %s success: %s", lockFile, lock));
                    }
                    UpagradeEvaluAction.this.sleepForever();
                    LOGGER.error("Cannot obtain file lock " + lockFile + ".");
                }
                catch (InterruptedException e) {
                    LOGGER.error("Obtain file lock " + lockFile + " failed.", e);
                    UpagradeEvaluAction.this.handleException(lockFile, fos, lock);
                }
                catch (Exception e2) {
                    LOGGER.error("Obtain file lock " + lockFile + " failed.", e2);
                    {
                        catch (Throwable throwable) {
                            UpagradeEvaluAction.this.handleException(lockFile, fos, lock);
                            throw throwable;
                        }
                    }
                    UpagradeEvaluAction.this.handleException(lockFile, fos, lock);
                }
                UpagradeEvaluAction.this.handleException(lockFile, fos, lock);
            }
        }).start();
    }

    private void handleException(String lockFile, FileOutputStream fos, FileLock lock) {
        if (null != lock) {
            try {
                lock.release();
            }
            catch (IOException e) {
                LOGGER.error("Release file lock " + lockFile + " failed.", e);
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error("Release file lock " + lockFile + " failed.", e);
            }
        }
    }

    private void sleepForever() throws InterruptedException {
        while (ApplicationContext.getInstance().isBlockLcokRealese()) {
            Thread.sleep(300000L);
        }
    }
}

