/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SshForwardConnector;
import com.huawei.ism.tool.devicemanager.entity.TaskResult;
import com.huawei.ism.tool.devicemanager.service.VerSpcGainer;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.ModifyAiNodeDialog;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.Socks5Proxy;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.ui.NeedPwdDialog;
import com.huawei.ism.tool.upgradeevalu.ui.SupportDeviceDialog;
import com.huawei.ism.tool.upgradeevalu.ui.action.BatchImportAction;
import com.huawei.ism.tool.upgradeevalu.ui.action.DownLoadAction;
import com.huawei.ism.tool.upgradeevalu.ui.card.EvaluAddDevCardLayout;
import com.huawei.ism.tool.upgradeevalu.ui.listenner.EvaluAddDevListener;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.HVSDevUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.RowSorter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class EvaluAddDevCard
extends FlowWizardCard
implements INodeObserver {
    private static final Logger log = LoggerFactory.getLogger(EvaluAddDevCard.class);
    private static final String GRAY_COLOR = "<font color=#C0C0C0>";
    private static final String VER_REGEX = "V\\d{3}R\\d{3}C\\d{2}";
    private static final String KUNPENG = " Kunpeng";
    private EvaluAddDevCardLayout layout = new EvaluAddDevCardLayout();
    private IDeviceManage devMng = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private EvaluDevManager evaluDevMgr = EvaluDevManager.getInstance();
    private EvaluService evaluService = EvaluService.getInstance();
    private boolean firstTime = true;

    private DefaultTableModel getTable() {
        return this.layout.getTable();
    }

    private IsmTable getDeviceTable() {
        return this.layout.getDeviceTable();
    }

    protected boolean init() {
        List devs;
        this.initData();
        this.layout.setCompName();
        if (this.firstTime) {
            this.firstTime = false;
            this.addListener();
            this.devMng.addNodeObservers((INodeObserver)this);
        }
        if (null != (devs = (List)this.getContext().getSingleObject("selectedDevs")) && !devs.isEmpty()) {
            this.defaultSelectedDev(devs);
        }
        return true;
    }

    public void initData() {
        this.layout.getTable().removeAll();
        this.initDevTable();
    }

    private void initDevTable() {
        List<DevNode> devList = this.devMng.getNodeList();
        if (ApplicationContext.getInstance().isSpecificDeviceMode() && !EvaluSceneUtils.getSceneArg().equals("setting")) {
            devList = this.getDevForHVS();
        }
        if (A800Utils.isA800UpgradeCheck()) {
            devList = this.getZoneDevs();
        }
        log.info("framework's devMng.getNodeList={}", (Object)devList);
        ArrayList<EvaluDevNode> evaluDevList = new ArrayList<EvaluDevNode>();
        for (DevNode dev : devList) {
            if (null == this.evaluService.matchProdcut(dev)) {
                log.warn("dev not match product, ip={}", (Object)dev.getIp());
                continue;
            }
            if (!EvaluSceneUtils.getSceneArg().equals("setting") && ArrayUtils.isHighEndDevOuterSvp((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)dev))) {
                log.warn("dev is High-end and is outer-svp, ip={}", (Object)dev.getIp());
                continue;
            }
            this.addStorageFromFcv(evaluDevList, dev);
        }
        List<EvaluDevNode> mainTabDevs = this.evaluDevMgr.getTabDevs();
        if (!evaluDevList.isEmpty()) {
            for (EvaluDevNode dev : evaluDevList) {
                if (mainTabDevs.contains((Object)dev)) continue;
                this.replaceDevVersionSVP(dev);
                TableRow<EvaluDevNode, String> row = this.createDeviceTableRow(dev);
                this.getTable().addRow(new TableRow[]{row});
            }
        }
    }

    @NotNull
    private List<DevNode> getZoneDevs() {
        return EntityUtils.toNewDevList(DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).map(A800Node::getZones).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private void addStorageFromFcv(List<EvaluDevNode> upgradeDevs, DevNode dev) {
        if (dev.isComputeStorage() && Objects.nonNull(dev.getComputeStorageDevNode())) {
            EntityUtils.convertComputeStorageToOldDevNode((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)dev)).forEach(storageDev -> this.setEvaluDev(upgradeDevs, EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)storageDev)));
        } else {
            this.setEvaluDev(upgradeDevs, dev);
        }
    }

    private void setEvaluDev(List<EvaluDevNode> upgradeDevs, DevNode devNode) {
        EvaluDevNode upgradeDevNode = new EvaluDevNode(devNode);
        upgradeDevNode.setSvpIp(devNode.getIp());
        upgradeDevs.add(upgradeDevNode);
    }

    private void replaceDevVersionSVP(EvaluDevNode dev) {
        try {
            SshForwardConnector sshCtr;
            ICliConnection sshConn;
            String devVersion;
            if (ApplicationContext.getInstance().isSpecificDeviceMode() && !StringUtils.isNULLStr((String)(devVersion = new VerSpcGainer().query(sshConn = (sshCtr = ConnectorFactory.getInstance().createSshForwardConnector((DevNode)dev)).getConnectionForPwdWillExpireBreak())))) {
                if (dev.getProductVersion().contains(KUNPENG) && StringUtils.hasMatchStr((String)dev.getProductVersion(), (String)VER_REGEX)) {
                    devVersion = devVersion + KUNPENG;
                }
                dev.setProductVersion(devVersion);
            }
        }
        catch (Exception e) {
            log.error("Refresh SVP device version failed:", e);
        }
    }

    private List<DevNode> getDevForHVS() {
        List devList = HVSDevUtils.getDevFromEnv();
        for (DevNode devNode : devList) {
            if (null == System.getenv("jsonDevEncode_1")) {
                log.info("old model toolDev_1={}", (Object)devNode);
                if (this.devMng.isContainsNode(devNode)) continue;
                this.devMng.addDevice(devNode);
                continue;
            }
            log.info("new model from ENV jsonDevEncode_1={}", (Object)devNode);
            log.info("new model devMng's dev ={}", (Object)this.devMng.getNodeList());
            if (this.devMng.deleteOneDevice("127.0.0.1")) {
                this.devMng.addDevice(devNode);
                log.info("new model devMng after delete dev 127.0.0.1, and devMng.getNodeList={}", (Object)this.devMng.getNodeList());
            }
            if (!this.devMng.deleteOneDevice(ResourceUtil.getString((String)"svp.ip"))) continue;
            this.devMng.addDevice(devNode);
            log.info("new model devMng after delete dev 172.17.126.11, and devMng.getNodeList={}", (Object)this.devMng.getNodeList());
        }
        devList = this.devMng.getNodeList();
        log.info("HVS's devMng.getNodeList={}", (Object)devList);
        return devList;
    }

    private void addListener() {
        ToolHyperLinkLabel addLabel = this.layout.getAddDeviceLabel();
        addLabel.addMouseListener((MouseListener)new EvaluAddDevListener(this));
        ToolHyperLinkLabel supLabel = this.layout.getShowSupLabel();
        supLabel.addMouseListener((MouseListener)new MouserClikedList());
        ToolHyperLinkLabel tmpLabel = this.layout.getImportTemplateLabel();
        tmpLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                log.info("import template file");
                DownLoadAction downLoadAction = new DownLoadAction((Window)EvaluAddDevCard.this.evaluContext.getWizDialog(), "template");
                downLoadAction.clickLink(e);
            }
        });
        ToolHyperLinkLabel devLabel = this.layout.getImportDevsLabel();
        devLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                log.info("import devices");
                BatchImportAction batchImport = new BatchImportAction((JDialog)EvaluAddDevCard.this.evaluContext.getWizDialog());
                batchImport.clickLink(e);
            }
        });
    }

    private TableRow<EvaluDevNode, String> createDeviceTableRow(EvaluDevNode dev) {
        if (null == dev) {
            return null;
        }
        int index = 0;
        String key = dev.getDeviceName() + dev.getDeviceSerialNumber();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTable().getColumnCount(), (Object)dev, (Object)key);
        if (dev.isHyperMetro()) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(dev.getDeviceType().toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
            String sns = dev.getRemoteSNs().toString();
            sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
            sns = EvaluSceneUtils.cutTooLongSns2Lines(sns);
            cell.setTips(ResourceUtil.getStringWithParams((String)"devicemanager.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
            row.setValueAt(index++, (Object)cell);
        } else {
            row.setValueAt(index++, (Object)dev.getDeviceType().toString());
        }
        switch (dev.getItDeviceType()) {
            case A800_NODE: 
            case Storage: {
                row.setValueAt(index++, (Object)ResourceUtil.getString((String)"evalu.ui.mainDialog.table.row.storage"));
                break;
            }
            case Host: {
                row.setValueAt(index++, (Object)ResourceUtil.getString((String)"evalu.ui.mainDialog.table.row.host"));
                break;
            }
            case Switch: {
                row.setValueAt(index++, (Object)ResourceUtil.getString((String)"evalu.ui.mainDialog.table.row.switch"));
                break;
            }
            default: {
                row.setValueAt(index++, (Object)"--");
            }
        }
        row.setValueAt(index++, (Object)dev.getProductVersion());
        row.setValueAt(index++, (Object)dev.getIp());
        row.setValueAt(index++, (Object)(StringUtils.isNULLStr((String)dev.getDeviceName()) ? "--" : dev.getDeviceName()));
        row.setValueAt(index++, (Object)dev.getDeviceSerialNumber());
        IsmTableCell.HyperlinkCell ismTableCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"evalu.ui.card.addDev.tabel.alert"), (ActionListener)new UpdateDevAuth(dev));
        row.setValueAt(index++, (Object)ismTableCell);
        return row;
    }

    private void defaultSelectedDev(List<EvaluDevNode> selectDevs) {
        int row = -1;
        List allTableRow = this.getDeviceTable().getAllRows();
        for (TableRow tableRow : allTableRow) {
            ++row;
            EvaluDevNode evaluDev = (EvaluDevNode)((Object)tableRow.getUserObject());
            for (EvaluDevNode selectDev : selectDevs) {
                this.validIp(this.getDeviceTable().convertRowIndexToView(row), evaluDev, selectDev);
            }
        }
    }

    private void validIp(int row, EvaluDevNode evalDev, EvaluDevNode selectDev) {
        if (selectDev.getIp().equals(evalDev.getIp())) {
            this.getDeviceTable().addRowSelectionInterval(row, row);
        }
    }

    private boolean isContains(List<EvaluDevNode> devs, DevNode dev) {
        return devs.stream().anyMatch(evalDev -> evalDev.getIp().equals(dev.getIp()));
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    public boolean ending() {
        List<EvaluDevNode> tabDevs = this.getSelectDevNode();
        if (tabDevs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.card.showinfo.seldevs"));
            return false;
        }
        if (!this.verifyA800Auth(tabDevs)) {
            return false;
        }
        if (this.checkTabDevsSize(tabDevs)) {
            return false;
        }
        if (this.checkIsSameType(tabDevs)) {
            return false;
        }
        ProductCfg matchedProduct = this.matchProdCfg4Devs(tabDevs);
        if (this.checkMatchedProduct(matchedProduct)) {
            return false;
        }
        if (!this.validDevInfo(tabDevs, matchedProduct)) {
            log.info("Select device for upgradeEvalu failed.  validDevInfo failed.");
            return false;
        }
        this.getContext().saveSingleObject("matchedDev", (Object)matchedProduct);
        this.getContext().removeSingleObject("selectedDevs");
        this.getContext().saveSingleObject("selectedDevs", tabDevs);
        boolean isFastAndRollType = matchedProduct.isFastAndRollType();
        for (EvaluDevNode evaluDevNode : tabDevs) {
            log.info("Select device {} for upgradeEvalu sucess.", (Object)evaluDevNode.getIp());
            if (Products.Feature.isSupportFastUpgrade((String)evaluDevNode.getDeviceType().toString())) {
                evaluDevNode.setSupportFast(true);
            }
            evaluDevNode.setFastAndRollType(isFastAndRollType);
        }
        List asyncResult = AsyncExcutor.execute((Window)this.evaluContext.getWizDialog(), (Callable[])new Callable[]{this.getCheckUserPermissionTask(tabDevs)});
        log.info("getCheckUserPermissionTask-------asyncResult:{}", (Object)JSONUtils.toJson((Object)asyncResult));
        return asyncResult.stream().allMatch(result -> Boolean.parseBoolean(result.toString()));
    }

    private boolean verifyA800Auth(List<EvaluDevNode> evaluDevNodes) {
        List authDevIps = evaluDevNodes.stream().filter(evaluDevNode -> Objects.isNull(evaluDevNode.getLoginUser()) || Objects.isNull(evaluDevNode.getLoginUser().getPassword())).map(DevNode::getIp).collect(Collectors.toList());
        String errorMsg = "";
        if (!authDevIps.isEmpty()) {
            String ipStr = org.apache.commons.lang3.StringUtils.join(authDevIps, ",");
            errorMsg = errorMsg + ResourceUtil.getStringWithParams((String)"a800.arrayupgrade.scene.no.auth", (Object[])new Object[]{ipStr});
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)errorMsg);
            return false;
        }
        return true;
    }

    private boolean checkMatchedProduct(ProductCfg matchedProduct) {
        if (matchedProduct == null) {
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.product.not.same"));
            log.info("Select device for upgradeEvalu failed.  package not matched with the device");
            return true;
        }
        return false;
    }

    private boolean checkIsSameType(List<EvaluDevNode> tabDevs) {
        if (!this.evaluService.isSameType(tabDevs)) {
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.addSameDev"));
            log.info("Select device for upgradeEvalu failed. Can not have the same type of device.");
            return true;
        }
        return false;
    }

    private boolean checkTabDevsSize(List<EvaluDevNode> tabDevs) {
        if (this.evaluDevMgr.getTabDevs().size() + tabDevs.size() > 256) {
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.ui.card.addDev.max.number.tip"));
            log.info("Select device for upgradeEvalu failed. Can not be more than 256 devices.");
            return true;
        }
        return false;
    }

    private Callable<Boolean> getCheckUserPermissionTask(List<EvaluDevNode> tabDevs) {
        return () -> {
            List<ArrayList<Object>> checkResult = this.checkDevInfo(tabDevs);
            log.info("checkResult:{}", (Object)JSONUtils.toJson(checkResult));
            Boolean isCheckSuccess = this.analyseCheckResult(tabDevs, checkResult);
            if (!isCheckSuccess.booleanValue()) {
                this.giveFailedHints(checkResult);
            }
            return isCheckSuccess;
        };
    }

    private Boolean analyseCheckResult(List<EvaluDevNode> tabDevs, List<ArrayList<Object>> checkResult) {
        checkResult.stream().filter(Objects::nonNull).forEach(result -> this.doRemoveFiledDev(tabDevs, (ArrayList<Object>)result));
        return checkResult.stream().noneMatch(Objects::nonNull);
    }

    private void doRemoveFiledDev(List<EvaluDevNode> tabDevs, ArrayList<Object> result) {
        String ip = (String)result.get(0);
        tabDevs.stream().filter(dev -> dev.getIp().equals(ip)).findFirst().ifPresent(this::removeFailedDevMark);
    }

    private void giveFailedHints(List<ArrayList<Object>> checkResult) {
        log.info("upgrade Device:login user levle has not supper admin");
        SubDialogUtils.showMultiInfoDialog((Window)EvaluContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"evalu.wizard.selectdevice.importinfodialog.desc"), (String[])new String[]{ResourceUtil.getString((String)"evalu.wizard.selectdevice.importinfodialog.ip"), ResourceUtil.getString((String)"evalu.wizard.selectdevice.importinfodialog.reson")}, checkResult);
    }

    private void giveFailedTips(List<TaskResult> taskResult) {
        log.info("upgrade Device:qurey apollo supported failed.");
        SubDialogUtils.showMultiInfoDialog4CheckResult((Window)EvaluContext.getInstance().getWizDialog(), (String)ResourceUtil.getString((String)"evalu.wizard.selectdevice.importinfodialog.desc"), (String[])new String[]{ResourceUtil.getString((String)"evalu.wizard.selectdevice.importinfodialog.ip"), ResourceUtil.getString((String)"evalu.wizard.selectdevice.importinfodialog.reson")}, taskResult);
    }

    private void removeFailedDevMark(EvaluDevNode upgradeDev) {
        this.layout.getDeviceTable().getMarkedRows().stream().filter(row -> row.getUserObject().equals((Object)upgradeDev)).forEach(row -> this.layout.getDeviceTable().unmarkTableRow(new TableRow[]{row}));
    }

    private List<ArrayList<Object>> checkDevInfo(List<EvaluDevNode> upgradeDevs) {
        ArrayList<ArrayList<Object>> checkResult = new ArrayList<ArrayList<Object>>();
        ArrayList<Future> allQueryFus = new ArrayList<Future>();
        for (EvaluDevNode dev : upgradeDevs) {
            Future f = ThreadPoolManager.getInstance().submit((Callable)new CheckDevInfo(dev));
            allQueryFus.add(f);
        }
        for (Future f : allQueryFus) {
            try {
                if (f.get() == null) continue;
                checkResult.add((ArrayList<Object>)f.get());
            }
            catch (Exception e) {
                log.error("wait query dev user permission error!", e);
            }
        }
        return checkResult;
    }

    private boolean validDevInfo(List<EvaluDevNode> tabDevs, ProductCfg matchedProduct) {
        List commonDevs = this.devMng.getNodeList();
        if (matchedProduct.isDedbug()) {
            ArrayList<EvaluDevNode> dpwdList = new ArrayList<EvaluDevNode>();
            for (EvaluDevNode evaluDevNode : tabDevs) {
                String dpwd;
                for (DevNode devInfo : commonDevs) {
                    if (!devInfo.getDevKey().equals(evaluDevNode.getDevKey()) || !StringUtils.isNULLStr((String)evaluDevNode.getDeveloperPwd()) || StringUtils.isNULLStr((String)devInfo.getDeveloperPwd())) continue;
                    evaluDevNode.setDeveloperPwd(devInfo.getDeveloperPwd());
                    break;
                }
                if (!StringUtils.isNULLStr((String)(dpwd = evaluDevNode.getDeveloperPwd()))) continue;
                dpwdList.add(evaluDevNode);
            }
            if (!dpwdList.isEmpty()) {
                NeedPwdDialog needPwdDialog = new NeedPwdDialog((JDialog)this.evaluContext.getWizDialog(), dpwdList);
                needPwdDialog.setModal(true);
                needPwdDialog.setVisible(true);
                return false;
            }
        }
        StringBuilder socketProxy = new StringBuilder();
        boolean hasSocketProxy = false;
        for (EvaluDevNode dev : tabDevs) {
            Socks5Proxy socks5Proxy = dev.getSocks5Proxy();
            boolean notSocketProxy = null == socks5Proxy || StringUtils.isNULLStr((String)socks5Proxy.getServerIp());
            if (notSocketProxy) continue;
            hasSocketProxy = true;
            socketProxy.append(dev.getIp()).append(",");
        }
        if (hasSocketProxy) {
            String string = socketProxy.deleteCharAt(socketProxy.length() - 1).toString();
            String ret = ResourceUtil.getStringWithParams((String)"evalu.add.device.socks5.devs", (Object[])new Object[]{string});
            DialogUtils.showInfoDialog((JDialog)EvaluContext.getInstance().getWizDialog(), (String)ret);
            return false;
        }
        return true;
    }

    public ProductCfg matchProdCfg4Devs(List<EvaluDevNode> devs) {
        ProductCfg tmpProd = null;
        for (EvaluDevNode dev : devs) {
            ProductCfg productCfg = this.evaluService.matchProdcut(dev);
            if (null == productCfg) {
                log.warn("dev " + dev.getIp() + " match productCfg failed.");
                return null;
            }
            if (null != tmpProd && !tmpProd.getProdcutName().equals(productCfg.getProdcutName())) {
                return null;
            }
            tmpProd = productCfg;
        }
        return tmpProd;
    }

    public boolean flowExiting() {
        this.devMng.removeNodeObserver(((Object)((Object)this)).getClass());
        return true;
    }

    public void fireNodeAdd(DevNode dev) {
        log.warn("dev firenodeadd=========.");
        if (Objects.isNull(dev)) {
            log.warn("dev is null.");
            return;
        }
        com.huawei.ism.tool.obase.entity.DevNode oldDev = EntityUtils.toOldDev((DevNode)dev);
        if (EntityUtils.isComputeStorageDevLoginThroughFcv((com.huawei.ism.tool.obase.entity.DevNode)oldDev)) {
            EntityUtils.convertComputeStorageToOldDevNode((com.huawei.ism.tool.obase.entity.DevNode)oldDev).stream().map(EntityUtils::toNewDev).forEach(this::setUpgradeDev);
            return;
        }
        if (A800Utils.isA800UpgradeCheck()) {
            log.info("add A800 zones.");
            this.getZoneDevs().forEach(this::setUpgradeDev);
            A800Utils.saveAiDevNode2Box();
            return;
        }
        this.setUpgradeDev(dev);
    }

    private void setUpgradeDev(DevNode dev) {
        EvaluDevNode evaluDev = new EvaluDevNode(dev);
        List<EvaluDevNode> selectedDevsNodes = this.getSelectDevNode();
        TableRow<EvaluDevNode, String> row = this.createDeviceTableRow(evaluDev);
        List oldRows = this.getDeviceTable().getAllRows();
        this.getDeviceTable().removeAll();
        RowSorter rowSorter = this.getDeviceTable().getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(new ArrayList());
        }
        this.getTable().addRow(new TableRow[]{row});
        oldRows.remove(row);
        this.getTable().addRows(oldRows);
        this.getDeviceTable().clearSelection();
        this.defaultSelectedDev(selectedDevsNodes);
    }

    public List<EvaluDevNode> getSelectDevNode() {
        ArrayList<EvaluDevNode> nodeList = new ArrayList<EvaluDevNode>();
        List rows = this.layout.getDeviceTable().getMarkedRows();
        for (TableRow tr : rows) {
            EvaluDevNode node = (EvaluDevNode)((Object)tr.getUserObject());
            nodeList.add(node);
        }
        return nodeList;
    }

    public void fireNodeDelete(DevNode dev) {
    }

    public void fireNodeModify(DevNode dev) {
        this.fireNodeAdd(dev);
    }

    @NotNull
    private static ArrayList<Object> setFailedMsg(EvaluDevNode node) {
        ArrayList<Object> oneFailMsg = new ArrayList<Object>();
        oneFailMsg.add(node.getIp());
        oneFailMsg.add(ResourceUtil.getString((String)"evalu.link.error"));
        return oneFailMsg;
    }

    static class CheckDevInfo
    implements Callable<ArrayList<Object>> {
        private EvaluDevNode dev;

        public CheckDevInfo(EvaluDevNode dev) {
            this.dev = dev;
        }

        @Override
        public ArrayList<Object> call() {
            com.huawei.ism.tool.obase.entity.DevNode baseDev = EntityUtils.toOldDev((DevNode)this.dev);
            if (!CliResolverUtils.checkSuperAdminUserRole((com.huawei.ism.tool.obase.entity.DevNode)baseDev)) {
                return EvaluAddDevCard.setFailedMsg(this.dev);
            }
            return null;
        }
    }

    private class UpdateDevAuth
    implements ActionListener {
        private EvaluDevNode dev;

        public UpdateDevAuth(EvaluDevNode dev) {
            this.dev = dev;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("valid devices");
            IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
            ArrayList<DevNode> updateDevs = new ArrayList<DevNode>();
            if (A800Utils.isA800UpgradeCheck()) {
                EvaluAddDevCard.this.devMng.addNodeObservers((INodeObserver)EvaluAddDevCard.this);
                Optional<AiDevNode> aiDevNode = A800Utils.transToAiNode(EntityUtils.toOldDev((DevNode)this.dev));
                if (!aiDevNode.isPresent()) {
                    log.info("current zone match ai node failed.");
                    DialogUtils.showInfoDialog((JDialog)EvaluAddDevCard.this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.card.a800.select.ai.node.failed"));
                    return;
                }
                new ModifyAiNodeDialog((Window)EvaluAddDevCard.this.evaluContext.getWizDialog(), aiDevNode.get()).setVisible(true);
                EvaluAddDevCard.this.initData();
                EvaluAddDevCard.this.defaultSelectedDev(EvaluAddDevCard.this.getSelectDevNode());
                return;
            }
            this.validCommonDevs(updateDevs);
            this.validUpdateDevs(idm, updateDevs);
        }

        private void validCommonDevs(List<DevNode> updateDevs) {
            List commonDevs = EvaluAddDevCard.this.devMng.getNodeList();
            List<EvaluDevNode> privateDevs = EvaluAddDevCard.this.evaluDevMgr.getTabDevs();
            for (DevNode commonDev : commonDevs) {
                ProductCfg prod = EvaluAddDevCard.this.evaluService.matchProdcut(commonDev);
                if (EvaluAddDevCard.this.isContains(privateDevs, commonDev) || null == prod) continue;
                updateDevs.add(commonDev);
            }
        }

        private void validUpdateDevs(IDeviceManageUI idm, List<DevNode> updateDevs) {
            if (updateDevs.isEmpty()) {
                return;
            }
            idm.showModifyIntegrateDeviceDialogByDevKey((Window)EvaluAddDevCard.this.evaluContext.getWizDialog(), false, this.dev.getDevKey(), updateDevs);
            EvaluAddDevCard.this.initData();
            EvaluAddDevCard.this.defaultSelectedDev(EvaluAddDevCard.this.getSelectDevNode());
        }
    }

    private class MouserClikedList
    extends MouseAdapter {
        private MouserClikedList() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            log.info("open support list dialog");
            SupportDeviceDialog supDialog = new SupportDeviceDialog((JDialog)EvaluAddDevCard.this.evaluContext.getWizDialog());
            supDialog.setModal(true);
            supDialog.setVisible(true);
        }
    }
}

