/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.upgrade.UpgradeModePanel;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallable;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallableOver;
import com.huawei.ism.tool.upgradeevalu.ui.card.EvaluStrategyCardLayout;
import com.huawei.ism.tool.upgradeevalu.ui.card.QRCodeImgDialog;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.ui.swing.combo.IsmComboBox;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class EvaluStrategyCard
extends FlowWizardCard {
    private static final Logger log = LoggerFactory.getLogger(EvaluStrategyCard.class);
    private EvaluStrategyCardLayout layout = new EvaluStrategyCardLayout();
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private List<String> keyWordList = new ArrayList<String>();
    private ProductCfg matchedProd;
    private Pattern containerPattern = Pattern.compile("^\\d+\\.\\d+\\.\\d*[RC|T]*\\d+(\\.(SPC)?\\d+)?$");

    public EvaluStrategyCard() {
        this.keyWordList.add("V200R002");
    }

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.layout = new EvaluStrategyCardLayout();
        this.setLayoutComboxExplainLabel();
        this.matchedProd = (ProductCfg)this.getContext().getSingleObject("matchedDev");
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        EvaluDevNode devNode = (EvaluDevNode)((Object)selectedDevs.get(0));
        if (devNode.isSecondaryUpgrade() && !devNode.isStorageImageUpgrade()) {
            UpgradeModePanel upgradeModePanel = this.getContainerUpgradeModePanel(devNode);
            this.initEvaluStrategyCardLayout(upgradeModePanel);
            return true;
        }
        if (!devNode.isSecondaryUpgrade()) {
            boolean allSupportApollo = selectedDevs.stream().allMatch(EvaluDevNode::isSupportApollo);
            this.layout.setDevicesSupportApollo(allSupportApollo);
            UpgradeModePanel upgradeModePanel = this.getStorageUpgradeModePanel(devNode, allSupportApollo);
            this.initEvaluStrategyCardLayout(upgradeModePanel);
            return true;
        }
        boolean allSupportApollo = selectedDevs.stream().allMatch(EvaluDevNode::isSupportApollo);
        this.layout.setDevicesSupportApollo(allSupportApollo);
        UpgradeModePanel upgradeModePanel = this.getStorageUpgradeModePanel(devNode, allSupportApollo);
        UpgradeModePanel containerModePanel = this.getContainerUpgradeModePanel(devNode);
        this.layout.initEvaluStrategyCardLayout(upgradeModePanel, containerModePanel);
        this.resetStrategy();
        this.layout.setCompName();
        this.initListener();
        return true;
    }

    private void initEvaluStrategyCardLayout(UpgradeModePanel upgradeModePanel) {
        this.layout.initEvaluStrategyCardLayout(upgradeModePanel);
        this.resetStrategy();
        this.layout.setCompName();
        this.initListener();
    }

    @NotNull
    private UpgradeModePanel getStorageUpgradeModePanel(EvaluDevNode devNode, boolean allSupportApollo) {
        UpgradeModePanel upgradeModePanel = new UpgradeModePanel(EvaluCommUtil.getUpgradeScene(devNode));
        upgradeModePanel.setParent((JDialog)this.evaluContext.getWizDialog());
        boolean showParallel = Products.Feature.isSupportParallUpgrade((String)devNode.getDeviceType().toString(), (String)devNode.getProductVersion());
        upgradeModePanel.setShowParallel(showParallel);
        upgradeModePanel.setShowStopHosBusiness(true);
        upgradeModePanel.setMaxWidth(550);
        upgradeModePanel.setShowApollo(allSupportApollo);
        upgradeModePanel.setCurrentVersion(devNode.getProductVersion());
        return upgradeModePanel;
    }

    @NotNull
    private UpgradeModePanel getContainerUpgradeModePanel(EvaluDevNode devNode) {
        UpgradeModePanel upgradeModePanel = new UpgradeModePanel(EvaluCommUtil.getContainerScene(devNode));
        upgradeModePanel.setParent((JDialog)this.evaluContext.getWizDialog());
        upgradeModePanel.setShowParallel(false);
        upgradeModePanel.setShowStopHosBusiness(false);
        upgradeModePanel.setMaxWidth(600);
        upgradeModePanel.setCurrentVersion(devNode.getProductVersion());
        return upgradeModePanel;
    }

    private void setLayoutComboxExplainLabel() {
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        String devType = ((EvaluDevNode)((Object)selectedDevs.get(0))).getId().split("_")[0].trim();
        log.info("devType={}", (Object)devType);
        if (A800Utils.isA800(devType)) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.a800explain"));
            return;
        }
        if (Products.isOceanProtectDev((String)devType)) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"secondaryupgrade.evalu.ui.card.addStrategy.combox.explain"));
            return;
        }
        if (Products.DORADO_V6_DEV.contains(devType) && !Products.isOceanProtectDev((String)devType)) {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.explainNew"));
        } else {
            this.layout.setComboxExplainLabel(ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.explainOld"));
        }
    }

    private void resetStrategy() {
        IsmComboBox combox = this.layout.getTargetVerCombox();
        combox.removeAllItems();
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        if (!EvaluCommUtil.isStorageOrA800(this.getSelectDevType(selectedDevs))) {
            this.layout.showTargerVersion(false, this.matchedProd);
            return;
        }
        List<String> validVers = this.matchedProd.getDestVers();
        for (String verStr : validVers) {
            combox.addItem((Object)verStr);
        }
        this.layout.showTargerVersion(true, this.matchedProd);
    }

    private ItDeviceType getSelectDevType(List<EvaluDevNode> devs) {
        EvaluDevNode dev = devs.get(0);
        ItDeviceType type = dev.getItDeviceType();
        return type;
    }

    public boolean ending() {
        if (this.layout.getUpgradeModePanel().getSelectedMode() == UpgradeModePanel.UpgradeMode.APOLLO && !StringUtils.isNULLStr((String)this.layout.getTargetVerInput().getText())) {
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.warn"));
        }
        log.info("java.io.tmpdir: {}", (Object)StringUtils.getCleanMessage((String)System.getProperty("java.io.tmpdir")));
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        if (this.checkDestVersion(this.validDestVersion())) {
            return false;
        }
        if (this.checkContainerDestVersion(selectedDevs)) {
            return false;
        }
        String errKey = this.invalidUpgradeMode(selectedDevs);
        if (!StringUtils.isNULLStr((String)errKey)) {
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)errKey));
            log.info("Evaluation strategy set failed. invalidUpgradeMode");
            return false;
        }
        this.updateStrategy2Devs();
        List retList = AsyncExcutor.execute((Window)this.evaluContext.getWizDialog(), (boolean)true, (long)50000L, (Callable[])new Callable[]{new LoadEvaluItemCallable(selectedDevs)});
        if (this.dealRetList(retList)) {
            return false;
        }
        this.evaluContext.getUiObserver().addDev2Table(selectedDevs);
        boolean isClickUpgTips = this.evaluContext.isClickUpgTipsBoolean();
        try {
            for (EvaluDevNode dev : selectedDevs) {
                this.evaluContext.putIsClickUpgTipsOfDevToMap(dev, isClickUpgTips);
                log.info("Evaluation strategy set: device: {}, upgrade mode: {}, dest Version: {} success", new Object[]{dev.getIp(), dev.getUpgradeModeUI(), dev.getDestVersion()});
            }
        }
        catch (Exception e) {
            log.error("Log records failed.", e);
        }
        EvaluSceneUtils sceneUtilInformation = new EvaluSceneUtils();
        sceneUtilInformation.addRecordsDottingInformation("5", "");
        return true;
    }

    private boolean checkDestVersion(String errMsg) {
        if (StringUtils.isNULLStr((String)errMsg)) {
            return false;
        }
        DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)errMsg);
        log.info("Evaluation strategy set failed. validDestVersion");
        return true;
    }

    private boolean checkContainerDestVersion(List<EvaluDevNode> selectedDevs) {
        EvaluDevNode devNode = selectedDevs.get(0);
        return devNode.isStorageImageUpgrade() && this.checkDestVersion(this.validDestContainerVersion(devNode));
    }

    private boolean dealRetList(List<LoadEvaluItemCallableOver> retList) {
        if (retList.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)"evalu.ui.card.addStrategy.execute.timeout"));
            log.info("Evaluation strategy set failed. LoadEvaluItemCallable timeout");
            return true;
        }
        if (!retList.get(0).getSuccess().booleanValue()) {
            String resultId = retList.get(0).getResult().getResultId();
            DialogUtils.showErrorDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getString((String)resultId));
            log.info("Evaluation strategy set failed. LoadEvaluItemCallable failed.");
            return true;
        }
        return false;
    }

    private String validDestContainerVersion(EvaluDevNode evaluDevNode) {
        String destVersion = this.layout.getSecondaryUpgradeInfoPanel().getTargetVerInput().getText();
        Matcher matcher = this.containerPattern.matcher(destVersion);
        if (!matcher.find()) {
            return ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.valid");
        }
        String srcVersion = evaluDevNode.getContainerVersion();
        UpgradeModePanel.UpgradeMode upgradeMode = this.layout.getContainerModePanel().getSelectedMode();
        if (this.isNotMatchTheUpgradeModeOfUpgradePackage(destVersion, upgradeMode)) {
            return ResourceUtil.getString((String)"secondaryupgrade.upgrade.utils.pkg.not.patch.model");
        }
        if (this.isPatchContainerModel(upgradeMode)) {
            return this.checkVersionInPatchContainer(destVersion, evaluDevNode, srcVersion);
        }
        if (Products.compareVersion((String)srcVersion, (String)destVersion) > 0) {
            ToolLoggerFactory.getLogger(EvaluStrategyCard.class).debug("the destversion smaller than srcversion.");
            return ResourceUtil.getString((String)"original.less.to.target");
        }
        if (srcVersion.compareToIgnoreCase(destVersion) == 0) {
            ToolLoggerFactory.getLogger(EvaluStrategyCard.class).debug("the destversion equals srcversion.");
            return ResourceUtil.getString((String)"original.equal.to.target");
        }
        return "";
    }

    private String validDestVersion() {
        if (UpgradeModePanel.UpgradeMode.APOLLO == this.layout.getUpgradeModePanel().getSelectedMode()) {
            return "";
        }
        String destVersion = this.matchedProd.getDestVers().isEmpty() ? this.layout.getTargetVerInput().getText().trim() : (String)this.layout.getTargetVerCombox().getSelectedItem();
        String destRegex = this.matchedProd.getDestVerRegex();
        Pattern pattern = Pattern.compile(destRegex);
        Matcher matcher = pattern.matcher(destVersion);
        if (!StringUtils.isNULLStr((String)destRegex) && !matcher.find()) {
            return ResourceUtil.getString((String)"evalu.ui.card.addStrategy.combox.valid");
        }
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        String srcVersion = "";
        srcVersion = ((EvaluDevNode)((Object)selectedDevs.get(0))).isSecondaryUpgrade() ? ((EvaluDevNode)((Object)selectedDevs.get(0))).getContainerVersion() : ((EvaluDevNode)((Object)selectedDevs.get(0))).getProductVersion();
        if (!((EvaluDevNode)((Object)selectedDevs.get(0))).isStorageImageUpgrade() && ((EvaluDevNode)((Object)selectedDevs.get(0))).isSecondaryUpgrade()) {
            UpgradeModePanel.UpgradeMode upgradeMode = this.layout.getUpgradeModePanel().getSelectedMode();
            if (this.isNotMatchTheUpgradeModeOfUpgradePackage(destVersion, upgradeMode)) {
                return ResourceUtil.getString((String)"secondaryupgrade.upgrade.utils.pkg.not.patch.model");
            }
            if (this.isPatchContainerModel(upgradeMode)) {
                return this.checkVersionInPatchContainer(destVersion, (EvaluDevNode)((Object)selectedDevs.get(0)), srcVersion);
            }
        }
        if (this.isNotThrUpgradePathOf6199(destVersion, srcVersion)) {
            return "";
        }
        if (Products.compareVersion((String)srcVersion, (String)destVersion) > 0) {
            ToolLoggerFactory.getLogger(EvaluStrategyCard.class).debug("the destversion smaller than srcversion.");
            return ResourceUtil.getString((String)"original.less.to.target");
        }
        if (srcVersion.compareToIgnoreCase(destVersion) == 0) {
            ToolLoggerFactory.getLogger(EvaluStrategyCard.class).debug("the destversion equals srcversion.");
            return ResourceUtil.getString((String)"original.equal.to.target");
        }
        return "";
    }

    private boolean isNotMatchTheUpgradeModeOfUpgradePackage(String destVersion, UpgradeModePanel.UpgradeMode upgradeMode) {
        return this.isPatchContainerModel(upgradeMode) && !EvaluStrategyCard.isPatchPackage(destVersion) || !this.isPatchContainerModel(upgradeMode) && EvaluStrategyCard.isPatchPackage(destVersion);
    }

    private boolean isNotThrUpgradePathOf6199(String destVersion, String srcVersion) {
        return srcVersion.contains("6.1.99") && !destVersion.contains("6.1.99") && Products.compareVersion((String)destVersion, (String)"6.1.7RC1") >= 0;
    }

    private String checkVersionInPatchContainer(String destVersion, EvaluDevNode selectedDev, String srcVersion) {
        if (Products.compareVersion((String)destVersion, (String)selectedDev.getContainerVersion()) <= 0) {
            return ResourceUtil.getStringWithParams((String)"secondaryupgrade.upgrade.utils.patch.pkg.version", (Object[])new Object[]{destVersion, srcVersion});
        }
        return "";
    }

    private boolean isPatchContainerModel(UpgradeModePanel.UpgradeMode upgradeMode) {
        return UpgradeModePanel.UpgradeMode.PATCH_CONTAINER == upgradeMode;
    }

    private static boolean isPatchPackage(String pkgVersion) {
        return pkgVersion.contains("SPC");
    }

    private String invalidUpgradeMode(List<EvaluDevNode> selectedDevs) {
        UpgradeMode selectedUpgradeMode;
        List<UpgradeMode> supportUpgradeModeList;
        if (UpgradeModePanel.UpgradeMode.APOLLO == this.layout.getUpgradeModePanel().getSelectedMode()) {
            return "";
        }
        String destVersion = this.layout.getTargetVerInput().getText().trim();
        for (EvaluDevNode dev : selectedDevs) {
            boolean isFastAndRollType = dev.isFastAndRollType();
            if (!isFastAndRollType || (supportUpgradeModeList = EvaluCommUtil.getSupportModeList(dev, destVersion)).contains((Object)(selectedUpgradeMode = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedMode().name())))) continue;
            return "evalu.ui.card.addStrategy.upgrademode.valid";
        }
        if (!selectedDevs.get(0).isStorageImageUpgrade()) {
            return "";
        }
        String destContainerVersion = this.layout.getSecondaryUpgradeInfoPanel().getTargetVerInput().getText().trim();
        for (EvaluDevNode dev : selectedDevs) {
            dev.setDeviceType(DeviceType.valueOf((String)(dev.getDeviceType().toString() + "_container")));
            supportUpgradeModeList = EvaluCommUtil.getSupportModeList(dev, destContainerVersion);
            this.clearContainerSuffix(dev);
            selectedUpgradeMode = UpgradeMode.valueOf(this.layout.getSecondaryUpgradeInfoPanel().getUpgradeModePanel().getSelectedMode().name());
            if (supportUpgradeModeList.contains((Object)selectedUpgradeMode)) continue;
            return "evalu.ui.card.addStrategy.containermode.valid";
        }
        return "";
    }

    private void clearContainerSuffix(EvaluDevNode node) {
        node.setDeviceType(DeviceType.valueOf((String)node.getDeviceType().toString().replace("_container", "")));
    }

    private void updateStrategy2Devs() {
        String destVersion = this.matchedProd.getDestVers().isEmpty() ? this.layout.getTargetVerInput().getText().trim() : (String)this.layout.getTargetVerCombox().getSelectedItem();
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        if (this.layout.getUpgradeModePanel().getSelectedMode() == UpgradeModePanel.UpgradeMode.APOLLO) {
            destVersion = ((EvaluDevNode)((Object)selectedDevs.get(0))).getProductVersion();
        }
        for (EvaluDevNode dev : selectedDevs) {
            if (dev.getProductVersion().contains("Kunpeng") && !destVersion.contains("Kunpeng")) {
                destVersion = destVersion + " Kunpeng";
            }
            UpgradeMode upgradeMode = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedMode().name());
            UpgradeMode upgradeModeUI = UpgradeMode.valueOf(this.layout.getUpgradeModePanel().getSelectedModeUI().name());
            dev.setUpgradeMode(upgradeMode);
            dev.setUpgradeModeUI(upgradeModeUI);
            dev.setStopHostBusiness(this.layout.getUpgradeModePanel().getStopHostBusinessCbx().isSelected());
            dev.setDestVersion(destVersion);
            if (!dev.isStorageImageUpgrade()) continue;
            UpgradeMode containerMode = UpgradeMode.valueOf(this.layout.getSecondaryUpgradeInfoPanel().getUpgradeModePanel().getSelectedMode().name());
            UpgradeMode containerModeUI = UpgradeMode.valueOf(this.layout.getSecondaryUpgradeInfoPanel().getUpgradeModePanel().getSelectedModeUI().name());
            dev.setContainerUpgradeMode(containerMode);
            dev.setContainerUpgradeModeUI(containerModeUI);
            dev.setContainerDestVersion(this.layout.getSecondaryUpgradeInfoPanel().getTargetVerInput().getText());
        }
    }

    public boolean flowExiting() {
        return true;
    }

    private void initListener() {
        List selectedDevs = (List)this.getContext().getSingleObject("selectedDevs");
        String curDeviceVersion = ((EvaluDevNode)((Object)selectedDevs.get(0))).getProductVersion();
        log.info("The device version of changing updmode is {}", (Object)curDeviceVersion);
        log.info("java.io.tmpdir: {}", (Object)StringUtils.getCleanMessage((String)System.getProperty("java.io.tmpdir")));
        IsmTextField targetVerInput = this.layout.getTargetVerInput();
        KeyListener[] keyListeners = targetVerInput.getKeyListeners();
        if (keyListeners != null) {
            for (KeyListener keyListener : keyListeners) {
                targetVerInput.removeKeyListener(keyListener);
            }
        }
        if (curDeviceVersion.compareTo("V3") >= 0) {
            this.targetVerInputListener();
        }
        ToolHyperLinkLabel qrcImgLink = this.layout.getQrcImgLink();
        qrcImgLink.addMouseListener((MouseListener)new QRCodeImgAdapter());
        for (String item : this.keyWordList) {
            if (!curDeviceVersion.contains(item)) continue;
            this.layout.getUpgradeModePanel().setNeedOfflineWarning(true);
            return;
        }
    }

    private void targetVerInputListener() {
        this.layout.getTargetVerInput().addKeyListener((KeyListener)new MyKeyAdapter());
    }

    private class QRCodeImgAdapter
    extends MouseAdapter {
        private QRCodeImgAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            log.info("open QRCodeImgDialog.");
            QRCodeImgDialog qrcDialog = new QRCodeImgDialog((JDialog)EvaluStrategyCard.this.evaluContext.getWizDialog());
            qrcDialog.setModal(true);
            qrcDialog.setVisible(true);
        }
    }

    private static class MyKeyAdapter
    extends KeyAdapter {
        private MyKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.setKeyChar(String.valueOf(e.getKeyChar()).toUpperCase(Locale.US).charAt(0));
        }
    }
}

